/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.opentelemetry.sdk.trace.samplers;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import java.util.Objects;

public class DeterministicTraceSampler
implements Sampler {
    private static final int ALWAYS_SAMPLE = 1;
    private static final int NEVER_SAMPLE = 0;
    private static final AttributeKey<Long> SAMPLE_RATE_ATTRIBUTE_KEY = AttributeKey.longKey("SampleRate");
    private final Sampler decoratedSampler;
    private final Sampler baseSampler;
    private final int sampleRate;
    public static final String DESCRIPTION = "HoneycombDeterministicSampler";

    public DeterministicTraceSampler(Sampler decoratedSampler, int sampleRate) {
        Objects.requireNonNull(decoratedSampler, "decoratedSampler cannot be null");
        this.decoratedSampler = decoratedSampler;
        this.sampleRate = sampleRate;
        double ratio = sampleRate == 1 ? 1.0 : (sampleRate == 0 ? 0.0 : 1.0 / (double)sampleRate);
        this.baseSampler = Sampler.traceIdRatioBased((double)ratio);
    }

    public DeterministicTraceSampler(int sampleRate) {
        this(Sampler.alwaysOn(), sampleRate);
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        SamplingResult result = this.decoratedSampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
        SamplingDecision decision = result.getDecision();
        if (decision != SamplingDecision.DROP) {
            decision = this.baseSampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks).getDecision();
        }
        Attributes newAttributes = Attributes.builder().putAll(result.getAttributes()).put(SAMPLE_RATE_ATTRIBUTE_KEY, Long.valueOf(this.sampleRate)).build();
        return SamplingResult.create((SamplingDecision)decision, (Attributes)newAttributes);
    }
}

