/*
 * Decompiled with CFR 0.152.
 */
package io.leonard.maven.plugins.jspc;

import io.leonard.maven.plugins.jspc.JspCContextAccessor;
import io.leonard.maven.plugins.jspc.JspcWorker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.jasper.JasperException;
import org.apache.jasper.TrimSpacesOption;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.xml.sax.SAXException;

@Mojo(name="compile", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class JspcMojo
extends AbstractMojo {
    private static final String WEB_XML = "web.xml";
    public static final String END_OF_WEBAPP = "</web-app>";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${basedir}/target/webfrag.xml")
    private String webXmlFragment;
    @Parameter
    private String insertionMarker;
    @Parameter(defaultValue="true")
    private boolean mergeFragment;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private String generatedClasses;
    @Parameter(defaultValue="false")
    private boolean keepSources;
    @Parameter(defaultValue="jsp")
    private String packageRoot;
    @Parameter(defaultValue="${basedir}/src/main/webapp")
    private String webAppSourceDirectory;
    @Parameter(defaultValue="${basedir}/src/main/webapp/WEB-INF/web.xml")
    private String webXml;
    @Parameter(defaultValue="**\\/*.jsp, **\\/*.jspx,  **\\/*.jspf")
    private String[] includes;
    @Parameter(defaultValue="**\\/.svn\\/**")
    private String[] excludes;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(defaultValue="false")
    private boolean validateXml;
    @Parameter(defaultValue="true")
    private boolean validateWebXmlAfterMerge;
    @Parameter(defaultValue="false")
    private boolean validateWebXmlWithXsdAfterMerge;
    @Parameter(defaultValue="http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd")
    private String webXmlXsdSchema;
    @Parameter
    private String httpProxyHost;
    @Parameter
    private String httpProxyPort;
    @Parameter
    private String httpNoProxyHosts;
    private boolean proxyEnvSet;
    private String httpProxyHostBackup;
    private String httpProxyPortBackup;
    private String httpNoProxyHostsBackup;
    @Parameter(defaultValue="UTF-8")
    private String javaEncoding;
    @Parameter(defaultValue="true")
    private boolean suppressSmap;
    @Parameter(defaultValue="false")
    private boolean ignoreJspFragmentErrors;
    @Parameter(defaultValue="true")
    private boolean stopAtFirstError;
    @Parameter(defaultValue="1")
    private int threads;
    @Parameter(defaultValue="true")
    private boolean enableJspTagPooling;
    @Parameter(defaultValue="false")
    private boolean trimSpaces;
    @Parameter(defaultValue="false")
    private boolean genStringAsCharArray;
    @Parameter(defaultValue="1.8")
    private String compilerVersion;
    @Parameter(defaultValue="org.apache.jasper.compiler.JDTCompiler")
    private String compilerClass;
    @Parameter(defaultValue="true")
    private boolean strictQuoteEscaping;
    private Map<String, NameEnvironmentAnswer> resourcesCache = new ConcurrentHashMap<String, NameEnvironmentAnswer>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)("verbose=" + this.verbose));
            this.getLog().info((CharSequence)("webAppSourceDirectory=" + this.webAppSourceDirectory));
            this.getLog().info((CharSequence)("generatedClasses=" + this.generatedClasses));
            this.getLog().info((CharSequence)("webXmlFragment=" + this.webXmlFragment));
            this.getLog().info((CharSequence)("webXml=" + this.webXml));
            this.getLog().info((CharSequence)("validateXml=" + this.validateXml));
            this.getLog().info((CharSequence)("packageRoot=" + this.packageRoot));
            this.getLog().info((CharSequence)("javaEncoding=" + this.javaEncoding));
            this.getLog().info((CharSequence)("insertionMarker=" + (this.insertionMarker == null || this.insertionMarker.equals("") ? END_OF_WEBAPP : this.insertionMarker)));
            this.getLog().info((CharSequence)("keepSources=" + this.keepSources));
            this.getLog().info((CharSequence)("mergeFragment=" + this.mergeFragment));
            this.getLog().info((CharSequence)("suppressSmap=" + this.suppressSmap));
            this.getLog().info((CharSequence)("ignoreJspFragmentErrors=" + this.ignoreJspFragmentErrors));
            this.getLog().info((CharSequence)("webXmlXsdSchema=" + this.webXmlXsdSchema));
            this.getLog().info((CharSequence)("stopAtFirstError=" + this.stopAtFirstError));
            this.getLog().info((CharSequence)("threads=" + this.threads));
            this.getLog().info((CharSequence)("enableJspTagPooling=" + this.enableJspTagPooling));
            this.getLog().info((CharSequence)("trimSpaces=" + this.trimSpaces));
            this.getLog().info((CharSequence)("genStringAsCharArray=" + this.genStringAsCharArray));
            this.getLog().info((CharSequence)("compilerVersion=" + this.compilerVersion));
            this.getLog().info((CharSequence)("compilerClass=" + this.compilerClass));
            this.getLog().info((CharSequence)("strictQuoteEscaping=" + this.strictQuoteEscaping));
        }
        try {
            long start = System.currentTimeMillis();
            this.prepare();
            this.compile();
            this.cleanupSrcs();
            this.mergeWebXml();
            long finish = System.currentTimeMillis();
            long millis = finish - start;
            String time = String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
            this.getLog().info((CharSequence)("Compilation completed in " + time));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure processing jsps", e);
        }
    }

    public void compile() throws IOException, InterruptedException, MojoExecutionException, ExecutionException, JasperException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<URL> urls = new ArrayList<URL>();
        this.setUpClassPath(urls);
        URLClassLoader ucl = new URLClassLoader(urls.toArray(new URL[0]), currentClassLoader);
        StringBuilder classpathStr = new StringBuilder();
        for (int i = 0; i < urls.size(); ++i) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("webappclassloader contains: " + urls.get(i)));
            }
            classpathStr.append(urls.get(i).getFile());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("added to classpath: " + urls.get(i).getFile()));
            }
            classpathStr.append(System.getProperty("path.separator"));
        }
        Thread.currentThread().setContextClassLoader(ucl);
        Object[] jspFiles = this.getJspFiles(this.webAppSourceDirectory);
        if (this.verbose) {
            this.getLog().info((CharSequence)("Files selected to precompile: " + StringUtils.join((Object[])jspFiles, (String)", ")));
        }
        ExecutorService executor = Executors.newFixedThreadPool(this.threads);
        List<Future<String>> results = executor.invokeAll(this.initJspcWorkers(classpathStr, (String[])jspFiles, this.initJspList((String[])jspFiles)));
        executor.shutdown();
        this.getLog().info((CharSequence)("Number total of jsps : " + jspFiles.length));
        this.manageResults(results);
        Thread.currentThread().setContextClassLoader(currentClassLoader);
    }

    private List<String> initJspList(String[] jspFiles) {
        ArrayList<String> jspFilesList = new ArrayList<String>();
        Collections.addAll(jspFilesList, jspFiles);
        return jspFilesList;
    }

    private List<JspcWorker> initJspcWorkers(StringBuilder classpathStr, String[] jspFiles, List<String> jspFilesList) throws JasperException, IOException {
        ArrayList<JspcWorker> workers = new ArrayList<JspcWorker>();
        int minItem = jspFiles.length / this.threads;
        int maxItem = minItem + 1;
        int threadsWithMaxItems = jspFiles.length - this.threads * minItem;
        int start = 0;
        JspCContextAccessor topJspC = this.initJspc(classpathStr, -1, null);
        for (int index = 0; index < this.threads; ++index) {
            int threadNumber = index + 1;
            int itemsCount = index < threadsWithMaxItems ? maxItem : minItem;
            int end = start + itemsCount;
            List<String> jspFilesSubList = jspFilesList.subList(start, end);
            if (jspFilesSubList.isEmpty()) {
                this.getLog().info((CharSequence)("Thread " + threadNumber + " have nothing to do, skip it"));
                continue;
            }
            JspCContextAccessor firstJspC = this.initJspc(classpathStr, index, topJspC);
            JspcWorker worker = new JspcWorker(firstJspC, jspFilesSubList);
            workers.add(worker);
            start = end;
            this.getLog().info((CharSequence)("Number of jsps for thread " + threadNumber + " : " + jspFilesSubList.size()));
        }
        return workers;
    }

    private JspCContextAccessor initJspc(StringBuilder classpathStr, int threadIndex, JspCContextAccessor topJspC) throws IOException, JasperException {
        JspCContextAccessor jspc = new JspCContextAccessor();
        jspc.setWebXmlInclude(this.getwebXmlFragmentFilename(threadIndex));
        jspc.setUriroot(this.webAppSourceDirectory);
        jspc.setPackage(this.packageRoot);
        jspc.setOutputDir(this.generatedClasses);
        jspc.setValidateXml(this.validateXml);
        jspc.setClassPath(classpathStr.toString());
        jspc.setCompile(true);
        jspc.setSmapSuppressed(this.suppressSmap);
        jspc.setSmapDumped(!this.suppressSmap);
        jspc.setJavaEncoding(this.javaEncoding);
        jspc.setFailOnError(this.stopAtFirstError);
        jspc.setPoolingEnabled(this.enableJspTagPooling);
        jspc.setTrimSpaces(this.trimSpaces ? TrimSpacesOption.TRUE : TrimSpacesOption.FALSE);
        jspc.setGenStringAsCharArray(this.genStringAsCharArray);
        jspc.setCompilerSourceVM(this.compilerVersion);
        jspc.setCompilerTargetVM(this.compilerVersion);
        jspc.setcompilerClass(this.compilerClass);
        jspc.setResourcesCache(this.resourcesCache);
        jspc.setStrictQuoteEscaping(this.strictQuoteEscaping);
        if (topJspC == null) {
            jspc.initClassLoader();
            jspc.initServletContext();
        } else {
            jspc.initContext(topJspC);
        }
        if (topJspC != null) {
            this.getLog().info((CharSequence)("Includes=" + StringUtils.join((Object[])this.includes, (String)",")));
            if (this.excludes != null) {
                this.getLog().info((CharSequence)("Excludes=" + StringUtils.join((Object[])this.excludes, (String)",")));
            }
        }
        if (this.verbose) {
            jspc.setVerbose(99);
        } else {
            jspc.setVerbose(0);
        }
        jspc.setThreadCount("1");
        return jspc;
    }

    private void manageResults(List<Future<String>> results) throws InterruptedException, ExecutionException, MojoExecutionException {
        boolean failTheBuild = false;
        for (Future<String> result : results) {
            if (result.get() == null) continue;
            this.getLog().error((CharSequence)result.get());
            failTheBuild = true;
        }
        if (failTheBuild) {
            throw new MojoExecutionException("see previous errors");
        }
    }

    private String[] getJspFiles(String webAppSrcDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(new File(webAppSrcDir));
        if (this.excludes != null && this.excludes.length != 0) {
            scanner.setExcludes(this.excludes);
        }
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.includes);
        scanner.setCaseSensitive(false);
        scanner.scan();
        Object[] includedFiles = scanner.getIncludedFiles();
        this.getLog().debug((CharSequence)String.format("Included files returned from directory scan: %s", StringUtils.join((Object[])includedFiles, (String)",")));
        this.getLog().debug((CharSequence)String.format("Excluded files returned from directory scan: %s", StringUtils.join((Object[])scanner.getExcludedFiles(), (String)",")));
        this.getLog().debug((CharSequence)String.format("Excluded directories returned from directory scan: %s", StringUtils.join((Object[])scanner.getExcludedDirectories(), (String)",")));
        return includedFiles;
    }

    public void cleanupSrcs() {
        File generatedClassesDir;
        if (!this.keepSources && (generatedClassesDir = new File(this.generatedClasses)).exists() && generatedClassesDir.isDirectory()) {
            JspcMojo.delete(generatedClassesDir, f -> f.isDirectory() || f.getName().endsWith(".java"));
        }
    }

    static void delete(File dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                JspcMojo.delete(f, filter);
                continue;
            }
            f.delete();
        }
    }

    public void mergeWebXml() throws IOException, MojoExecutionException {
        if (this.mergeFragment) {
            File webXmlFile = this.getWebXmlFile();
            if (!webXmlFile.exists()) {
                this.getLog().info((CharSequence)(webXmlFile.toString() + " does not exist, cannot merge with generated fragment"));
                return;
            }
            File mergedWebXml = new File(new File(this.getwebXmlFragmentFilename(0)).getParentFile(), WEB_XML);
            Path mergedWebXmlPath = this.createAndGetMergeWebXml(mergedWebXml);
            try (BufferedReader webXmlReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(webXmlFile), StandardCharsets.UTF_8));){
                this.writeWebXmlMergedFile(webXmlReader, mergedWebXmlPath);
            }
            if (this.validateWebXmlAfterMerge) {
                this.validateXmlContent(mergedWebXml);
            }
            if (this.validateWebXmlWithXsdAfterMerge) {
                this.validateWithXsd(mergedWebXml);
            }
        }
    }

    private Path createAndGetMergeWebXml(File mergedWebXml) throws IOException {
        Path mergedWebXmlPath = Paths.get(mergedWebXml.toURI());
        Files.deleteIfExists(mergedWebXmlPath);
        Files.createFile(mergedWebXmlPath, new FileAttribute[0]);
        return mergedWebXmlPath;
    }

    private void validateXmlContent(File mergedWebXml) throws IOException, MojoExecutionException {
        try {
            this.setHttpProxyIfNecessary();
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.parse(mergedWebXml);
        }
        catch (ParserConfigurationException e) {
            this.getLog().debug((CharSequence)"Unable to instanciate Document Builder, so web.xml merged validation is not possible", (Throwable)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Error when validating XML content of merged web.xml !", (Exception)e);
        }
        finally {
            this.restoreHttpProxy();
        }
    }

    private void validateWithXsd(File mergedWebXml) throws IOException, MojoExecutionException {
        try {
            this.setHttpProxyIfNecessary();
            StreamSource webXmlSource = new StreamSource(mergedWebXml);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema webXmlSchema = schemaFactory.newSchema(this.getWebXmlSchema());
            Validator validator = webXmlSchema.newValidator();
            validator.validate(webXmlSource);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Error when validating with XSD merged web.xml !", (Exception)e);
        }
        finally {
            this.restoreHttpProxy();
        }
    }

    private void setHttpProxyIfNecessary() {
        if (!this.proxyEnvSet && this.httpProxyHost != null && !this.httpProxyHost.isEmpty()) {
            this.proxyEnvSet = true;
            this.httpProxyHostBackup = System.getProperty("http.proxyHost");
            System.setProperty("http.proxyHost", this.httpProxyHost);
            this.httpProxyPortBackup = System.getProperty("http.proxyPort");
            System.setProperty("http.proxyPort", this.httpProxyPort);
            if (this.httpNoProxyHosts != null && !this.httpNoProxyHosts.isEmpty()) {
                this.httpNoProxyHostsBackup = System.getProperty("http.nonProxyHosts");
                System.setProperty("http.nonProxyHosts", this.httpNoProxyHosts);
            }
        }
    }

    private void restoreHttpProxy() {
        if (this.proxyEnvSet) {
            System.setProperty("http.proxyHost", this.httpProxyHostBackup != null ? this.httpProxyHostBackup : "");
            System.setProperty("http.proxyPort", this.httpProxyPortBackup != null ? this.httpProxyPortBackup : "");
            if (this.httpNoProxyHosts != null && !this.httpNoProxyHosts.isEmpty()) {
                System.setProperty("http.nonProxyHosts", this.httpNoProxyHostsBackup != null ? this.httpNoProxyHostsBackup : "");
            }
            this.proxyEnvSet = false;
        }
    }

    private StreamSource[] getWebXmlSchema() throws MalformedURLException {
        URL webXmlXsdUrl = new URL(this.webXmlXsdSchema);
        return new StreamSource[]{new StreamSource(webXmlXsdUrl.toExternalForm())};
    }

    private String writeWebXmlMergedFile(BufferedReader webXmlReader, Path mergedWebXmlPath) throws IOException {
        String marker = this.insertionMarker == null || this.insertionMarker.equals("") ? END_OF_WEBAPP : this.insertionMarker;
        String line = "";
        while ((line = webXmlReader.readLine()) != null) {
            if (line.indexOf(marker) >= 0) {
                this.writeXmlFragments(mergedWebXmlPath);
                this.writeEndOfWebappIfNecessary(mergedWebXmlPath, marker);
                continue;
            }
            Files.write(mergedWebXmlPath, (line + System.lineSeparator()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
        }
        return marker;
    }

    private void writeEndOfWebappIfNecessary(Path mergedWebXmlPath, String marker) throws IOException {
        if (marker.equals(END_OF_WEBAPP)) {
            Files.write(mergedWebXmlPath, END_OF_WEBAPP.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
        }
    }

    private void writeXmlFragments(Path mergedWebXmlPath) throws IOException {
        for (int index = 0; index < this.threads; ++index) {
            File fragmentWebXml = new File(this.getwebXmlFragmentFilename(index));
            if (!fragmentWebXml.exists()) {
                this.getLog().info((CharSequence)("No fragment web.xml file generated for thread " + index));
                continue;
            }
            Files.write(mergedWebXmlPath, Files.readAllBytes(Paths.get(fragmentWebXml.toURI())), StandardOpenOption.APPEND);
        }
    }

    private void prepare() {
        File generatedSourceDirectoryFile = new File(this.generatedClasses);
        if (!generatedSourceDirectoryFile.exists()) {
            generatedSourceDirectoryFile.mkdirs();
        }
    }

    private void setUpClassPath(List<URL> urls) throws IOException {
        String classesDir = this.classesDirectory.getCanonicalPath();
        classesDir = classesDir + (classesDir.endsWith(File.pathSeparator) ? "" : File.separator);
        urls.add(new File(classesDir).toURL());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Adding to classpath classes dir: " + classesDir));
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            if ("test".equals(artifact.getScope())) continue;
            String filePath = artifact.getFile().getCanonicalPath();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Adding to classpath dependency file: " + filePath));
            }
            urls.add(artifact.getFile().toURL());
        }
    }

    private File getWebXmlFile() throws IOException {
        File file = null;
        File baseDir = this.project.getBasedir().getCanonicalFile();
        File defaultWebAppSrcDir = new File(baseDir, "src/main/webapp").getCanonicalFile();
        File webAppSrcDir = new File(this.webAppSourceDirectory).getCanonicalFile();
        File defaultWebXml = new File(defaultWebAppSrcDir, WEB_XML).getCanonicalFile();
        File webXmlFile = new File(this.webXml).getCanonicalFile();
        if (webXmlFile.compareTo(defaultWebXml) != 0) {
            file = new File(this.webXml);
            return file;
        }
        file = new File(webAppSrcDir, WEB_XML);
        return file;
    }

    private String getwebXmlFragmentFilename(int threadIndex) {
        return this.threads == 1 ? this.webXmlFragment : this.webXmlFragment + "." + threadIndex;
    }
}

