/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal.grpc;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Codec;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.otlp.internal.ExporterMetrics;
import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.otlp.internal.grpc.ManagedChannelUtil;
import io.opentelemetry.exporter.otlp.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DefaultGrpcExporter<T extends Marshaler>
implements GrpcExporter<T> {
    private static final Logger internalLogger = Logger.getLogger(DefaultGrpcExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final String type;
    private final ExporterMetrics exporterMetrics;
    private final ManagedChannel managedChannel;
    private final MarshalerServiceStub<T, ?, ?> stub;
    private final long timeoutNanos;

    DefaultGrpcExporter(String type, ManagedChannel channel, MarshalerServiceStub<T, ?, ?> stub, MeterProvider meterProvider, long timeoutNanos, boolean compressionEnabled) {
        this.type = type;
        this.exporterMetrics = ExporterMetrics.createGrpc(type, meterProvider);
        this.managedChannel = channel;
        this.timeoutNanos = timeoutNanos;
        Codec codec = compressionEnabled ? new Codec.Gzip() : Codec.Identity.NONE;
        this.stub = (MarshalerServiceStub)stub.withCompression(codec.getMessageEncoding());
    }

    @Override
    public CompletableResultCode export(T exportRequest, final int numItems) {
        this.exporterMetrics.addSeen(numItems);
        final CompletableResultCode result = new CompletableResultCode();
        MarshalerServiceStub stub = this.stub;
        if (this.timeoutNanos > 0L) {
            stub = (MarshalerServiceStub)stub.withDeadlineAfter(this.timeoutNanos, TimeUnit.NANOSECONDS);
        }
        Futures.addCallback(stub.export(exportRequest), (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(@Nullable Object unused) {
                DefaultGrpcExporter.this.exporterMetrics.addSuccess(numItems);
                result.succeed();
            }

            public void onFailure(Throwable t) {
                DefaultGrpcExporter.this.exporterMetrics.addFailed(numItems);
                Status status = Status.fromThrowable((Throwable)t);
                switch (status.getCode()) {
                    case UNIMPLEMENTED: {
                        DefaultGrpcExporter.this.logger.log(Level.SEVERE, "Failed to export " + DefaultGrpcExporter.this.type + "s. Server responded with UNIMPLEMENTED. This usually means that your collector is not configured with an otlp receiver in the \"pipelines\" section of the configuration. Full error message: " + status.getDescription());
                        break;
                    }
                    case UNAVAILABLE: {
                        DefaultGrpcExporter.this.logger.log(Level.SEVERE, "Failed to export " + DefaultGrpcExporter.this.type + "s. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network. Full error message:" + status.getDescription());
                        break;
                    }
                    default: {
                        DefaultGrpcExporter.this.logger.log(Level.WARNING, "Failed to export " + DefaultGrpcExporter.this.type + "s. Server responded with gRPC status code " + status.getCode().value() + ". Error message: " + status.getDescription());
                    }
                }
                if (DefaultGrpcExporter.this.logger.isLoggable(Level.FINEST)) {
                    DefaultGrpcExporter.this.logger.log(Level.FINEST, "Failed to export " + DefaultGrpcExporter.this.type + "s. Details follow: " + t);
                }
                result.fail();
            }
        }, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.managedChannel.isTerminated()) {
            return CompletableResultCode.ofSuccess();
        }
        return ManagedChannelUtil.shutdownChannel(this.managedChannel);
    }
}

