/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal.metrics;

import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.MarshalerUtil;
import io.opentelemetry.exporter.otlp.internal.MarshalerWithSize;
import io.opentelemetry.exporter.otlp.internal.ProtoFieldInfo;
import io.opentelemetry.exporter.otlp.internal.Serializer;
import io.opentelemetry.exporter.otlp.internal.metrics.NumberDataPointMarshaler;
import io.opentelemetry.proto.metrics.v1.internal.Gauge;
import io.opentelemetry.sdk.metrics.data.GaugeData;
import io.opentelemetry.sdk.metrics.data.PointData;
import java.io.IOException;

final class GaugeMarshaler
extends MarshalerWithSize {
    private final NumberDataPointMarshaler[] dataPoints;

    static GaugeMarshaler create(GaugeData<? extends PointData> gauge) {
        NumberDataPointMarshaler[] dataPointMarshalers = NumberDataPointMarshaler.createRepeated(gauge.getPoints());
        return new GaugeMarshaler(dataPointMarshalers);
    }

    private GaugeMarshaler(NumberDataPointMarshaler[] dataPoints) {
        super(GaugeMarshaler.calculateSize(dataPoints));
        this.dataPoints = dataPoints;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeRepeatedMessage(Gauge.DATA_POINTS, this.dataPoints);
    }

    private static int calculateSize(NumberDataPointMarshaler[] dataPoints) {
        int size = 0;
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Gauge.DATA_POINTS, (Marshaler[])dataPoints);
    }
}

