/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugins.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.StatisticsReportingArtifactFilter;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.slf4j.Logger;

public final class FilterUtils {
    private FilterUtils() {
    }

    public static Set<MavenProject> filterProjects(Set<MavenProject> projects, List<String> includes, List<String> excludes, boolean actTransitively, Logger logger) {
        ArrayList<Object> allFilters = new ArrayList<Object>();
        AndArtifactFilter filter = new AndArtifactFilter();
        if (!includes.isEmpty()) {
            PatternIncludesArtifactFilter includeFilter = new PatternIncludesArtifactFilter(includes, actTransitively);
            filter.add((ArtifactFilter)includeFilter);
            allFilters.add(includeFilter);
        }
        if (!excludes.isEmpty()) {
            PatternExcludesArtifactFilter excludeFilter = new PatternExcludesArtifactFilter(excludes, actTransitively);
            filter.add((ArtifactFilter)excludeFilter);
            allFilters.add(excludeFilter);
        }
        LinkedHashSet<MavenProject> result = new LinkedHashSet<MavenProject>(projects.size());
        for (MavenProject mavenProject : projects) {
            Artifact artifact = mavenProject.getArtifact();
            if (!filter.include(artifact)) continue;
            result.add(mavenProject);
        }
        for (PatternIncludesArtifactFilter patternIncludesArtifactFilter : allFilters) {
            if (patternIncludesArtifactFilter == null) continue;
            patternIncludesArtifactFilter.reportMissedCriteria(logger);
        }
        return result;
    }

    public static void filterArtifacts(Set<Artifact> artifacts, List<String> includes, List<String> excludes, boolean strictFiltering, boolean actTransitively, Logger logger, ArtifactFilter ... additionalFilters) throws InvalidAssemblerConfigurationException {
        ArrayList<ArtifactFilter> allFilters = new ArrayList<ArtifactFilter>();
        AndArtifactFilter filter = new AndArtifactFilter();
        if (additionalFilters != null) {
            for (ArtifactFilter additionalFilter : additionalFilters) {
                if (additionalFilter == null) continue;
                filter.add(additionalFilter);
            }
        }
        if (!includes.isEmpty()) {
            PatternIncludesArtifactFilter includeFilter = new PatternIncludesArtifactFilter(includes, actTransitively);
            filter.add((ArtifactFilter)includeFilter);
            allFilters.add((ArtifactFilter)includeFilter);
        }
        if (!excludes.isEmpty()) {
            PatternExcludesArtifactFilter excludeFilter = new PatternExcludesArtifactFilter(excludes, actTransitively);
            filter.add((ArtifactFilter)excludeFilter);
            allFilters.add((ArtifactFilter)excludeFilter);
        }
        Iterator<Artifact> it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = it.next();
            if (filter.include(artifact)) continue;
            it.remove();
            if (!logger.isDebugEnabled()) continue;
            logger.debug(artifact.getId() + " was removed by one or more filters.");
        }
        FilterUtils.reportFilteringStatistics(allFilters, logger);
        for (ArtifactFilter f : allFilters) {
            if (!(f instanceof StatisticsReportingArtifactFilter)) continue;
            StatisticsReportingArtifactFilter sFilter = (StatisticsReportingArtifactFilter)f;
            if (!strictFiltering || !sFilter.hasMissedCriteria()) continue;
            throw new InvalidAssemblerConfigurationException("One or more filters had unmatched criteria. Check debug log for more information.");
        }
    }

    public static void reportFilteringStatistics(Collection<ArtifactFilter> filters, Logger logger) {
        for (ArtifactFilter f : filters) {
            if (!(f instanceof StatisticsReportingArtifactFilter)) continue;
            StatisticsReportingArtifactFilter sFilter = (StatisticsReportingArtifactFilter)f;
            if (logger.isDebugEnabled()) {
                logger.debug("Statistics for " + sFilter + "\n");
            }
            sFilter.reportMissedCriteria(logger);
            sFilter.reportFilteredArtifacts(logger);
        }
    }

    public static ScopeFilter newScopeFilter(String rootScope) {
        return FilterUtils.newScopeFilter(Collections.singleton(rootScope));
    }

    public static ScopeFilter newScopeFilter(Collection<String> rootScopes) {
        HashSet<String> scopes = new HashSet<String>();
        for (String rootScope : rootScopes) {
            if ("compile".equals(rootScope)) {
                scopes.addAll(Arrays.asList("compile", "provided", "system"));
            }
            if ("provided".equals(rootScope)) {
                scopes.add("provided");
            }
            if ("runtime".equals(rootScope)) {
                scopes.addAll(Arrays.asList("compile", "runtime"));
            }
            if ("system".equals(rootScope)) {
                scopes.add("system");
            }
            if (!"test".equals(rootScope)) continue;
            scopes.addAll(Arrays.asList("compile", "provided", "runtime", "system", "test"));
        }
        return ScopeFilter.including(scopes);
    }
}

