/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer.asm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Set;
import org.apache.maven.shared.dependency.analyzer.ClassFileVisitor;
import org.apache.maven.shared.dependency.analyzer.ClassesPatterns;
import org.apache.maven.shared.dependency.analyzer.DependencyUsage;
import org.apache.maven.shared.dependency.analyzer.asm.ConstantPoolParser;
import org.apache.maven.shared.dependency.analyzer.asm.DefaultAnnotationVisitor;
import org.apache.maven.shared.dependency.analyzer.asm.DefaultClassVisitor;
import org.apache.maven.shared.dependency.analyzer.asm.DefaultFieldVisitor;
import org.apache.maven.shared.dependency.analyzer.asm.DefaultMethodVisitor;
import org.apache.maven.shared.dependency.analyzer.asm.DefaultSignatureVisitor;
import org.apache.maven.shared.dependency.analyzer.asm.ResultCollector;
import org.apache.maven.shared.dependency.analyzer.asm.UnknownConstantPoolTypeException;
import org.apache.maven.shared.dependency.analyzer.asm.VisitClassException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class DependencyClassFileVisitor
implements ClassFileVisitor {
    private static final int BUF_SIZE = 8192;
    private final ResultCollector resultCollector = new ResultCollector();
    private final ClassesPatterns excludedClasses;

    public DependencyClassFileVisitor(ClassesPatterns excludedClasses) {
        this.excludedClasses = excludedClasses;
    }

    public DependencyClassFileVisitor() {
        this(new ClassesPatterns());
    }

    @Override
    public void visitClass(String className, InputStream in) {
        try {
            byte[] byteCode = this.toByteArray(in);
            if (this.excludedClasses.isMatch(className)) {
                return;
            }
            ClassReader reader = new ClassReader(byteCode);
            Set<String> constantPoolClassRefs = ConstantPoolParser.getConstantPoolClassReferences(byteCode);
            for (String string : constantPoolClassRefs) {
                this.resultCollector.addName(className, string);
            }
            DefaultAnnotationVisitor annotationVisitor = new DefaultAnnotationVisitor(this.resultCollector, className);
            DefaultSignatureVisitor signatureVisitor = new DefaultSignatureVisitor(this.resultCollector, className);
            DefaultFieldVisitor fieldVisitor = new DefaultFieldVisitor(annotationVisitor, this.resultCollector, className);
            DefaultMethodVisitor methodVisitor = new DefaultMethodVisitor(annotationVisitor, signatureVisitor, this.resultCollector, className);
            DefaultClassVisitor classVisitor = new DefaultClassVisitor(signatureVisitor, annotationVisitor, fieldVisitor, methodVisitor, this.resultCollector, className);
            reader.accept((ClassVisitor)classVisitor, 0);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
        catch (IndexOutOfBoundsException e) {
            throw new VisitClassException("Unable to process: " + className, e);
        }
        catch (IllegalArgumentException | UnknownConstantPoolTypeException e) {
            throw new VisitClassException("Byte code of '" + className + "' is corrupt", e);
        }
    }

    private byte[] toByteArray(InputStream in) throws IOException {
        int i;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((i = in.read(buffer)) > 0) {
            out.write(buffer, 0, i);
        }
        return out.toByteArray();
    }

    public Set<String> getDependencies() {
        return this.resultCollector.getDependencies();
    }

    public Set<DependencyUsage> getDependencyUsages() {
        return this.resultCollector.getDependencyUsages();
    }
}

