/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.syntax.Types;
import org.eclipse.jdt.groovy.search.VariableScope;

public class AssignmentStorer {
    public void storeAssignment(BinaryExpression exp, VariableScope scope, ClassNode rhsType) {
        assert (Types.ofType(exp.getOperation().getType(), 1100));
        if (exp instanceof DeclarationExpression) {
            DeclarationExpression decl = (DeclarationExpression)exp;
            if (decl.isMultipleAssignmentDeclaration()) {
                TupleExpression vars = decl.getTupleExpression();
                AssignmentStorer.handleMultiAssignment(vars, decl.getRightExpression(), scope, rhsType);
            } else {
                VariableExpression var = decl.getVariableExpression();
                scope.addVariable(var.getName(), AssignmentStorer.findVariableType(var, rhsType), null);
            }
        } else {
            Expression lhs = exp.getLeftExpression();
            if (lhs instanceof TupleExpression) {
                TupleExpression tuple = (TupleExpression)lhs;
                AssignmentStorer.handleMultiAssignment(tuple, exp.getRightExpression(), scope, rhsType);
            } else {
                AssignmentStorer.handleSingleAssignment(lhs, scope, rhsType);
            }
        }
    }

    public void storeField(FieldNode node, VariableScope scope) {
        Expression init = node.getInitialExpression();
        if (init != null && !VariableScope.OBJECT_CLASS_NODE.equals(init.getType())) {
            scope.addVariable(node.getName(), init.getType(), node.getDeclaringClass());
        }
    }

    public void storeImport(ImportNode node, VariableScope scope) {
        block6: {
            List<MethodNode> methods;
            ClassNode type;
            block5: {
                type = node.getType();
                if (!node.isStar() || type == null) break block5;
                List<FieldNode> fields = type.getFields();
                for (FieldNode field : fields) {
                    if (!field.isStatic()) continue;
                    scope.addVariable(field.getName(), field.getType(), type);
                }
                List<MethodNode> methods2 = node.getType().getMethods();
                for (MethodNode method : methods2) {
                    if (!method.isStatic()) continue;
                    scope.addVariable(method.getName(), method.getReturnType(), type);
                }
                break block6;
            }
            String fieldName = node.getFieldName();
            if (!node.isStatic() || type == null || fieldName == null) break block6;
            String alias = node.getAlias() != null ? node.getAlias() : fieldName;
            FieldNode field = type.getField(fieldName);
            if (field != null) {
                scope.addVariable(alias, field.getType(), type);
            }
            if ((methods = type.getDeclaredMethods(fieldName)) != null) {
                for (MethodNode method : methods) {
                    scope.addVariable(alias, method.getReturnType(), type);
                }
            }
        }
    }

    private static void handleMultiAssignment(TupleExpression lhs, Expression rhs, VariableScope scope, ClassNode rhsListType) {
        List<Expression> lhsExprs = lhs.getExpressions();
        List rhsExprs = rhs instanceof ListExpression ? ((ListExpression)rhs).getExpressions() : Collections.emptyList();
        int i = 0;
        int lhsSize = lhsExprs.size();
        int rhsSize = rhsExprs.size();
        while (i < lhsSize) {
            ClassNode rhsType;
            Expression lhsExpr = lhsExprs.get(i);
            ClassNode classNode = rhsType = i < rhsSize ? ((Expression)rhsExprs.get(i)).getType() : AssignmentStorer.findComponentType(rhsListType);
            if (lhsExpr instanceof VariableExpression) {
                VariableExpression var = (VariableExpression)lhsExpr;
                scope.addVariable(var.getName(), AssignmentStorer.findVariableType(var, rhsType), null);
            }
            ++i;
        }
    }

    private static void handleSingleAssignment(Expression lhs, VariableScope scope, ClassNode rhsType) {
        if (lhs instanceof VariableExpression) {
            VariableExpression var = (VariableExpression)lhs;
            if (scope.inScriptRunMethod() || scope.getEnclosingClosure() != null || scope.getEnclosingTypeDeclaration().equals(AssignmentStorer.findDeclaringType(var))) {
                scope.updateOrAddVariable(var.getName(), AssignmentStorer.findVariableType(var, rhsType), AssignmentStorer.findDeclaringType(var));
            } else {
                scope.updateVariable(var.getName(), AssignmentStorer.findVariableType(var, rhsType), AssignmentStorer.findDeclaringType(var));
            }
            scope.getWormhole().put("lhs", lhs);
        } else if (lhs instanceof ConstantExpression) {
            scope.getWormhole().put("lhs", lhs);
            lhs.putNodeMetaData("rhsType", rhsType);
        } else if (lhs instanceof PropertyExpression) {
            PropertyExpression exp = (PropertyExpression)lhs;
            AssignmentStorer.handleSingleAssignment(exp.getProperty(), scope, rhsType);
        }
    }

    private static ClassNode findComponentType(ClassNode type) {
        return type == null ? VariableScope.OBJECT_CLASS_NODE : VariableScope.extractElementType(type);
    }

    private static ClassNode findDeclaringType(VariableExpression var) {
        if (var.getAccessedVariable() instanceof AnnotatedNode) {
            return ((AnnotatedNode)((Object)var.getAccessedVariable())).getDeclaringClass();
        }
        return null;
    }

    private static ClassNode findVariableType(VariableExpression var, ClassNode rhsType) {
        ClassNode varType = var.getOriginType();
        if (varType == null) {
            varType = var.getType();
        }
        if (varType != null && !VariableScope.isVoidOrObject(varType)) {
            return varType;
        }
        if (rhsType != null && !VariableScope.isVoidOrObject(rhsType)) {
            return rhsType;
        }
        return VariableScope.OBJECT_CLASS_NODE;
    }
}

