/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.converter;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBlockBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirComponentCallBuilder;
import org.jetbrains.kotlin.fir.lightTree.fir.DestructuringDeclaration;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStringTemplateExpressionElementType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a/\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0019\u0010\u0016\u001a\u0015\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0017\u00a2\u0006\u0002\b\u0018H\u0086\b\u00f8\u0001\u0000\u001a/\u0010\u0019\u001a\u0002H\u001a\"\b\b\u0000\u0010\u001a*\u00020\u001b*\u0002H\u001a2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u001c\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u001d\u001a\n\u0010\u001e\u001a\u00020\u001f*\u00020\u0015\u001a\n\u0010 \u001a\u00020\u0002*\u00020\u001f\u001a\n\u0010!\u001a\u00020\u0012*\u00020\u0015\u001a\u0016\u0010\"\u001a\u00020#*\u0004\u0018\u00010\u001f2\b\b\u0002\u0010$\u001a\u00020\u001f\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006%"}, d2={"expressionSet", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "qualifiedAccessTokens", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getQualifiedAccessTokens", "()Lcom/intellij/psi/tree/TokenSet;", "generateDestructuringBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "multiDeclaration", "Lorg/jetbrains/kotlin/fir/lightTree/fir/DestructuringDeclaration;", "container", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "tmpVariable", "", "isClassLocal", "classNode", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "getParent", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "extractArgumentsFrom", "T", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;", "stubMode", "(Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;Ljava/util/List;Z)Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;", "getAsStringWithoutBacktick", "", "getOperationSymbol", "isExpression", "nameAsSafeName", "Lorg/jetbrains/kotlin/name/Name;", "defaultName", "light-tree2fir"})
public final class ConverterUtilKt {
    private static final List<IElementType> expressionSet = CollectionsKt.listOf((Object[])new IElementType[]{KtNodeTypes.REFERENCE_EXPRESSION, KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.LAMBDA_EXPRESSION, KtNodeTypes.FUN});
    private static final TokenSet qualifiedAccessTokens;

    @NotNull
    public static final TokenSet getQualifiedAccessTokens() {
        return qualifiedAccessTokens;
    }

    @NotNull
    public static final Name nameAsSafeName(@Nullable String $this$nameAsSafeName, @NotNull String defaultName) {
        Name name;
        Intrinsics.checkNotNullParameter((Object)defaultName, (String)"defaultName");
        if ($this$nameAsSafeName != null) {
            Name name2 = Name.identifier(StringsKt.replace$default((String)$this$nameAsSafeName, (String)"`", (String)"", (boolean)false, (int)4, null));
            name = name2;
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(this.replace(\"`\", \"\"))");
        } else {
            CharSequence charSequence = defaultName;
            boolean bl = false;
            if (charSequence.length() > 0) {
                Name name3 = Name.identifier(defaultName);
                name = name3;
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"Name.identifier(defaultName)");
            } else {
                Name name4 = SpecialNames.NO_NAME_PROVIDED;
                name = name4;
                Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"SpecialNames.NO_NAME_PROVIDED");
            }
        }
        return name;
    }

    public static /* synthetic */ Name nameAsSafeName$default(String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string3 = "";
        }
        return ConverterUtilKt.nameAsSafeName(string2, string3);
    }

    @NotNull
    public static final IElementType getOperationSymbol(@NotNull String $this$getOperationSymbol) {
        Intrinsics.checkNotNullParameter((Object)$this$getOperationSymbol, (String)"$this$getOperationSymbol");
        TokenSet tokenSet = KotlinExpressionParsing.ALL_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"KotlinExpressionParsing.ALL_OPERATIONS");
        IElementType[] iElementTypeArray = tokenSet.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"KotlinExpressionParsing.ALL_OPERATIONS.types");
        IElementType[] $this$forEach$iv = iElementTypeArray;
        boolean $i$f$forEach = false;
        IElementType[] iElementTypeArray2 = $this$forEach$iv;
        int n = iElementTypeArray2.length;
        for (int i = 0; i < n; ++i) {
            IElementType element$iv;
            IElementType it = element$iv = iElementTypeArray2[i];
            boolean bl = false;
            if (!(it instanceof KtSingleValueToken) || !Intrinsics.areEqual((Object)((KtSingleValueToken)it).getValue(), (Object)$this$getOperationSymbol)) continue;
            return it;
        }
        if (Intrinsics.areEqual((Object)$this$getOperationSymbol, (Object)"as?")) {
            KtToken ktToken = KtTokens.AS_SAFE;
            Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"KtTokens.AS_SAFE");
            return ktToken;
        }
        KtToken ktToken = KtTokens.IDENTIFIER;
        Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"KtTokens.IDENTIFIER");
        return ktToken;
    }

    @NotNull
    public static final String getAsStringWithoutBacktick(@NotNull LighterASTNode $this$getAsStringWithoutBacktick) {
        Intrinsics.checkNotNullParameter((Object)$this$getAsStringWithoutBacktick, (String)"$this$getAsStringWithoutBacktick");
        return StringsKt.replace$default((String)$this$getAsStringWithoutBacktick.toString(), (String)"`", (String)"", (boolean)false, (int)4, null);
    }

    public static final boolean isExpression(@NotNull LighterASTNode $this$isExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$isExpression, (String)"$this$isExpression");
        IElementType iElementType = $this$isExpression.getTokenType();
        return iElementType instanceof KtNodeType || iElementType instanceof KtConstantExpressionElementType || iElementType instanceof KtStringTemplateExpressionElementType || expressionSet.contains(iElementType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends FirCallBuilder> T extractArgumentsFrom(@NotNull T $this$extractArgumentsFrom, @NotNull List<? extends FirExpression> container, boolean stubMode) {
        Intrinsics.checkNotNullParameter($this$extractArgumentsFrom, (String)"$this$extractArgumentsFrom");
        Intrinsics.checkNotNullParameter(container, (String)"container");
        if (!stubMode || $this$extractArgumentsFrom instanceof FirAnnotationCallBuilder) {
            void $this$buildArgumentList;
            boolean $i$f$buildArgumentList = false;
            boolean bl = false;
            FirArgumentListBuilder firArgumentListBuilder = new FirArgumentListBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            FirArgumentListBuilder firArgumentListBuilder2 = firArgumentListBuilder;
            T t = $this$extractArgumentsFrom;
            boolean bl4 = false;
            Collection collection = $this$buildArgumentList.getArguments();
            Iterable iterable = container;
            boolean bl5 = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            Unit unit = Unit.INSTANCE;
            t.setArgumentList(firArgumentListBuilder.build());
        }
        return $this$extractArgumentsFrom;
    }

    public static final boolean isClassLocal(@NotNull LighterASTNode classNode, @NotNull Function1<? super LighterASTNode, ? extends LighterASTNode> getParent) {
        int $i$f$isClassLocal = 0;
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        Intrinsics.checkNotNullParameter(getParent, (String)"getParent");
        LighterASTNode currentNode = classNode;
        while (currentNode != null) {
            IElementType tokenType = currentNode.getTokenType();
            LighterASTNode parent2 = (LighterASTNode)getParent.invoke((Object)currentNode);
            if (Intrinsics.areEqual((Object)tokenType, (Object)KtNodeTypes.PROPERTY) || Intrinsics.areEqual((Object)tokenType, (Object)KtNodeTypes.FUN)) {
                LighterASTNode lighterASTNode = parent2;
                LighterASTNode grandParent = lighterASTNode != null ? (LighterASTNode)getParent.invoke((Object)lighterASTNode) : null;
                LighterASTNode lighterASTNode2 = parent2;
                if (Intrinsics.areEqual((Object)(lighterASTNode2 != null ? lighterASTNode2.getTokenType() : null), (Object)KtNodeTypes.KT_FILE)) {
                    return true;
                }
                LighterASTNode lighterASTNode3 = parent2;
                if (Intrinsics.areEqual((Object)(lighterASTNode3 != null ? lighterASTNode3.getTokenType() : null), (Object)KtNodeTypes.CLASS_BODY)) {
                    LighterASTNode lighterASTNode4;
                    LighterASTNode lighterASTNode5 = grandParent;
                    if (!Intrinsics.areEqual((Object)(lighterASTNode5 != null ? lighterASTNode5.getTokenType() : null), (Object)KtNodeTypes.OBJECT_DECLARATION) || !Intrinsics.areEqual((lighterASTNode4 = grandParent) != null && (lighterASTNode4 = (LighterASTNode)getParent.invoke((Object)lighterASTNode4)) != null ? lighterASTNode4.getTokenType() : null, (Object)KtNodeTypes.OBJECT_LITERAL)) {
                        return true;
                    }
                }
                LighterASTNode lighterASTNode6 = parent2;
                if (Intrinsics.areEqual((Object)(lighterASTNode6 != null ? lighterASTNode6.getTokenType() : null), (Object)KtNodeTypes.BLOCK)) {
                    LighterASTNode lighterASTNode7 = grandParent;
                    if (Intrinsics.areEqual((Object)(lighterASTNode7 != null ? lighterASTNode7.getTokenType() : null), (Object)KtNodeTypes.SCRIPT)) {
                        return true;
                    }
                }
                LighterASTNode lighterASTNode8 = parent2;
                if (Intrinsics.areEqual((Object)(lighterASTNode8 != null ? lighterASTNode8.getTokenType() : null), (Object)KtNodeTypes.ENUM_ENTRY)) {
                    return true;
                }
            }
            if (Intrinsics.areEqual((Object)tokenType, (Object)KtNodeTypes.BLOCK)) {
                return true;
            }
            currentNode = parent2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirExpression generateDestructuringBlock(@NotNull FirSession session2, @NotNull DestructuringDeclaration multiDeclaration, @NotNull FirVariable<?> container, boolean tmpVariable) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)multiDeclaration, (String)"multiDeclaration");
        Intrinsics.checkNotNullParameter(container, (String)"container");
        boolean $i$f$buildBlock = false;
        boolean bl = false;
        FirBlockBuilder firBlockBuilder = new FirBlockBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirBlockBuilder $this$buildBlock = firBlockBuilder;
        boolean bl4 = false;
        if (tmpVariable) {
            Collection collection = $this$buildBlock.getStatements();
            FirVariable<?> firVariable = container;
            boolean bl5 = false;
            collection.add(firVariable);
        }
        boolean isVar = multiDeclaration.isVar();
        boolean bl6 = false;
        for (FirVariable entry : (Iterable)multiDeclaration.getEntries()) {
            void index2;
            void $this$buildComponentCall;
            Collection collection = $this$buildBlock.getStatements();
            boolean $i$f$buildProperty = false;
            boolean bl7 = false;
            FirPropertyBuilder firPropertyBuilder = new FirPropertyBuilder();
            boolean bl8 = false;
            boolean bl9 = false;
            FirPropertyBuilder $this$buildProperty = firPropertyBuilder;
            boolean bl10 = false;
            $this$buildProperty.setSession(session2);
            $this$buildProperty.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$buildProperty.setReturnTypeRef(entry.getReturnTypeRef());
            $this$buildProperty.setName(entry.getName());
            boolean $i$f$buildComponentCall = false;
            boolean bl11 = false;
            Object object = new FirComponentCallBuilder();
            boolean bl12 = false;
            boolean bl13 = false;
            FirComponentCallBuilder firComponentCallBuilder = object;
            FirPropertyBuilder firPropertyBuilder2 = $this$buildProperty;
            boolean bl14 = false;
            $this$buildComponentCall.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(null, container));
            $this$buildComponentCall.setComponentIndex((int)(index2 + true));
            Unit unit = Unit.INSTANCE;
            firPropertyBuilder2.setInitializer(((FirComponentCallBuilder)object).build());
            $this$buildProperty.setVar(isVar);
            $this$buildProperty.setSymbol(new FirPropertySymbol(entry.getName()));
            $this$buildProperty.setSource(entry.getSource());
            $this$buildProperty.setLocal(true);
            $this$buildProperty.setStatus(new FirDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL));
            Collection collection2 = $this$buildProperty.getAnnotations();
            object = entry.getAnnotations();
            bl12 = false;
            CollectionsKt.addAll((Collection)collection2, (Iterable)object);
            FirProperty firProperty = firPropertyBuilder.build();
            bl7 = false;
            collection.add(firProperty);
            ++index2;
        }
        return firBlockBuilder.build();
    }

    static {
        TokenSet tokenSet = TokenSet.create(KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.SAFE_ACCESS_EXPRESSION);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.create(DOT_QUAL\u2026, SAFE_ACCESS_EXPRESSION)");
        qualifiedAccessTokens = tokenSet;
    }
}

