/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.scopes.impl.FirIntegerOperatorCall;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u0004\u0018\u00010\u0006*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u0006*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/EmptyRangeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "()V", "asLong", "", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirIntegerOperatorCall;", "getAsLong", "(Lorg/jetbrains/kotlin/fir/scopes/impl/FirIntegerOperatorCall;)Ljava/lang/Long;", "rangeLeft", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "getRangeLeft", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Ljava/lang/Long;", "rangeRight", "getRangeRight", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class EmptyRangeChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final EmptyRangeChecker INSTANCE = new EmptyRangeChecker();

    private EmptyRangeChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean needReport;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (expression2.getSource() instanceof FirFakeSourceElement) {
            return;
        }
        if (!(expression2 instanceof FirFunctionCall)) {
            return;
        }
        Long l = this.getRangeLeft((FirFunctionCall)expression2);
        if (l == null) {
            return;
        }
        long left = l;
        Long l2 = this.getRangeRight((FirFunctionCall)expression2);
        if (l2 == null) {
            return;
        }
        long right = l2;
        switch (((FirFunctionCall)expression2).getCalleeReference().getName().asString()) {
            case "rangeTo": {
                boolean bl;
                if (left > right) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "downTo": {
                boolean bl;
                if (right > left) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "until": {
                boolean bl;
                if (left >= right) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = needReport = false;
            }
        }
        if (needReport) {
            void source$iv;
            Object object = reporter;
            FirSourceElement firSourceElement = expression2.getSource();
            FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv = FirErrors.INSTANCE.getEMPTY_RANGE();
            boolean $i$f$report = false;
            void var13_13 = source$iv;
            if (var13_13 != null) {
                void $this$report$iv;
                void var14_14 = var13_13;
                boolean bl = false;
                boolean bl2 = false;
                void it$iv = var14_14;
                boolean bl3 = false;
                $this$report$iv.report((FirDiagnostic)factory$iv.on((FirSourceElement)it$iv));
            }
        }
    }

    private final Long getRangeLeft(FirFunctionCall $this$rangeLeft) {
        Long l;
        if ($this$rangeLeft.getExplicitReceiver() instanceof FirIntegerOperatorCall) {
            FirIntegerOperatorCall firIntegerOperatorCall;
            FirExpression firExpression2 = $this$rangeLeft.getExplicitReceiver();
            FirIntegerOperatorCall firIntegerOperatorCall2 = firIntegerOperatorCall = firExpression2 instanceof FirIntegerOperatorCall ? (FirIntegerOperatorCall)firExpression2 : null;
            l = firIntegerOperatorCall == null ? null : this.getAsLong(firIntegerOperatorCall);
        } else {
            FirExpression firExpression3 = $this$rangeLeft.getExplicitReceiver();
            FirConstExpression firConstExpression = firExpression3 instanceof FirConstExpression ? (FirConstExpression)firExpression3 : null;
            Object var2_5 = firConstExpression == null ? null : firConstExpression.getValue();
            l = var2_5 instanceof Long ? (Long)var2_5 : null;
        }
        return l;
    }

    private final Long getRangeRight(FirFunctionCall $this$rangeRight) {
        Long l;
        FirExpression arg = (FirExpression)CollectionsKt.getOrNull($this$rangeRight.getArgumentList().getArguments(), (int)0);
        if (arg instanceof FirIntegerOperatorCall) {
            l = this.getAsLong((FirIntegerOperatorCall)arg);
        } else {
            FirConstExpression firConstExpression = arg instanceof FirConstExpression ? (FirConstExpression)arg : null;
            Object var3_4 = firConstExpression == null ? null : firConstExpression.getValue();
            l = var3_4 instanceof Long ? (Long)var3_4 : null;
        }
        return l;
    }

    private final Long getAsLong(FirIntegerOperatorCall $this$asLong) {
        FirExpression firExpression2 = $this$asLong.getDispatchReceiver();
        FirConstExpression firConstExpression = firExpression2 instanceof FirConstExpression ? (FirConstExpression)firExpression2 : null;
        Long l = firConstExpression == null ? null : firConstExpression.getValue();
        if (l == null) {
            return null;
        }
        long value2 = l;
        if (Intrinsics.areEqual((Object)$this$asLong.getCalleeReference().getName().asString(), (Object)"unaryMinus")) {
            return -value2;
        }
        return value2;
    }
}

