/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Maps;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Queue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnalyzerExtensions;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.BodyResolveCache;
import org.jetbrains.kotlin.resolve.ControlFlowAnalyzer;
import org.jetbrains.kotlin.resolve.DeclarationsChecker;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolver;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;
import org.jetbrains.kotlin.types.expressions.ValueParameterResolver;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.Box;
import org.jetbrains.kotlin.util.ReenteringLazyValueComputationException;

public class BodyResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final ObservableBindingTrace trace;
    @NotNull
    private final ControlFlowAnalyzer controlFlowAnalyzer;
    @NotNull
    private final DeclarationsChecker declarationsChecker;
    @NotNull
    private final AnnotationResolver annotationResolver;
    @NotNull
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    @NotNull
    private final AnalyzerExtensions analyzerExtensions;
    @NotNull
    private final ValueParameterResolver valueParameterResolver;
    @NotNull
    private final BodyResolveCache bodyResolveCache;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final OverloadChecker overloadChecker;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public BodyResolver(@NotNull Project project, @NotNull AnnotationResolver annotationResolver, @NotNull BodyResolveCache bodyResolveCache, @NotNull CallResolver callResolver, @NotNull ControlFlowAnalyzer controlFlowAnalyzer, @NotNull DeclarationsChecker declarationsChecker, @NotNull DelegatedPropertyResolver delegatedPropertyResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull AnalyzerExtensions analyzerExtensions, @NotNull BindingTrace trace, @NotNull ValueParameterResolver valueParameterResolver, @NotNull AnnotationChecker annotationChecker, @NotNull KotlinBuiltIns builtIns, @NotNull OverloadChecker overloadChecker, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (project == null) {
            BodyResolver.$$$reportNull$$$0(0);
        }
        if (annotationResolver == null) {
            BodyResolver.$$$reportNull$$$0(1);
        }
        if (bodyResolveCache == null) {
            BodyResolver.$$$reportNull$$$0(2);
        }
        if (callResolver == null) {
            BodyResolver.$$$reportNull$$$0(3);
        }
        if (controlFlowAnalyzer == null) {
            BodyResolver.$$$reportNull$$$0(4);
        }
        if (declarationsChecker == null) {
            BodyResolver.$$$reportNull$$$0(5);
        }
        if (delegatedPropertyResolver == null) {
            BodyResolver.$$$reportNull$$$0(6);
        }
        if (expressionTypingServices == null) {
            BodyResolver.$$$reportNull$$$0(7);
        }
        if (analyzerExtensions == null) {
            BodyResolver.$$$reportNull$$$0(8);
        }
        if (trace == null) {
            BodyResolver.$$$reportNull$$$0(9);
        }
        if (valueParameterResolver == null) {
            BodyResolver.$$$reportNull$$$0(10);
        }
        if (annotationChecker == null) {
            BodyResolver.$$$reportNull$$$0(11);
        }
        if (builtIns == null) {
            BodyResolver.$$$reportNull$$$0(12);
        }
        if (overloadChecker == null) {
            BodyResolver.$$$reportNull$$$0(13);
        }
        if (languageVersionSettings == null) {
            BodyResolver.$$$reportNull$$$0(14);
        }
        this.project = project;
        this.annotationResolver = annotationResolver;
        this.bodyResolveCache = bodyResolveCache;
        this.callResolver = callResolver;
        this.controlFlowAnalyzer = controlFlowAnalyzer;
        this.declarationsChecker = declarationsChecker;
        this.delegatedPropertyResolver = delegatedPropertyResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.analyzerExtensions = analyzerExtensions;
        this.annotationChecker = annotationChecker;
        this.overloadChecker = overloadChecker;
        this.trace = new ObservableBindingTrace(trace);
        this.valueParameterResolver = valueParameterResolver;
        this.builtIns = builtIns;
        this.languageVersionSettings = languageVersionSettings;
    }

    private void resolveBehaviorDeclarationBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            BodyResolver.$$$reportNull$$$0(15);
        }
        this.resolveSuperTypeEntryLists(c);
        this.resolvePropertyDeclarationBodies(c);
        this.resolveAnonymousInitializers(c);
        this.resolvePrimaryConstructorParameters(c);
        this.resolveSecondaryConstructors(c);
        this.resolveFunctionBodies(c);
        if (!c.getTopDownAnalysisMode().isLocalDeclarations()) {
            this.computeDeferredTypes();
        }
    }

    private void resolveSecondaryConstructors(@NotNull BodiesResolveContext c) {
        if (c == null) {
            BodyResolver.$$$reportNull$$$0(16);
        }
        for (Map.Entry<KtSecondaryConstructor, ClassConstructorDescriptor> entry : c.getSecondaryConstructors().entrySet()) {
            LexicalScope declaringScope = c.getDeclaringScope(entry.getKey());
            assert (declaringScope != null) : "Declaring scope should be registered before body resolve";
            this.resolveSecondaryConstructorBody(c.getOuterDataFlowInfo(), this.trace, entry.getKey(), entry.getValue(), declaringScope);
        }
        if (c.getSecondaryConstructors().isEmpty()) {
            return;
        }
        HashSet<ConstructorDescriptor> visitedConstructors = new HashSet<ConstructorDescriptor>();
        for (Map.Entry<KtSecondaryConstructor, ClassConstructorDescriptor> entry : c.getSecondaryConstructors().entrySet()) {
            this.checkCyclicConstructorDelegationCall(entry.getValue(), visitedConstructors);
        }
    }

    public void resolveSecondaryConstructorBody(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull BindingTrace trace, @NotNull KtSecondaryConstructor constructor2, @NotNull ClassConstructorDescriptor descriptor2, @NotNull LexicalScope declaringScope) {
        if (outerDataFlowInfo == null) {
            BodyResolver.$$$reportNull$$$0(17);
        }
        if (trace == null) {
            BodyResolver.$$$reportNull$$$0(18);
        }
        if (constructor2 == null) {
            BodyResolver.$$$reportNull$$$0(19);
        }
        if (descriptor2 == null) {
            BodyResolver.$$$reportNull$$$0(20);
        }
        if (declaringScope == null) {
            BodyResolver.$$$reportNull$$$0(21);
        }
        ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
        this.resolveFunctionBody(outerDataFlowInfo, trace, constructor2, descriptor2, declaringScope, (Function1<LexicalScope, DataFlowInfo>)((Function1)headerInnerScope -> this.resolveSecondaryConstructorDelegationCall(outerDataFlowInfo, trace, (LexicalScope)headerInnerScope, constructor2, descriptor2)), (Function1<LexicalScope, LexicalScope>)((Function1)scope2 -> new LexicalScopeImpl((HierarchicalScope)scope2, descriptor2, scope2.isOwnerDescriptorAccessibleByLabel(), scope2.getImplicitReceiver(), LexicalScopeKind.CONSTRUCTOR_HEADER)));
    }

    @Nullable
    private DataFlowInfo resolveSecondaryConstructorDelegationCall(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull BindingTrace trace, @NotNull LexicalScope scope2, @NotNull KtSecondaryConstructor constructor2, @NotNull ClassConstructorDescriptor descriptor2) {
        if (outerDataFlowInfo == null) {
            BodyResolver.$$$reportNull$$$0(22);
        }
        if (trace == null) {
            BodyResolver.$$$reportNull$$$0(23);
        }
        if (scope2 == null) {
            BodyResolver.$$$reportNull$$$0(24);
        }
        if (constructor2 == null) {
            BodyResolver.$$$reportNull$$$0(25);
        }
        if (descriptor2 == null) {
            BodyResolver.$$$reportNull$$$0(26);
        }
        if (descriptor2.isExpect() || DescriptorUtilsKt.isEffectivelyExternal(descriptor2)) {
            return DataFlowInfo.Companion.getEMPTY();
        }
        OverloadResolutionResults<ConstructorDescriptor> results = this.callResolver.resolveConstructorDelegationCall(trace, scope2, outerDataFlowInfo, descriptor2, constructor2.getDelegationCall());
        if (results != null && results.isSingleResult()) {
            ResolvedCall<ConstructorDescriptor> resolvedCall2 = results.getResultingCall();
            BodyResolver.recordConstructorDelegationCall(trace, descriptor2, resolvedCall2);
            return resolvedCall2.getDataFlowInfoForArguments().getResultInfo();
        }
        return null;
    }

    private void checkCyclicConstructorDelegationCall(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull Set<ConstructorDescriptor> visitedConstructors) {
        if (constructorDescriptor == null) {
            BodyResolver.$$$reportNull$$$0(27);
        }
        if (visitedConstructors == null) {
            BodyResolver.$$$reportNull$$$0(28);
        }
        if (visitedConstructors.contains(constructorDescriptor)) {
            return;
        }
        HashSet<ConstructorDescriptor> visitedInCurrentChain = new HashSet<ConstructorDescriptor>();
        ConstructorDescriptor currentConstructorDescriptor = constructorDescriptor;
        while (true) {
            ProgressManager.checkCanceled();
            visitedInCurrentChain.add(currentConstructorDescriptor);
            ConstructorDescriptor delegatedConstructorDescriptor = this.getDelegatedConstructor(currentConstructorDescriptor);
            if (delegatedConstructorDescriptor == null || !constructorDescriptor.getContainingDeclaration().equals(delegatedConstructorDescriptor.getContainingDeclaration()) || delegatedConstructorDescriptor.isPrimary() || visitedConstructors.contains(delegatedConstructorDescriptor)) break;
            if (visitedInCurrentChain.contains(delegatedConstructorDescriptor)) {
                this.reportEachConstructorOnCycle(delegatedConstructorDescriptor);
                break;
            }
            currentConstructorDescriptor = delegatedConstructorDescriptor;
        }
        visitedConstructors.addAll(visitedInCurrentChain);
    }

    private void reportEachConstructorOnCycle(@NotNull ConstructorDescriptor startConstructor) {
        if (startConstructor == null) {
            BodyResolver.$$$reportNull$$$0(29);
        }
        ConstructorDescriptor currentConstructor = startConstructor;
        do {
            PsiElement constructorToReport;
            if ((constructorToReport = DescriptorToSourceUtils.descriptorToDeclaration(currentConstructor)) != null) {
                KtConstructorDelegationCall call2 = ((KtSecondaryConstructor)constructorToReport).getDelegationCall();
                assert (call2.getCalleeExpression() != null) : "Callee expression of delegation call should not be null on cycle as there should be explicit 'this' calls";
                this.trace.report(Errors.CYCLIC_CONSTRUCTOR_DELEGATION_CALL.on(call2.getCalleeExpression()));
            }
            currentConstructor = this.getDelegatedConstructor(currentConstructor);
            assert (currentConstructor != null) : "Delegated constructor should not be null in cycle";
        } while (startConstructor != currentConstructor);
    }

    @Nullable
    private ConstructorDescriptor getDelegatedConstructor(@NotNull ConstructorDescriptor constructor2) {
        ResolvedCall<ConstructorDescriptor> call2;
        if (constructor2 == null) {
            BodyResolver.$$$reportNull$$$0(30);
        }
        return (call2 = this.trace.get(BindingContext.CONSTRUCTOR_RESOLVED_DELEGATION_CALL, constructor2)) == null || !call2.getStatus().isSuccess() ? null : call2.getResultingDescriptor().getOriginal();
    }

    public void resolveBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            BodyResolver.$$$reportNull$$$0(31);
        }
        this.resolveBehaviorDeclarationBodies(c);
        this.controlFlowAnalyzer.process(c);
        this.declarationsChecker.process(c);
        this.analyzerExtensions.process(c);
    }

    private void resolveSuperTypeEntryLists(@NotNull BodiesResolveContext c) {
        if (c == null) {
            BodyResolver.$$$reportNull$$$0(32);
        }
        for (Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            KtClassOrObject classOrObject = entry.getKey();
            ClassDescriptorWithResolutionScopes descriptor2 = entry.getValue();
            this.resolveSuperTypeEntryList(c.getOuterDataFlowInfo(), classOrObject, descriptor2, descriptor2.getUnsubstitutedPrimaryConstructor(), descriptor2.getScopeForConstructorHeaderResolution(), descriptor2.getScopeForMemberDeclarationResolution());
        }
    }

    public void resolveSuperTypeEntryList(final @NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtClassOrObject ktClass, final @NotNull ClassDescriptor descriptor2, final @Nullable ConstructorDescriptor primaryConstructor2, @NotNull LexicalScope scopeForConstructorResolution, final @NotNull LexicalScope scopeForMemberResolution) {
        LexicalScope scopeForConstructor;
        if (outerDataFlowInfo == null) {
            BodyResolver.$$$reportNull$$$0(33);
        }
        if (ktClass == null) {
            BodyResolver.$$$reportNull$$$0(34);
        }
        if (descriptor2 == null) {
            BodyResolver.$$$reportNull$$$0(35);
        }
        if (scopeForConstructorResolution == null) {
            BodyResolver.$$$reportNull$$$0(36);
        }
        if (scopeForMemberResolution == null) {
            BodyResolver.$$$reportNull$$$0(37);
        }
        ProgressManager.checkCanceled();
        LexicalScope lexicalScope = scopeForConstructor = primaryConstructor2 == null ? null : FunctionDescriptorUtil.getFunctionInnerScope(scopeForConstructorResolution, primaryConstructor2, this.trace, this.overloadChecker);
        if (primaryConstructor2 == null) {
            this.checkRedeclarationsInClassHeaderWithoutPrimaryConstructor(descriptor2, scopeForConstructorResolution);
        }
        final ExpressionTypingServices typeInferrer = this.expressionTypingServices;
        final LinkedHashMap<KtTypeReference, KotlinType> supertypes2 = Maps.newLinkedHashMap();
        final ResolvedCall[] primaryConstructorDelegationCall = new ResolvedCall[1];
        KtVisitorVoid visitor2 = new KtVisitorVoid(){

            private void recordSupertype(KtTypeReference typeReference, KotlinType supertype2) {
                if (supertype2 == null) {
                    return;
                }
                supertypes2.put(typeReference, supertype2);
            }

            @Override
            public void visitDelegatedSuperTypeEntry(@NotNull KtDelegatedSuperTypeEntry specifier) {
                KtExpression delegateExpression2;
                ClassDescriptor classDescriptor2;
                ClassifierDescriptor declarationDescriptor;
                if (specifier == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (descriptor2.getKind() == ClassKind.INTERFACE) {
                    BodyResolver.this.trace.report(Errors.DELEGATION_IN_INTERFACE.on(specifier));
                }
                KotlinType supertype2 = BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, specifier.getTypeReference());
                this.recordSupertype(specifier.getTypeReference(), supertype2);
                if (supertype2 != null && (declarationDescriptor = supertype2.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor && (classDescriptor2 = (ClassDescriptor)declarationDescriptor).getKind() != ClassKind.INTERFACE) {
                    BodyResolver.this.trace.report(Errors.DELEGATION_NOT_TO_INTERFACE.on(specifier.getTypeReference()));
                }
                if ((delegateExpression2 = specifier.getDelegateExpression()) != null) {
                    LexicalScope scope2 = scopeForConstructor == null ? scopeForMemberResolution : scopeForConstructor;
                    KotlinType expectedType2 = supertype2 != null ? supertype2 : TypeUtils.NO_EXPECTED_TYPE;
                    typeInferrer.getType(scope2, delegateExpression2, expectedType2, outerDataFlowInfo, InferenceSession.Companion.getDefault(), BodyResolver.this.trace);
                }
                if (descriptor2.isExpect()) {
                    BodyResolver.this.trace.report(Errors.IMPLEMENTATION_BY_DELEGATION_IN_EXPECT_CLASS.on(specifier));
                } else if (primaryConstructor2 == null) {
                    BodyResolver.this.trace.report(Errors.UNSUPPORTED.on(specifier, "Delegation without primary constructor is not supported"));
                }
            }

            @Override
            public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call2) {
                KtTypeReference typeReference;
                KtValueArgumentList valueArgumentList;
                KtElementImplStub elementToMark;
                if (call2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                KtElementImplStub ktElementImplStub = elementToMark = (valueArgumentList = call2.getValueArgumentList()) == null ? call2 : valueArgumentList;
                if (descriptor2.getKind() == ClassKind.INTERFACE) {
                    BodyResolver.this.trace.report(Errors.SUPERTYPE_INITIALIZED_IN_INTERFACE.on(elementToMark));
                }
                if (descriptor2.isExpect()) {
                    BodyResolver.this.trace.report(Errors.SUPERTYPE_INITIALIZED_IN_EXPECTED_CLASS.on(elementToMark));
                }
                if ((typeReference = call2.getTypeReference()) == null) {
                    return;
                }
                if (primaryConstructor2 == null) {
                    if (descriptor2.getKind() != ClassKind.INTERFACE) {
                        BodyResolver.this.trace.report(Errors.SUPERTYPE_INITIALIZED_WITHOUT_PRIMARY_CONSTRUCTOR.on(call2));
                    }
                    this.recordSupertype(typeReference, BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                    return;
                }
                OverloadResolutionResults<FunctionDescriptor> results = BodyResolver.this.callResolver.resolveFunctionCall(BodyResolver.this.trace, scopeForConstructor, CallMaker.makeConstructorCallWithoutTypeArguments(call2), TypeUtils.NO_EXPECTED_TYPE, outerDataFlowInfo, false);
                if (results.isSingleResult()) {
                    KotlinType supertype2 = results.getResultingDescriptor().getReturnType();
                    this.recordSupertype(typeReference, supertype2);
                    ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor(supertype2);
                    if (classDescriptor2 != null) {
                        primaryConstructorDelegationCall[0] = primaryConstructorDelegationCall[0] == null ? results.getResultingCall() : null;
                    }
                    BodyResolver.this.trace.record(BindingContext.PROCESSED, call2.getCalleeExpression(), true);
                    BodyResolver.this.trace.record(BindingContext.EXPRESSION_TYPE_INFO, call2.getCalleeExpression(), TypeInfoFactoryKt.noTypeInfo(results.getResultingCall().getDataFlowInfoForArguments().getResultInfo()));
                } else {
                    this.recordSupertype(typeReference, BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                }
            }

            @Override
            public void visitSuperTypeEntry(@NotNull KtSuperTypeEntry specifier) {
                if (specifier == null) {
                    1.$$$reportNull$$$0(2);
                }
                KtTypeReference typeReference = specifier.getTypeReference();
                KotlinType supertype2 = BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference);
                this.recordSupertype(typeReference, supertype2);
                if (supertype2 == null) {
                    return;
                }
                ClassDescriptor superClass2 = TypeUtils.getClassDescriptor(supertype2);
                if (superClass2 == null) {
                    return;
                }
                if (superClass2.getKind().isSingleton()) {
                    return;
                }
                if (!(descriptor2.getKind() == ClassKind.INTERFACE || descriptor2.getUnsubstitutedPrimaryConstructor() == null || superClass2.getKind() == ClassKind.INTERFACE || descriptor2.isExpect() || DescriptorUtilsKt.isEffectivelyExternal(descriptor2) || ErrorUtils.isError(superClass2))) {
                    BodyResolver.this.trace.report(Errors.SUPERTYPE_NOT_INITIALIZED.on(specifier));
                }
            }

            @Override
            public void visitKtElement(@NotNull KtElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(3);
                }
                throw new UnsupportedOperationException(element.getText() + " : " + element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "specifier";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/resolve/BodyResolver$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDelegatedSuperTypeEntry";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSuperTypeCallEntry";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSuperTypeEntry";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitKtElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (ktClass instanceof KtEnumEntry && DescriptorUtils.isEnumEntry(descriptor2) && ktClass.getSuperTypeListEntries().isEmpty()) {
            assert (scopeForConstructor != null) : "Scope for enum class constructor should be non-null: " + descriptor2;
            this.resolveConstructorCallForEnumEntryWithoutInitializer((KtEnumEntry)ktClass, descriptor2, scopeForConstructor, outerDataFlowInfo, primaryConstructorDelegationCall);
        }
        for (KtSuperTypeListEntry delegationSpecifier : ktClass.getSuperTypeListEntries()) {
            ProgressManager.checkCanceled();
            delegationSpecifier.accept(visitor2);
        }
        if (DescriptorUtils.isAnnotationClass(descriptor2) && ktClass.getSuperTypeList() != null) {
            this.trace.report(Errors.SUPERTYPES_FOR_ANNOTATION_CLASS.on(ktClass.getSuperTypeList()));
        }
        if (primaryConstructorDelegationCall[0] != null && primaryConstructor2 != null) {
            BodyResolver.recordConstructorDelegationCall(this.trace, primaryConstructor2, primaryConstructorDelegationCall[0]);
        }
        this.checkSupertypeList(descriptor2, supertypes2, ktClass);
    }

    private void checkRedeclarationsInClassHeaderWithoutPrimaryConstructor(final @NotNull ClassDescriptor descriptor2, @NotNull LexicalScope scopeForConstructorResolution) {
        if (descriptor2 == null) {
            BodyResolver.$$$reportNull$$$0(38);
        }
        if (scopeForConstructorResolution == null) {
            BodyResolver.$$$reportNull$$$0(39);
        }
        new LexicalScopeImpl(scopeForConstructorResolution, descriptor2, true, null, LexicalScopeKind.CLASS_HEADER, new TraceBasedLocalRedeclarationChecker(this.trace, this.overloadChecker), (Function1<? super LexicalScopeImpl.InitializeHandler, Unit>)new Function1<LexicalScopeImpl.InitializeHandler, Unit>(){

            public Unit invoke(LexicalScopeImpl.InitializeHandler handler2) {
                for (TypeParameterDescriptor typeParameter : descriptor2.getDeclaredTypeParameters()) {
                    handler2.addClassifierDescriptor(typeParameter);
                }
                return Unit.INSTANCE;
            }
        });
    }

    private void resolveConstructorCallForEnumEntryWithoutInitializer(@NotNull KtEnumEntry ktEnumEntry, @NotNull ClassDescriptor enumEntryDescriptor, @NotNull LexicalScope scopeForConstructor, @NotNull DataFlowInfo outerDataFlowInfo, @NotNull ResolvedCall<?>[] primaryConstructorDelegationCall) {
        if (ktEnumEntry == null) {
            BodyResolver.$$$reportNull$$$0(40);
        }
        if (enumEntryDescriptor == null) {
            BodyResolver.$$$reportNull$$$0(41);
        }
        if (scopeForConstructor == null) {
            BodyResolver.$$$reportNull$$$0(42);
        }
        if (outerDataFlowInfo == null) {
            BodyResolver.$$$reportNull$$$0(43);
        }
        if (primaryConstructorDelegationCall == null) {
            BodyResolver.$$$reportNull$$$0(44);
        }
        assert (enumEntryDescriptor.getKind() == ClassKind.ENUM_ENTRY) : "Enum entry expected: " + enumEntryDescriptor;
        ClassDescriptor enumClassDescriptor = (ClassDescriptor)enumEntryDescriptor.getContainingDeclaration();
        if (enumClassDescriptor.getKind() != ClassKind.ENUM_CLASS) {
            return;
        }
        if (enumClassDescriptor.isExpect()) {
            return;
        }
        List<ClassConstructorDescriptor> applicableConstructors = BodyResolver.getConstructorForEmptyArgumentsList(enumClassDescriptor);
        if (applicableConstructors.size() != 1) {
            this.trace.report(Errors.ENUM_ENTRY_SHOULD_BE_INITIALIZED.on(ktEnumEntry));
            return;
        }
        KtInitializerList ktInitializerList = new KtPsiFactory(this.project, false).createEnumEntryInitializerList();
        KtSuperTypeCallEntry ktCallEntry = (KtSuperTypeCallEntry)ktInitializerList.getInitializers().get(0);
        Call call2 = CallMaker.makeConstructorCallWithoutTypeArguments(ktCallEntry);
        this.trace.record(BindingContext.TYPE, ktCallEntry.getTypeReference(), enumClassDescriptor.getDefaultType());
        this.trace.record(BindingContext.CALL, ktEnumEntry, call2);
        OverloadResolutionResults<FunctionDescriptor> results = this.callResolver.resolveFunctionCall(this.trace, scopeForConstructor, call2, TypeUtils.NO_EXPECTED_TYPE, outerDataFlowInfo, false);
        if (primaryConstructorDelegationCall[0] == null) {
            primaryConstructorDelegationCall[0] = results.getResultingCall();
        }
    }

    @NotNull
    private static List<ClassConstructorDescriptor> getConstructorForEmptyArgumentsList(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            BodyResolver.$$$reportNull$$$0(45);
        }
        List list2 = CollectionsKt.filter(descriptor2.getConstructors(), constructor2 -> CollectionsKt.all(constructor2.getValueParameters(), parameter -> parameter.declaresDefaultValue() || parameter.getVarargElementType() != null));
        if (list2 == null) {
            BodyResolver.$$$reportNull$$$0(46);
        }
        return list2;
    }

    @NotNull
    private Set<TypeConstructor> getAllowedFinalSupertypes(@NotNull ClassDescriptor descriptor2, @NotNull Map<KtTypeReference, KotlinType> supertypes2, @NotNull KtClassOrObject ktClassOrObject) {
        if (descriptor2 == null) {
            BodyResolver.$$$reportNull$$$0(47);
        }
        if (supertypes2 == null) {
            BodyResolver.$$$reportNull$$$0(48);
        }
        if (ktClassOrObject == null) {
            BodyResolver.$$$reportNull$$$0(49);
        }
        Set<TypeConstructor> parentEnumOrSealed = Collections.emptySet();
        if (ktClassOrObject instanceof KtEnumEntry) {
            parentEnumOrSealed = Collections.singleton(((ClassDescriptor)descriptor2.getContainingDeclaration()).getTypeConstructor());
        } else if (this.languageVersionSettings.supportsFeature(LanguageFeature.TopLevelSealedInheritance) && DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            for (KotlinType supertype2 : supertypes2.values()) {
                ClassifierDescriptor classifierDescriptor = supertype2.getConstructor().getDeclarationDescriptor();
                if (!DescriptorUtils.isSealedClass(classifierDescriptor) || !DescriptorUtils.isTopLevelDeclaration(classifierDescriptor)) continue;
                parentEnumOrSealed = Collections.singleton(classifierDescriptor.getTypeConstructor());
            }
        } else {
            ClassDescriptor currentDescriptor = descriptor2;
            while (currentDescriptor.getContainingDeclaration() instanceof ClassDescriptor) {
                if (!DescriptorUtils.isSealedClass(currentDescriptor = (ClassDescriptor)currentDescriptor.getContainingDeclaration())) continue;
                if (parentEnumOrSealed.isEmpty()) {
                    parentEnumOrSealed = new HashSet();
                }
                parentEnumOrSealed.add(currentDescriptor.getTypeConstructor());
                if (!currentDescriptor.isExpect()) continue;
                List<MemberDescriptor> actualDescriptors = ExpectedActualResolver.INSTANCE.findCompatibleActualForExpected(currentDescriptor, DescriptorUtilsKt.getModule(currentDescriptor));
                for (MemberDescriptor actualDescriptor : actualDescriptors) {
                    if (!(actualDescriptor instanceof TypeAliasDescriptor)) continue;
                    parentEnumOrSealed.add(((TypeAliasDescriptor)actualDescriptor).getExpandedType().getConstructor());
                }
            }
        }
        Set<TypeConstructor> set = parentEnumOrSealed;
        if (set == null) {
            BodyResolver.$$$reportNull$$$0(50);
        }
        return set;
    }

    private static void recordConstructorDelegationCall(@NotNull BindingTrace trace, @NotNull ConstructorDescriptor constructor2, @NotNull ResolvedCall<?> call2) {
        if (trace == null) {
            BodyResolver.$$$reportNull$$$0(51);
        }
        if (constructor2 == null) {
            BodyResolver.$$$reportNull$$$0(52);
        }
        if (call2 == null) {
            BodyResolver.$$$reportNull$$$0(53);
        }
        trace.record(BindingContext.CONSTRUCTOR_RESOLVED_DELEGATION_CALL, constructor2, call2);
    }

    private void checkSupertypeList(@NotNull ClassDescriptor supertypeOwner, @NotNull Map<KtTypeReference, KotlinType> supertypes2, @NotNull KtClassOrObject ktClassOrObject) {
        if (supertypeOwner == null) {
            BodyResolver.$$$reportNull$$$0(54);
        }
        if (supertypes2 == null) {
            BodyResolver.$$$reportNull$$$0(55);
        }
        if (ktClassOrObject == null) {
            BodyResolver.$$$reportNull$$$0(56);
        }
        Set<TypeConstructor> allowedFinalSupertypes = this.getAllowedFinalSupertypes(supertypeOwner, supertypes2, ktClassOrObject);
        HashSet<TypeConstructor> typeConstructors = new HashSet<TypeConstructor>();
        boolean classAppeared = false;
        for (Map.Entry<KtTypeReference, KotlinType> entry : supertypes2.entrySet()) {
            KtTypeReference typeReference = entry.getKey();
            KotlinType supertype2 = entry.getValue();
            KtTypeElement typeElement = typeReference.getTypeElement();
            if (typeElement instanceof KtFunctionType) {
                for (KtParameter parameter : ((KtFunctionType)typeElement).getParameters()) {
                    PsiElement nameIdentifier = parameter.getNameIdentifier();
                    if (nameIdentifier == null) continue;
                    this.trace.report(Errors.UNSUPPORTED.on(nameIdentifier, "named parameter in function type in supertype position"));
                }
            }
            boolean addSupertype = true;
            ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor(supertype2);
            if (classDescriptor2 != null) {
                if (ErrorUtils.isError(classDescriptor2)) continue;
                if (FunctionTypesKt.isExtensionFunctionType(supertype2)) {
                    this.trace.report(Errors.SUPERTYPE_IS_EXTENSION_FUNCTION_TYPE.on(typeReference));
                } else if (FunctionTypesKt.isSuspendFunctionType(supertype2)) {
                    this.trace.report(Errors.SUPERTYPE_IS_SUSPEND_FUNCTION_TYPE.on(typeReference));
                } else if (FunctionTypesKt.isKSuspendFunctionType(supertype2)) {
                    this.trace.report(Errors.SUPERTYPE_IS_KSUSPEND_FUNCTION_TYPE.on(typeReference));
                }
                if (classDescriptor2.getKind() != ClassKind.INTERFACE) {
                    if (supertypeOwner.getKind() == ClassKind.ENUM_CLASS) {
                        this.trace.report(Errors.CLASS_IN_SUPERTYPE_FOR_ENUM.on(typeReference));
                        addSupertype = false;
                    } else if (supertypeOwner.getKind() == ClassKind.INTERFACE && !classAppeared && !DynamicTypesKt.isDynamic(supertype2)) {
                        this.trace.report(Errors.INTERFACE_WITH_SUPERCLASS.on(typeReference));
                        addSupertype = false;
                    } else if (ktClassOrObject.hasModifier(KtTokens.DATA_KEYWORD) && !this.languageVersionSettings.supportsFeature(LanguageFeature.DataClassInheritance)) {
                        this.trace.report(Errors.DATA_CLASS_CANNOT_HAVE_CLASS_SUPERTYPES.on(typeReference));
                        addSupertype = false;
                    } else if (DescriptorUtils.isSubclass(classDescriptor2, this.builtIns.getThrowable())) {
                        if (!supertypeOwner.getDeclaredTypeParameters().isEmpty()) {
                            this.trace.report(Errors.GENERIC_THROWABLE_SUBCLASS.on(ktClassOrObject.getTypeParameterList()));
                            addSupertype = false;
                        } else if (!supertypeOwner.getTypeConstructor().getParameters().isEmpty()) {
                            if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitInnerClassesOfGenericClassExtendingThrowable)) {
                                this.trace.report(Errors.INNER_CLASS_OF_GENERIC_THROWABLE_SUBCLASS.on(ktClassOrObject));
                                addSupertype = false;
                            } else {
                                this.trace.report(Errors.INNER_CLASS_OF_GENERIC_THROWABLE_SUBCLASS_WARNING.on(ktClassOrObject));
                            }
                        }
                    }
                    if (classAppeared) {
                        this.trace.report(Errors.MANY_CLASSES_IN_SUPERTYPE_LIST.on(typeReference));
                    } else {
                        classAppeared = true;
                    }
                }
            } else {
                this.trace.report(Errors.SUPERTYPE_NOT_A_CLASS_OR_INTERFACE.on(typeReference));
            }
            TypeConstructor constructor2 = supertype2.getConstructor();
            if (addSupertype && !typeConstructors.add(constructor2)) {
                this.trace.report(Errors.SUPERTYPE_APPEARS_TWICE.on(typeReference));
            }
            if (classDescriptor2 == null) {
                return;
            }
            if (classDescriptor2.getKind().isSingleton()) {
                if (DescriptorUtils.isEnumEntry(classDescriptor2)) continue;
                this.trace.report(Errors.SINGLETON_IN_SUPERTYPE.on(typeReference));
                continue;
            }
            if (allowedFinalSupertypes.contains(constructor2)) continue;
            if (DescriptorUtils.isSealedClass(classDescriptor2)) {
                DeclarationDescriptor containingDescriptor;
                for (containingDescriptor = supertypeOwner.getContainingDeclaration(); containingDescriptor != null && containingDescriptor != classDescriptor2; containingDescriptor = containingDescriptor.getContainingDeclaration()) {
                }
                if (containingDescriptor == null) {
                    if (this.languageVersionSettings.supportsFeature(LanguageFeature.AllowSealedInheritorsInDifferentFilesOfSamePackage) && !DescriptorUtils.isLocal(supertypeOwner)) continue;
                    this.trace.report(Errors.SEALED_SUPERTYPE.on(typeReference));
                    continue;
                }
                this.trace.report(Errors.SEALED_SUPERTYPE_IN_LOCAL_CLASS.on(typeReference));
                continue;
            }
            if (ModalityUtilsKt.isFinalOrEnum(classDescriptor2)) {
                this.trace.report(Errors.FINAL_SUPERTYPE.on(typeReference));
                continue;
            }
            if (!KotlinBuiltIns.isEnum(classDescriptor2)) continue;
            this.trace.report(Errors.CLASS_CANNOT_BE_EXTENDED_DIRECTLY.on(typeReference, classDescriptor2));
        }
    }

    private void resolveAnonymousInitializers(@NotNull BodiesResolveContext c) {
        if (c == null) {
            BodyResolver.$$$reportNull$$$0(57);
        }
        for (Map.Entry<KtAnonymousInitializer, ClassDescriptorWithResolutionScopes> entry : c.getAnonymousInitializers().entrySet()) {
            KtAnonymousInitializer initializer2 = entry.getKey();
            ClassDescriptorWithResolutionScopes descriptor2 = entry.getValue();
            this.resolveAnonymousInitializer(c.getOuterDataFlowInfo(), initializer2, descriptor2);
        }
    }

    public void resolveAnonymousInitializer(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtAnonymousInitializer anonymousInitializer, @NotNull ClassDescriptorWithResolutionScopes classDescriptor2) {
        if (outerDataFlowInfo == null) {
            BodyResolver.$$$reportNull$$$0(58);
        }
        if (anonymousInitializer == null) {
            BodyResolver.$$$reportNull$$$0(59);
        }
        if (classDescriptor2 == null) {
            BodyResolver.$$$reportNull$$$0(60);
        }
        ProgressManager.checkCanceled();
        LexicalScope scopeForInitializers = classDescriptor2.getScopeForInitializerResolution();
        KtExpression body2 = anonymousInitializer.getBody();
        if (body2 != null) {
            PreliminaryDeclarationVisitor.Companion.createForDeclaration((KtDeclaration)anonymousInitializer.getParent().getParent(), this.trace, this.languageVersionSettings);
            this.expressionTypingServices.getTypeInfo(scopeForInitializers, body2, TypeUtils.NO_EXPECTED_TYPE, outerDataFlowInfo, InferenceSession.Companion.getDefault(), this.trace, true);
        }
        this.processModifiersOnInitializer(anonymousInitializer, scopeForInitializers);
        if (classDescriptor2.getConstructors().isEmpty()) {
            this.trace.report(Errors.ANONYMOUS_INITIALIZER_IN_INTERFACE.on(anonymousInitializer));
        }
        if (classDescriptor2.isExpect()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on(anonymousInitializer));
        }
    }

    private void processModifiersOnInitializer(@NotNull KtModifierListOwner owner, @NotNull LexicalScope scope2) {
        if (owner == null) {
            BodyResolver.$$$reportNull$$$0(61);
        }
        if (scope2 == null) {
            BodyResolver.$$$reportNull$$$0(62);
        }
        this.annotationChecker.check(owner, this.trace, null);
        ModifierCheckerCore.INSTANCE.check(owner, this.trace, null, this.languageVersionSettings);
        KtModifierList modifierList2 = owner.getModifierList();
        if (modifierList2 == null) {
            return;
        }
        this.annotationResolver.resolveAnnotationsWithArguments(scope2, modifierList2, (BindingTrace)this.trace);
    }

    private void resolvePrimaryConstructorParameters(@NotNull BodiesResolveContext c) {
        if (c == null) {
            BodyResolver.$$$reportNull$$$0(63);
        }
        for (Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            KtClassOrObject klass = entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptor2 = entry.getValue();
            ClassConstructorDescriptor unsubstitutedPrimaryConstructor = classDescriptor2.getUnsubstitutedPrimaryConstructor();
            if (unsubstitutedPrimaryConstructor == null) continue;
            ForceResolveUtil.forceResolveAllContents(unsubstitutedPrimaryConstructor.getAnnotations());
            LexicalScope parameterScope = BodyResolver.getPrimaryConstructorParametersScope(classDescriptor2.getScopeForConstructorHeaderResolution(), unsubstitutedPrimaryConstructor);
            this.valueParameterResolver.resolveValueParameters(klass.getPrimaryConstructorParameters(), unsubstitutedPrimaryConstructor.getValueParameters(), parameterScope, c.getOuterDataFlowInfo(), this.trace);
            this.resolveConstructorPropertyDescriptors(klass);
        }
    }

    private void resolveConstructorPropertyDescriptors(KtClassOrObject ktClassOrObject) {
        for (KtParameter parameter : ktClassOrObject.getPrimaryConstructorParameters()) {
            PropertySetterDescriptor setterDescriptor;
            PropertyDescriptor descriptor2 = this.trace.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
            if (descriptor2 == null) continue;
            ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitErroneousExpressionsInAnnotationsWithUseSiteTargets)) continue;
            PropertyGetterDescriptor getterDescriptor = descriptor2.getGetter();
            if (getterDescriptor != null) {
                ForceResolveUtil.forceResolveAllContents(getterDescriptor.getAnnotations());
            }
            if ((setterDescriptor = descriptor2.getSetter()) == null) continue;
            ForceResolveUtil.forceResolveAllContents(setterDescriptor.getAnnotations());
        }
    }

    private static LexicalScope getPrimaryConstructorParametersScope(LexicalScope originalScope, ConstructorDescriptor unsubstitutedPrimaryConstructor) {
        return new LexicalScopeImpl(originalScope, unsubstitutedPrimaryConstructor, false, null, LexicalScopeKind.DEFAULT_VALUE, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, (Function1<? super LexicalScopeImpl.InitializeHandler, Unit>)((Function1)handler2 -> {
            for (ValueParameterDescriptor valueParameter : unsubstitutedPrimaryConstructor.getValueParameters()) {
                handler2.addVariableDescriptor(valueParameter);
            }
            return Unit.INSTANCE;
        }));
    }

    public void resolveProperty(@NotNull BodiesResolveContext c, @NotNull KtProperty property2, @NotNull PropertyDescriptor propertyDescriptor) {
        KtExpression delegateExpression2;
        if (c == null) {
            BodyResolver.$$$reportNull$$$0(64);
        }
        if (property2 == null) {
            BodyResolver.$$$reportNull$$$0(65);
        }
        if (propertyDescriptor == null) {
            BodyResolver.$$$reportNull$$$0(66);
        }
        BodyResolver.computeDeferredType(propertyDescriptor.getReturnType());
        PreliminaryDeclarationVisitor.Companion.createForDeclaration(property2, this.trace, this.languageVersionSettings);
        KtExpression initializer2 = property2.getInitializer();
        LexicalScope propertyHeaderScope = ScopeUtils.makeScopeForPropertyHeader(BodyResolver.getScopeForProperty(c, property2), propertyDescriptor);
        if (initializer2 != null) {
            this.resolvePropertyInitializer(c.getOuterDataFlowInfo(), property2, propertyDescriptor, initializer2, propertyHeaderScope);
        }
        if ((delegateExpression2 = property2.getDelegateExpression()) != null) {
            assert (initializer2 == null) : "Initializer should be null for delegated property : " + property2.getText();
            this.resolvePropertyDelegate(c.getOuterDataFlowInfo(), property2, propertyDescriptor, delegateExpression2, propertyHeaderScope);
        }
        this.resolvePropertyAccessors(c, property2, propertyDescriptor);
        ForceResolveUtil.forceResolveAllContents(propertyDescriptor.getAnnotations());
    }

    private void resolvePropertyDeclarationBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            BodyResolver.$$$reportNull$$$0(67);
        }
        HashSet<KtProperty> processed = new HashSet<KtProperty>();
        for (Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            if (!(entry.getKey() instanceof KtClass)) continue;
            KtClass ktClass = (KtClass)entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptor2 = entry.getValue();
            for (KtProperty property2 : ktClass.getProperties()) {
                PropertyDescriptor propertyDescriptor = c.getProperties().get(property2);
                assert (propertyDescriptor != null);
                this.resolveProperty(c, property2, propertyDescriptor);
                processed.add(property2);
            }
        }
        for (Map.Entry<KtTypeParameterListOwnerStub, Substitutable<ClassifierDescriptorWithTypeParameters>> entry : c.getProperties().entrySet()) {
            KtProperty property3 = (KtProperty)entry.getKey();
            if (processed.contains(property3)) continue;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            this.resolveProperty(c, property3, propertyDescriptor);
        }
    }

    private static LexicalScope makeScopeForPropertyAccessor(@NotNull BodiesResolveContext c, @NotNull KtPropertyAccessor accessor, @NotNull PropertyDescriptor descriptor2) {
        if (c == null) {
            BodyResolver.$$$reportNull$$$0(68);
        }
        if (accessor == null) {
            BodyResolver.$$$reportNull$$$0(69);
        }
        if (descriptor2 == null) {
            BodyResolver.$$$reportNull$$$0(70);
        }
        LexicalScope accessorDeclaringScope = c.getDeclaringScope(accessor);
        assert (accessorDeclaringScope != null) : "Scope for accessor " + accessor.getText() + " should exists";
        LexicalScope headerScope = ScopeUtils.makeScopeForPropertyHeader(accessorDeclaringScope, descriptor2);
        return new LexicalScopeImpl(headerScope, descriptor2, true, descriptor2.getExtensionReceiverParameter(), LexicalScopeKind.PROPERTY_ACCESSOR_BODY);
    }

    private void resolvePropertyAccessors(@NotNull BodiesResolveContext c, @NotNull KtProperty property2, @NotNull PropertyDescriptor propertyDescriptor) {
        if (c == null) {
            BodyResolver.$$$reportNull$$$0(71);
        }
        if (property2 == null) {
            BodyResolver.$$$reportNull$$$0(72);
        }
        if (propertyDescriptor == null) {
            BodyResolver.$$$reportNull$$$0(73);
        }
        ObservableBindingTrace fieldAccessTrackingTrace = this.createFieldTrackingTrace(propertyDescriptor);
        KtPropertyAccessor getter2 = property2.getGetter();
        PropertyGetterDescriptor getterDescriptor = propertyDescriptor.getGetter();
        boolean forceResolveAnnotations = this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitErroneousExpressionsInAnnotationsWithUseSiteTargets);
        if (getterDescriptor != null) {
            if (getter2 != null) {
                LexicalScope accessorScope = BodyResolver.makeScopeForPropertyAccessor(c, getter2, propertyDescriptor);
                this.resolveFunctionBody(c.getOuterDataFlowInfo(), fieldAccessTrackingTrace, getter2, getterDescriptor, accessorScope);
            }
            if (getter2 != null || forceResolveAnnotations) {
                ForceResolveUtil.forceResolveAllContents(getterDescriptor.getAnnotations());
            }
        }
        KtPropertyAccessor setter2 = property2.getSetter();
        PropertySetterDescriptor setterDescriptor = propertyDescriptor.getSetter();
        if (setterDescriptor != null) {
            if (setter2 != null) {
                LexicalScope accessorScope = BodyResolver.makeScopeForPropertyAccessor(c, setter2, propertyDescriptor);
                this.resolveFunctionBody(c.getOuterDataFlowInfo(), fieldAccessTrackingTrace, setter2, setterDescriptor, accessorScope);
            }
            if (setter2 != null || forceResolveAnnotations) {
                ForceResolveUtil.forceResolveAllContents(setterDescriptor.getAnnotations());
            }
        }
    }

    private ObservableBindingTrace createFieldTrackingTrace(PropertyDescriptor propertyDescriptor) {
        return new ObservableBindingTrace(this.trace).addHandler(BindingContext.REFERENCE_TARGET, (slice, expression2, descriptor2) -> {
            if (expression2 instanceof KtSimpleNameExpression && descriptor2 instanceof SyntheticFieldDescriptor) {
                this.trace.record(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
            }
        });
    }

    private void resolvePropertyDelegate(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull KtExpression delegateExpression2, @NotNull LexicalScope propertyHeaderScope) {
        if (outerDataFlowInfo == null) {
            BodyResolver.$$$reportNull$$$0(74);
        }
        if (property2 == null) {
            BodyResolver.$$$reportNull$$$0(75);
        }
        if (propertyDescriptor == null) {
            BodyResolver.$$$reportNull$$$0(76);
        }
        if (delegateExpression2 == null) {
            BodyResolver.$$$reportNull$$$0(77);
        }
        if (propertyHeaderScope == null) {
            BodyResolver.$$$reportNull$$$0(78);
        }
        this.delegatedPropertyResolver.resolvePropertyDelegate(outerDataFlowInfo, property2, propertyDescriptor, delegateExpression2, propertyHeaderScope, InferenceSession.Companion.getDefault(), this.trace);
    }

    private void resolvePropertyInitializer(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull KtExpression initializer2, @NotNull LexicalScope propertyHeader) {
        KotlinType expectedTypeForInitializer;
        if (outerDataFlowInfo == null) {
            BodyResolver.$$$reportNull$$$0(79);
        }
        if (property2 == null) {
            BodyResolver.$$$reportNull$$$0(80);
        }
        if (propertyDescriptor == null) {
            BodyResolver.$$$reportNull$$$0(81);
        }
        if (initializer2 == null) {
            BodyResolver.$$$reportNull$$$0(82);
        }
        if (propertyHeader == null) {
            BodyResolver.$$$reportNull$$$0(83);
        }
        LexicalScope propertyDeclarationInnerScope = ScopeUtils.makeScopeForPropertyInitializer(propertyHeader, propertyDescriptor);
        KotlinType kotlinType = expectedTypeForInitializer = property2.getTypeReference() != null ? propertyDescriptor.getType() : TypeUtils.NO_EXPECTED_TYPE;
        if (propertyDescriptor.getCompileTimeInitializer() == null) {
            this.expressionTypingServices.getType(propertyDeclarationInnerScope, initializer2, expectedTypeForInitializer, outerDataFlowInfo, InferenceSession.Companion.getDefault(), this.trace);
        }
    }

    @NotNull
    private static LexicalScope getScopeForProperty(@NotNull BodiesResolveContext c, @NotNull KtProperty property2) {
        if (c == null) {
            BodyResolver.$$$reportNull$$$0(84);
        }
        if (property2 == null) {
            BodyResolver.$$$reportNull$$$0(85);
        }
        LexicalScope scope2 = c.getDeclaringScope(property2);
        assert (scope2 != null) : "Scope for property " + property2.getText() + " should exists";
        LexicalScope lexicalScope = scope2;
        if (lexicalScope == null) {
            BodyResolver.$$$reportNull$$$0(86);
        }
        return lexicalScope;
    }

    private void resolveFunctionBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            BodyResolver.$$$reportNull$$$0(87);
        }
        for (Map.Entry<KtNamedFunction, SimpleFunctionDescriptor> entry : c.getFunctions().entrySet()) {
            KtNamedFunction declaration2 = entry.getKey();
            LexicalScope scope2 = c.getDeclaringScope(declaration2);
            assert (scope2 != null) : "Scope is null: " + PsiUtilsKt.getElementTextWithContext(declaration2);
            if (!c.getTopDownAnalysisMode().isLocalDeclarations() && !(this.bodyResolveCache instanceof BodyResolveCache.ThrowException) && this.expressionTypingServices.getStatementFilter() != StatementFilter.NONE) {
                this.bodyResolveCache.resolveFunctionBody(declaration2).addOwnDataTo(this.trace, true);
                continue;
            }
            this.resolveFunctionBody(c.getOuterDataFlowInfo(), this.trace, declaration2, entry.getValue(), scope2);
        }
    }

    public void resolveFunctionBody(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull BindingTrace trace, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull LexicalScope declaringScope) {
        if (outerDataFlowInfo == null) {
            BodyResolver.$$$reportNull$$$0(88);
        }
        if (trace == null) {
            BodyResolver.$$$reportNull$$$0(89);
        }
        if (function2 == null) {
            BodyResolver.$$$reportNull$$$0(90);
        }
        if (functionDescriptor == null) {
            BodyResolver.$$$reportNull$$$0(91);
        }
        if (declaringScope == null) {
            BodyResolver.$$$reportNull$$$0(92);
        }
        BodyResolver.computeDeferredType(functionDescriptor.getReturnType());
        this.resolveFunctionBody(outerDataFlowInfo, trace, function2, functionDescriptor, declaringScope, null, null);
        assert (functionDescriptor.getReturnType() != null);
    }

    private void resolveFunctionBody(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull BindingTrace trace, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull LexicalScope scope2, @Nullable Function1<LexicalScope, DataFlowInfo> beforeBlockBody, @Nullable Function1<LexicalScope, LexicalScope> headerScopeFactory) {
        if (outerDataFlowInfo == null) {
            BodyResolver.$$$reportNull$$$0(93);
        }
        if (trace == null) {
            BodyResolver.$$$reportNull$$$0(94);
        }
        if (function2 == null) {
            BodyResolver.$$$reportNull$$$0(95);
        }
        if (functionDescriptor == null) {
            BodyResolver.$$$reportNull$$$0(96);
        }
        if (scope2 == null) {
            BodyResolver.$$$reportNull$$$0(97);
        }
        ProgressManager.checkCanceled();
        PreliminaryDeclarationVisitor.Companion.createForDeclaration(function2, trace, this.languageVersionSettings);
        LexicalScope innerScope = FunctionDescriptorUtil.getFunctionInnerScope(scope2, functionDescriptor, trace, this.overloadChecker);
        List<KtParameter> valueParameters2 = function2.getValueParameters();
        List<ValueParameterDescriptor> valueParameterDescriptors = functionDescriptor.getValueParameters();
        LexicalScope headerScope = headerScopeFactory != null ? (LexicalScope)headerScopeFactory.invoke((Object)innerScope) : innerScope;
        this.valueParameterResolver.resolveValueParameters(valueParameters2, valueParameterDescriptors, headerScope, outerDataFlowInfo, trace);
        if (functionDescriptor instanceof PropertyAccessorDescriptor && functionDescriptor.getExtensionReceiverParameter() == null) {
            PropertyAccessorDescriptor accessorDescriptor = (PropertyAccessorDescriptor)functionDescriptor;
            KtProperty property2 = (KtProperty)function2.getParent();
            SyntheticFieldDescriptor fieldDescriptor = new SyntheticFieldDescriptor(accessorDescriptor, property2);
            innerScope = new LexicalScopeImpl(innerScope, functionDescriptor, true, null, LexicalScopeKind.PROPERTY_ACCESSOR_BODY, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, (Function1<? super LexicalScopeImpl.InitializeHandler, Unit>)((Function1)handler2 -> {
                handler2.addVariableDescriptor(fieldDescriptor);
                return Unit.INSTANCE;
            }));
            for (KtParameter parameter : function2.getValueParameters()) {
                if (!SyntheticFieldDescriptor.NAME.equals(parameter.getNameAsName())) continue;
                trace.report(Errors.ACCESSOR_PARAMETER_NAME_SHADOWING.on(parameter));
            }
        }
        DataFlowInfo dataFlowInfo = null;
        if (beforeBlockBody != null) {
            dataFlowInfo = (DataFlowInfo)beforeBlockBody.invoke((Object)headerScope);
        }
        if (function2.hasBody()) {
            this.expressionTypingServices.checkFunctionReturnType(innerScope, function2, functionDescriptor, dataFlowInfo != null ? dataFlowInfo : outerDataFlowInfo, null, trace);
        }
        assert (functionDescriptor.getReturnType() != null);
    }

    public void resolveConstructorParameterDefaultValues(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull BindingTrace trace, @NotNull KtPrimaryConstructor constructor2, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull LexicalScope declaringScope) {
        if (outerDataFlowInfo == null) {
            BodyResolver.$$$reportNull$$$0(98);
        }
        if (trace == null) {
            BodyResolver.$$$reportNull$$$0(99);
        }
        if (constructor2 == null) {
            BodyResolver.$$$reportNull$$$0(100);
        }
        if (constructorDescriptor == null) {
            BodyResolver.$$$reportNull$$$0(101);
        }
        if (declaringScope == null) {
            BodyResolver.$$$reportNull$$$0(102);
        }
        List<KtParameter> valueParameters2 = constructor2.getValueParameters();
        List<ValueParameterDescriptor> valueParameterDescriptors = constructorDescriptor.getValueParameters();
        LexicalScope scope2 = BodyResolver.getPrimaryConstructorParametersScope(declaringScope, constructorDescriptor);
        this.valueParameterResolver.resolveValueParameters(valueParameters2, valueParameterDescriptors, scope2, outerDataFlowInfo, trace);
    }

    private static void computeDeferredType(KotlinType type2) {
        DeferredType deferredType;
        if (type2 instanceof DeferredType && !(deferredType = (DeferredType)type2).isComputed()) {
            deferredType.getDelegate();
        }
    }

    private void computeDeferredTypes() {
        Collection<Box<DeferredType>> deferredTypes = this.trace.getKeys(BindingContext.DEFERRED_TYPE);
        if (deferredTypes.isEmpty()) {
            return;
        }
        Queue<DeferredType> queue = new Queue<DeferredType>(deferredTypes.size() + 1);
        this.trace.addHandler(BindingContext.DEFERRED_TYPE, (deferredTypeKeyDeferredTypeWritableSlice, key, value2) -> queue.addLast((DeferredType)key.getData()));
        for (Box<DeferredType> deferredType : deferredTypes) {
            queue.addLast(deferredType.getData());
        }
        while (!queue.isEmpty()) {
            DeferredType deferredType = (DeferredType)queue.pullFirst();
            if (deferredType.isComputed()) continue;
            try {
                deferredType.getDelegate();
            }
            catch (ReenteringLazyValueComputationException reenteringLazyValueComputationException) {}
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 46: 
            case 50: 
            case 86: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 46: 
            case 50: 
            case 86: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyResolveCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callResolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlowAnalyzer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationsChecker";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegatedPropertyResolver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionTypingServices";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyzerExtensions";
                break;
            }
            case 9: 
            case 18: 
            case 23: 
            case 51: 
            case 89: 
            case 94: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameterResolver";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationChecker";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloadChecker";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 57: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 71: 
            case 84: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 17: 
            case 22: 
            case 33: 
            case 43: 
            case 58: 
            case 74: 
            case 79: 
            case 88: 
            case 93: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerDataFlowInfo";
                break;
            }
            case 19: 
            case 25: 
            case 30: 
            case 52: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 20: 
            case 26: 
            case 35: 
            case 38: 
            case 45: 
            case 47: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 21: 
            case 92: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringScope";
                break;
            }
            case 24: 
            case 62: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 27: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorDescriptor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedConstructors";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startConstructor";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktClass";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForConstructorResolution";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForMemberResolution";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktEnumEntry";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumEntryDescriptor";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForConstructor";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryConstructorDelegationCall";
                break;
            }
            case 46: 
            case 50: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/BodyResolver";
                break;
            }
            case 48: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supertypes";
                break;
            }
            case 49: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktClassOrObject";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supertypeOwner";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anonymousInitializer";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 65: 
            case 72: 
            case 75: 
            case 80: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 66: 
            case 73: 
            case 76: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateExpression";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyHeaderScope";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyHeader";
                break;
            }
            case 90: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 91: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/BodyResolver";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorForEmptyArgumentsList";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedFinalSupertypes";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveBehaviorDeclarationBodies";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveSecondaryConstructors";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveSecondaryConstructorBody";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveSecondaryConstructorDelegationCall";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkCyclicConstructorDelegationCall";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "reportEachConstructorOnCycle";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDelegatedConstructor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveBodies";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveSuperTypeEntryLists";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "resolveSuperTypeEntryList";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkRedeclarationsInClassHeaderWithoutPrimaryConstructor";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorCallForEnumEntryWithoutInitializer";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorForEmptyArgumentsList";
                break;
            }
            case 46: 
            case 50: 
            case 86: {
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getAllowedFinalSupertypes";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "recordConstructorDelegationCall";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "checkSupertypeList";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "resolveAnonymousInitializers";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "resolveAnonymousInitializer";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "processModifiersOnInitializer";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "resolvePrimaryConstructorParameters";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "resolveProperty";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertyDeclarationBodies";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "makeScopeForPropertyAccessor";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertyAccessors";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertyDelegate";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertyInitializer";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getScopeForProperty";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "resolveFunctionBodies";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "resolveFunctionBody";
                break;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorParameterDefaultValues";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 46: 
            case 50: 
            case 86: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

