/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.ValueArgumentName;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;

public class ValueArgumentsToParametersMapper {
    public static <D extends CallableDescriptor> Status mapValueArgumentsToParameters(@NotNull Call call2, @NotNull TracingStrategy tracing, @NotNull MutableResolvedCall<D> candidateCall) {
        if (call2 == null) {
            ValueArgumentsToParametersMapper.$$$reportNull$$$0(0);
        }
        if (tracing == null) {
            ValueArgumentsToParametersMapper.$$$reportNull$$$0(1);
        }
        if (candidateCall == null) {
            ValueArgumentsToParametersMapper.$$$reportNull$$$0(2);
        }
        Processor processor2 = new Processor(call2, candidateCall, tracing);
        processor2.process();
        return processor2.status;
    }

    private ValueArgumentsToParametersMapper() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "tracing";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "candidateCall";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper";
        objectArray[2] = "mapValueArgumentsToParameters";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Processor<D extends CallableDescriptor> {
        private final Call call;
        private final TracingStrategy tracing;
        private final MutableResolvedCall<D> candidateCall;
        private final List<ValueParameterDescriptor> parameters;
        private final Map<Name, ValueParameterDescriptor> parameterByName;
        private Map<Name, ValueParameterDescriptor> parameterByNameInOverriddenMethods;
        private final Map<ValueParameterDescriptor, VarargValueArgument> varargs;
        private final Set<ValueParameterDescriptor> usedParameters;
        private Status status;
        private final ProcessorState positionedOnly;
        private final ProcessorState positionedThenNamed;

        private Processor(@NotNull Call call2, @NotNull MutableResolvedCall<D> candidateCall, @NotNull TracingStrategy tracing) {
            if (call2 == null) {
                Processor.$$$reportNull$$$0(0);
            }
            if (candidateCall == null) {
                Processor.$$$reportNull$$$0(1);
            }
            if (tracing == null) {
                Processor.$$$reportNull$$$0(2);
            }
            this.varargs = new HashMap<ValueParameterDescriptor, VarargValueArgument>();
            this.usedParameters = new HashSet<ValueParameterDescriptor>();
            this.status = Status.OK;
            this.positionedOnly = new ProcessorState(){
                private int currentParameter = 0;

                private int numberOfParametersForPositionedArguments() {
                    return call.getCallType() == Call.CallType.ARRAY_SET_METHOD ? parameters.size() - 1 : parameters.size();
                }

                @Nullable
                public ValueParameterDescriptor nextValueParameter() {
                    if (this.currentParameter >= this.numberOfParametersForPositionedArguments()) {
                        return null;
                    }
                    ValueParameterDescriptor head = (ValueParameterDescriptor)parameters.get(this.currentParameter);
                    if (head.getVarargElementType() == null) {
                        ++this.currentParameter;
                    }
                    return head;
                }

                @Override
                public ProcessorState processNamedArgument(@NotNull ValueArgument argument) {
                    if (argument == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return positionedThenNamed.processNamedArgument(argument);
                }

                @Override
                public ProcessorState processPositionedArgument(@NotNull ValueArgument argument) {
                    if (argument == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.processArgument(argument, this.nextValueParameter());
                    return positionedOnly;
                }

                @Override
                public ProcessorState processArraySetRHS(@NotNull ValueArgument argument) {
                    if (argument == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    this.processArgument(argument, (ValueParameterDescriptor)CollectionsKt.lastOrNull((List)parameters));
                    return positionedOnly;
                }

                private void processArgument(@NotNull ValueArgument argument, @Nullable ValueParameterDescriptor parameter) {
                    if (argument == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (parameter != null) {
                        usedParameters.add(parameter);
                        this.putVararg(parameter, argument);
                    } else {
                        this.report(Errors.TOO_MANY_ARGUMENTS.on(argument.asElement(), (CallableDescriptor)candidateCall.getCandidateDescriptor()));
                        this.setStatus(Status.WEAK_ERROR);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "argument";
                    objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper$Processor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processNamedArgument";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processPositionedArgument";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processArraySetRHS";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processArgument";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.positionedThenNamed = new ProcessorState(){

                @Override
                public ProcessorState processNamedArgument(@NotNull ValueArgument argument) {
                    if (argument == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    assert (argument.isNamed());
                    Object candidate2 = candidateCall.getCandidateDescriptor();
                    ValueArgumentName argumentName = argument.getArgumentName();
                    assert (argumentName != null);
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)parameterByName.get(argumentName.getAsName());
                    KtSimpleNameExpression nameReference = argumentName.getReferenceExpression();
                    ReservedCheckingKt.checkReservedYield(nameReference, candidateCall.getTrace());
                    if (nameReference != null) {
                        if (candidate2 instanceof MemberDescriptor && ((MemberDescriptor)candidate2).isExpect() && candidate2.getContainingDeclaration() instanceof ClassDescriptor) {
                            this.report(Errors.NAMED_ARGUMENTS_NOT_ALLOWED.on(nameReference, Errors.BadNamedArgumentsTarget.EXPECTED_CLASS_MEMBER));
                        } else if (!candidate2.hasStableParameterNames()) {
                            Errors.BadNamedArgumentsTarget badNamedArgumentsTarget = candidate2 instanceof FunctionInvokeDescriptor ? Errors.BadNamedArgumentsTarget.INVOKE_ON_FUNCTION_TYPE : (candidate2 instanceof DeserializedCallableMemberDescriptor ? Errors.BadNamedArgumentsTarget.INTEROP_FUNCTION : Errors.BadNamedArgumentsTarget.NON_KOTLIN_FUNCTION);
                            this.report(Errors.NAMED_ARGUMENTS_NOT_ALLOWED.on(nameReference, badNamedArgumentsTarget));
                        }
                    }
                    if (candidate2.hasStableParameterNames() && nameReference != null && candidate2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)candidate2).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                        if (valueParameterDescriptor == null) {
                            valueParameterDescriptor = this.getParameterByNameInOverriddenMethods(argumentName.getAsName());
                        }
                        if (valueParameterDescriptor != null) {
                            for (ValueParameterDescriptor parameterFromSuperclass : valueParameterDescriptor.getOverriddenDescriptors()) {
                                if (!OverrideResolver.Companion.shouldReportParameterNameOverrideWarning(valueParameterDescriptor, parameterFromSuperclass)) continue;
                                this.report(Errors.NAME_FOR_AMBIGUOUS_PARAMETER.on(nameReference));
                            }
                        }
                    }
                    if (valueParameterDescriptor == null) {
                        if (nameReference != null) {
                            this.report(Errors.NAMED_PARAMETER_NOT_FOUND.on(nameReference, nameReference));
                        }
                        this.setStatus(Status.WEAK_ERROR);
                    } else {
                        if (nameReference != null) {
                            candidateCall.getTrace().record(BindingContext.REFERENCE_TARGET, nameReference, valueParameterDescriptor);
                        }
                        if (!usedParameters.add(valueParameterDescriptor)) {
                            if (nameReference != null) {
                                this.report(Errors.ARGUMENT_PASSED_TWICE.on(nameReference));
                            }
                            this.setStatus(Status.WEAK_ERROR);
                        } else {
                            this.putVararg(valueParameterDescriptor, argument);
                        }
                    }
                    return positionedThenNamed;
                }

                @Override
                public ProcessorState processPositionedArgument(@NotNull ValueArgument argument) {
                    if (argument == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    this.report(Errors.MIXING_NAMED_AND_POSITIONED_ARGUMENTS.on(argument.asElement()));
                    this.setStatus(Status.WEAK_ERROR);
                    return positionedThenNamed;
                }

                @Override
                public ProcessorState processArraySetRHS(@NotNull ValueArgument argument) {
                    if (argument == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    throw new IllegalStateException("Array set RHS cannot appear after a named argument syntactically: " + argument);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "argument";
                    objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper$Processor$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processNamedArgument";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processPositionedArgument";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processArraySetRHS";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.call = call2;
            this.tracing = tracing;
            this.candidateCall = candidateCall;
            this.parameters = candidateCall.getCandidateDescriptor().getValueParameters();
            this.parameterByName = new HashMap<Name, ValueParameterDescriptor>();
            for (ValueParameterDescriptor valueParameter : this.parameters) {
                this.parameterByName.put(valueParameter.getName(), valueParameter);
            }
        }

        @Nullable
        private ValueParameterDescriptor getParameterByNameInOverriddenMethods(Name name) {
            if (this.parameterByNameInOverriddenMethods == null) {
                this.parameterByNameInOverriddenMethods = new HashMap<Name, ValueParameterDescriptor>();
                for (ValueParameterDescriptor valueParameter : this.parameters) {
                    for (ValueParameterDescriptor parameterDescriptor : valueParameter.getOverriddenDescriptors()) {
                        this.parameterByNameInOverriddenMethods.put(parameterDescriptor.getName(), valueParameter);
                    }
                }
            }
            return this.parameterByNameInOverriddenMethods.get(name);
        }

        public void process() {
            ProcessorState state = this.positionedOnly;
            boolean isArraySetMethod = this.call.getCallType() == Call.CallType.ARRAY_SET_METHOD;
            List<ValueArgument> argumentsInParentheses = CallUtilKt.getValueArgumentsInParentheses(this.call);
            Iterator<ValueArgument> iterator2 = argumentsInParentheses.iterator();
            while (iterator2.hasNext()) {
                ValueArgument valueArgument = iterator2.next();
                if (valueArgument.isNamed()) {
                    state = state.processNamedArgument(valueArgument);
                    continue;
                }
                if (isArraySetMethod && !iterator2.hasNext()) {
                    state = state.processArraySetRHS(valueArgument);
                    continue;
                }
                state = state.processPositionedArgument(valueArgument);
            }
            for (Map.Entry<ValueParameterDescriptor, VarargValueArgument> entry : this.varargs.entrySet()) {
                this.candidateCall.recordValueArgument(entry.getKey(), entry.getValue());
            }
            this.processFunctionLiteralArguments();
            this.reportUnmappedParameters();
        }

        private void processFunctionLiteralArguments() {
            List<? extends LambdaArgument> functionLiteralArguments = this.call.getFunctionLiteralArguments();
            if (functionLiteralArguments.isEmpty()) {
                return;
            }
            LambdaArgument lambdaArgument = functionLiteralArguments.get(0);
            KtExpression possiblyLabeledFunctionLiteral = lambdaArgument.getArgumentExpression();
            if (this.parameters.isEmpty()) {
                CallUtilKt.reportTrailingLambdaErrorOr(this.candidateCall.getTrace(), possiblyLabeledFunctionLiteral, (Function1<? super KtExpression, ? extends Diagnostic>)((Function1)expression2 -> Errors.TOO_MANY_ARGUMENTS.on((PsiElement)expression2, (CallableDescriptor)this.candidateCall.getCandidateDescriptor())));
                this.setStatus(Status.ERROR);
            } else {
                ValueParameterDescriptor lastParameter = (ValueParameterDescriptor)CollectionsKt.last(this.parameters);
                if (lastParameter.getVarargElementType() != null) {
                    CallUtilKt.reportTrailingLambdaErrorOr(this.candidateCall.getTrace(), possiblyLabeledFunctionLiteral, (Function1<? super KtExpression, ? extends Diagnostic>)((Function1)expression2 -> Errors.VARARG_OUTSIDE_PARENTHESES.on((KtExpression)expression2)));
                    this.setStatus(Status.ERROR);
                } else if (!this.usedParameters.add(lastParameter)) {
                    CallUtilKt.reportTrailingLambdaErrorOr(this.candidateCall.getTrace(), possiblyLabeledFunctionLiteral, (Function1<? super KtExpression, ? extends Diagnostic>)((Function1)expr -> Errors.TOO_MANY_ARGUMENTS.on((PsiElement)expr, (CallableDescriptor)this.candidateCall.getCandidateDescriptor())));
                    this.setStatus(Status.WEAK_ERROR);
                } else {
                    this.putVararg(lastParameter, lambdaArgument);
                }
            }
            for (int i = 1; i < functionLiteralArguments.size(); ++i) {
                KtExpression argument = functionLiteralArguments.get(i).getArgumentExpression();
                if (argument instanceof KtLambdaExpression) {
                    this.report(Errors.MANY_LAMBDA_EXPRESSION_ARGUMENTS.on(argument));
                    if (CallUtilKt.isTrailingLambdaOnNewLIne((KtLambdaExpression)argument)) {
                        this.report(Errors.UNEXPECTED_TRAILING_LAMBDA_ON_A_NEW_LINE.on((KtLambdaExpression)argument));
                    }
                }
                this.setStatus(Status.WEAK_ERROR);
            }
        }

        private void reportUnmappedParameters() {
            for (ValueParameterDescriptor valueParameter : this.parameters) {
                if (this.usedParameters.contains(valueParameter)) continue;
                if (ArgumentsUtilsKt.hasDefaultValue(valueParameter)) {
                    this.candidateCall.recordValueArgument(valueParameter, DefaultValueArgument.DEFAULT);
                    continue;
                }
                if (valueParameter.getVarargElementType() != null) {
                    this.candidateCall.recordValueArgument(valueParameter, new VarargValueArgument());
                    continue;
                }
                this.tracing.noValueForParameter(this.candidateCall.getTrace(), valueParameter);
                this.setStatus(Status.ERROR);
            }
        }

        private void putVararg(ValueParameterDescriptor valueParameterDescriptor, ValueArgument valueArgument) {
            if (valueParameterDescriptor.getVarargElementType() != null) {
                VarargValueArgument vararg = this.varargs.computeIfAbsent(valueParameterDescriptor, k -> new VarargValueArgument());
                vararg.addArgument(valueArgument);
            } else {
                LeafPsiElement spread = valueArgument.getSpreadElement();
                if (spread != null) {
                    this.candidateCall.getTrace().report(Errors.NON_VARARG_SPREAD.on(spread));
                    this.setStatus(Status.WEAK_ERROR);
                }
                ExpressionValueArgument argument = new ExpressionValueArgument(valueArgument);
                this.candidateCall.recordValueArgument(valueParameterDescriptor, argument);
            }
        }

        private void setStatus(@NotNull Status newStatus) {
            if (newStatus == null) {
                Processor.$$$reportNull$$$0(3);
            }
            this.status = this.status.compose(newStatus);
        }

        private void report(Diagnostic diagnostic) {
            this.candidateCall.getTrace().report(diagnostic);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidateCall";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracing";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newStatus";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper$Processor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setStatus";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static interface ProcessorState {
            public ProcessorState processNamedArgument(@NotNull ValueArgument var1);

            public ProcessorState processPositionedArgument(@NotNull ValueArgument var1);

            public ProcessorState processArraySetRHS(@NotNull ValueArgument var1);
        }
    }

    public static enum Status {
        ERROR(false),
        WEAK_ERROR(false),
        OK(true);

        private final boolean success;

        private Status(boolean success) {
            this.success = success;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Status compose(Status other) {
            if (this == ERROR || other == ERROR) {
                return ERROR;
            }
            if (this == WEAK_ERROR || other == WEAK_ERROR) {
                return WEAK_ERROR;
            }
            return this;
        }
    }
}

