/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/InfixCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class InfixCallChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Object object;
        Object object2;
        FunctionDescriptor functionDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object3 = resolvedCall2.getResultingDescriptor();
        FunctionDescriptor functionDescriptor2 = functionDescriptor = object3 instanceof FunctionDescriptor ? (FunctionDescriptor)object3 : null;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor3 = functionDescriptor;
        if (functionDescriptor3.isInfix() || DynamicCallsKt.isDynamic(functionDescriptor3) || ErrorUtils.isError(functionDescriptor3)) {
            return;
        }
        Object object4 = object2 = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? (VariableAsFunctionResolvedCall)((Object)resolvedCall2) : null;
        object3 = (object2 == null ? resolvedCall2 : ((object = object2.getVariableCall()) == null ? resolvedCall2 : object)).getCall();
        Intrinsics.checkNotNullExpressionValue(object3, (String)"(resolvedCall as? VariableAsFunctionResolvedCall)?.variableCall ?: resolvedCall).call");
        Object call2 = object3;
        if (CallResolverUtilKt.isInfixCall(call2)) {
            object = functionDescriptor3.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"functionDescriptor.containingDeclaration");
            object2 = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)object).asString();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"functionDescriptor.containingDeclaration.fqNameUnsafe.asString()");
            Object containingDeclarationName = object2;
            context2.getTrace().report(Errors.INFIX_MODIFIER_REQUIRED.on(reportOn, functionDescriptor3, (String)containingDeclarationName));
        }
    }
}

