/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstUtilKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.resolve.checkers.ConstApplicability;
import org.jetbrains.kotlin.resolve.checkers.ConstModifierCheckerKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ConstModifierChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "canBeConst", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "constModifierPsiElement", "Lcom/intellij/psi/PsiElement;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "check", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkCanBeConst", "Lorg/jetbrains/kotlin/resolve/checkers/ConstApplicability;", "frontend"})
public final class ConstModifierChecker
implements DeclarationChecker {
    @NotNull
    public static final ConstModifierChecker INSTANCE = new ConstModifierChecker();

    private ConstModifierChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof VariableDescriptor) || !declaration2.hasModifier(KtTokens.CONST_KEYWORD)) {
            return;
        }
        KtModifierList ktModifierList = declaration2.getModifierList();
        Intrinsics.checkNotNull((Object)ktModifierList);
        PsiElement psiElement2 = ktModifierList.getModifier(KtTokens.CONST_KEYWORD);
        Intrinsics.checkNotNull((Object)psiElement2);
        PsiElement constModifierPsiElement = psiElement = psiElement2;
        Diagnostic diagnostic = this.checkCanBeConst(declaration2, constModifierPsiElement, (VariableDescriptor)descriptor2).getDiagnostic();
        if (diagnostic != null) {
            context2.getTrace().report(diagnostic);
        }
    }

    public final boolean canBeConst(@NotNull KtDeclaration declaration2, @NotNull PsiElement constModifierPsiElement, @NotNull VariableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)constModifierPsiElement, (String)"constModifierPsiElement");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return this.checkCanBeConst(declaration2, constModifierPsiElement, descriptor2).getCanBeConst();
    }

    private final ConstApplicability checkCanBeConst(KtDeclaration declaration2, PsiElement constModifierPsiElement, VariableDescriptor descriptor2) {
        if (descriptor2.isVar()) {
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.WRONG_MODIFIER_TARGET.on(constModifierPsiElement, KtTokens.CONST_KEYWORD, "vars");
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"WRONG_MODIFIER_TARGET.on(constModifierPsiElement, KtTokens.CONST_KEYWORD, \"vars\")");
            return ConstModifierCheckerKt.access$nonApplicable(parametrizedDiagnostic);
        }
        SimpleDiagnostic<PsiElement> simpleDiagnostic = descriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)simpleDiagnostic, (String)"descriptor.containingDeclaration");
        DeclarationDescriptor containingDeclaration = simpleDiagnostic;
        if (containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() != ClassKind.OBJECT) {
            simpleDiagnostic = Errors.CONST_VAL_NOT_TOP_LEVEL_OR_OBJECT.on(constModifierPsiElement);
            Intrinsics.checkNotNullExpressionValue((Object)simpleDiagnostic, (String)"CONST_VAL_NOT_TOP_LEVEL_OR_OBJECT.on(constModifierPsiElement)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        if (!(declaration2 instanceof KtProperty) || !(descriptor2 instanceof PropertyDescriptor)) {
            return new ConstApplicability.NonApplicable(null, 1, null);
        }
        if (((KtProperty)declaration2).hasDelegate()) {
            KtPropertyDelegate ktPropertyDelegate = ((KtProperty)declaration2).getDelegate();
            Intrinsics.checkNotNull((Object)ktPropertyDelegate);
            simpleDiagnostic = Errors.CONST_VAL_WITH_DELEGATE.on(ktPropertyDelegate);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"CONST_VAL_WITH_DELEGATE.on(declaration.delegate!!)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        KtPropertyAccessor getter2 = ((KtProperty)declaration2).getGetter();
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = ((PropertyDescriptor)descriptor2).getGetter();
        Intrinsics.checkNotNull((Object)parametrizedDiagnostic);
        if (!parametrizedDiagnostic.isDefault() && getter2 != null) {
            parametrizedDiagnostic = Errors.CONST_VAL_WITH_GETTER.on(getter2);
            Intrinsics.checkNotNullExpressionValue((Object)parametrizedDiagnostic, (String)"CONST_VAL_WITH_GETTER.on(getter)");
            return ConstModifierCheckerKt.access$nonApplicable(parametrizedDiagnostic);
        }
        parametrizedDiagnostic = ((PropertyDescriptor)descriptor2).getType();
        Intrinsics.checkNotNullExpressionValue((Object)parametrizedDiagnostic, (String)"descriptor.type");
        if (KotlinTypeKt.isError((KotlinType)((Object)parametrizedDiagnostic))) {
            return new ConstApplicability.NonApplicable(null, 1, null);
        }
        parametrizedDiagnostic = ((PropertyDescriptor)descriptor2).getType();
        Intrinsics.checkNotNullExpressionValue((Object)parametrizedDiagnostic, (String)"descriptor.type");
        if (!ConstUtilKt.canBeUsedForConstVal((KotlinType)((Object)parametrizedDiagnostic))) {
            parametrizedDiagnostic = Errors.TYPE_CANT_BE_USED_FOR_CONST_VAL.on(constModifierPsiElement, ((PropertyDescriptor)descriptor2).getType());
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"TYPE_CANT_BE_USED_FOR_CONST_VAL.on(constModifierPsiElement, descriptor.type)");
            return ConstModifierCheckerKt.access$nonApplicable(parametrizedDiagnostic);
        }
        if (((KtProperty)declaration2).getInitializer() == null) {
            parametrizedDiagnostic = Errors.CONST_VAL_WITHOUT_INITIALIZER.on(constModifierPsiElement);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"CONST_VAL_WITHOUT_INITIALIZER.on(constModifierPsiElement)");
            return ConstModifierCheckerKt.access$nonApplicable(parametrizedDiagnostic);
        }
        if (((PropertyDescriptor)descriptor2).getCompileTimeInitializer() == null) {
            KtExpression ktExpression = ((KtProperty)declaration2).getInitializer();
            Intrinsics.checkNotNull((Object)ktExpression);
            parametrizedDiagnostic = Errors.CONST_VAL_WITH_NON_CONST_INITIALIZER.on((KtExpression)((PsiElement)ktExpression));
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"CONST_VAL_WITH_NON_CONST_INITIALIZER.on(declaration.initializer!!)");
            return ConstModifierCheckerKt.access$nonApplicable(parametrizedDiagnostic);
        }
        return ConstApplicability.Applicable.INSTANCE;
    }
}

