/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/KClassWithIncorrectTypeArgumentChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isKClassWithBadArgument", "", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "frontend"})
public final class KClassWithIncorrectTypeArgumentChecker
implements DeclarationChecker {
    @NotNull
    public static final KClassWithIncorrectTypeArgumentChecker INSTANCE = new KClassWithIncorrectTypeArgumentChecker();

    private KClassWithIncorrectTypeArgumentChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof CallableMemberDescriptor) || Intrinsics.areEqual((Object)((CallableMemberDescriptor)descriptor2).getVisibility(), (Object)DescriptorVisibilities.LOCAL)) {
            return;
        }
        if (!(declaration2 instanceof KtCallableDeclaration) || ((KtCallableDeclaration)declaration2).getTypeReference() != null) {
            return;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return;
        }
        KotlinType kotlinType2 = ((CallableMemberDescriptor)descriptor2).getReturnType();
        if (kotlinType2 == null) {
            return;
        }
        KotlinType returnType2 = kotlinType = kotlinType2;
        Ref.ObjectRef typeParameterWithoutNotNullableUpperBound = new Ref.ObjectRef();
        TypeUtilsKt.contains(returnType2, (Function1<? super UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>(this, descriptor2, (Ref.ObjectRef<TypeParameterDescriptor>)typeParameterWithoutNotNullableUpperBound){
            final /* synthetic */ KClassWithIncorrectTypeArgumentChecker this$0;
            final /* synthetic */ DeclarationDescriptor $descriptor;
            final /* synthetic */ Ref.ObjectRef<TypeParameterDescriptor> $typeParameterWithoutNotNullableUpperBound;
            {
                this.this$0 = $receiver;
                this.$descriptor = $descriptor;
                this.$typeParameterWithoutNotNullableUpperBound = $typeParameterWithoutNotNullableUpperBound;
                super(1);
            }

            public final boolean invoke(@NotNull UnwrappedType type2) {
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                boolean kClassWithBadArgument = KClassWithIncorrectTypeArgumentChecker.access$isKClassWithBadArgument(this.this$0, type2);
                if (kClassWithBadArgument) {
                    Object object;
                    TypeConstructor typeConstructor2;
                    Object object2 = (TypeProjection)CollectionsKt.singleOrNull(type2.getArguments());
                    TypeConstructor typeConstructor3 = object2 == null ? null : (typeConstructor2 = (object = object2.getType()) == null ? null : ((KotlinType)object).getConstructor());
                    if (typeConstructor2 != null && (object2 = typeConstructor2.getDeclarationDescriptor()) != null) {
                        object = object2;
                        DeclarationDescriptor declarationDescriptor = this.$descriptor;
                        Ref.ObjectRef<TypeParameterDescriptor> objectRef = this.$typeParameterWithoutNotNullableUpperBound;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object;
                        boolean bl3 = false;
                        if (it instanceof TypeParameterDescriptor && Intrinsics.areEqual((Object)((TypeParameterDescriptor)it).getContainingDeclaration(), (Object)declarationDescriptor)) {
                            objectRef.element = it;
                        }
                    }
                }
                return kClassWithBadArgument;
            }
        }));
        if (typeParameterWithoutNotNullableUpperBound.element != null) {
            BindingTrace bindingTrace = context2.getTrace();
            PsiElement psiElement = declaration2;
            Intrinsics.checkNotNull((Object)typeParameterWithoutNotNullableUpperBound.element);
            bindingTrace.report(Errors.KCLASS_WITH_NULLABLE_TYPE_PARAMETER_IN_SIGNATURE.on((KtNamedDeclaration)psiElement, (TypeParameterDescriptor)typeParameterWithoutNotNullableUpperBound.element));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isKClassWithBadArgument(UnwrappedType $this$isKClassWithBadArgument) {
        Object object = (TypeProjection)CollectionsKt.singleOrNull($this$isKClassWithBadArgument.getArguments());
        if (object == null) {
            return false;
        }
        Object object2 = object;
        boolean bl = false;
        boolean bl2 = false;
        TypeProjection it = object2;
        boolean bl3 = false;
        if (it.isStarProjection()) {
            return false;
        }
        UnwrappedType unwrappedType = it.getType().unwrap();
        UnwrappedType unwrappedType2 = unwrappedType;
        if (unwrappedType2 == null) {
            return false;
        }
        UnwrappedType argumentType = unwrappedType2;
        object2 = $this$isKClassWithBadArgument.getConstructor().getDeclarationDescriptor();
        if (!(object2 instanceof ClassDescriptor)) return false;
        ClassDescriptor classDescriptor2 = (ClassDescriptor)object2;
        object = classDescriptor2;
        if (object == null) {
            return false;
        }
        Object klass = object;
        if (!KotlinBuiltIns.isKClass((ClassDescriptor)klass)) return false;
        KotlinType kotlinType = argumentType;
        object = TypeUtilsKt.getBuiltIns(argumentType).getAnyType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"argumentType.builtIns.anyType");
        if (TypeUtilsKt.isSubtypeOf(kotlinType, (KotlinType)object)) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$isKClassWithBadArgument(KClassWithIncorrectTypeArgumentChecker $this, UnwrappedType $receiver) {
        return $this.isKClassWithBadArgument($receiver);
    }
}

