/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmMultifileClassStateChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class JvmMultifileClassStateChecker
implements DeclarationChecker {
    @NotNull
    public static final JvmMultifileClassStateChecker INSTANCE = new JvmMultifileClassStateChecker();

    private JvmMultifileClassStateChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof PropertyDescriptor) || !DescriptorUtils.isTopLevelDeclaration(descriptor2) || ((PropertyDescriptor)descriptor2).isExpect() || ((PropertyDescriptor)descriptor2).isConst()) {
            return;
        }
        if (!context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.INSTANCE.getInheritMultifileParts()).booleanValue()) {
            return;
        }
        KtFile ktFile = declaration2.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"declaration.containingKtFile");
        if (!JvmFileClassUtil.getFileClassInfoNoResolve(ktFile).getWithJvmMultifileClass()) {
            return;
        }
        if (((PropertyDescriptor)descriptor2).isDelegated() || Intrinsics.areEqual(context2.getTrace().getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2), (Object)true)) {
            context2.getTrace().report(ErrorsJvm.STATE_IN_MULTIFILE_CLASS.on((KtDeclaration)((PsiElement)declaration2)));
        }
    }
}

