/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="5.1")
public enum JRE {
    UNDEFINED(-1),
    JAVA_8(8),
    JAVA_9(9),
    JAVA_10(10),
    JAVA_11(11),
    JAVA_12(12),
    JAVA_13(13),
    JAVA_14(14),
    JAVA_15(15),
    JAVA_16(16),
    JAVA_17(17),
    JAVA_18(18),
    JAVA_19(19),
    JAVA_20(20),
    JAVA_21(21),
    JAVA_22(22),
    JAVA_23(23),
    JAVA_24(24),
    JAVA_25(25),
    JAVA_26(26),
    OTHER(Integer.MAX_VALUE);

    static final int UNDEFINED_VERSION = -1;
    static final int MINIMUM_VERSION = 8;
    private static final int CURRENT_VERSION;
    private final int version;

    private JRE(int version) {
        this.version = version;
    }

    @API(status=API.Status.MAINTAINED, since="5.13.3")
    public int version() {
        return this.version;
    }

    public boolean isCurrentVersion() {
        return this == JRE.currentJre();
    }

    @API(status=API.Status.DEPRECATED, since="5.12")
    @Deprecated(since="5.12")
    public static JRE currentVersion() {
        return JRE.currentJre();
    }

    @API(status=API.Status.STABLE, since="5.12")
    public static JRE currentJre() {
        return switch (CURRENT_VERSION) {
            case 8 -> JAVA_8;
            case 9 -> JAVA_9;
            case 10 -> JAVA_10;
            case 11 -> JAVA_11;
            case 12 -> JAVA_12;
            case 13 -> JAVA_13;
            case 14 -> JAVA_14;
            case 15 -> JAVA_15;
            case 16 -> JAVA_16;
            case 17 -> JAVA_17;
            case 18 -> JAVA_18;
            case 19 -> JAVA_19;
            case 20 -> JAVA_20;
            case 21 -> JAVA_21;
            case 22 -> JAVA_22;
            case 23 -> JAVA_23;
            case 24 -> JAVA_24;
            case 25 -> JAVA_25;
            case 26 -> JAVA_26;
            default -> OTHER;
        };
    }

    @API(status=API.Status.MAINTAINED, since="5.13.3")
    public static int currentVersionNumber() {
        return CURRENT_VERSION;
    }

    @API(status=API.Status.MAINTAINED, since="5.13.3")
    public static boolean isCurrentVersion(int version) {
        return version == CURRENT_VERSION || version == JRE.currentJre().version;
    }

    static boolean isCurrentVersionWithinRange(int min, int max) {
        return CURRENT_VERSION >= min && CURRENT_VERSION <= max;
    }

    static {
        CURRENT_VERSION = Runtime.version().feature();
    }
}

