/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.common.api.rolodex;

import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.sys.api.model.Inactivatable;

public interface RolodexContract extends Inactivatable, Addressable {
    
    Integer getRolodexId();

    @Override
    String getAddressLine1();

    @Override
    String getAddressLine2();

    @Override
    String getAddressLine3();

    @Override
    String getCity();

    String getComments();

    @Override
    String getCountryCode();

    @Override
    String getCounty();

    Boolean getDeleteFlag();

    String getEmailAddress();

    String getFaxNumber();

    String getFirstName();

    String getLastName();

    String getMiddleName();

    String getOrganization();

    String getOrganizationUei();

    String getOwnedByUnit();

    String getPhoneNumber();

    @Override
    String getPostalCode();

    String getPrefix();

    boolean getSponsorAddressFlag();

    String getSponsorCode();

    @Override
    String getState();

    String getSuffix();

    String getTitle();

    String getCreateUser();

    String getFullName();
}
