-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

-- ============================================================================
-- Elasticsearch Index Job Configuration Parameters
-- ============================================================================
-- This migration adds the system parameters needed to configure and enable
-- the Elasticsearch scheduled indexing job. This job ensures that:
-- - New users added to roles/groups can see existing documents
-- - Permission changes are reflected in search results
-- - Proposal Workload Assignment dropdowns are updated
--
-- Related Ticket: Elasticsearch Indexing Performance & Bug Fixes
-- ============================================================================

-- Parameter 1: Enable/Disable the Elasticsearch Index Job
insert into krcr_parm_t (nmspc_cd, cmpnt_cd, parm_nm, obj_id, ver_nbr, parm_typ_cd, val, parm_desc_txt, eval_oprtr_cd, appl_id)
values ('KC-SYS', 'All', 'Elasticsearch_Index_Job_Enabled', UUID(), 1, 'CONFG', 'N',
        'Enable or disable the Elasticsearch scheduled indexing job. Set to Y to enable automatic re-indexing of documents on a schedule. Default is N (disabled).', 'A', 'KC')
on duplicate key update parm_desc_txt = values(parm_desc_txt);

-- Parameter 2: Cron Expression for Job Schedule
insert into krcr_parm_t (nmspc_cd, cmpnt_cd, parm_nm, obj_id, ver_nbr, parm_typ_cd, val, parm_desc_txt, eval_oprtr_cd, appl_id)
values ('KC-SYS', 'All', 'Elasticsearch_Index_Job_Cron_Expression', UUID(), 1, 'CONFG', '0 0 2 * * ?',
        'Cron expression for the Elasticsearch indexing job schedule. Default is daily at 2:00 AM (0 0 2 * * ?). Examples: 0 0 */6 * * ? (every 6 hours), 0 0 0 * * SUN (weekly on Sunday).', 'A', 'KC')
on duplicate key update parm_desc_txt = values(parm_desc_txt);

-- Parameter 3: Skip Misfire Handling
insert into krcr_parm_t (nmspc_cd, cmpnt_cd, parm_nm, obj_id, ver_nbr, parm_typ_cd, val, parm_desc_txt, eval_oprtr_cd, appl_id)
values ('KC-SYS', 'All', 'Elasticsearch_Index_Job_Skip_Misfire', UUID(), 1, 'CONFG', 'N',
        'Determines whether to skip missed Elasticsearch indexing job executions (e.g., if server was down during scheduled time). Set to Y to skip misfires, N to execute them. Default is N.', 'A', 'KC')
on duplicate key update parm_desc_txt = values(parm_desc_txt);

-- Parameter 4: Roles to Skip During Indexing (Optional)
insert into krcr_parm_t (nmspc_cd, cmpnt_cd, parm_nm, obj_id, ver_nbr, parm_typ_cd, val, parm_desc_txt, eval_oprtr_cd, appl_id)
values ('KC-SYS', 'All', 'Elasticsearch_Index_Skip_Roles', UUID(), 1, 'CONFG', '',
        'List of roles to exclude from permission indexing. Format: namespace:roleName separated by semicolons. Example: KC-PD:Proposal Viewer;KC-AWARD:Award Viewer. Use * to skip all roles. Default is empty (no roles skipped).', 'A', 'KC')
on duplicate key update parm_desc_txt = values(parm_desc_txt);

-- Parameter 5: Unrestricted View Units (Optional)
insert into krcr_parm_t (nmspc_cd, cmpnt_cd, parm_nm, obj_id, ver_nbr, parm_typ_cd, val, parm_desc_txt, eval_oprtr_cd, appl_id)
values ('KC-SYS', 'All', 'Elasticsearch_Index_Unrestricted_View_Units', UUID(), 1, 'CONFG', '',
        'List of unit numbers that have unrestricted viewing access for Elasticsearch search results. All subunits of specified units will also have unrestricted access. Separate multiple units with semicolons. Default is empty.', 'A', 'KC')
on duplicate key update parm_desc_txt = values(parm_desc_txt);

-- Parameter 6: Unrestricted View Namespaces (Optional)
insert into krcr_parm_t (nmspc_cd, cmpnt_cd, parm_nm, obj_id, ver_nbr, parm_typ_cd, val, parm_desc_txt, eval_oprtr_cd, appl_id)
values ('KC-SYS', 'All', 'Elasticsearch_Index_Unrestricted_View_Namespaces', UUID(), 1, 'CONFG', '',
        'List of namespaces that have unrestricted viewing access for Elasticsearch search results. If specified, documents namespace must be in this list to have unrestricted view units applied. Separate multiple namespaces with semicolons. Default is empty.', 'A', 'KC')
on duplicate key update parm_desc_txt = values(parm_desc_txt);

-- ============================================================================
-- End of Elasticsearch Index Job Configuration Parameters
-- ============================================================================
