-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
INSERT INTO COEUS_MODULE (MODULE_CODE, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (11, 'Committee', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_NOTIFICATION_TYPE_ID VALUES(NULL)
/
INSERT INTO NOTIFICATION_TYPE (NOTIFICATION_TYPE_ID, MODULE_CODE, ACTION_CODE, DESCRIPTION, SUBJECT, MESSAGE, PROMPT_USER, SEND_NOTIFICATION, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_NOTIFICATION_TYPE_ID), 11, 213, 'Agenda Created Event', 'Agenda created for committee {COMMITTEE_NAME}', 'An Agenda has been created for committee <a title="" target="_self" href="{DOCUMENT_PREFIX}/kew/DocHandler.do?command=displayDocSearchView&amp;docId={DOCUMENT_NUMBER}">{COMMITTEE_NAME}</a>. Date of committee meeting is {LAST_ACTION_DATE}. Click <a href="../meetingActions.do?methodToCall=viewAgenda&line={OBJECT_INDEX}&docFormKey=0&documentWebScope=undefined">here</a> for a printable version of the agenda.', 'N', 'Y', 'admin', NOW(), 1, UUID())
/
INSERT INTO SEQ_NOTIFICATION_TYPE_ID VALUES(NULL)
/
INSERT INTO NOTIFICATION_TYPE (NOTIFICATION_TYPE_ID, MODULE_CODE, ACTION_CODE, DESCRIPTION, SUBJECT, MESSAGE, PROMPT_USER, SEND_NOTIFICATION, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_NOTIFICATION_TYPE_ID), 11, 215, 'Minutes Generated Event', 'Minutes generated for committee {COMMITTEE_NAME}', 'Minutes have been generated for committee <a title="" target="_self" href="{DOCUMENT_PREFIX}/kew/DocHandler.do?command=displayDocSearchView&amp;docId={DOCUMENT_NUMBER}">{COMMITTEE_NAME}</a>. Date of committee meeting is {LAST_ACTION_DATE}. Click <a href="../meetingActions.do?methodToCall=viewMinute&line={OBJECT_INDEX}&docFormKey=0&documentWebScope=undefined">here</a> for a printable version of the minutes.', 'N', 'Y', 'admin', NOW(), 1, UUID())
/
INSERT INTO SEQ_NTFCTN_MODULE_ROLE_ID VALUES(NULL)
/
INSERT INTO NOTIFICATION_MODULE_ROLE (NOTIFICATION_MODULE_ROLE_ID, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, MODULE_CODE, ROLE_NAME)
VALUES ((SELECT (MAX(ID)) FROM SEQ_NTFCTN_MODULE_ROLE_ID), UUID(), 1, NOW(), 'admin', 11, 'KC-COMMITTEE:Committee Administrator')
/
INSERT INTO SEQ_NTFCTN_MODULE_ROLE_ID VALUES(NULL)
/
INSERT INTO NOTIFICATION_MODULE_ROLE (NOTIFICATION_MODULE_ROLE_ID, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, MODULE_CODE, ROLE_NAME)
VALUES ((SELECT (MAX(ID)) FROM SEQ_NTFCTN_MODULE_ROLE_ID), UUID(), 1, NOW(), 'admin', 11, 'KC-PROTOCOL:Active Committee Member On Scheduled Date')
/
INSERT INTO SEQ_NOTIFICATION_TYPE_ID VALUES(NULL)
/
INSERT INTO NOTIFICATION_TYPE_RECIPIENT (NOTIFICATION_TYPE_RECIPIENT_ID, NOTIFICATION_TYPE_ID, ROLE_NAME, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_NOTIFICATION_TYPE_ID), (SELECT NOTIFICATION_TYPE_ID FROM NOTIFICATION_TYPE WHERE ACTION_CODE=213), 'KC-COMMITTEE:Committee Administrator', 'admin', NOW(), UUID())
/
INSERT INTO SEQ_NOTIFICATION_TYPE_ID VALUES(NULL)
/
INSERT INTO NOTIFICATION_TYPE_RECIPIENT (NOTIFICATION_TYPE_RECIPIENT_ID, NOTIFICATION_TYPE_ID, ROLE_NAME, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_NOTIFICATION_TYPE_ID), (SELECT NOTIFICATION_TYPE_ID FROM NOTIFICATION_TYPE WHERE ACTION_CODE=215), 'KC-COMMITTEE:Committee Administrator', 'admin', NOW(), UUID())
/
INSERT INTO SEQ_NOTIFICATION_TYPE_ID VALUES(NULL)
/
INSERT INTO NOTIFICATION_TYPE_RECIPIENT (NOTIFICATION_TYPE_RECIPIENT_ID, NOTIFICATION_TYPE_ID, ROLE_NAME, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_NOTIFICATION_TYPE_ID), (SELECT NOTIFICATION_TYPE_ID FROM NOTIFICATION_TYPE WHERE ACTION_CODE=213), 'KC-PROTOCOL:Active Committee Member On Scheduled Date', 'admin', NOW(), UUID())
/
INSERT INTO SEQ_NOTIFICATION_TYPE_ID VALUES(NULL)
/
INSERT INTO NOTIFICATION_TYPE_RECIPIENT (NOTIFICATION_TYPE_RECIPIENT_ID, NOTIFICATION_TYPE_ID, ROLE_NAME, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_NOTIFICATION_TYPE_ID), (SELECT NOTIFICATION_TYPE_ID FROM NOTIFICATION_TYPE WHERE ACTION_CODE=215), 'KC-PROTOCOL:Active Committee Member On Scheduled Date', 'admin', NOW(), UUID())
/
INSERT INTO SEQ_NTFCTN_MDL_ROLE_QLFR_ID VALUES(NULL)
/
INSERT INTO NOTIFICATION_MDL_ROLE_QLFR (NOTIFICATION_MDL_ROLE_QLFR_ID, NOTIFICATION_MODULE_ROLE_ID, QUALIFIER, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER)
VALUES ((SELECT (MAX(ID)) FROM SEQ_NTFCTN_MDL_ROLE_QLFR_ID), (select NOTIFICATION_MODULE_ROLE_ID from NOTIFICATION_MODULE_ROLE where ROLE_NAME = 'KC-PROTOCOL:Active Committee Member On Scheduled Date'), 'committee', UUID(), 1, NOW(), 'admin')
/
INSERT INTO SEQ_NTFCTN_MDL_ROLE_QLFR_ID VALUES(NULL)
/
INSERT INTO NOTIFICATION_MDL_ROLE_QLFR (NOTIFICATION_MDL_ROLE_QLFR_ID, NOTIFICATION_MODULE_ROLE_ID, QUALIFIER, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER)
VALUES ((SELECT (MAX(ID)) FROM SEQ_NTFCTN_MDL_ROLE_QLFR_ID), (select NOTIFICATION_MODULE_ROLE_ID from NOTIFICATION_MODULE_ROLE where ROLE_NAME = 'KC-PROTOCOL:Active Committee Member On Scheduled Date'), 'committeeSchedule', UUID(), 1, NOW(), 'admin')
/
DELIMITER ;
