-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
INSERT INTO KRIM_PERM_T (PERM_ID, OBJ_ID, VER_NBR, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND) 
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S), UUID(), 1, 
(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NM = 'View Document Section'), 
'KC-B', 'View Personnel Salaries', 'View Personnel Salaries', 'Y')
/
INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL)
/
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, OBJ_ID, VER_NBR, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL) 
VALUES ((SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S), UUID(), 1, 
(SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'VIEW_PROP_PERSON_INST_SALARIES'), 
(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NM = 'Document Section'), 
(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NM = 'sectionName'), 
'personnel_salaries')
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND) 
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S), UUID(), 1, 
(SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Award Budget Administrator'), 
(SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'View Personnel Salaries'), 'Y')
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND) 
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S), UUID(), 1, 
(SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Award Budget Maintainer'), 
(SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'View Personnel Salaries'), 'Y')
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND) 
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S), UUID(), 1, 
(SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Award Budget Aggregator'), 
(SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'View Personnel Salaries'), 'Y')
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND) 
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S), UUID(), 1, 
(SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Award Budget Approver'), 
(SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'View Personnel Salaries'), 'Y')
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND) 
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S), UUID(), 1, 
(SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Award Budget Modifier'), 
(SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'View Personnel Salaries'), 'Y')
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND) 
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S), UUID(), 1, 
(SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Award Budget Viewer'), 
(SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'View Personnel Salaries'), 'Y')
/

CREATE PROCEDURE `p` ()  
BEGIN  
  DECLARE roleid VARCHAR(40);
  DECLARE cont INT;  
  DECLARE cur1 CURSOR FOR SELECT ROLE_ID FROM KRIM_ROLE_PERM_T WHERE ACTV_IND = 'Y' AND (PERM_ID = (SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-PD' AND NM = 'VIEW_INSTITUTIONAL_SALARIES') OR PERM_ID = (SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-PD' AND NM = 'VIEW_PROP_PERSON_INST_SALARIES'));
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET cont = 1;
  OPEN cur1;  
  
  SET cont = 0;
  SET @role_perm_seq := 'INSERT INTO KRIM_ROLE_PERM_ID_S VALUES (null)';
  PREPARE insert_role_perm_seq FROM @role_perm_seq;
     
  WHILE cont = 0 DO  
  FETCH cur1 INTO roleid;  
  IF cont = 0 THEN
    EXECUTE insert_role_perm_seq;
    INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND) 
      VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S), UUID(), 1, roleid, 
      (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'View Personnel Salaries'), 'Y'); 
  END IF;    
  END WHILE;  
  DEALLOCATE PREPARE insert_role_perm_seq;
  CLOSE cur1;    
END 
/

UPDATE KRIM_ROLE_PERM_T SET ACTV_IND = 'N' WHERE 
PERM_ID = (SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-PD' AND NM = 'VIEW_INSTITUTIONAL_SALARIES')
/

UPDATE KRIM_ROLE_PERM_T SET ACTV_IND = 'N' WHERE
PERM_ID = (SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-PD' AND NM = 'VIEW_PROP_PERSON_INST_SALARIES')
/

UPDATE KRIM_PERM_T SET ACTV_IND = 'N' WHERE NMSPC_CD = 'KC-PD' AND NM = 'VIEW_INSTITUTIONAL_SALARIES'
/

UPDATE KRIM_PERM_T SET ACTV_IND = 'N' WHERE NMSPC_CD = 'KC-PD' AND NM = 'VIEW_PROP_PERSON_INST_SALARIES'
/
DELIMITER ;
