/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.dc.common.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.List;
import java.util.stream.IntStream;

public final class PreparedStatementUtils {
    private PreparedStatementUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static PreparedStatement setStrings(List<String> strings, PreparedStatement stmt) {
        IntStream.range(0, strings.size()).mapToObj(i -> new AbstractMap.SimpleImmutableEntry<Integer, String>(i + 1, (String)strings.get(i))).forEach(entry -> {
            try {
                PreparedStatementUtils.setString((Integer)entry.getKey(), (String)entry.getValue(), stmt);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        return stmt;
    }

    public static PreparedStatement setString(int index, String string, PreparedStatement stmt) throws SQLException {
        stmt.setString(index, string);
        return stmt;
    }

    public static PreparedStatement setLong(int index, Long l, PreparedStatement stmt) throws SQLException {
        stmt.setLong(index, l);
        return stmt;
    }

    public static PreparedStatement setInt(int index, int i, PreparedStatement stmt) throws SQLException {
        stmt.setInt(index, i);
        return stmt;
    }

    public static PreparedStatement setTimestamp(int index, Timestamp t, PreparedStatement stmt) throws SQLException {
        stmt.setTimestamp(index, t);
        return stmt;
    }
}

