/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.dc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.kuali.coeus.dc.CliOptions;
import org.kuali.coeus.dc.CliOptionsBasedDaoFactory;
import org.kuali.coeus.dc.common.db.DbValidatorDaoService;

public final class Main {
    private static final Logger LOG = LogManager.getLogger(Main.class);

    public static void main(String[] args) {
        CliOptions options;
        String file = System.getProperty("log4j.configurationFile");
        if (file == null || "".equals(file.trim())) {
            Main.initLogging("/org/kuali/coeus/dc/log4j2-default.xml");
        }
        if (!(options = new CliOptions(args)).isValid()) {
            System.out.println(options.getCliHelpString());
            return;
        }
        if (options.containsDebug()) {
            Main.initLogging("/org/kuali/coeus/dc/log4j2-debug.xml");
        }
        if (options.containsHelp()) {
            System.out.println(options.getCliHelpString());
            return;
        }
        if (options.containsVersion()) {
            Properties buildProperties = new Properties();
            try (InputStream stream = Main.class.getResourceAsStream("/META-INF/org/kuali/coeus/coeus-data-conv/project.properties");){
                if (stream != null) {
                    buildProperties.load(stream);
                }
            }
            catch (IOException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
            String version = buildProperties.getProperty("project.version");
            System.out.println(version != null && !version.trim().equals("") ? version : "UNKNOWN");
            return;
        }
        CliOptionsBasedDaoFactory factory = new CliOptionsBasedDaoFactory();
        factory.setCliOptions(options);
        if (options.containsValidate()) {
            DbValidatorDaoService validator = factory.getDbValidatorDaoService();
            if (validator.isValidCoeusConnection()) {
                System.out.println("COEUS SUCCESS: " + options.getCoeusConnectionString());
            } else {
                System.out.println("COEUS FAILED: " + options.getCoeusConnectionString());
            }
            if (validator.isValidRiceConnection()) {
                System.out.println("RICE SUCCESS: " + options.getRiceConnectionString());
            } else {
                System.out.println("RICE FAILED: " + options.getRiceConnectionString());
            }
            return;
        }
        try (Connection coeusConnection = factory.getConnectionDaoService().getCoeusConnection();
             Connection riceConnection = factory.getConnectionDaoService().getRiceConnection();){
            if (options.containsProposalPersonRole()) {
                factory.getProposalPersonRoleDao().convertParameterValues();
            }
            if (options.containsProposal()) {
                Collection<String> roleIds = factory.getProposalRoleDao().getRoleIdsToConvert();
                factory.getRoleDao().copyRoleMembersToDocAccessType(roleIds, factory.getProposalKimAttributeDocumentValueHandler());
            }
            if (options.containsQuestSeq()) {
                factory.getQuestSeqDao().convertQuestSeqKrmsValues();
            }
            if (options.containsQuestReseq()) {
                factory.getQuestReseqDao().resequenceQuestions();
            }
            if (options.containsTimeAndMoneyDocStatus()) {
                factory.getTimeAndMoneyDocumentStatusDao().updateTimeAndMoneyDocumentStatusFromKew();
            }
            if (options.containsSubawardAmountInfo()) {
                factory.getSubAwardAmountInfoDao().fixSubAwardAmountInfoHistory();
            }
            if (options.containsTimeAndMoneyDups()) {
                factory.getAwardAmountInfoDuplicatesDao().fixAwardAmountInfoDuplicates();
            }
            if (options.containsProposalYnq()) {
                factory.getProposalYnqConversionDao().convertProposalYnqs();
            }
            if (options.containsProposalPersonNames()) {
                factory.getProposalPersonDao().fixFullNames();
            }
            if (options.containsAwardUpdateUser()) {
                factory.getAwardUpdateUserDao().fixUpdateUsers();
            }
            if (options.containsIpUpdateUser()) {
                factory.getIpUpdateUserDao().fixUpdateUsers();
            }
            if (options.containsSubawardUpdateUser()) {
                factory.getSubawardUpdateUserDao().fixUpdateUsers();
            }
            if (options.containsTmUpdateUser()) {
                factory.getTimeAndMoneyUpdateUserDao().fixUpdateUsers();
            }
            if (options.containsSubawardStatus()) {
                factory.getSubawardStatusDao().fixSubawardStatus();
            }
            if (options.containsSubawardTmplAttach()) {
                factory.getSubawardTemplateAttachmentDao().moveSubawardTemplateAttachments();
            }
            if (options.containsDryRun()) {
                coeusConnection.rollback();
                riceConnection.rollback();
            } else {
                coeusConnection.commit();
                riceConnection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        System.exit(0);
    }

    private static void initLogging(String file) {
        try {
            LoggerContext context = LoggerContext.getContext();
            context.setConfigLocation(Main.class.getResource(file).toURI());
            context.updateLoggers();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

