-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
INSERT INTO KRIM_ROLE_ID_S VALUES(NULL)
/
INSERT INTO KRIM_ROLE_T (ROLE_ID,NMSPC_CD,ROLE_NM,DESC_TXT,KIM_TYP_ID,ACTV_IND,LAST_UPDT_DT,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),'KC-UNT','Modify all IACUC Protocols','Modify all IACUC Protocols',
(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'UnitHierarchy'),
'Y',NOW(),1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_PERM_T (PERM_ID,NMSPC_CD,NM,DESC_TXT,PERM_TMPL_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'KC-IACUC','Create Any IACUC Amendment','Create Amendments on any IACUC Protocol',
(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'Perform Document Action'),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_ROLE_PERM_T (ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_PERM_T (PERM_ID,NMSPC_CD,NM,DESC_TXT,PERM_TMPL_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'KC-IACUC','Create Any IACUC Renewal','Create renewals for any IACUC Protocol',
(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'Perform Document Action'),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_ROLE_PERM_T (ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_PERM_T (PERM_ID,NMSPC_CD,NM,DESC_TXT,PERM_TMPL_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'KC-IACUC','Create Any IACUC Renewal with Amendment','Create Renewal with Amendment for any IACUC Protocol',
(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'Perform Document Action'),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_ROLE_PERM_T (ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_PERM_T (PERM_ID,NMSPC_CD,NM,DESC_TXT,PERM_TMPL_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'KC-IACUC','Submit Any IACUC Protocol','Submit Any IACUC Protocol',
(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'Perform Document Action'),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_ROLE_PERM_T (ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_PERM_T (PERM_ID,NMSPC_CD,NM,DESC_TXT,PERM_TMPL_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'KC-IACUC','Review IACUC Protocol','Review IACUC Protocol',
(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'Perform Document Action'),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_ROLE_PERM_T (ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_PERM_T (PERM_ID,NMSPC_CD,NM,DESC_TXT,PERM_TMPL_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'KC-IACUC','IACUC Administrative Corrections','Perform Administrative Corrections on IACUC Protocols',
(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'Perform Document Action'),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_ROLE_PERM_T (ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_PERM_T (PERM_ID,NMSPC_CD,NM,DESC_TXT,PERM_TMPL_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'KC-IACUC','Maintain IACUC Protocol Review Comments','Maintain IACUC Protocol Review Comments',
(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'Edit Document Section'),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_ROLE_PERM_T (ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_PERM_T (PERM_ID,NMSPC_CD,NM,DESC_TXT,PERM_TMPL_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'KC-IACUC','Maintain IACUC Protocol Related Proj','Maintain IACUC Protocols link to award and proposal',
(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'Edit Document Section'),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_ROLE_PERM_T (ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_PERM_T (PERM_ID,NMSPC_CD,NM,DESC_TXT,PERM_TMPL_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'KC-IACUC','Maintain Any IACUC Protocol Access','Maintain Any IACUC Protocol Access',
(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'Edit Document Section'),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_ROLE_PERM_T (ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_PERM_T (PERM_ID,NMSPC_CD,NM,DESC_TXT,PERM_TMPL_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'KC-IACUC','Add Any IACUC Protocol Notes','Add Any IACUC Protocol Notes',
(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'Edit Document Section'),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_ROLE_PERM_T (ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_PERM_T (PERM_ID,NMSPC_CD,NM,DESC_TXT,PERM_TMPL_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'KC-IACUC','Maintain IACUC Research Areas','Maintain IACUC Research Areas',
(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'Edit Document Section'),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_ROLE_PERM_T (ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/

INSERT INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'Perform Any Document Action'),'KC-IACUC','Perform IACUC Actions on Protocol','Perform any IRB action on a protocol submitted to a committee','Y',UUID(),1)
/
INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL)
/
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID,PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL,OBJ_ID,VER_NBR)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Document Action'),(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),'IacucProtocolDocument',UUID(),1)
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_ROLE_PERM_T (ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_ROLE_PERM_T (ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT ROLE_ID FROM KRIM_ROLE_T WHERE NMSPC_CD = 'KC-UNT' AND ROLE_NM = 'IACUC Administrator'),
(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_ID_S VALUES(NULL)
/
INSERT INTO KRIM_ROLE_T (ROLE_ID,NMSPC_CD,ROLE_NM,DESC_TXT,KIM_TYP_ID,ACTV_IND,LAST_UPDT_DT,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),'KC-UNT','View all IACUC Protocols','View all IACUC Protocols',
(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'UnitHierarchy'),'Y',NOW(),1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_PERM_T (PERM_ID,NMSPC_CD,NM,DESC_TXT,PERM_TMPL_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'KC-IACUC','View Any IACUC Protocol','View Any IACUC Protocol',
(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'Perform Document Action'),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
Insert into KRIM_ROLE_PERM_T (ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
-- delete any has no role associate with it
Insert into KRIM_PERM_T (PERM_ID,NMSPC_CD,NM,DESC_TXT,PERM_TMPL_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'KC-IACUC','Delete Any IACUC Protocol','Delete Any IACUC Protocol',
(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'Perform Document Action'),'Y',1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
-- delete iacuc protocol
Insert into KRIM_PERM_T (PERM_ID,NMSPC_CD,NM,DESC_TXT,PERM_TMPL_ID,ACTV_IND,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'KC-IACUC','Delete IACUC Protocol','Delete IACUC Protocol',
(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'Edit Document Section'),'Y',1,UUID())
/
INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL)
/
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL, OBJ_ID) VALUES
((SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),
(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Document Section'),
(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'sectionName'),
'iacucProtocol', UUID())
/
INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL)
/
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL, OBJ_ID) VALUES
((SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),
(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Document Section'),
(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),
'IacucProtocolDocument', UUID()
)
/
INSERT INTO KRIM_ROLE_ID_S VALUES(NULL)
/
INSERT INTO KRIM_ROLE_T
(ROLE_ID,NMSPC_CD,ROLE_NM,DESC_TXT,KIM_TYP_ID,ACTV_IND,LAST_UPDT_DT,VER_NBR,OBJ_ID)VALUES
((SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),'KC-IACUC','IACUC Protocol Deleter','IACUC Protocol Deleter',
(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Unit'),
'Y',NOW(),1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
INSERT INTO KRIM_ROLE_PERM_T
(ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID) VALUES
((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
INSERT INTO KRIM_ROLE_PERM_T
(ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID) VALUES
((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'IACUC Protocol Aggregator' AND NMSPC_CD='KC-IACUC'),
(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL)
/
INSERT INTO KRIM_ROLE_PERM_T
(ROLE_PERM_ID,ROLE_ID,PERM_ID,ACTV_IND,VER_NBR,OBJ_ID) VALUES
((SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S),(SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'IACUC Administrator' AND NMSPC_CD='KC-UNT'),
(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),'Y',1,UUID())
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
-- corr template
INSERT INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'Edit Document'),'KC-IACUC','Modify IACUC Correspondence Template',null,'Y',UUID(),1)
/
INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL)
/
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID,PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL,OBJ_ID,VER_NBR)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'),(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),'ProtocolCorrespondenceTemplateMaintenanceDocument',UUID(),1)
/
INSERT INTO KRIM_PERM_ID_S VALUES(NULL)
/
INSERT INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES ((SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'Open Document'),'KC-IACUC','View IACUC Correspondence Template',null,'Y',UUID(),1)
/
INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL)
/
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID,PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL,OBJ_ID,VER_NBR)
VALUES ((SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S),(SELECT (MAX(ID)) FROM KRIM_PERM_ID_S),(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'),(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'),'ProtocolCorrespondenceTemplateMaintenanceDocument',UUID(),1)
/
DELIMITER ;
