-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

-- This repairs possible errors in data caused by bugs that allowed periods to change without updating the
-- details within them.  Details start and end dates should always be within the period start and end dates.

-- When a budget personnel details has dates outside its containing period on both start and end, match the period
update budget_personnel_details d
    join budget_periods p on d.BUDGET_ID = p.BUDGET_ID and d.BUDGET_PERIOD_NUMBER = p.BUDGET_PERIOD_NUMBER
set d.START_DATE = p.START_DATE,
    d.END_DATE   = p.END_DATE
where d.START_DATE < p.START_DATE
  and d.END_DATE > p.END_DATE;

-- When a budget personnel details has just the start date before the period start date.  We attempt to move the
-- entire detail period back by the amount it was outside the period window.  For example, if it started 1 day
-- before the period, we would attempt to shift it back by one day, but keep the end date within the period.
update budget_personnel_details d
    join budget_periods p on d.BUDGET_ID = p.BUDGET_ID and d.BUDGET_PERIOD_NUMBER = p.BUDGET_PERIOD_NUMBER
set d.START_DATE = p.START_DATE,
    d.END_DATE   = IF(date_add(d.END_DATE, INTERVAL datediff(p.START_DATE, d.START_DATE) DAY) > p.END_DATE,
                      p.END_DATE,
                      date_add(d.END_DATE, INTERVAL datediff(p.START_DATE, d.START_DATE) DAY))
where d.START_DATE < p.START_DATE;

-- When a budget personnel details has just the end date before the period end date.  We apply the same strategy
-- ensuring that the start date remains within the period.
update budget_personnel_details d
    join budget_periods p on d.BUDGET_ID = p.BUDGET_ID and d.BUDGET_PERIOD_NUMBER = p.BUDGET_PERIOD_NUMBER
set d.END_DATE   = p.END_DATE,
    d.START_DATE = IF(date_sub(d.START_DATE, INTERVAL datediff(d.END_DATE, p.END_DATE) DAY) < p.START_DATE,
                      p.START_DATE,
                      date_sub(d.START_DATE, INTERVAL datediff(d.END_DATE, p.END_DATE) DAY))
where d.END_DATE > p.END_DATE;
