-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /

DROP PROCEDURE IF EXISTS cleanupSequences
/
CREATE PROCEDURE cleanupSequences()
BEGIN
    DECLARE NO_MORE_SEQUENCES BOOLEAN DEFAULT FALSE;
    DECLARE V_TABLE_NAME VARCHAR(64);
    DECLARE V_CUR_ID BIGINT;

    DECLARE SEQUENCES_CUR CURSOR FOR
        SELECT TABLE_NAME
        FROM information_schema.columns
        WHERE UPPER(COLUMN_NAME) = 'ID'
            AND TABLE_SCHEMA = DATABASE()
            AND TABLE_NAME in (
                SELECT TABLE_NAME
                FROM information_schema.COLUMNS
                WHERE TABLE_SCHEMA = DATABASE()
                GROUP BY TABLE_SCHEMA, TABLE_NAME
                HAVING COUNT(*) = 1
            );

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET NO_MORE_SEQUENCES = TRUE;

    OPEN SEQUENCES_CUR;

    sequences_loop:
        LOOP
            FETCH SEQUENCES_CUR INTO V_TABLE_NAME;

            IF NO_MORE_SEQUENCES THEN
                LEAVE sequences_loop;
            END IF;

            -- Insert a row with NULL to ensure MAX(ID) is never NULL
            SET @insert_null := CONCAT('INSERT INTO `', V_TABLE_NAME, '` VALUES (NULL)');
            PREPARE insert_null_stmt FROM @insert_null;
            EXECUTE insert_null_stmt;
            DEALLOCATE PREPARE insert_null_stmt;

            -- Get the current max ID (use user variable for dynamic SQL)
            SET @get_max_id := CONCAT('SELECT MAX(ID) INTO @TMP_CUR_ID FROM `', V_TABLE_NAME, '`');
            PREPARE get_max_id_stmt FROM @get_max_id;
            EXECUTE get_max_id_stmt;
            DEALLOCATE PREPARE get_max_id_stmt;
            SET V_CUR_ID = @TMP_CUR_ID;

            -- Truncate the table
            SET @truncate_table := CONCAT('TRUNCATE TABLE `', V_TABLE_NAME, '`');
            PREPARE truncate_table_stmt FROM @truncate_table;
            EXECUTE truncate_table_stmt;
            DEALLOCATE PREPARE truncate_table_stmt;

            -- Insert the max ID minus 1 back (no need to check for NULL since it will never be NULL)
            SET @insert_id := CONCAT('INSERT INTO `', V_TABLE_NAME, '` VALUES (', V_CUR_ID - 1, ')');
            PREPARE insert_id_stmt FROM @insert_id;
            EXECUTE insert_id_stmt;
            DEALLOCATE PREPARE insert_id_stmt;
        END LOOP;

    CLOSE SEQUENCES_CUR;

END
/
CALL cleanupSequences()
/
DELIMITER ;
