-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
INSERT INTO IACUC_BATCH_CORRESPONDENCE (BATCH_CORRESPONDENCE_TYPE_CODE, DESCRIPTION, DAYS_TO_EVENT_UI_TEXT, SEND_CORRESPONDENCE, FINAL_ACTION_DAY, FINAL_ACTION_TYPE_CODE, FINAL_ACTION_CORRESP_TYPE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR) 
VALUES ('1', 'Protocol Renewal Reminders', 'Days prior Protocol Expiration', 'BEFORE', 0, (SELECT PROTOCOL_ACTION_TYPE_CODE FROM IACUC_PROTOCOL_ACTION_TYPE WHERE DESCRIPTION = 'Expired'), null, 'admin', NOW(), UUID(), 1)
/

INSERT INTO IACUC_BATCH_CORRESPONDENCE (BATCH_CORRESPONDENCE_TYPE_CODE, DESCRIPTION, DAYS_TO_EVENT_UI_TEXT, SEND_CORRESPONDENCE, FINAL_ACTION_DAY, FINAL_ACTION_TYPE_CODE, FINAL_ACTION_CORRESP_TYPE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR) 
VALUES ('2', 'Reminder to IACUC Notifications', 'Days since Committee Action', 'AFTER', 30, null, (SELECT PROTO_CORRESP_TYPE_CODE FROM IACUC_PROTOCOL_CORRESP_TYPE WHERE DESCRIPTION = 'Notify IACUC Letter'), 'admin', NOW(), UUID(), 1)
/
INSERT INTO SEQ_IACUC_BAT_CORRESP_DET_ID VALUES(NULL)
/



INSERT INTO IACUC_BATCH_CORRESP_DETAIL (BATCH_CORRESPONDENCE_DETAIL_ID, BATCH_CORRESPONDENCE_TYPE_CODE, PROTO_CORRESP_TYPE_CODE, DAYS_TO_EVENT, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_IACUC_BAT_CORRESP_DET_ID), (SELECT BATCH_CORRESPONDENCE_TYPE_CODE FROM IACUC_BATCH_CORRESPONDENCE WHERE DESCRIPTION = 'Protocol Renewal Reminders'), (SELECT PROTO_CORRESP_TYPE_CODE FROM IACUC_PROTOCOL_CORRESP_TYPE WHERE DESCRIPTION = 'Renewal Reminder Notification'), 60, 'admin', NOW(),UUID(), 1)
/
INSERT INTO SEQ_IACUC_BAT_CORRESP_DET_ID VALUES(NULL)
/
INSERT INTO IACUC_BATCH_CORRESP_DETAIL (BATCH_CORRESPONDENCE_DETAIL_ID, BATCH_CORRESPONDENCE_TYPE_CODE, PROTO_CORRESP_TYPE_CODE, DAYS_TO_EVENT, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_IACUC_BAT_CORRESP_DET_ID), (SELECT BATCH_CORRESPONDENCE_TYPE_CODE FROM IACUC_BATCH_CORRESPONDENCE WHERE DESCRIPTION = 'Protocol Renewal Reminders'), (SELECT PROTO_CORRESP_TYPE_CODE FROM IACUC_PROTOCOL_CORRESP_TYPE WHERE DESCRIPTION = 'Renewal Reminder Notification'), 15, 'admin', NOW(),UUID(), 1)
/
INSERT INTO SEQ_IACUC_BAT_CORRESP_DET_ID VALUES(NULL)
/
INSERT INTO IACUC_BATCH_CORRESP_DETAIL (BATCH_CORRESPONDENCE_DETAIL_ID, BATCH_CORRESPONDENCE_TYPE_CODE, PROTO_CORRESP_TYPE_CODE, DAYS_TO_EVENT, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_IACUC_BAT_CORRESP_DET_ID), (SELECT BATCH_CORRESPONDENCE_TYPE_CODE FROM IACUC_BATCH_CORRESPONDENCE WHERE DESCRIPTION = 'Reminder to IACUC Notifications'), (SELECT PROTO_CORRESP_TYPE_CODE FROM IACUC_PROTOCOL_CORRESP_TYPE WHERE DESCRIPTION = 'Notify IACUC Letter'), 15, 'admin', NOW(),UUID(), 1)
/


DELIMITER ;
