/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home;

import com.codiform.moo.annotation.Ignore;
import com.codiform.moo.annotation.Property;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.award.finance.AwardPosts;
import org.kuali.coeus.coi.framework.Versionedproject;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.Permissionable;
import org.kuali.coeus.common.framework.custom.CustomDataContainer;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.fiscalyear.FiscalYearMonthService;
import org.kuali.coeus.common.framework.keyword.KeywordsManager;
import org.kuali.coeus.common.framework.keyword.ScienceKeyword;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.person.PrincipalInvestigatorAware;
import org.kuali.coeus.common.framework.rolodex.PersonRolodex;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.sponsor.Sponsorable;
import org.kuali.coeus.common.framework.type.ActivityType;
import org.kuali.coeus.common.framework.type.ProposalType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitContactType;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.VersionStatusConstants;
import org.kuali.coeus.common.framework.version.history.VersionHistorySearchBo;
import org.kuali.coeus.common.framework.version.sequence.owner.SequenceOwner;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.AwardTemplateSyncScope;
import org.kuali.kra.award.awardalternatenumber.AwardAlternateNumber;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyTempObject;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncStatus;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncableProperty;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetLimit;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.cgb.AwardCgb;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.contacts.AwardCentralAdminContact;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.award.contacts.AwardUnitContact;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardBasisOfPayment;
import org.kuali.kra.award.home.AwardCfda;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardCommentFactory;
import org.kuali.kra.award.home.AwardMethodOfPayment;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.AwardSponsorTerm;
import org.kuali.kra.award.home.AwardStatus;
import org.kuali.kra.award.home.AwardSyncable;
import org.kuali.kra.award.home.AwardSyncableList;
import org.kuali.kra.award.home.AwardTemplate;
import org.kuali.kra.award.home.AwardTemplateComment;
import org.kuali.kra.award.home.AwardTemplateContact;
import org.kuali.kra.award.home.AwardTemplateReportTerm;
import org.kuali.kra.award.home.AwardTemplateTerm;
import org.kuali.kra.award.home.AwardTransferringSponsor;
import org.kuali.kra.award.home.AwardType;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.award.home.ValuableItem;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubaward;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.award.home.keywords.AwardScienceKeyword;
import org.kuali.kra.award.notesandattachments.attachments.AwardAttachment;
import org.kuali.kra.award.notesandattachments.notes.AwardNotepad;
import org.kuali.kra.award.notification.AwardNotification;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseout;
import org.kuali.kra.award.paymentreports.paymentschedule.AwardPaymentSchedule;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipment;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravel;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistribution;
import org.kuali.kra.bo.AccountType;
import org.kuali.kra.bo.NsfCode;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.NegotiationPersonDTO;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.timeandmoney.TimeAndMoneyDocumentHistory;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyHistoryService;
import org.kuali.kra.timeandmoney.transactions.AwardTransactionType;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class Award
extends KcPersistableBusinessObjectBase
implements KeywordsManager<AwardScienceKeyword>,
Permissionable,
SequenceOwner<Award>,
BudgetParent,
Sponsorable,
Negotiable,
CustomDataContainer,
Versionedproject,
PrincipalInvestigatorAware {
    public static final String DEFAULT_AWARD_NUMBER = "000000-00000";
    public static final String BLANK_COMMENT = "";
    public static final String ICR_RATE_CODE_NONE = "ICRNONE";
    private static final String NONE = "None";
    public static final String NO_FLAG = "N";
    private static final int TOTAL_STATIC_REPORTS = 5;
    public static final String CLOSE_OUT_REPORT_TYPE_FINANCIAL_REPORT = "1";
    public static final String CLOSE_OUT_REPORT_TYPE_TECHNICAL = "4";
    public static final String CLOSE_OUT_REPORT_TYPE_PATENT = "3";
    public static final String CLOSE_OUT_REPORT_TYPE_PROPERTY = "2";
    public static final String CLOSE_OUT_REPORT_TYPE_INVOICE = "6";
    public static final String BUDGET_STATUS = "2";
    private static final String REPORT_STATUSES = "1 3 6";
    private static final long serialVersionUID = 3797220122448310165L;
    private static final Logger LOG = LogManager.getLogger(Award.class);
    private static final String AWARD_DOCUMENT = "awardDocument";
    private static final String AWARD_STATUS = "awardStatus";
    private static final String SPONSOR = "sponsor";
    private static final String PRIME_SPONSOR = "primeSponsor";
    private static final String AWARD_NUMBER = "awardNumber";
    private static final String DOCUMENT_NUMBER = "documentNumber";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String CG_2 = "CG2";
    private static final String CG_1 = "CG1";
    private static final String CG_3 = "CG3";
    private static final String AWARD_AMOUNT_INFOS = "awardAmountInfos";
    private static final String ACCOUNT_TYPE_CODE = "accountTypeCode";
    private static final String UNIT_NUMBER = "unitNumber";
    private static final String COLON = ":";
    public static final String AWARD_ID = "awardId";
    private FiscalYearMonthService fiscalYearMonthService;
    private transient ParameterService parameterService;
    private Long awardId;
    private AwardDocument awardDocument;
    @Property
    @Ignore
    private String awardNumber;
    @Property
    @Ignore
    private Integer sequenceNumber;
    @AwardSyncableProperty
    private String sponsorCode;
    @AwardSyncableProperty
    private Integer statusCode;
    private AwardStatus awardStatus;
    private String accountNumber;
    private String approvedEquipmentIndicator;
    private String approvedForeignTripIndicator;
    private String subContractIndicator;
    private java.sql.Date awardEffectiveDate;
    private java.sql.Date awardExecutionDate;
    private java.sql.Date beginDate;
    private String costSharingIndicator;
    private String indirectCostIndicator;
    private String modificationNumber;
    private Integer nsfSequenceNumber;
    private String paymentScheduleIndicator;
    private String scienceCodeIndicator;
    private String specialReviewIndicator;
    private String sponsorAwardNumber;
    private String transferSponsorIndicator;
    private Integer accountTypeCode;
    private String activityTypeCode;
    private Integer awardTypeCode;
    private AwardType awardType;
    private String documentFundingId;
    private ScaleTwoDecimal preAwardAuthorizedAmount;
    private java.sql.Date preAwardEffectiveDate;
    private ScaleTwoDecimal preAwardInstitutionalAuthorizedAmount;
    private java.sql.Date preAwardInstitutionalEffectiveDate;
    private String procurementPriorityCode;
    private String proposalNumber;
    private ScaleTwoDecimal specialEbRateOffCampus;
    private ScaleTwoDecimal specialEbRateOnCampus;
    private String subPlanFlag;
    private String title;
    private String archiveLocation;
    private java.sql.Date closeoutDate;
    private Integer awardTransactionTypeCode;
    private java.sql.Date noticeDate;
    private String currentActionComments;
    private String financialAccountDocumentNumber;
    private java.sql.Date financialAccountCreationDate;
    private String financialChartOfAccountsCode;
    private String awardSequenceStatus;
    private boolean newVersion;
    private Integer templateCode;
    @AwardSyncable(scopes={AwardTemplateSyncScope.AWARD_PAGE})
    private String primeSponsorCode;
    @AwardSyncable(impactSourceScopeEmpty=false, scopes={AwardTemplateSyncScope.PAYMENTS_AND_INVOICES_TAB})
    private String basisOfPaymentCode;
    @AwardSyncable(impactSourceScopeEmpty=false, scopes={AwardTemplateSyncScope.PAYMENTS_AND_INVOICES_TAB})
    private String methodOfPaymentCode;
    private AwardTemplate awardTemplate;
    private AwardBasisOfPayment awardBasisOfPayment;
    private AwardMethodOfPayment awardMethodOfPayment;
    private AwardTransactionType awardTransactionType;
    private ActivityType activityType;
    private NsfCode nsfCodeBo;
    private Sponsor sponsor;
    private Sponsor primeSponsor;
    @AwardSyncableList(syncClass=AwardComment.class, syncSourceClass=AwardTemplateComment.class, scopes={AwardTemplateSyncScope.COST_SHARE, AwardTemplateSyncScope.PAYMENTS_AND_INVOICES_TAB, AwardTemplateSyncScope.COMMENTS_TAB}, removeMissingListElementsFromTarget=false)
    private List<AwardComment> awardComments;
    @AwardSyncableList(syncClass=AwardReportTerm.class, syncSourceClass=AwardTemplateReportTerm.class, scopes={AwardTemplateSyncScope.PAYMENTS_AND_INVOICES_TAB, AwardTemplateSyncScope.REPORTS_TAB})
    private List<AwardReportTerm> awardReportTermItems;
    @AwardSyncableList(syncClass=AwardSponsorTerm.class, syncSourceClass=AwardTemplateTerm.class, scopes={AwardTemplateSyncScope.TERMS_TAB})
    private List<AwardSponsorTerm> awardSponsorTerms;
    @AwardSyncableList(syncClass=AwardSponsorContact.class, syncSourceClass=AwardTemplateContact.class, scopes={AwardTemplateSyncScope.SPONSOR_CONTACTS_TAB})
    private List<AwardSponsorContact> sponsorContacts;
    private List<AwardCfda> awardCfdas;
    private List<AwardCustomData> awardCustomDataList;
    private List<Boolean> awardCommentHistoryFlags;
    private Map<String, AwardComment> commentMap;
    private List<AwardCostShare> awardCostShares;
    private List<AwardFandaRate> awardFandaRate;
    private List<AwardDirectFandADistribution> awardDirectFandADistributions;
    private List<AwardApprovedSubaward> awardApprovedSubawards;
    private List<AwardScienceKeyword> keywords;
    private List<AwardPerson> projectPersons;
    private List<AwardUnitContact> awardUnitContacts;
    private List<AwardCentralAdminContact> awardCentralAdminContacts;
    private boolean syncCentralAdminContacts;
    private transient boolean centralAdminContactsSynced;
    private List<AwardAlternateNumber> awardAlternateNumbers;
    private List<AwardSpecialReview> specialReviews;
    private List<AwardApprovedEquipment> approvedEquipmentItems;
    private List<AwardApprovedForeignTravel> approvedForeignTravelTrips;
    private List<AwardPaymentSchedule> paymentScheduleItems;
    private List<AwardTransferringSponsor> awardTransferringSponsors;
    private List<AwardAmountInfo> awardAmountInfos;
    private List<AwardCloseout> awardCloseoutItems;
    private List<AwardCloseout> awardCloseoutNewItems;
    private List<AwardNotepad> awardNotepads;
    private List<AwardAttachment> awardAttachments;
    private List<AwardSyncChange> syncChanges;
    private List<AwardSyncStatus> syncStatuses;
    private List<AwardNotification> awardNotifications;
    private boolean syncChild;
    private List<AwardFundingProposal> fundingProposals;
    private List<AwardFundingProposal> allFundingProposals;
    private List<AwardBudgetLimit> awardBudgetLimits;
    private Unit leadUnit;
    private String unitNumber;
    private transient KcPerson investigator;
    private KcPerson ospAdministrator;
    private String principalInvestigatorName;
    private String icrRateCode;
    private transient boolean awardInMultipleNodeHierarchy;
    private transient boolean awardHasAssociatedTandMOrIsVersioned;
    private transient Boolean sponsorNihMultiplePi;
    private transient List<AwardHierarchyTempObject> awardHierarchyTempObjects;
    private transient String docIdStatus;
    private transient String lookupOspAdministratorName;
    private transient AwardAmountInfoService awardAmountInfoService;
    private transient TimeAndMoneyHistoryService timeAndMoneyHistoryService;
    private transient SystemAuthorizationService systemAuthorizationService;
    private transient AwardBudgetService awardBudgetService;
    private transient InstitutionalProposalService institutionalProposalService;
    private transient BusinessObjectService businessObjectService;
    private transient UnitService unitService;
    private List<SubAward> subAwardList;
    private transient boolean allowUpdateTimestampToBeReset = true;
    private transient boolean allowUpdateUserToBeReset = true;
    private VersionHistorySearchBo versionHistory;
    private transient KcPersonService kcPersonService;
    private transient SponsorHierarchyService sponsorHierarchyService;
    private List<AwardCgb> awardCgbList;
    @SkipVersioning
    private transient Integer indexOfAwardAmountInfoForDisplay;
    private String fainId;
    private Integer fedAwardYear;
    private java.sql.Date fedAwardDate;
    @SkipVersioning
    private transient DataObjectService dataObjectService;
    @SkipVersioning
    private transient AwardService awardService;
    private List<AwardBudgetExt> currentVersionBudgets;
    private List<AwardBudgetExt> budgets;

    public Award() {
        this.initializeAwardWithDefaultValues();
        this.initializeCollections();
    }

    private void initializeAwardWithDefaultValues() {
        this.setAwardNumber(DEFAULT_AWARD_NUMBER);
        this.setSequenceNumber(1);
        this.setApprovedEquipmentIndicator(NO_FLAG);
        this.setApprovedForeignTripIndicator(NO_FLAG);
        this.setSubContractIndicator(NO_FLAG);
        this.setCostSharingIndicator(NO_FLAG);
        this.setIdcIndicator(NO_FLAG);
        this.setPaymentScheduleIndicator(NO_FLAG);
        this.setScienceCodeIndicator(NO_FLAG);
        this.setSpecialReviewIndicator(NO_FLAG);
        this.setTransferSponsorIndicator(NO_FLAG);
        this.awardComments = new AutoPopulatingList(AwardComment.class);
        this.setCurrentActionComments(BLANK_COMMENT);
        this.setNewVersion(false);
        this.awardSequenceStatus = VersionStatus.PENDING.name();
        this.setSyncCentralAdminContacts(this.getAutoSyncCentralAdminContactsByDefault());
    }

    protected boolean getAutoSyncCentralAdminContactsByDefault() {
        if (this.getParameterService() == null) {
            return true;
        }
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "Document", "AUTOSYNC_AWARD_CENTRAL_ADMIN_CONTACTS_BY_DEFAULT", Boolean.valueOf(true));
    }

    private Map<String, AwardComment> getCommentMap() {
        if (this.commentMap == null || this.getNewVersion()) {
            this.commentMap = new HashMap<String, AwardComment>();
            for (AwardComment ac : this.awardComments) {
                if (this.getNewVersion() && ac.getCommentType().getCommentTypeCode().equals("21")) {
                    ac.setComments(BLANK_COMMENT);
                }
                this.commentMap.put(ac.getCommentType().getCommentTypeCode(), ac);
            }
        }
        return this.commentMap;
    }

    public boolean isPosted() {
        HashMap<String, Long> criteria = new HashMap<String, Long>();
        criteria.put(AWARD_ID, this.getAwardId());
        return this.getDataObjectService().findMatching(AwardPosts.class, QueryByCriteria.Builder.andAttributes(criteria).setCountFlag(CountFlag.ONLY).build()).getTotalRowCount() != 0;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    public Integer getTemplateCode() {
        return this.templateCode;
    }

    public String getFinancialChartOfAccountsCode() {
        return this.financialChartOfAccountsCode;
    }

    public void setFinancialChartOfAccountsCode(String financialChartOfAccountsCode) {
        this.financialChartOfAccountsCode = financialChartOfAccountsCode;
    }

    public Long getAwardId() {
        return this.awardId;
    }

    public void setAwardId(Long awardId) {
        this.awardId = awardId;
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public int getIndexOfLastAwardAmountInfo() {
        return this.awardAmountInfos.size() - 1;
    }

    public AwardAmountInfo getLastAwardAmountInfo() {
        return this.awardAmountInfos.get(this.getIndexOfLastAwardAmountInfo());
    }

    public AwardAmountInfo getAwardAmountInfoForDisplay() {
        return this.awardAmountInfos.get(this.getIndexOfAwardAmountInfoForDisplay());
    }

    public Integer getIndexOfAwardAmountInfoForDisplay() {
        if (this.indexOfAwardAmountInfoForDisplay != null) {
            return this.indexOfAwardAmountInfoForDisplay;
        }
        AwardAmountInfo aai = this.getAwardAmountInfoService().fetchLastAwardAmountInfoForAwardVersionAndFinalizedTandMDocumentNumber(this);
        this.indexOfAwardAmountInfoForDisplay = this.getIndexOfAwardAmountInfo(aai);
        return this.indexOfAwardAmountInfoForDisplay;
    }

    public int getIndexOfAwardAmountInfoForDisplayFromTimeAndMoneyDocNumber(String docNum) {
        AwardAmountInfo aai = this.getAwardAmountInfoService().fetchLastAwardAmountInfoForDocNum(this, docNum);
        return this.getIndexOfAwardAmountInfo(aai);
    }

    public int getIndexOfAwardAmountInfo(AwardAmountInfo aai) {
        int returnVal = 0;
        int index = 0;
        if (aai.getAwardAmountInfoId() != null && this.isAwardInMultipleNodeHierarchy()) {
            this.refreshReferenceObject(AWARD_AMOUNT_INFOS);
        }
        if (this.isAwardInitialCopy()) {
            returnVal = this.getAwardAmountInfos().size() - 1;
        } else {
            for (AwardAmountInfo awardAmountInfo : this.getAwardAmountInfos()) {
                if (awardAmountInfo.getAwardAmountInfoId() == null && aai.getAwardAmountInfoId() == null) {
                    returnVal = index;
                    continue;
                }
                if (awardAmountInfo.getAwardAmountInfoId().equals(aai.getAwardAmountInfoId())) {
                    returnVal = index;
                    continue;
                }
                ++index;
            }
        }
        return returnVal;
    }

    public boolean isAwardInitialCopy() {
        boolean returnValue = true;
        if (this.getAwardAmountInfos().size() > 1) {
            for (AwardAmountInfo aai : this.getAwardAmountInfos()) {
                if (aai.getAwardAmountInfoId() == null) continue;
                returnValue = false;
                break;
            }
        }
        return returnValue;
    }

    public AwardAmountInfoService getAwardAmountInfoService() {
        if (this.awardAmountInfoService == null) {
            this.awardAmountInfoService = KcServiceLocator.getService(AwardAmountInfoService.class);
        }
        return this.awardAmountInfoService;
    }

    public TimeAndMoneyHistoryService getTimeAndMoneyHistoryService() {
        if (this.timeAndMoneyHistoryService == null) {
            this.timeAndMoneyHistoryService = KcServiceLocator.getService(TimeAndMoneyHistoryService.class);
        }
        return this.timeAndMoneyHistoryService;
    }

    public void setAwardAmountInfoService(AwardAmountInfoService awardAmountInfoService) {
        this.awardAmountInfoService = awardAmountInfoService;
    }

    @Override
    public String getSponsorCode() {
        return this.sponsorCode;
    }

    @Override
    public void setSponsorCode(String sponsorCode) {
        this.sponsorCode = sponsorCode;
        this.setSponsorNihMultiplePi(null);
    }

    public String getAccountTypeDescription() {
        AccountType accountType = (AccountType)this.getBusinessObjectService().findByPrimaryKey(AccountType.class, Collections.singletonMap(ACCOUNT_TYPE_CODE, this.getAccountTypeCode()));
        if (accountType == null) {
            return "None Selected";
        }
        return accountType.getDescription();
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public List<AwardApprovedEquipment> getApprovedEquipmentItems() {
        return this.approvedEquipmentItems;
    }

    public List<AwardUnitContact> getAwardUnitContacts() {
        return this.awardUnitContacts;
    }

    public AwardPerson getProjectPerson(int index) {
        return this.projectPersons.get(index);
    }

    public AwardPerson getProjectPerson(String personId) {
        if (!StringUtils.isBlank((CharSequence)personId)) {
            for (AwardPerson awardPerson : this.getProjectPersons()) {
                if (!personId.equals(awardPerson.getPersonId())) continue;
                return awardPerson;
            }
        }
        return null;
    }

    public AwardPerson getProjectPerson(Integer rolodexId) {
        if (rolodexId != null) {
            for (AwardPerson awardPerson : this.getProjectPersons()) {
                if (!rolodexId.equals(awardPerson.getRolodexId())) continue;
                return awardPerson;
            }
        }
        return null;
    }

    public List<AwardPerson> getProjectPersons() {
        return this.projectPersons;
    }

    public List<AwardPerson> getProjectPersonsSorted() {
        ArrayList<AwardPerson> aList = new ArrayList<AwardPerson>();
        if (this.getPrincipalInvestigator() != null) {
            aList.add(this.getPrincipalInvestigator());
        }
        aList.addAll(this.getMultiplePis());
        aList.addAll(this.getCoInvestigators());
        aList.addAll(this.getKeyPersons());
        this.projectPersons.stream().filter(p -> !aList.contains(p)).forEach(p -> aList.add((AwardPerson)p));
        return aList;
    }

    public List<AwardPerson> getInvestigators() {
        return this.projectPersons.stream().filter(person -> person.isPrincipalInvestigator() || person.isCoInvestigator()).sorted().collect(Collectors.toList());
    }

    public List<AwardPerson> getCoInvestigators() {
        return this.projectPersons.stream().filter(AwardPerson::isCoInvestigator).sorted().collect(Collectors.toList());
    }

    public List<AwardPerson> getMultiplePis() {
        return this.projectPersons.stream().filter(AwardPerson::isMultiplePi).sorted().collect(Collectors.toList());
    }

    public List<AwardPerson> getKeyPersons() {
        return this.projectPersons.stream().filter(AwardPerson::isKeyPerson).sorted().collect(Collectors.toList());
    }

    public int getTotalUnitCount() {
        int count = 0;
        for (AwardPerson person : this.projectPersons) {
            count += person.getUnits().size();
        }
        return count;
    }

    public int getAwardContactsCount() {
        return this.awardUnitContacts.size();
    }

    public int getApprovedEquipmentItemCount() {
        return this.approvedEquipmentItems.size();
    }

    public int getApprovedForeignTravelTripCount() {
        return this.approvedForeignTravelTrips.size();
    }

    public List<AwardApprovedForeignTravel> getApprovedForeignTravelTrips() {
        return this.approvedForeignTravelTrips;
    }

    public void setAwardUnitContacts(List<AwardUnitContact> awardUnitContacts) {
        this.awardUnitContacts = awardUnitContacts;
    }

    public void setApprovedEquipmentItems(List<AwardApprovedEquipment> awardApprovedEquipmentItems) {
        this.approvedEquipmentItems = awardApprovedEquipmentItems;
    }

    public void setApprovedForeignTravelTrips(List<AwardApprovedForeignTravel> approvedForeignTravelTrips) {
        this.approvedForeignTravelTrips = approvedForeignTravelTrips;
    }

    public String getApprovedEquipmentIndicator() {
        return this.approvedEquipmentIndicator;
    }

    public void setApprovedEquipmentIndicator(String approvedEquipmentIndicator) {
        this.approvedEquipmentIndicator = approvedEquipmentIndicator;
    }

    public String getApprovedForeignTripIndicator() {
        return this.approvedForeignTripIndicator;
    }

    public void setApprovedForeignTripIndicator(String approvedForeignTripIndicator) {
        this.approvedForeignTripIndicator = approvedForeignTripIndicator;
    }

    public String getSubContractIndicator() {
        return this.subContractIndicator;
    }

    public void setSubContractIndicator(String subContractIndicator) {
        this.subContractIndicator = subContractIndicator;
    }

    public java.sql.Date getAwardEffectiveDate() {
        return this.awardEffectiveDate;
    }

    public void setAwardEffectiveDate(java.sql.Date awardEffectiveDate) {
        this.awardEffectiveDate = awardEffectiveDate;
    }

    public java.sql.Date getAwardExecutionDate() {
        return this.awardExecutionDate;
    }

    public void setAwardExecutionDate(java.sql.Date awardExecutionDate) {
        this.awardExecutionDate = awardExecutionDate;
    }

    public java.sql.Date getBeginDate() {
        return this.beginDate;
    }

    public java.sql.Date getProjectEndDate() {
        return this.getLatestAwardAmountInfo().getFinalExpirationDate();
    }

    public void setProjectEndDate(java.sql.Date date) {
        this.awardAmountInfos.get(0).setFinalExpirationDate(date);
    }

    public java.sql.Date getObligationExpirationDate() {
        return this.getLastAwardAmountInfo().getObligationExpirationDate();
    }

    public void setObligationExpirationDate(java.sql.Date date) {
        this.awardAmountInfos.get(0).setObligationExpirationDate(date);
    }

    public void setBeginDate(java.sql.Date beginDate) {
        this.beginDate = beginDate;
    }

    public String getCostSharingIndicator() {
        return this.costSharingIndicator;
    }

    public void setCostSharingIndicator(String costSharingIndicator) {
        this.costSharingIndicator = costSharingIndicator;
    }

    public List<AwardFundingProposal> getFundingProposals() {
        return this.fundingProposals;
    }

    public void setFundingProposals(List<AwardFundingProposal> fundingProposals) {
        this.fundingProposals = fundingProposals;
    }

    public String getIdcIndicator() {
        return this.indirectCostIndicator;
    }

    public void setIdcIndicator(String indirectCostIndicator) {
        this.indirectCostIndicator = indirectCostIndicator;
    }

    public String getModificationNumber() {
        return this.modificationNumber;
    }

    public void setModificationNumber(String modificationNumber) {
        this.modificationNumber = modificationNumber;
    }

    public Integer getNsfSequenceNumber() {
        return this.nsfSequenceNumber;
    }

    public void setNsfSequenceNumber(Integer nsfSequenceNumber) {
        this.nsfSequenceNumber = nsfSequenceNumber;
    }

    public String getPaymentScheduleIndicator() {
        return this.paymentScheduleIndicator;
    }

    public void setPaymentScheduleIndicator(String paymentScheduleIndicator) {
        this.paymentScheduleIndicator = paymentScheduleIndicator;
    }

    public String getScienceCodeIndicator() {
        return this.scienceCodeIndicator;
    }

    public void setScienceCodeIndicator(String scienceCodeIndicator) {
        this.scienceCodeIndicator = scienceCodeIndicator;
    }

    public String getSpecialReviewIndicator() {
        return this.specialReviewIndicator;
    }

    public void setSpecialReviewIndicator(String specialReviewIndicator) {
        this.specialReviewIndicator = specialReviewIndicator;
    }

    @Override
    public String getSponsorAwardNumber() {
        return this.sponsorAwardNumber;
    }

    public void setSponsorAwardNumber(String sponsorAwardNumber) {
        this.sponsorAwardNumber = sponsorAwardNumber;
    }

    public String getTransferSponsorIndicator() {
        return this.transferSponsorIndicator;
    }

    public String getUnitName() {
        Unit leadUnit = this.getLeadUnit();
        return leadUnit != null ? leadUnit.getUnitName() : null;
    }

    @Override
    public String getUnitNumber() {
        return this.unitNumber;
    }

    @Override
    public String getLeadUnitNumber() {
        return this.getUnitNumber();
    }

    public void setTransferSponsorIndicator(String transferSponsorIndicator) {
        this.transferSponsorIndicator = transferSponsorIndicator;
    }

    public Integer getAccountTypeCode() {
        return this.accountTypeCode;
    }

    public void setAccountTypeCode(Integer accountTypeCode) {
        this.accountTypeCode = accountTypeCode;
    }

    @Override
    public String getActivityTypeCode() {
        return this.activityTypeCode;
    }

    public void setActivityTypeCode(String activityTypeCode) {
        this.activityTypeCode = activityTypeCode;
    }

    public Integer getAwardTypeCode() {
        return this.awardTypeCode;
    }

    public void setAwardTypeCode(Integer awardTypeCode) {
        this.awardTypeCode = awardTypeCode;
    }

    @Deprecated
    public String getCfdaNumber() {
        return this.findFirstCfda().map(AwardCfda::getCfdaNumber).orElse(null);
    }

    @Deprecated
    public void setCfdaNumber(String cfdaNumber) {
        if (this.awardCfdas == null) {
            this.awardCfdas = new ArrayList<AwardCfda>();
        }
        if (StringUtils.isBlank((CharSequence)cfdaNumber)) {
            this.awardCfdas.clear();
        } else {
            AwardCfda cfda = this.findFirstCfda().orElseGet(AwardCfda::new);
            this.awardCfdas.clear();
            cfda.setCfdaNumber(cfdaNumber);
            cfda.setAwardId(this.getAwardId());
            cfda.setAwardNumber(this.getAwardNumber());
            cfda.setSequenceNumber(this.getSequenceNumber());
            cfda.setAward(this);
            this.awardCfdas.add(cfda);
        }
    }

    @Deprecated
    private Optional<AwardCfda> findFirstCfda() {
        if (this.awardCfdas != null) {
            return this.awardCfdas.stream().findFirst();
        }
        return Optional.empty();
    }

    public String getDocumentFundingId() {
        return this.documentFundingId;
    }

    public void setDocumentFundingId(String documentFundingId) {
        this.documentFundingId = documentFundingId;
    }

    public KcPerson getOspAdministrator() {
        for (AwardCentralAdminContact contact : this.getAwardCentralAdminContacts()) {
            if (!contact.isOspAdministrator()) continue;
            this.ospAdministrator = contact.getPerson();
            break;
        }
        return this.ospAdministrator;
    }

    public String getOspAdministratorName() {
        KcPerson ospAdministrator = this.getOspAdministrator();
        return ospAdministrator != null ? ospAdministrator.getFullName() : null;
    }

    public ScaleTwoDecimal getPreAwardAuthorizedAmount() {
        return this.preAwardAuthorizedAmount;
    }

    public void setPreAwardAuthorizedAmount(ScaleTwoDecimal preAwardAuthorizedAmount) {
        this.preAwardAuthorizedAmount = preAwardAuthorizedAmount != null && preAwardAuthorizedAmount.isNegative() ? (ScaleTwoDecimal)ScaleTwoDecimal.ZERO.subtract((AbstractDecimal)preAwardAuthorizedAmount) : preAwardAuthorizedAmount;
    }

    public java.sql.Date getPreAwardEffectiveDate() {
        return this.preAwardEffectiveDate;
    }

    public void setPreAwardEffectiveDate(java.sql.Date preAwardEffectiveDate) {
        this.preAwardEffectiveDate = preAwardEffectiveDate;
    }

    public String getProcurementPriorityCode() {
        return this.procurementPriorityCode;
    }

    public void setProcurementPriorityCode(String procurementPriorityCode) {
        this.procurementPriorityCode = procurementPriorityCode;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public ScaleTwoDecimal getSpecialEbRateOffCampus() {
        return this.specialEbRateOffCampus;
    }

    public void setSpecialEbRateOffCampus(ScaleTwoDecimal specialEbRateOffCampus) {
        this.specialEbRateOffCampus = specialEbRateOffCampus;
    }

    public ScaleTwoDecimal getSpecialEbRateOnCampus() {
        return this.specialEbRateOnCampus;
    }

    public void setSpecialEbRateOnCampus(ScaleTwoDecimal specialEbRateOnCampus) {
        this.specialEbRateOnCampus = specialEbRateOnCampus;
    }

    public String getSubPlanFlag() {
        return this.subPlanFlag;
    }

    public void setSubPlanFlag(String subPlanFlag) {
        this.subPlanFlag = subPlanFlag;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getSourceIdentifier() {
        return this.awardNumber;
    }

    @Override
    public String getSourceStatus() {
        return this.getAwardStatus().getStatusCode();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getArchiveLocation() {
        return this.archiveLocation;
    }

    public void setArchiveLocation(String archiveLocation) {
        this.archiveLocation = archiveLocation;
    }

    public java.sql.Date getCloseoutDate() {
        return this.closeoutDate;
    }

    public void setCloseoutDate(java.sql.Date closeoutDate) {
        this.closeoutDate = closeoutDate;
    }

    public Integer getAwardTransactionTypeCode() {
        return this.awardTransactionTypeCode;
    }

    public void setAwardTransactionTypeCode(Integer awardTransactionTypeCode) {
        this.awardTransactionTypeCode = awardTransactionTypeCode;
    }

    public java.sql.Date getNoticeDate() {
        return this.noticeDate;
    }

    public void setNoticeDate(java.sql.Date noticeDate) {
        this.noticeDate = this.getNewVersion() ? null : noticeDate;
    }

    public String getCurrentActionComments() {
        return this.currentActionComments;
    }

    public void setCurrentActionComments(String currentActionComments) {
        this.currentActionComments = this.getNewVersion() ? BLANK_COMMENT : currentActionComments;
    }

    public void setNewVersion(boolean newVersion) {
        this.newVersion = newVersion;
        if (this.newVersion) {
            this.commentMap = this.getCommentMap();
            this.setCurrentActionComments(BLANK_COMMENT);
            this.setNoticeDate(null);
        }
    }

    public boolean getNewVersion() {
        return this.newVersion;
    }

    public AwardTransactionType getAwardTransactionType() {
        return this.awardTransactionType;
    }

    public void setAwardTransactionType(AwardTransactionType awardTransactionType) {
        this.awardTransactionType = awardTransactionType;
    }

    public String getFinancialAccountDocumentNumber() {
        return this.financialAccountDocumentNumber;
    }

    public void setFinancialAccountDocumentNumber(String financialAccountDocumentNumber) {
        this.financialAccountDocumentNumber = financialAccountDocumentNumber;
    }

    public java.sql.Date getFinancialAccountCreationDate() {
        return this.financialAccountCreationDate;
    }

    public void setFinancialAccountCreationDate(java.sql.Date financialAccountCreationDate) {
        this.financialAccountCreationDate = financialAccountCreationDate;
    }

    public AwardDocument getAwardDocument() {
        if (this.awardDocument == null) {
            this.refreshReferenceObject(AWARD_DOCUMENT);
        }
        if (this.awardDocument != null && this.awardDocument.getDocumentHeader() != null && this.awardDocument.getDocumentNumber() != null && !this.awardDocument.getDocumentHeader().hasWorkflowDocument() && GlobalVariables.getUserSession() != null) {
            this.awardDocument.getDocumentHeader().setWorkflowDocument(WorkflowDocumentFactory.loadDocument((String)GlobalVariables.getUserSession().getPrincipalId(), (String)this.awardDocument.getDocumentNumber()));
        }
        return this.awardDocument;
    }

    public String getAwardDocumentUrl() {
        return this.getAwardDocument().buildForwardUrl();
    }

    public void setAwardDocument(AwardDocument awardDocument) {
        this.awardDocument = awardDocument;
    }

    public List<AwardComment> getAwardComments() {
        return this.awardComments;
    }

    public void setAwardComments(List<AwardComment> awardComments) {
        this.awardComments = awardComments;
    }

    public List<AwardCostShare> getAwardCostShares() {
        return this.awardCostShares;
    }

    public void setAwardCostShares(List<AwardCostShare> awardCostShares) {
        this.awardCostShares = awardCostShares;
    }

    public List<AwardApprovedSubaward> getAwardApprovedSubawards() {
        return this.awardApprovedSubawards;
    }

    public void setAwardApprovedSubawards(List<AwardApprovedSubaward> awardApprovedSubawards) {
        this.awardApprovedSubawards = awardApprovedSubawards;
    }

    public AwardComment getAwardCostShareComment() {
        return this.getAwardCommentByType("9", true, true);
    }

    public AwardComment getAwardPreAwardSponsorAuthorizationComment() {
        return this.getAwardCommentByType("18", false, true);
    }

    public AwardComment getAwardPreAwardInstitutionalAuthorizationComment() {
        return this.getAwardCommentByType("19", false, true);
    }

    public AwardComment getAwardFandaRateComment() {
        return this.getAwardCommentByType("8", true, true);
    }

    public AwardComment getAwardPaymentAndInvoiceRequirementsComments() {
        return this.getAwardCommentByType(CLOSE_OUT_REPORT_TYPE_FINANCIAL_REPORT, true, true);
    }

    public AwardComment getAwardBenefitsRateComment() {
        return this.getAwardCommentByType("20", true, true);
    }

    public AwardComment getAwardGeneralComments() {
        return this.getAwardCommentByType("2", true, true);
    }

    public AwardComment getAwardFiscalReportComments() {
        return this.getAwardCommentByType(CLOSE_OUT_REPORT_TYPE_PATENT, true, true);
    }

    public AwardComment getAwardCurrentActionComments() {
        return this.getAwardCommentByType("21", false, true);
    }

    public AwardComment getAwardIntellectualPropertyComments() {
        return this.getAwardCommentByType(CLOSE_OUT_REPORT_TYPE_TECHNICAL, false, true);
    }

    public AwardComment getAwardProcurementComments() {
        return this.getAwardCommentByType("5", true, true);
    }

    public AwardComment getAwardPropertyComments() {
        return this.getAwardCommentByType(CLOSE_OUT_REPORT_TYPE_INVOICE, true, true);
    }

    public AwardComment getAwardSpecialRate() {
        return this.getAwardCommentByType("7", false, true);
    }

    public AwardComment getAwardSpecialReviewComments() {
        return this.getAwardCommentByType("10", false, true);
    }

    public AwardComment getAwardProposalSummary() {
        return this.getAwardCommentByType("12", false, true);
    }

    public AwardComment getAwardProposalComments() {
        return this.getAwardCommentByType("13", false, true);
    }

    public AwardComment getAwardProposalIPReviewComment() {
        return this.getAwardCommentByType("16", false, true);
    }

    public AwardComment getAwardCommentByType(String awardCommentTypeCode, Boolean checklistPrintFlag, boolean createNew) {
        AwardCommentFactory awardCommentFactory = new AwardCommentFactory();
        AwardComment awardComment = this.getCommentMap().get(awardCommentTypeCode);
        if (awardComment == null && createNew) {
            awardComment = (AwardComment)awardCommentFactory.createComment(awardCommentTypeCode, checklistPrintFlag != null && checklistPrintFlag != false);
            this.add(awardComment);
            this.commentMap.put(awardComment.getCommentType().getCommentTypeCode(), awardComment);
        }
        return awardComment;
    }

    public AwardSponsorTerm getAwardSponsorTermByTemplateTerm(AwardTemplateTerm templateTerm, boolean createNew) {
        AwardSponsorTerm result = null;
        for (AwardSponsorTerm term : this.getAwardSponsorTerms()) {
            if (!term.getSponsorTermId().equals(templateTerm.getSponsorTermId())) continue;
            result = term;
            break;
        }
        if (result == null && createNew) {
            result = new AwardSponsorTerm();
            result.setSponsorTermId(templateTerm.getSponsorTermId());
            result.setSponsorTerm(templateTerm.getSponsorTerm());
        }
        return result;
    }

    public ScaleTwoDecimal getTotalCostShareCommitmentAmount() {
        return this.getTotalAmount(this.awardCostShares);
    }

    public ScaleTwoDecimal getTotalCostShareMetAmount() {
        ScaleTwoDecimal returnVal = ScaleTwoDecimal.ZERO;
        for (AwardCostShare awardCostShare : this.awardCostShares) {
            ScaleTwoDecimal amount = awardCostShare.getCostShareMet() != null ? awardCostShare.getCostShareMet() : ScaleTwoDecimal.ZERO;
            returnVal = (ScaleTwoDecimal)returnVal.add((AbstractDecimal)amount);
        }
        return returnVal;
    }

    public ScaleTwoDecimal getTotalDirectFandADistributionDirectCostAmount() {
        ScaleTwoDecimal returnVal = ScaleTwoDecimal.ZERO;
        for (AwardDirectFandADistribution awardDirectFandADistribution : this.awardDirectFandADistributions) {
            ScaleTwoDecimal amount = awardDirectFandADistribution.getDirectCost() != null ? awardDirectFandADistribution.getDirectCost() : ScaleTwoDecimal.ZERO;
            returnVal = (ScaleTwoDecimal)returnVal.add((AbstractDecimal)amount);
        }
        return returnVal;
    }

    public ScaleTwoDecimal getTotalDirectFandADistributionIndirectCostAmount() {
        ScaleTwoDecimal returnVal = ScaleTwoDecimal.ZERO;
        for (AwardDirectFandADistribution awardDirectFandADistribution : this.awardDirectFandADistributions) {
            ScaleTwoDecimal amount = awardDirectFandADistribution.getIndirectCost() != null ? awardDirectFandADistribution.getIndirectCost() : ScaleTwoDecimal.ZERO;
            returnVal = (ScaleTwoDecimal)returnVal.add((AbstractDecimal)amount);
        }
        return returnVal;
    }

    public ScaleTwoDecimal getTotalDirectFandADistributionAnticipatedCostAmount() {
        ScaleTwoDecimal returnVal = ScaleTwoDecimal.ZERO;
        returnVal = (ScaleTwoDecimal)returnVal.add((AbstractDecimal)this.getTotalDirectFandADistributionDirectCostAmount());
        returnVal = (ScaleTwoDecimal)returnVal.add((AbstractDecimal)this.getTotalDirectFandADistributionIndirectCostAmount());
        return returnVal;
    }

    public ScaleTwoDecimal getTotalApprovedSubawardAmount() {
        return this.getTotalAmount(this.awardApprovedSubawards);
    }

    public ScaleTwoDecimal getTotalApprovedEquipmentAmount() {
        return this.getTotalAmount(this.approvedEquipmentItems);
    }

    public ScaleTwoDecimal getTotalApprovedApprovedForeignTravelAmount() {
        return this.getTotalAmount(this.approvedForeignTravelTrips);
    }

    public List<AwardFandaRate> getAwardFandaRate() {
        return this.awardFandaRate;
    }

    public void setAwardFandaRate(List<AwardFandaRate> awardFandaRate) {
        this.awardFandaRate = awardFandaRate;
    }

    @Override
    public List<AwardScienceKeyword> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<AwardScienceKeyword> keywords) {
        this.keywords = keywords;
    }

    public void setLeadUnit(Unit leadUnit) {
        this.leadUnit = leadUnit;
        this.unitNumber = leadUnit != null ? leadUnit.getUnitNumber() : null;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    @Override
    public void addKeyword(ScienceKeyword scienceKeyword) {
        AwardScienceKeyword awardScienceKeyword = new AwardScienceKeyword(this.getAwardId(), scienceKeyword);
        this.getKeywords().add(awardScienceKeyword);
    }

    @Override
    public AwardScienceKeyword getKeyword(int index) {
        return this.getKeywords().get(index);
    }

    public void setSpecialReviews(List<AwardSpecialReview> awardSpecialReviews) {
        this.specialReviews = awardSpecialReviews;
    }

    public void addSpecialReview(AwardSpecialReview specialReview) {
        specialReview.setSequenceOwner(this);
        this.getSpecialReviews().add(specialReview);
    }

    public AwardSpecialReview getSpecialReview(int index) {
        return this.getSpecialReviews().get(index);
    }

    public List<AwardSpecialReview> getSpecialReviews() {
        return this.specialReviews;
    }

    public void add(AwardApprovedEquipment approvedEquipmentItem) {
        this.approvedEquipmentItems.add(0, approvedEquipmentItem);
        approvedEquipmentItem.setAward(this);
    }

    public void add(AwardFandaRate fandaRate) {
        this.awardFandaRate.add(fandaRate);
        fandaRate.setAward(this);
    }

    public void add(AwardSpecialReview awardSpecialReview) {
        this.specialReviews.add(awardSpecialReview);
        awardSpecialReview.setSequenceOwner(this);
    }

    public void add(AwardSponsorContact awardSponsorContact) {
        this.sponsorContacts.add(awardSponsorContact);
        awardSponsorContact.setAward(this);
    }

    public void add(AwardReportTerm awardReportTerm) {
        this.awardReportTermItems.add(awardReportTerm);
        awardReportTerm.setAward(this);
    }

    public void add(AwardCloseout awardCloseoutItem) {
        this.awardCloseoutNewItems.clear();
        if (this.awardCloseoutItems != null && this.awardCloseoutItems.size() > 5) {
            for (int i = 5; i < this.awardCloseoutItems.size(); ++i) {
                this.awardCloseoutNewItems.add(this.awardCloseoutItems.get(i));
            }
        }
        this.awardCloseoutItems.removeAll(this.awardCloseoutNewItems);
        this.awardCloseoutNewItems.add(awardCloseoutItem);
        this.awardCloseoutNewItems.sort(Comparator.comparing(AwardCloseout::getCloseoutReportName));
        this.awardCloseoutItems.addAll(this.awardCloseoutNewItems);
        awardCloseoutItem.setAward(this);
    }

    public void addStaticCloseout(AwardCloseout awardCloseoutItem) {
        this.awardCloseoutItems.add(awardCloseoutItem);
        awardCloseoutItem.setAward(this);
    }

    public void add(AwardUnitContact awardUnitContact) {
        this.awardUnitContacts.add(awardUnitContact);
        awardUnitContact.setAward(this);
    }

    public void add(AwardCentralAdminContact awardCentralAdminContact) {
        this.awardCentralAdminContacts.add(awardCentralAdminContact);
        awardCentralAdminContact.setAward(this);
    }

    public void add(AwardAlternateNumber awardAlternateNumber) {
        this.awardAlternateNumbers.add(awardAlternateNumber);
        awardAlternateNumber.setAward(this);
    }

    public void add(InstitutionalProposal institutionalProposal) {
        if (institutionalProposal != null) {
            AwardFundingProposal afp = new AwardFundingProposal(this, institutionalProposal);
            this.fundingProposals.add(afp);
            this.allFundingProposals.add(afp);
            institutionalProposal.add(afp);
        }
    }

    public void addSponsorContact(AwardSponsorContact awardSponsorContact) {
        this.sponsorContacts.add(awardSponsorContact);
        awardSponsorContact.setAward(this);
    }

    public void add(AwardPerson projectPerson) {
        this.projectPersons.add(projectPerson);
        projectPerson.setAward(this);
    }

    public void add(AwardPaymentSchedule paymentScheduleItem) {
        this.paymentScheduleItems.add(paymentScheduleItem);
        paymentScheduleItem.setAward(this);
    }

    public void addAwardTransferringSponsor(Sponsor sponsor) {
        AwardTransferringSponsor awardTransferringSponsor = new AwardTransferringSponsor(this, sponsor);
        this.awardTransferringSponsors.add(0, awardTransferringSponsor);
    }

    protected void initializeCollections() {
        this.setAwardCostShares(new ArrayList<AwardCostShare>());
        this.setAwardComments(new ArrayList<AwardComment>());
        this.awardApprovedSubawards = new ArrayList<AwardApprovedSubaward>();
        this.setAwardFandaRate(new ArrayList<AwardFandaRate>());
        this.setAwardReportTermItems(new ArrayList<AwardReportTerm>());
        this.keywords = new ArrayList<AwardScienceKeyword>();
        this.specialReviews = new ArrayList<AwardSpecialReview>();
        this.approvedEquipmentItems = new ArrayList<AwardApprovedEquipment>();
        this.approvedForeignTravelTrips = new ArrayList<AwardApprovedForeignTravel>();
        this.setAwardSponsorTerms(new ArrayList<AwardSponsorTerm>());
        this.paymentScheduleItems = new ArrayList<AwardPaymentSchedule>();
        this.awardTransferringSponsors = new ArrayList<AwardTransferringSponsor>();
        this.awardDirectFandADistributions = new ArrayList<AwardDirectFandADistribution>();
        this.awardCustomDataList = new ArrayList<AwardCustomData>();
        this.awardCloseoutItems = new ArrayList<AwardCloseout>();
        this.awardCloseoutNewItems = new ArrayList<AwardCloseout>();
        this.awardNotepads = new ArrayList<AwardNotepad>();
        this.initializeAwardAmountInfoObjects();
        this.projectPersons = new ArrayList<AwardPerson>();
        this.awardUnitContacts = new ArrayList<AwardUnitContact>();
        this.awardCentralAdminContacts = new ArrayList<AwardCentralAdminContact>();
        this.awardAlternateNumbers = new ArrayList<AwardAlternateNumber>();
        this.sponsorContacts = new ArrayList<AwardSponsorContact>();
        this.awardBudgetLimits = new ArrayList<AwardBudgetLimit>();
        this.awardCgbList = new ArrayList<AwardCgb>();
        this.fundingProposals = new ArrayList<AwardFundingProposal>();
        this.allFundingProposals = new ArrayList<AwardFundingProposal>();
        this.initializeAwardHierarchyTempObjects();
        this.syncChanges = new ArrayList<AwardSyncChange>();
        this.syncStatuses = new ArrayList<AwardSyncStatus>();
        this.subAwardList = new ArrayList<SubAward>();
        this.currentVersionBudgets = new ArrayList<AwardBudgetExt>();
        this.awardCfdas = new ArrayList<AwardCfda>();
        this.awardNotifications = new ArrayList<AwardNotification>();
    }

    public void initializeAwardAmountInfoObjects() {
        this.awardAmountInfos = new ArrayList<AwardAmountInfo>();
        AwardAmountInfo awardAmountInfo = new AwardAmountInfo();
        awardAmountInfo.setAward(this);
        awardAmountInfo.setOriginatingAwardVersion(1);
        this.awardAmountInfos.add(awardAmountInfo);
    }

    public void initializeAwardHierarchyTempObjects() {
        this.awardHierarchyTempObjects = new AutoPopulatingList(AwardHierarchyTempObject.class);
    }

    public ScaleTwoDecimal getPreAwardInstitutionalAuthorizedAmount() {
        return this.preAwardInstitutionalAuthorizedAmount;
    }

    public void setPreAwardInstitutionalAuthorizedAmount(ScaleTwoDecimal preAwardInstitutionalAuthorizedAmount) {
        this.preAwardInstitutionalAuthorizedAmount = preAwardInstitutionalAuthorizedAmount != null && preAwardInstitutionalAuthorizedAmount.isNegative() ? (ScaleTwoDecimal)ScaleTwoDecimal.ZERO.subtract((AbstractDecimal)preAwardInstitutionalAuthorizedAmount) : preAwardInstitutionalAuthorizedAmount;
    }

    public java.sql.Date getPreAwardInstitutionalEffectiveDate() {
        return this.preAwardInstitutionalEffectiveDate;
    }

    public void setPreAwardInstitutionalEffectiveDate(java.sql.Date preAwardInstitutionalEffectiveDate) {
        this.preAwardInstitutionalEffectiveDate = preAwardInstitutionalEffectiveDate;
    }

    public void add(AwardCostShare awardCostShare) {
        this.awardCostShares.add(awardCostShare);
        awardCostShare.setAward(this);
    }

    public void add(AwardApprovedSubaward awardApprovedSubaward) {
        this.awardApprovedSubawards.add(awardApprovedSubaward);
        awardApprovedSubaward.setAward(this);
    }

    public void add(AwardComment awardComment) {
        this.awardComments.add(awardComment);
        awardComment.setAward(this);
    }

    public void addTemplateComments(List<AwardTemplateComment> awardTemplateComments) {
        AwardCommentFactory awardCommentFactory = new AwardCommentFactory();
        for (AwardTemplateComment awardTemplateComment : awardTemplateComments) {
            AwardComment testAwardComment = this.getCommentMap().get(awardTemplateComment.getCommentTypeCode());
            if (testAwardComment == null) {
                AwardComment awardComment = (AwardComment)awardCommentFactory.createComment(awardTemplateComment.getCommentTypeCode(), awardTemplateComment.getChecklistPrintFlag());
                awardComment.setComments(awardTemplateComment.getComments());
                this.add(awardComment);
                this.commentMap.put(awardComment.getCommentType().getCommentTypeCode(), awardComment);
                continue;
            }
            testAwardComment.setComments(awardTemplateComment.getComments());
        }
    }

    public void add(AwardSponsorTerm awardSponsorTerm) {
        this.awardSponsorTerms.add(awardSponsorTerm);
        awardSponsorTerm.setAward(this);
    }

    public void addTemplateTerms(List<AwardTemplateTerm> awardTemplateTerms) {
        List<AwardSponsorTerm> tempAwardSponsorTerms = awardTemplateTerms.stream().map(awardTemplateTerm -> new AwardSponsorTerm(awardTemplateTerm.getSponsorTermId(), awardTemplateTerm.getSponsorTerm())).collect(Collectors.toList());
        this.setAwardSponsorTerms(tempAwardSponsorTerms);
    }

    public void add(AwardDirectFandADistribution awardDirectFandADistribution) {
        this.awardDirectFandADistributions.add(awardDirectFandADistribution);
        awardDirectFandADistribution.setAward(this);
        awardDirectFandADistribution.setBudgetPeriod(this.awardDirectFandADistributions.size());
    }

    public void add(int index, AwardDirectFandADistribution awardDirectFandADistribution) {
        this.awardDirectFandADistributions.add(index, awardDirectFandADistribution);
        awardDirectFandADistribution.setAward(this);
        awardDirectFandADistribution.setBudgetPeriod(index + 1);
        this.updateDirectFandADistributionBudgetPeriods(index + 1);
    }

    public void add(AwardNotepad awardNotepad) {
        awardNotepad.setEntryNumber(this.awardNotepads.size() + 1);
        awardNotepad.setAwardNumber(this.getAwardNumber());
        this.awardNotepads.add(awardNotepad);
        awardNotepad.setAward(this);
    }

    public void updateDirectFandADistributionBudgetPeriods(int index) {
        for (int newIndex = index; newIndex < this.awardDirectFandADistributions.size(); ++newIndex) {
            this.awardDirectFandADistributions.get(newIndex).setBudgetPeriod(newIndex + 1);
        }
    }

    ScaleTwoDecimal getTotalAmount(List<? extends ValuableItem> valuableItems) {
        ScaleTwoDecimal returnVal = ScaleTwoDecimal.ZERO;
        for (ValuableItem valuableItem : valuableItems) {
            ScaleTwoDecimal amount = valuableItem.getAmount() != null ? valuableItem.getAmount() : ScaleTwoDecimal.ZERO;
            returnVal = (ScaleTwoDecimal)returnVal.add((AbstractDecimal)amount);
        }
        return returnVal;
    }

    public List<AwardSponsorTerm> getAwardSponsorTerms() {
        return this.awardSponsorTerms;
    }

    public AwardStatus getAwardStatus() {
        if (this.awardStatus == null && this.statusCode != null) {
            this.refreshReferenceObject(AWARD_STATUS);
        }
        return this.awardStatus;
    }

    public void setAwardSponsorTerms(List<AwardSponsorTerm> awardSponsorTerms) {
        this.awardSponsorTerms = awardSponsorTerms;
    }

    @Override
    public Sponsor getSponsor() {
        if (!StringUtils.isEmpty((CharSequence)this.sponsorCode)) {
            this.refreshReferenceObject(SPONSOR);
        }
        return this.sponsor;
    }

    public List<AwardSponsorContact> getSponsorContacts() {
        return this.sponsorContacts;
    }

    public void setSponsorContacts(List<AwardSponsorContact> awardSponsorContacts) {
        this.sponsorContacts = awardSponsorContacts;
    }

    public void setSponsor(Sponsor sponsor) {
        this.sponsor = sponsor;
        this.sponsorCode = sponsor != null ? sponsor.getSponsorCode() : null;
    }

    @Override
    public String getSponsorName() {
        Sponsor sponsor = this.getSponsor();
        return sponsor != null ? sponsor.getSponsorName() : null;
    }

    @Override
    public Long getUniqueIdentifier() {
        return this.awardId;
    }

    public String getIcrRateCode() {
        return this.icrRateCode;
    }

    public void setIcrRateCode(String icrRateCode) {
        this.icrRateCode = icrRateCode;
    }

    public void add(AwardApprovedForeignTravel approvedForeignTravelTrip) {
        this.approvedForeignTravelTrips.add(approvedForeignTravelTrip);
        approvedForeignTravelTrip.setAward(this);
    }

    public List<AwardPaymentSchedule> getPaymentScheduleItems() {
        return this.paymentScheduleItems;
    }

    public void setPaymentScheduleItems(List<AwardPaymentSchedule> paymentScheduleItems) {
        this.paymentScheduleItems = paymentScheduleItems;
    }

    public ScaleTwoDecimal getTotalPaymentScheduleAmount() {
        ScaleTwoDecimal amount = ScaleTwoDecimal.ZERO;
        for (AwardPaymentSchedule schedule : this.paymentScheduleItems) {
            if (schedule.getAmount() == null) continue;
            amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)schedule.getAmount());
        }
        return amount;
    }

    @Override
    public Sponsor getPrimeSponsor() {
        if (!StringUtils.isEmpty((CharSequence)this.getPrimeSponsorCode())) {
            this.refreshReferenceObject(PRIME_SPONSOR);
        }
        return this.primeSponsor;
    }

    @Override
    public Date getStartDate() {
        return this.awardEffectiveDate;
    }

    @Override
    public Date getEndDate() {
        return this.findLatestFinalExpirationDate();
    }

    @Override
    public String getSponsorProjectId() {
        return this.sponsorAwardNumber;
    }

    @Override
    public String getNoticeOfOpportunityCode() {
        return null;
    }

    @Override
    public String getNoticeOfOpportunityDescription() {
        return null;
    }

    @Override
    public List<? extends KcPersistableBusinessObjectBase> getPersons() {
        return this.getProjectPersons();
    }

    @Override
    public List<Sponsor> getSponsors() {
        return Collections.singletonList(this.getSponsor());
    }

    public void setPrimeSponsor(Sponsor primeSponsor) {
        this.primeSponsor = primeSponsor;
    }

    public List<AwardTransferringSponsor> getAwardTransferringSponsors() {
        return this.awardTransferringSponsors;
    }

    public void setAwardStatus(AwardStatus awardStatus) {
        this.awardStatus = awardStatus;
    }

    public void setAwardTransferringSponsors(List<AwardTransferringSponsor> awardTransferringSponsors) {
        this.awardTransferringSponsors = awardTransferringSponsors;
    }

    public List<AwardDirectFandADistribution> getAwardDirectFandADistributions() {
        return this.awardDirectFandADistributions;
    }

    public void setAwardDirectFandADistributions(List<AwardDirectFandADistribution> awardDirectFandADistributions) {
        for (AwardDirectFandADistribution awardDirectFandADistribution : awardDirectFandADistributions) {
            awardDirectFandADistribution.setAward(this);
        }
        this.awardDirectFandADistributions = awardDirectFandADistributions;
    }

    public List<AwardNotepad> getAwardNotepads() {
        return this.awardNotepads;
    }

    public void setAwardNotepads(List<AwardNotepad> awardNotepads) {
        this.awardNotepads = awardNotepads;
    }

    public String getIndirectCostIndicator() {
        return this.indirectCostIndicator;
    }

    public void setIndirectCostIndicator(String indirectCostIndicator) {
        this.indirectCostIndicator = indirectCostIndicator;
    }

    public ScaleTwoDecimal getObligatedTotal() {
        ScaleTwoDecimal returnValue = ScaleTwoDecimal.ZERO;
        if (this.getLastAwardAmountInfo().getAmountObligatedToDate() != null) {
            returnValue = (ScaleTwoDecimal)returnValue.add((AbstractDecimal)this.getLastAwardAmountInfo().getAmountObligatedToDate());
        }
        return returnValue;
    }

    public ScaleTwoDecimal getObligatedDistributableTotal() {
        ScaleTwoDecimal returnValue = ScaleTwoDecimal.ZERO;
        if (this.getLastAwardAmountInfo().getObliDistributableAmount() != null) {
            returnValue = this.getLastAwardAmountInfo().getObliDistributableAmount();
        }
        return returnValue;
    }

    public ScaleTwoDecimal getObligatedChangeTotal() {
        ScaleTwoDecimal returnValue = ScaleTwoDecimal.ZERO;
        if (this.getLastAwardAmountInfo().getObligatedChange() != null) {
            returnValue = (ScaleTwoDecimal)returnValue.add((AbstractDecimal)this.getLastAwardAmountInfo().getObligatedChange());
        }
        return returnValue;
    }

    public ScaleTwoDecimal getBudgetTotalCostLimit() {
        ScaleTwoDecimal limit = this.getTotalCostBudgetLimit();
        ScaleTwoDecimal obliTotal = this.getObligatedDistributableTotal();
        if (limit != null && limit.isLessEqual((AbstractDecimal)obliTotal)) {
            return limit;
        }
        return obliTotal;
    }

    public ScaleTwoDecimal getObligatedTotalDirect() {
        ScaleTwoDecimal returnValue = ScaleTwoDecimal.ZERO;
        if (this.getLastAwardAmountInfo().getObligatedTotalDirect() != null) {
            returnValue = (ScaleTwoDecimal)returnValue.add((AbstractDecimal)this.getLastAwardAmountInfo().getObligatedTotalDirect());
        }
        return returnValue;
    }

    public ScaleTwoDecimal getObligatedTotalIndirect() {
        ScaleTwoDecimal returnValue = ScaleTwoDecimal.ZERO;
        if (this.getLastAwardAmountInfo().getObligatedTotalIndirect() != null) {
            returnValue = (ScaleTwoDecimal)returnValue.add((AbstractDecimal)this.getLastAwardAmountInfo().getObligatedTotalIndirect());
        }
        return returnValue;
    }

    public ScaleTwoDecimal getAnticipatedTotal() {
        ScaleTwoDecimal returnValue = ScaleTwoDecimal.ZERO;
        if (this.getLastAwardAmountInfo().getAnticipatedTotalAmount() != null) {
            returnValue = (ScaleTwoDecimal)returnValue.add((AbstractDecimal)this.getLastAwardAmountInfo().getAnticipatedTotalAmount());
        }
        return returnValue;
    }

    public ScaleTwoDecimal getAnticipatedTotalDirect() {
        ScaleTwoDecimal returnValue = ScaleTwoDecimal.ZERO;
        if (this.getLastAwardAmountInfo().getAnticipatedTotalDirect() != null) {
            returnValue = (ScaleTwoDecimal)returnValue.add((AbstractDecimal)this.getLastAwardAmountInfo().getAnticipatedTotalDirect());
        }
        return returnValue;
    }

    public ScaleTwoDecimal getAnticipatedTotalIndirect() {
        ScaleTwoDecimal returnValue = ScaleTwoDecimal.ZERO;
        if (this.getLastAwardAmountInfo().getAnticipatedTotalIndirect() != null) {
            returnValue = (ScaleTwoDecimal)returnValue.add((AbstractDecimal)this.getLastAwardAmountInfo().getAnticipatedTotalIndirect());
        }
        return returnValue;
    }

    @Override
    public String getDocumentNumberForPermission() {
        return this.awardId != null ? this.awardId.toString() : BLANK_COMMENT;
    }

    @Override
    public String getDocumentKey() {
        return "award";
    }

    @Override
    public List<String> getRoleNames() {
        return this.getSystemAuthorizationService().getRoles("KC-AWARD").stream().map(Role::getName).collect(Collectors.toList());
    }

    public List<AwardAmountInfo> getAwardAmountInfos() {
        return this.awardAmountInfos;
    }

    public void setAwardAmountInfos(List<AwardAmountInfo> awardAmountInfos) {
        this.awardAmountInfos = awardAmountInfos;
    }

    public AwardAmountInfo getAwardAmountInfo() {
        return this.awardAmountInfos.get(0);
    }

    public AwardAmountInfo getLatestAwardAmountInfo() {
        return this.getAwardAmountInfoService().fetchAwardAmountInfoWithHighestTransactionId(this.awardAmountInfos);
    }

    public Unit getLeadUnit() {
        if (this.leadUnit == null && StringUtils.isNotEmpty((CharSequence)this.unitNumber) || StringUtils.isNotEmpty((CharSequence)this.unitNumber) && this.leadUnit != null && !this.unitNumber.equals(this.leadUnit.getUnitNumber())) {
            this.loadLeadUnit();
        }
        return this.leadUnit;
    }

    public boolean isNew() {
        return this.awardId == null;
    }

    @Override
    public List<? extends DocumentCustomData> getCustomDataList() {
        return this.getAwardCustomDataList();
    }

    public List<AwardReportTerm> getAwardReportTermItems() {
        this.awardReportTermItems.sort(new ARTComparator());
        return this.awardReportTermItems;
    }

    public void setAwardReportTermItems(List<AwardReportTerm> awardReportTermItems) {
        this.awardReportTermItems = awardReportTermItems;
    }

    public AwardPerson getPrincipalInvestigator() {
        AwardPerson principleInvestigator = null;
        for (AwardPerson person : this.projectPersons) {
            if (!person.isPrincipalInvestigator()) continue;
            principleInvestigator = person;
            break;
        }
        return principleInvestigator;
    }

    @Override
    public String getPrincipalInvestigatorName() {
        AwardPerson pi = this.getPrincipalInvestigator();
        if (pi != null) {
            this.principalInvestigatorName = pi.getIsRolodexPerson() ? pi.getRolodex().getOrganization() : pi.getFullName();
        }
        return this.principalInvestigatorName;
    }

    public void setPrincipalInvestigatorName(String principalInvestigatorName) {
        this.principalInvestigatorName = principalInvestigatorName;
    }

    public String getStatusDescription() {
        AwardStatus status = this.getAwardStatus();
        return status != null ? status.getDescription() : null;
    }

    public List<AwardCustomData> getAwardCustomDataList() {
        return this.awardCustomDataList;
    }

    public void setAwardCustomDataList(List<AwardCustomData> awardCustomDataList) {
        this.awardCustomDataList = awardCustomDataList;
    }

    public List<AwardCloseout> getAwardCloseoutItems() {
        return this.awardCloseoutItems;
    }

    public void setAwardCloseoutItems(List<AwardCloseout> awardCloseoutItems) {
        if (awardCloseoutItems != null && awardCloseoutItems.size() > 5) {
            int i;
            this.awardCloseoutNewItems.clear();
            for (i = 5; i < awardCloseoutItems.size(); ++i) {
                this.awardCloseoutNewItems.add(awardCloseoutItems.get(i));
            }
            for (i = awardCloseoutItems.size(); i > 5; --i) {
                awardCloseoutItems.remove(i - 1);
            }
            this.awardCloseoutNewItems.sort(Comparator.comparing(AwardCloseout::getCloseoutReportName));
            awardCloseoutItems.addAll(5, this.awardCloseoutNewItems);
        }
        this.awardCloseoutItems = awardCloseoutItems;
    }

    public List<AwardCloseout> getAwardCloseoutNewItems() {
        return this.awardCloseoutNewItems;
    }

    public void setAwardCloseoutNewItems(List<AwardCloseout> awardCloseoutNewItems) {
        this.awardCloseoutNewItems = awardCloseoutNewItems;
    }

    public void setTemplateCode(Integer templateCode) {
        this.templateCode = templateCode;
    }

    @Override
    public String getPrimeSponsorCode() {
        return this.primeSponsorCode;
    }

    public void setPrimeSponsorCode(String primeSponsorCode) {
        this.primeSponsorCode = primeSponsorCode;
    }

    public String getBasisOfPaymentCode() {
        return this.basisOfPaymentCode;
    }

    public void setBasisOfPaymentCode(String basisOfPaymentCode) {
        this.basisOfPaymentCode = basisOfPaymentCode;
    }

    public String getMethodOfPaymentCode() {
        return this.methodOfPaymentCode;
    }

    public void setMethodOfPaymentCode(String methodOfPaymentCode) {
        this.methodOfPaymentCode = methodOfPaymentCode;
    }

    public AwardTemplate getAwardTemplate() {
        return this.awardTemplate;
    }

    public void setAwardTemplate(AwardTemplate awardTemplate) {
        this.awardTemplate = awardTemplate;
    }

    public AwardBasisOfPayment getAwardBasisOfPayment() {
        return this.awardBasisOfPayment;
    }

    public void setAwardBasisOfPayment(AwardBasisOfPayment awardBasisOfPayment) {
        this.awardBasisOfPayment = awardBasisOfPayment;
    }

    public AwardMethodOfPayment getAwardMethodOfPayment() {
        return this.awardMethodOfPayment;
    }

    public void setAwardMethodOfPayment(AwardMethodOfPayment awardMethodOfPayment) {
        this.awardMethodOfPayment = awardMethodOfPayment;
    }

    @Override
    public Integer getOwnerSequenceNumber() {
        return null;
    }

    @Override
    public void incrementSequenceNumber() {
        Integer n = this.sequenceNumber;
        this.sequenceNumber = this.sequenceNumber + 1;
    }

    @Override
    public Award getSequenceOwner() {
        return this;
    }

    @Override
    public void setSequenceOwner(Award newOwner) {
    }

    @Override
    public void resetPersistenceState() {
        this.awardId = null;
    }

    @Override
    public String getVersionNameField() {
        return AWARD_NUMBER;
    }

    @Override
    public String getVersionNameFieldValue() {
        return this.getAwardNumber();
    }

    @Override
    public ActivityType getActivityType() {
        return this.activityType;
    }

    public void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }

    public AwardFundingProposal removeFundingProposal(int index) {
        AwardFundingProposal afp;
        AwardFundingProposal awardFundingProposal = afp = index >= 0 ? this.getAllFundingProposalsSortedBySequence().get(index) : null;
        if (afp != null) {
            this.removeFundingProposal(afp);
        }
        return afp;
    }

    public List<AwardFundingProposal> removeFundingProposals(String proposalNumber) {
        List<AwardFundingProposal> fundingProposals = this.getAllFundingProposals().stream().filter(afp -> afp.getProposal() != null).filter(afp -> StringUtils.equals((CharSequence)afp.getProposal().getProposalNumber(), (CharSequence)proposalNumber)).collect(Collectors.toList());
        fundingProposals.forEach(this::removeFundingProposal);
        return fundingProposals;
    }

    public void removeFundingProposal(AwardFundingProposal afp) {
        this.fundingProposals.remove(afp);
        this.allFundingProposals.remove(afp);
        InstitutionalProposal proposal = this.getInstitutionalProposalService().getInstitutionalProposal(afp.getProposalId().toString());
        if (proposal != null) {
            proposal.remove(afp);
        }
    }

    public AwardComment findCommentOfSpecifiedType(AwardComment template) {
        return this.findCommentOfSpecifiedType(template.getCommentTypeCode());
    }

    public AwardComment findCommentOfSpecifiedType(String commentTypeCode) {
        AwardComment comment = null;
        for (AwardComment ac : this.getAwardComments()) {
            if (!ac.getCommentTypeCode().equals(commentTypeCode)) continue;
            comment = ac;
            break;
        }
        return comment;
    }

    @Override
    public String getBudgetStatus() {
        return "2";
    }

    public List<AwardPerson> getPersonRolodexList() {
        return this.getProjectPersons();
    }

    @Override
    public PersonRolodex getProposalEmployee(String personId) {
        return this.getPerson(personId, true);
    }

    private PersonRolodex getPerson(String personId, boolean personFindFlag) {
        List<AwardPerson> awardPersons = this.getProjectPersons();
        for (AwardPerson awardPerson : awardPersons) {
            if (personId == null || !personId.equals(awardPerson.getPersonId())) continue;
            return awardPerson;
        }
        return null;
    }

    @Override
    public ContactRole getProposalEmployeeRole(String personId) {
        if (this.getProposalEmployee(personId) != null) {
            return this.getProposalEmployee(personId).getContactRole();
        }
        return null;
    }

    @Override
    public PersonRolodex getProposalNonEmployee(Integer rolodexId) {
        List<AwardPerson> awardPersons = this.getProjectPersons();
        for (AwardPerson awardPerson : awardPersons) {
            if (!rolodexId.equals(awardPerson.getRolodexId())) continue;
            return awardPerson;
        }
        return null;
    }

    @Override
    public ContactRole getProposalNonEmployeeRole(Integer rolodexId) {
        if (this.getProposalNonEmployee(rolodexId) != null) {
            return this.getProposalNonEmployee(rolodexId).getContactRole();
        }
        return null;
    }

    @Override
    public java.sql.Date getRequestedEndDateInitial() {
        return this.getObligationExpirationDate();
    }

    @Override
    public java.sql.Date getRequestedStartDateInitial() {
        AwardAmountInfo awardAmountInfo = this.getLastAwardAmountInfo();
        return awardAmountInfo == null ? null : awardAmountInfo.getCurrentFundEffectiveDate();
    }

    @Override
    public Unit getUnit() {
        return this.getLeadUnit();
    }

    public Boolean isSponsorNihMultiplePi() {
        if (this.sponsorNihMultiplePi == null) {
            this.sponsorNihMultiplePi = this.getSponsorHierarchyService().isSponsorNihMultiplePi(this.getSponsorCode());
        }
        return this.sponsorNihMultiplePi;
    }

    @Override
    public void setBudgetStatus(String budgetStatus) {
    }

    public List<AwardAttachment> getAwardAttachments() {
        if (this.awardAttachments == null) {
            this.awardAttachments = new ArrayList<AwardAttachment>();
        }
        return this.awardAttachments;
    }

    public void setAttachments(List<AwardAttachment> attachments) {
        this.awardAttachments = attachments;
    }

    public AwardAttachment getAwardAttachment(int index) {
        return this.awardAttachments.get(index);
    }

    public void addAttachment(AwardAttachment attachment) {
        this.getAwardAttachments().add(attachment);
        attachment.setAward(this);
    }

    public boolean isPersisted() {
        return this.awardId != null;
    }

    public AwardApprovedSubaward getAwardApprovedSubawards(int index) {
        return this.getAwardApprovedSubawards().get(index);
    }

    @Override
    public String getNamespace() {
        return "KC-AWARD";
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return "KC-AWARD";
    }

    protected void loadLeadUnit() {
        this.leadUnit = (Unit)this.getBusinessObjectService().findByPrimaryKey(Unit.class, Collections.singletonMap(UNIT_NUMBER, this.getUnitNumber()));
    }

    @Override
    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
        String documentNumber = this.getAwardDocument() != null ? this.getAwardDocument().getDocumentNumber() : BLANK_COMMENT;
        qualifiedRoleAttributes.put(DOCUMENT_NUMBER, documentNumber);
    }

    @Override
    public String getHierarchyStatus() {
        return NO_FLAG;
    }

    public java.sql.Date findLatestFinalExpirationDate() {
        java.sql.Date latestExpDate = new java.sql.Date(new GregorianCalendar(1900, 0, 1).getTimeInMillis());
        for (AwardAmountInfo amountInfo : this.getAwardAmountInfos()) {
            java.sql.Date expDate = amountInfo.getFinalExpirationDate();
            if (expDate == null || !expDate.after(latestExpDate)) continue;
            latestExpDate = expDate;
        }
        return latestExpDate;
    }

    @Override
    public boolean isParentInHierarchyComplete() {
        return true;
    }

    @Override
    public String getDefaultBudgetStatusParameter() {
        return "awardBudgetStatusInProgress";
    }

    public List<AwardHierarchyTempObject> getAwardHierarchyTempObjects() {
        return this.awardHierarchyTempObjects;
    }

    public AwardHierarchyTempObject getAwardHierarchyTempObject(int index) {
        if (this.awardHierarchyTempObjects == null) {
            this.initializeAwardHierarchyTempObjects();
        }
        return this.awardHierarchyTempObjects.get(index);
    }

    public AwardType getAwardType() {
        return this.awardType;
    }

    public void setAwardType(AwardType awardType) {
        this.awardType = awardType;
    }

    public AwardComment getAwardComment(int index) {
        while (this.getAwardComments().size() <= index) {
            this.getAwardComments().add(new AwardComment());
        }
        return this.getAwardComments().get(index);
    }

    public String getDocIdStatus() {
        return this.docIdStatus;
    }

    public String getAwardIdAccount() {
        if (StringUtils.isNotBlank((CharSequence)this.getAccountNumber())) {
            return this.getAwardNumber() + COLON + this.getAccountNumber();
        }
        return this.getAwardNumber() + COLON;
    }

    public void setLookupOspAdministratorName(String lookupOspAdministratorName) {
        this.lookupOspAdministratorName = lookupOspAdministratorName;
    }

    public String getLookupOspAdministratorName() {
        return this.lookupOspAdministratorName;
    }

    public List<AwardCentralAdminContact> getAwardCentralAdminContacts() {
        if (this.syncCentralAdminContacts && !this.centralAdminContactsSynced) {
            this.syncCentralAdminContactsWithUnitAdministrators();
        } else if (!(this.getAutoSyncCentralAdminContactsByDefault() || this.awardCentralAdminContacts != null && this.awardCentralAdminContacts.size() >= 1)) {
            this.syncCentralAdminContactsWithUnitAdministrators();
        } else if (this.awardCentralAdminContacts == null) {
            this.awardCentralAdminContacts = new ArrayList<AwardCentralAdminContact>();
        }
        return this.awardCentralAdminContacts;
    }

    public void removeDuplicateAwardCentralAdminContacts() {
        if (this.awardCentralAdminContacts == null) {
            return;
        }
        HashSet<AwardCentralAdminContact> uniqueContacts = new HashSet<AwardCentralAdminContact>();
        int i = 0;
        while (i < this.awardCentralAdminContacts.size()) {
            if (uniqueContacts.add(this.awardCentralAdminContacts.get(i))) {
                ++i;
                continue;
            }
            this.awardCentralAdminContacts.remove(i);
        }
    }

    public boolean getSyncCentralAdminContacts() {
        return this.syncCentralAdminContacts;
    }

    public void setSyncCentralAdminContacts(boolean syncCentralAdminContacts) {
        this.syncCentralAdminContacts = syncCentralAdminContacts;
    }

    public void setAwardCentralAdminContacts(List<AwardCentralAdminContact> awardCentralAdminContacts) {
        this.awardCentralAdminContacts = awardCentralAdminContacts;
    }

    public List<AwardAlternateNumber> getAwardAlternateNumbers() {
        return this.awardAlternateNumbers;
    }

    public void setAwardAlternateNumbers(List<AwardAlternateNumber> awardAlternateNumbers) {
        this.awardAlternateNumbers = awardAlternateNumbers;
    }

    public void syncCentralAdminContactsWithUnitAdministrators() {
        if (this.awardCentralAdminContacts != null) {
            this.awardCentralAdminContacts.clear();
        } else {
            this.awardCentralAdminContacts = new ArrayList<AwardCentralAdminContact>();
        }
        List<UnitAdministrator> unitAdministrators = this.getUnitService().retrieveUnitAdministratorsByUnitNumber(this.getUnitNumber());
        for (UnitAdministrator unitAdministrator : unitAdministrators) {
            if (!unitAdministrator.getUnitAdministratorType().getDefaultGroupFlag().equals("C")) continue;
            KcPerson person = null;
            try {
                person = this.getKcPersonService().getKcPersonByPersonId(unitAdministrator.getPersonId());
            }
            catch (IllegalArgumentException e) {
                LOG.info("syncCentralAdminContactsWithUnitAdministrators(): entity/person missing: " + unitAdministrator.getPersonId());
            }
            if (person == null) continue;
            AwardCentralAdminContact awardCentralAdminContact = new AwardCentralAdminContact();
            awardCentralAdminContact.setAward(this);
            awardCentralAdminContact.setPerson(person);
            awardCentralAdminContact.setUnitAdministratorType(unitAdministrator.getUnitAdministratorType());
            awardCentralAdminContact.setUnitAdministratorTypeCode(unitAdministrator.getUnitAdministratorTypeCode());
            awardCentralAdminContact.setFullName(person.getFullName());
            awardCentralAdminContact.setDefaultUnitContact(true);
            awardCentralAdminContact.setUnitContactType(UnitContactType.CONTACT);
            if (this.awardCentralAdminContacts.contains(awardCentralAdminContact)) continue;
            this.awardCentralAdminContacts.add(awardCentralAdminContact);
        }
        this.centralAdminContactsSynced = true;
    }

    public boolean isAwardInMultipleNodeHierarchy() {
        return this.awardInMultipleNodeHierarchy;
    }

    public void setAwardInMultipleNodeHierarchy(boolean awardInMultipleNodeHierarchy) {
        this.awardInMultipleNodeHierarchy = awardInMultipleNodeHierarchy;
    }

    public boolean isAwardHasAssociatedTandMOrIsVersioned() {
        return this.awardHasAssociatedTandMOrIsVersioned;
    }

    public void setAwardHasAssociatedTandMOrIsVersioned(boolean awardHasAssociatedTandMOrIsVersioned) {
        this.awardHasAssociatedTandMOrIsVersioned = awardHasAssociatedTandMOrIsVersioned;
    }

    public boolean isSyncChild() {
        return this.syncChild;
    }

    public void setSyncChild(boolean syncChild) {
        this.syncChild = syncChild;
    }

    public List<AwardSyncChange> getSyncChanges() {
        return this.syncChanges;
    }

    public void setSyncChanges(List<AwardSyncChange> syncChanges) {
        this.syncChanges = syncChanges;
    }

    public List<AwardSyncStatus> getSyncStatuses() {
        return this.syncStatuses;
    }

    public void setSyncStatuses(List<AwardSyncStatus> syncStatuses) {
        this.syncStatuses = syncStatuses;
    }

    public void setSponsorNihMultiplePi(Boolean sponsorNihMultiplePi) {
        this.sponsorNihMultiplePi = sponsorNihMultiplePi;
    }

    public boolean isActiveVersion() {
        return REPORT_STATUSES.contains(this.getAwardStatus().getStatusCode());
    }

    public List<AwardBudgetLimit> getAwardBudgetLimits() {
        return this.awardBudgetLimits;
    }

    public void setAwardBudgetLimits(List<AwardBudgetLimit> awardBudgetLimits) {
        this.awardBudgetLimits = awardBudgetLimits;
    }

    public ScaleTwoDecimal getTotalCostBudgetLimit() {
        return this.getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE.TOTAL_COST).getLimit();
    }

    public ScaleTwoDecimal getDirectCostBudgetLimit() {
        return this.getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE.DIRECT_COST).getLimit();
    }

    public ScaleTwoDecimal getIndirectCostBudgetLimit() {
        return this.getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE.INDIRECT_COST).getLimit();
    }

    protected AwardBudgetLimit getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE type) {
        for (AwardBudgetLimit limit : this.getAwardBudgetLimits()) {
            if (limit.getLimitType() != type) continue;
            return limit;
        }
        return new AwardBudgetLimit(type);
    }

    public List<Boolean> getAwardCommentHistoryFlags() {
        return this.awardCommentHistoryFlags;
    }

    public void setAwardCommentHistoryFlags(List<Boolean> awardCommentHistoryFlags) {
        this.awardCommentHistoryFlags = awardCommentHistoryFlags;
    }

    public void orderStaticCloseOutReportItems(List<AwardCloseout> awardCloseoutItems) {
        if (awardCloseoutItems != null && awardCloseoutItems.size() == 5) {
            this.awardCloseoutNewItems.clear();
            ArrayList<AwardCloseout> staticCloseoutItems = new ArrayList<AwardCloseout>();
            for (int i = 0; i < 5; ++i) {
                staticCloseoutItems.add(awardCloseoutItems.get(i));
                this.awardCloseoutNewItems.add(awardCloseoutItems.get(i));
            }
            awardCloseoutItems.removeAll(staticCloseoutItems);
            for (AwardCloseout awardCloseout : staticCloseoutItems) {
                if (awardCloseout.getCloseoutReportCode() != null && awardCloseout.getCloseoutReportCode().equalsIgnoreCase(CLOSE_OUT_REPORT_TYPE_FINANCIAL_REPORT)) {
                    this.awardCloseoutNewItems.remove(awardCloseout);
                    this.awardCloseoutNewItems.add(0, awardCloseout);
                    continue;
                }
                if (awardCloseout.getCloseoutReportCode() != null && awardCloseout.getCloseoutReportCode().equalsIgnoreCase(CLOSE_OUT_REPORT_TYPE_TECHNICAL)) {
                    this.awardCloseoutNewItems.remove(awardCloseout);
                    this.awardCloseoutNewItems.add(1, awardCloseout);
                    continue;
                }
                if (awardCloseout.getCloseoutReportCode() != null && awardCloseout.getCloseoutReportCode().equalsIgnoreCase(CLOSE_OUT_REPORT_TYPE_PATENT)) {
                    this.awardCloseoutNewItems.remove(awardCloseout);
                    this.awardCloseoutNewItems.add(2, awardCloseout);
                    continue;
                }
                if (awardCloseout.getCloseoutReportCode() != null && awardCloseout.getCloseoutReportCode().equalsIgnoreCase("2")) {
                    this.awardCloseoutNewItems.remove(awardCloseout);
                    this.awardCloseoutNewItems.add(3, awardCloseout);
                    continue;
                }
                if (awardCloseout.getCloseoutReportCode() == null || !awardCloseout.getCloseoutReportCode().equalsIgnoreCase(CLOSE_OUT_REPORT_TYPE_INVOICE)) continue;
                this.awardCloseoutNewItems.remove(awardCloseout);
                this.awardCloseoutNewItems.add(4, awardCloseout);
            }
            awardCloseoutItems.addAll(0, this.awardCloseoutNewItems);
        }
    }

    @Override
    public String getLeadUnitName() {
        return this.getLeadUnit() == null ? BLANK_COMMENT : this.getLeadUnit().getUnitName();
    }

    @Override
    public String getPiName() {
        return this.getPiEmployeeName();
    }

    @Override
    public String getPiEmployeeName() {
        return this.getPrincipalInvestigatorName();
    }

    @Override
    public String getPiNonEmployeeName() {
        return BLANK_COMMENT;
    }

    @Override
    public String getAdminPersonName() {
        return BLANK_COMMENT;
    }

    @Override
    public String getPrimeSponsorName() {
        return this.getPrimeSponsor() == null ? BLANK_COMMENT : this.getPrimeSponsor().getSponsorName();
    }

    @Override
    public String getSubAwardOrganizationName() {
        return BLANK_COMMENT;
    }

    @Override
    public List<NegotiationPersonDTO> getProjectPeople() {
        return this.getProjectPersons().stream().map(person -> new NegotiationPersonDTO(person.getPerson(), person.getContactRoleCode())).collect(Collectors.toList());
    }

    @Override
    public String getNegotiableProposalTypeCode() {
        return BLANK_COMMENT;
    }

    @Override
    public String getParentNumber() {
        return this.getAwardNumber();
    }

    @Override
    public String getParentPIName() {
        String investigatorName = null;
        for (AwardPerson aPerson : this.getProjectPersons()) {
            if (aPerson == null || !aPerson.isPrincipalInvestigator()) continue;
            investigatorName = aPerson.getFullName();
            break;
        }
        return investigatorName;
    }

    @Override
    public String getParentTitle() {
        return this.getTitle();
    }

    @Override
    public String getOwnedByUnitNumber() {
        return this.getLeadUnitName();
    }

    @Override
    public Integer getParentInvestigatorFlag(String personId, Integer flag) {
        for (AwardPerson aPerson : this.getProjectPersons()) {
            if ((aPerson.getPersonId() == null || !aPerson.getPersonId().equals(personId)) && (aPerson.getRolodexId() == null || !aPerson.getRolodexId().toString().equals(personId))) continue;
            flag = 2;
            if (!aPerson.isPrincipalInvestigator()) continue;
            flag = 1;
            break;
        }
        return flag;
    }

    public AwardFandaRate getCurrentFandaRate() {
        List<AwardFandaRate> rates = this.getAwardFandaRate();
        Calendar calendar = Calendar.getInstance();
        int currentFiscalYear = this.getFiscalYearMonthService().getFiscalYearFromDate(calendar);
        return rates.stream().filter(rate -> Integer.parseInt(rate.getFiscalYear()) == currentFiscalYear).max(Comparator.comparing(AwardFandaRate::getApplicableFandaRate)).orElse(null);
    }

    @Override
    public String getParentTypeName() {
        return "Award";
    }

    @Override
    public String getAssociatedDocumentId() {
        return this.getAwardNumber();
    }

    public String getAwardSequenceStatus() {
        return this.awardSequenceStatus;
    }

    public void setAwardSequenceStatus(String awardSequenceStatus) {
        this.awardSequenceStatus = awardSequenceStatus;
    }

    public String getAwardSequenceStatusResult() {
        try {
            VersionStatusConstants status = VersionStatusConstants.valueOf(this.getAwardSequenceStatus());
            return status.getDescription();
        }
        catch (IllegalArgumentException | NullPointerException e) {
            LOG.warn("Unknown award sequence status error - " + this.getAwardSequenceStatus(), (Throwable)e);
            return "Unknown Status";
        }
    }

    public void setAwardSequenceStatusResult(String awardSequenceStatusResult) {
    }

    @Override
    public ProposalType getNegotiableProposalType() {
        return null;
    }

    public NsfCode getNsfCodeBo() {
        return this.nsfCodeBo;
    }

    public void setNsfCodeBo(NsfCode nsfCodeBo) {
        this.nsfCodeBo = nsfCodeBo;
    }

    @Override
    public String getSubAwardRequisitionerName() {
        return BLANK_COMMENT;
    }

    @Override
    public String getSubAwardRequisitionerUnitNumber() {
        return BLANK_COMMENT;
    }

    @Override
    public String getSubAwardRequisitionerUnitName() {
        return BLANK_COMMENT;
    }

    @Override
    public String getSubAwardRequisitionerId() {
        return BLANK_COMMENT;
    }

    public List<SubAward> getSubAwardList() {
        return this.subAwardList;
    }

    public void setSubAwardList(List<SubAward> subAwardList) {
        this.subAwardList = subAwardList;
    }

    @Override
    public void setUpdateTimestamp(Timestamp updateTimestamp) {
        if (this.allowUpdateTimestampToBeReset) {
            super.setUpdateTimestamp(updateTimestamp);
        } else {
            this.allowUpdateTimestampToBeReset = true;
        }
    }

    @Override
    public void setUpdateUser(String updateUser) {
        if (this.allowUpdateUserToBeReset) {
            super.setUpdateUser(updateUser);
        } else {
            this.allowUpdateUserToBeReset = true;
        }
    }

    public void setAllowUpdateFieldsToBeReset(boolean updateFieldsToBeReset) {
        this.allowUpdateTimestampToBeReset = updateFieldsToBeReset;
        this.allowUpdateUserToBeReset = updateFieldsToBeReset;
    }

    public List<Award> getAwardVersions() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(AWARD_NUMBER, this.getAwardNumber());
        return this.getBusinessObjectService().findMatchingOrderBy(Award.class, fieldValues, SEQUENCE_NUMBER, true);
    }

    public String getAwardDescriptionLine() {
        String versionNumber = this.getSequenceNumber().toString();
        String noticeDate = this.getNoticeDate() != null ? this.getNoticeDate().toString() : NONE;
        String transactionTypeDescription = this.getAwardTransactionType() != null ? this.getAwardTransactionType().getDescription() : NONE;
        return "Award Version " + versionNumber + ", " + transactionTypeDescription + ", notice date: " + noticeDate + ", updated " + this.getUpdateTimeAndUser() + ". Comments:" + (this.getAwardCurrentActionComments().getComments() == null ? "None." : this.getAwardCurrentActionComments().getComments());
    }

    public String getUpdateTimeAndUser() {
        String createDateStr = null;
        String updateUser = null;
        if (this.getUpdateTimestamp() != null) {
            createDateStr = CoreApiServiceLocator.getDateTimeService().toString((Date)this.awardDocument.getUpdateTimestamp(), "hh:mm a MM/dd/yyyy");
            updateUser = this.awardDocument.getUpdateUser().length() > 30 ? this.getUpdateUser().substring(0, 30) : this.getUpdateUser();
        }
        return createDateStr + ", by " + updateUser;
    }

    public List<TimeAndMoneyDocumentHistory> getTimeAndMoneyDocumentHistoryList() throws WorkflowException {
        List<TimeAndMoneyDocument> tnmDocs = this.getTimeAndMoneyHistoryService().buildTimeAndMoneyListForAwardDisplay(this, true);
        return this.getTimeAndMoneyHistoryService().getDocHistoryAndValidInfosAssociatedWithAwardVersion(tnmDocs, this.getAwardAmountInfos(), this);
    }

    public VersionHistorySearchBo getVersionHistory() {
        return this.versionHistory;
    }

    public void setVersionHistory(VersionHistorySearchBo versionHistory) {
        this.versionHistory = versionHistory;
    }

    public void setProjectPersons(List<AwardPerson> projectPersons) {
        this.projectPersons = projectPersons;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public ScaleTwoDecimal getFandATotals() {
        ScaleTwoDecimal total = ScaleTwoDecimal.ZERO;
        for (AwardFandaRate currentRate : this.getAwardFandaRate()) {
            if (currentRate.getUnderrecoveryOfIndirectCost() == null) continue;
            total = (ScaleTwoDecimal)total.add((AbstractDecimal)new ScaleTwoDecimal(currentRate.getUnderrecoveryOfIndirectCost().bigDecimalValue()));
        }
        return total;
    }

    @Override
    public boolean isProposalBudget() {
        return false;
    }

    public BudgetParentDocument<Award> getDocument() {
        return this.getAwardDocument();
    }

    @Override
    public Budget getNewBudget() {
        return new AwardBudgetExt();
    }

    @Override
    public Integer getNextBudgetVersionNumber() {
        return this.getAwardDocument().getNextBudgetVersionNumber();
    }

    public List<AwardBudgetExt> getBudgets() {
        if (this.budgets == null || this.budgets.isEmpty()) {
            this.budgets = this.getAwardBudgetService().getAllBudgetsForAward(this);
        }
        return this.budgets;
    }

    public void setBudgets(List<AwardBudgetExt> budgets) {
        this.budgets = budgets;
    }

    public List<AwardBudgetExt> getCurrentVersionBudgets() {
        return this.currentVersionBudgets;
    }

    public void setCurrentVersionBudgets(List<AwardBudgetExt> budgets) {
        this.currentVersionBudgets = budgets;
    }

    public AwardComment getAdditionalFormsDescriptionComment() {
        return this.getAwardCommentByType(CG_2, false, true);
    }

    public AwardComment getStopWorkReasonComment() {
        return this.getAwardCommentByType(CG_1, false, true);
    }

    public AwardComment getSuspendInvoicingComment() {
        return this.getAwardCommentByType(CG_3, false, true);
    }

    public AwardCgb getAwardCgb() {
        if (this.awardCgbList.isEmpty()) {
            this.awardCgbList.add(new AwardCgb(this));
        }
        return this.awardCgbList.get(0);
    }

    public void setAwardCgb(AwardCgb awardCgb) {
        this.awardCgbList.set(0, awardCgb);
    }

    public List<AwardCgb> getAwardCgbList() {
        return this.awardCgbList;
    }

    public void setAwardCgbList(List<AwardCgb> awardCgbList) {
        this.awardCgbList = awardCgbList;
    }

    public List<AwardFundingProposal> getAllFundingProposals() {
        return this.allFundingProposals;
    }

    public void setAllFundingProposals(List<AwardFundingProposal> allFundingProposals) {
        this.allFundingProposals = allFundingProposals;
    }

    public List<AwardFundingProposal> getAllFundingProposalsSortedBySequence() {
        return this.getAllFundingProposals().stream().sorted(Comparator.comparing(AwardFundingProposal::getAwardSequenceNumber)).collect(Collectors.toList());
    }

    public String getFainId() {
        return this.fainId;
    }

    public void setFainId(String fainId) {
        this.fainId = fainId;
    }

    public Integer getFedAwardYear() {
        return this.fedAwardYear;
    }

    public void setFedAwardYear(Integer fedAwardYear) {
        this.fedAwardYear = fedAwardYear;
    }

    public java.sql.Date getFedAwardDate() {
        return this.fedAwardDate;
    }

    public void setFedAwardDate(java.sql.Date fedAwardDate) {
        this.fedAwardDate = fedAwardDate;
    }

    public SystemAuthorizationService getSystemAuthorizationService() {
        if (this.systemAuthorizationService == null) {
            this.systemAuthorizationService = KcServiceLocator.getService(SystemAuthorizationService.class);
        }
        return this.systemAuthorizationService;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    public AwardBudgetService getAwardBudgetService() {
        if (this.awardBudgetService == null) {
            this.awardBudgetService = KcServiceLocator.getService(AwardBudgetService.class);
        }
        return this.awardBudgetService;
    }

    public void setAwardBudgetService(AwardBudgetService awardBudgetService) {
        this.awardBudgetService = awardBudgetService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        if (this.institutionalProposalService == null) {
            this.institutionalProposalService = KcServiceLocator.getService(InstitutionalProposalService.class);
        }
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public UnitService getUnitService() {
        if (this.unitService == null) {
            this.unitService = KcServiceLocator.getService(UnitService.class);
        }
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public KcPerson getInvestigator() {
        return this.investigator;
    }

    public SponsorHierarchyService getSponsorHierarchyService() {
        if (this.sponsorHierarchyService == null) {
            this.sponsorHierarchyService = KcServiceLocator.getService(SponsorHierarchyService.class);
        }
        return this.sponsorHierarchyService;
    }

    public void setSponsorHierarchyService(SponsorHierarchyService sponsorHierarchyService) {
        this.sponsorHierarchyService = sponsorHierarchyService;
    }

    protected AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KcServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    public List<AwardPerson> getPersonsSelectedForCreditSplit() {
        return this.getAwardService().getPersonsSelectedForCreditSplit(this.projectPersons);
    }

    public void setFiscalYearMonthService(FiscalYearMonthService fiscalYearMonthService) {
        this.fiscalYearMonthService = fiscalYearMonthService;
    }

    protected FiscalYearMonthService getFiscalYearMonthService() {
        if (this.fiscalYearMonthService == null) {
            this.fiscalYearMonthService = KcServiceLocator.getService(FiscalYearMonthService.class);
        }
        return this.fiscalYearMonthService;
    }

    public List<AwardCfda> getAwardCfdas() {
        return this.awardCfdas;
    }

    public void setAwardCfdas(List<AwardCfda> awardCfdas) {
        this.awardCfdas = awardCfdas;
    }

    public List<AwardNotification> getAwardNotifications() {
        return this.awardNotifications;
    }

    public void setAwardNotifications(List<AwardNotification> awardNotifications) {
        this.awardNotifications = awardNotifications;
    }

    public void addNotification(AwardNotification awardNotification) {
        this.awardNotifications.add(awardNotification);
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    @Override
    protected void prePersist() {
        super.prePersist();
        try {
            Optional<Award> newActiveAward = this.getAwardService().verifyAwardSequencing(this);
            if (LOG.isInfoEnabled() && newActiveAward.isPresent()) {
                LOG.info("An award sequencing issue has been detected. This award sequencing issue was detected on prePersist. Tried saving a PENDING award with a FINAL document status.Document Number = " + newActiveAward.get().getAwardDocument().getDocumentNumber(), (Object[])new Throwable().getStackTrace());
            }
        }
        catch (WorkflowException e) {
            LOG.error((Object)e);
        }
    }

    static class ARTComparator
    implements Comparator<AwardReportTerm> {
        ARTComparator() {
        }

        @Override
        public int compare(AwardReportTerm art1, AwardReportTerm art2) {
            try {
                String art1Desc = art1.getReport().getDescription();
                String art2Desc = art2.getReport().getDescription();
                if (art1Desc == null) {
                    art1Desc = Award.BLANK_COMMENT;
                }
                if (art2Desc == null) {
                    art2Desc = Award.BLANK_COMMENT;
                }
                return art1Desc.compareTo(art2Desc);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

