/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.keyvalue.FormViewAwareUifKeyValuesFinderBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.KeyValuesService;

public class ContactsValuesFinder
extends FormViewAwareUifKeyValuesFinderBase {
    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(ValuesFinderUtils.getSelectOption());
        Long awardId = ((AwardDocument)this.getDocument()).getAward().getAwardId();
        HashMap<String, Long> keyMap = new HashMap<String, Long>();
        keyMap.put("awardId", awardId);
        Collection awardSponsorContacts = this.getKeyValuesService().findMatching(AwardSponsorContact.class, keyMap);
        for (AwardSponsorContact awardSponsorContact : awardSponsorContacts) {
            if (awardSponsorContact.getContactRole() == null) {
                awardSponsorContact.refreshReferenceObject("contactRole");
            }
            String desc = awardSponsorContact.getContactRole().getRoleDescription() + " - ";
            desc = StringUtils.isNotBlank((CharSequence)awardSponsorContact.getFullName()) ? desc + awardSponsorContact.getFullName() : desc + awardSponsorContact.getContactOrganizationName();
            keyValues.add((KeyValue)new ConcreteKeyValue(awardSponsorContact.getAwardContactId().toString(), desc));
        }
        return keyValues;
    }

    protected KeyValuesService getKeyValuesService() {
        return KcServiceLocator.getService(KeyValuesService.class);
    }
}

