/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.paymentschedule;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.paymentschedule.AddAwardPaymentScheduleRuleEvent;
import org.kuali.kra.award.paymentreports.paymentschedule.AwardPaymentSchedule;
import org.kuali.kra.award.service.AwardScheduleGenerationService;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.ObjectUtils;

public class PaymentScheduleBean
implements Serializable {
    private static final long serialVersionUID = -5513993757805685581L;
    private AwardPaymentSchedule newAwardPaymentSchedule;
    private transient KualiRuleService ruleService;
    private AwardForm form;

    public PaymentScheduleBean(AwardForm form) {
        this.form = form;
        this.init();
    }

    public boolean addPaymentScheduleItem() {
        AddAwardPaymentScheduleRuleEvent event = this.generateAddEvent();
        boolean success = this.getRuleService().applyRules((DocumentEvent)event);
        if (success) {
            this.getAward().add(this.getNewAwardPaymentSchedule());
            this.init();
        }
        return success;
    }

    public void deletePaymentScheduleItem(int deletedItemIndex) {
        List<AwardPaymentSchedule> items = this.getAward().getPaymentScheduleItems();
        if (deletedItemIndex >= 0 && deletedItemIndex < items.size()) {
            items.remove(deletedItemIndex);
        }
    }

    public void generatePaymentSchedules() throws ParseException {
        HashMap<AwardReportTerm, List> dateMap = new HashMap<AwardReportTerm, List>();
        for (AwardReportTerm art2 : this.getAward().getAwardReportTermItems()) {
            List<Date> dates2 = this.getAwardScheduleGenerationService().generateSchedules(this.getAward(), Collections.singletonList(art2), false);
            if (dateMap.containsKey(art2)) {
                List currentDates = (List)dateMap.get(art2);
                currentDates.addAll(dates2);
                dateMap.put(art2, currentDates);
                continue;
            }
            dateMap.put(art2, dates2);
        }
        dateMap.forEach((art, dates) -> dates.forEach(date -> {
            this.newAwardPaymentSchedule = new AwardPaymentSchedule();
            this.newAwardPaymentSchedule.setDueDate(new java.sql.Date(date.getTime()));
            this.newAwardPaymentSchedule.setAmount(ScaleTwoDecimal.ZERO);
            this.newAwardPaymentSchedule.setAwardReportTermDescription(this.getSummary((AwardReportTerm)art));
            this.newAwardPaymentSchedule.setAwardReportTerm((AwardReportTerm)art);
            this.getAward().add(this.newAwardPaymentSchedule);
        }));
        this.init();
    }

    public String getSummary(AwardReportTerm art) {
        art.refreshReferenceObject("frequency");
        art.refreshReferenceObject("report");
        art.refreshReferenceObject("distribution");
        art.refreshReferenceObject("frequencyBase");
        Object description = "";
        description = (String)description + (art.getReport() != null && StringUtils.isNotEmpty((CharSequence)art.getReport().getDescription()) ? art.getReport().getDescription() : "");
        description = (String)description + (String)(art.getFrequency() != null && StringUtils.isNotEmpty((CharSequence)art.getFrequency().getDescription()) ? "-" + art.getFrequency().getDescription() : "");
        description = (String)description + (String)(art.getFrequencyBase() != null && StringUtils.isNotEmpty((CharSequence)art.getFrequencyBase().getDescription()) ? "-" + art.getFrequencyBase().getDescription() : "");
        description = (String)description + (String)(art.getDistribution() != null && StringUtils.isNotEmpty((CharSequence)art.getDistribution().getDescription()) ? "-" + art.getDistribution().getDescription() : "");
        description = (String)description + (String)(ObjectUtils.isNotNull((Object)art.getDueDate()) ? "-" + String.valueOf(art.getDueDate()) : "");
        return description;
    }

    public Award getAward() {
        return this.form.getAwardDocument().getAward();
    }

    public AwardDocument getAwardDocument() {
        return this.form.getAwardDocument();
    }

    public Object getData() {
        return this.getNewAwardPaymentSchedule();
    }

    public void init() {
        this.newAwardPaymentSchedule = new AwardPaymentSchedule();
    }

    protected KualiRuleService getRuleService() {
        if (this.ruleService == null) {
            this.ruleService = KcServiceLocator.getService(KualiRuleService.class);
        }
        return this.ruleService;
    }

    protected void setRuleService(KualiRuleService ruleService) {
        this.ruleService = ruleService;
    }

    AddAwardPaymentScheduleRuleEvent generateAddEvent() {
        AddAwardPaymentScheduleRuleEvent event = new AddAwardPaymentScheduleRuleEvent("paymentScheduleBean.newAwardPaymentSchedule", this.getAwardDocument(), this.getAward(), this.getNewAwardPaymentSchedule());
        return event;
    }

    public AwardPaymentSchedule getNewAwardPaymentSchedule() {
        return this.newAwardPaymentSchedule;
    }

    public void setNewAwardPaymentSchedule(AwardPaymentSchedule newAwardPaymentSchedule) {
        this.newAwardPaymentSchedule = newAwardPaymentSchedule;
    }

    protected AwardScheduleGenerationService getAwardScheduleGenerationService() {
        return KcServiceLocator.getService(AwardScheduleGenerationService.class);
    }
}

