/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Convert;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.PropAwardPersonRole;
import org.kuali.coeus.common.framework.person.PropAwardPersonRoleService;
import org.kuali.coeus.common.framework.rolodex.NonOrganizationalRolodex;
import org.kuali.coeus.common.framework.rolodex.PersonRolodex;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncableProperty;
import org.kuali.kra.award.contacts.AwardContact;
import org.kuali.kra.award.contacts.AwardPersonCreditSplit;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.AbstractPersonRoleAware;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

public class AwardPerson
extends AwardContact
implements PersonRolodex,
Comparable<AwardPerson>,
AbstractPersonRoleAware {
    private static final long serialVersionUID = 7980027108784055721L;
    @AwardSyncableProperty
    private ScaleTwoDecimal academicYearEffort;
    @AwardSyncableProperty
    private ScaleTwoDecimal calendarYearEffort;
    @AwardSyncableProperty
    private boolean faculty;
    @AwardSyncableProperty
    private ScaleTwoDecimal summerEffort;
    @AwardSyncableProperty
    private ScaleTwoDecimal totalEffort;
    @AwardSyncableProperty
    private String keyPersonRole;
    @AwardSyncableProperty
    private boolean optInUnitStatus;
    @Column(name="CAN_PASSIVELY_DISCLOSE_COIS")
    @Convert(converter=BooleanYNConverter.class)
    private boolean canPassivelyDiscloseCois;
    @AwardSyncableProperty
    private List<AwardPersonUnit> units;
    private List<AwardPersonCreditSplit> creditSplits;
    private Boolean includeInCreditAllocation;
    private transient ParameterService parameterService;
    private transient PropAwardPersonRoleService propAwardPersonRoleService;

    public AwardPerson() {
        this.init();
    }

    public AwardPerson(NonOrganizationalRolodex rolodex, ContactRole contactRole) {
        super(rolodex, contactRole);
        this.init();
    }

    public AwardPerson(KcPerson person, ContactRole role) {
        super(person, role);
        this.init();
    }

    public void add(AwardPersonCreditSplit creditSplit) {
        this.creditSplits.add(creditSplit);
        creditSplit.setAwardPerson(this);
    }

    public void add(AwardPersonUnit awardPersonUnit) {
        this.units.add(awardPersonUnit);
        awardPersonUnit.setAwardPerson(this);
    }

    public void setIncludeInCreditAllocation(Boolean includeInCreditAllocation) {
        this.includeInCreditAllocation = includeInCreditAllocation;
    }

    public ScaleTwoDecimal getAcademicYearEffort() {
        return this.academicYearEffort;
    }

    public ScaleTwoDecimal getCalendarYearEffort() {
        return this.calendarYearEffort;
    }

    public AwardPersonCreditSplit getCreditSplit(int index) {
        return this.creditSplits.get(index);
    }

    public List<AwardPersonCreditSplit> getCreditSplits() {
        return this.creditSplits;
    }

    public ScaleTwoDecimal getSummerEffort() {
        return this.summerEffort;
    }

    public ScaleTwoDecimal getTotalEffort() {
        return this.totalEffort;
    }

    public AwardPersonUnit getUnit(int index) {
        return this.units.get(index);
    }

    public AwardPersonUnit getUnit(String unitNumber) {
        for (AwardPersonUnit awardPersonUnit : this.getUnits()) {
            if (!awardPersonUnit.getUnitNumber().equals(unitNumber)) continue;
            return awardPersonUnit;
        }
        return null;
    }

    public List<AwardPersonUnit> getUnits() {
        return this.units;
    }

    public boolean isCoInvestigator() {
        return StringUtils.equals((CharSequence)this.getContactRoleCode(), (CharSequence)"COI");
    }

    public boolean isFaculty() {
        return this.faculty;
    }

    public boolean isKeyPerson() {
        return StringUtils.equals((CharSequence)this.getContactRoleCode(), (CharSequence)"KP");
    }

    @Override
    public boolean isPrincipalInvestigator() {
        return StringUtils.equals((CharSequence)this.getContactRoleCode(), (CharSequence)"PI");
    }

    @Override
    public boolean isMultiplePi() {
        return StringUtils.equals((CharSequence)this.getContactRoleCode(), (CharSequence)"MPI");
    }

    public void setAcademicYearEffort(ScaleTwoDecimal academicYearEffort) {
        this.academicYearEffort = academicYearEffort;
    }

    public void setCalendarYearEffort(ScaleTwoDecimal calendarYearEffort) {
        this.calendarYearEffort = calendarYearEffort;
    }

    public void setCreditSplits(List<AwardPersonCreditSplit> creditSplits) {
        this.creditSplits = creditSplits;
    }

    public void setFaculty(boolean faculty) {
        this.faculty = faculty;
    }

    public void setSummerEffort(ScaleTwoDecimal summerEffort) {
        this.summerEffort = summerEffort;
    }

    public void setTotalEffort(ScaleTwoDecimal totalEffort) {
        this.totalEffort = totalEffort;
    }

    public void setUnits(List<AwardPersonUnit> units) {
        this.units = units;
    }

    protected Class<PropAwardPersonRole> getContactRoleType() {
        return PropAwardPersonRole.class;
    }

    @Override
    protected Map<String, Object> getContactRoleIdentifierMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", this.getRoleCode());
        map.put("sponsorHierarchyName", this.getPropAwardPersonRoleService().getSponsorHierarchy(this.getAward().getSponsorCode()));
        return map;
    }

    protected void init() {
        this.units = new ArrayList<AwardPersonUnit>();
        this.creditSplits = new ArrayList<AwardPersonCreditSplit>();
        this.optInUnitStatus = false;
    }

    @Override
    public String getProjectRole() {
        return this.getContactRole().getRoleDescription();
    }

    @Override
    public boolean isOtherSignificantContributorFlag() {
        return false;
    }

    public String getKeyPersonRole() {
        return this.keyPersonRole;
    }

    public void setKeyPersonRole(String keyPersonRole) {
        this.keyPersonRole = keyPersonRole;
    }

    @Override
    public int compareTo(AwardPerson o) {
        int lastNameComp = ObjectUtils.compare((Comparable)((Object)this.getLastName()), (Comparable)((Object)o.getLastName()));
        if (lastNameComp != 0) {
            return lastNameComp;
        }
        return ObjectUtils.compare((Comparable)((Object)this.getFirstName()), (Comparable)((Object)o.getFirstName()));
    }

    @Override
    public Award getParent() {
        return this.getAward();
    }

    @Override
    public String getInvestigatorRoleDescription() {
        return this.getContactRole().getRoleDescription();
    }

    public boolean isOptInUnitStatus() {
        return this.optInUnitStatus;
    }

    public void setOptInUnitStatus(boolean optInUnitStatus) {
        this.optInUnitStatus = optInUnitStatus;
    }

    public boolean getCanPassivelyDiscloseCois() {
        return this.canPassivelyDiscloseCois;
    }

    public void setCanPassivelyDiscloseCois(boolean canPassivelyDiscloseCois) {
        this.canPassivelyDiscloseCois = canPassivelyDiscloseCois;
    }

    @Override
    public String getLastName() {
        String lastName = null;
        if (this.getPerson() != null) {
            lastName = this.getPerson().getLastName();
        } else if (this.getRolodex() != null) {
            lastName = this.getRolodex().getLastName();
        }
        return lastName;
    }

    public String getFirstName() {
        String firstName = null;
        if (this.getPerson() != null) {
            firstName = this.getPerson().getFirstName();
        } else if (this.getRolodex() != null) {
            firstName = this.getRolodex().getFirstName();
        }
        return firstName;
    }

    public boolean getIsRolodexPerson() {
        return this.getRolodex() != null;
    }

    @Override
    public void setContactRoleCode(String roleCode) {
        boolean isRoleChanged = !StringUtils.equals((CharSequence)roleCode, (CharSequence)this.roleCode);
        super.setContactRoleCode(roleCode);
        if (isRoleChanged) {
            this.updateBasedOnRoleChange();
        }
    }

    private void updateBasedOnRoleChange() {
        if ("KP".equals(this.roleCode)) {
            this.setOptInUnitStatus(true);
        } else if (this.getPerson() != null && this.getPerson().getUnit() != null && this.getUnits().isEmpty()) {
            this.add(new AwardPersonUnit(this, this.getPerson().getUnit(), true));
        }
        this.getUnits().forEach(awardPersonUnit -> awardPersonUnit.setLeadUnit(false));
        if (this.isPrincipalInvestigator()) {
            Optional awardPersonUnit2 = this.getUnits().stream().findFirst();
            awardPersonUnit2.ifPresent(awardPersonUnit1 -> awardPersonUnit1.setLeadUnit(true));
        }
    }

    @Override
    protected ContactRole refreshContactRole() {
        this.contactRole = StringUtils.isNotBlank((CharSequence)this.getRoleCode()) && this.getParent() != null && StringUtils.isNotBlank((CharSequence)this.getParent().getSponsorCode()) ? this.getPropAwardPersonRoleService().getRole(this.getRoleCode(), this.getParent().getSponsorCode()) : null;
        return this.contactRole;
    }

    @Override
    public PropAwardPersonRoleService getPropAwardPersonRoleService() {
        if (this.propAwardPersonRoleService == null) {
            this.propAwardPersonRoleService = KcServiceLocator.getService(PropAwardPersonRoleService.class);
        }
        return this.propAwardPersonRoleService;
    }

    @Override
    public void setPropAwardPersonRoleService(PropAwardPersonRoleService propAwardPersonRoleService) {
        this.propAwardPersonRoleService = propAwardPersonRoleService;
    }

    @Override
    public Integer getOrdinalPosition() {
        return 0;
    }

    @Override
    public boolean isInvestigator() {
        return this.isPrincipalInvestigator() || this.isMultiplePi() || this.isCoInvestigator() || this.isKeyPerson() && this.isOptInUnitStatus();
    }

    public Boolean getIncludeInCreditAllocation() {
        if (this.includeInCreditAllocation == null) {
            this.includeInCreditAllocation = this.defaultIncludeInCreditAllocation(this.roleCode);
        }
        return this.includeInCreditAllocation;
    }

    public Boolean defaultIncludeInCreditAllocation(String proposalPersonRoleId) {
        Collection roles = this.getParameterService().getParameterValuesAsString("KC-PD", "All", "CREDIT_SPLIT_OPT_IN_DEFAULT_ROLES");
        return StringUtils.isNotBlank((CharSequence)proposalPersonRoleId) && roles.contains(proposalPersonRoleId);
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }
}

