/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.serializers;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.elasticsearch.NoteDocument;
import org.kuali.coeus.elasticsearch.NotificationDocument;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchAwardSerializer;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDocumentSerializer;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardContact;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.annotation.Qualifier;

@Configurable(autowire=Autowire.BY_TYPE)
public class ElasticsearchSubAwardSerializer
extends ElasticsearchDocumentSerializer {
    @Autowired
    @Qualifier(value="esAwardSerializer")
    private ElasticsearchAwardSerializer awardSerializer;
    @Autowired
    @Qualifier(value="awardVersionService")
    private AwardVersionService awardVersionService;

    @Override
    public GrantsSearchDocument translateDocument(Object doc) {
        SubAwardDocument document = (SubAwardDocument)doc;
        SubAward subAward = document.getSubAward();
        GrantsSearchDocument esDoc = new GrantsSearchDocument();
        this.setGenericDocumentFields(esDoc, document);
        esDoc.setPrimaryKey(String.valueOf(subAward.getSubAwardId()));
        esDoc.setSubawardNumber(subAward.getSubAwardCode());
        esDoc.setNamespace(document.getNamespace());
        esDoc.setAccountId(subAward.getAccountNumber());
        esDoc.setSequenceNumber(subAward.getSequenceNumber());
        esDoc.setSequenceStatus(subAward.getSubAwardSequenceStatus());
        esDoc.setTypeCode(String.valueOf(subAward.getSubAwardTypeCode()));
        esDoc.setTypeDescription(String.valueOf(subAward.getSubAwardType().getDescription()));
        esDoc.setStatusCode(String.valueOf(subAward.getStatusCode()));
        esDoc.setStatusDescription(subAward.getStatusDescription());
        esDoc.setStartDate(DateUtils.toUtc(subAward.getStartDate()));
        esDoc.setEndDate(DateUtils.toUtc(subAward.getEndDate()));
        if (subAward.getExecutionDate() != null) {
            esDoc.addExecutionDate(DateUtils.toUtc(subAward.getExecutionDate()));
        }
        esDoc.setRequisitionerName(subAward.getRequisitionerName());
        this.getRolodex(subAward.getSiteInvestigatorId()).map(this::formatNameForElasticsearch).ifPresent(esDoc::setSiteInvestigatorName);
        esDoc.addSubrecipientOrganizationName(subAward.getSubAwardOrganizationName());
        esDoc.setPoNumber(subAward.getPurchaseOrderNum());
        esDoc.setNotifications(subAward.getSubAwardNotifications().stream().map(n -> new NotificationDocument(n.getSubject(), n.getMessage())).collect(Collectors.toList()));
        esDoc.setComments(subAward.getSubAwardComments().stream().map(c -> c.getComments()).filter(StringUtils::isNotEmpty).collect(Collectors.toSet()));
        esDoc.setNotes(subAward.getSubAwardNotepads().stream().map(n -> new NoteDocument(n.getNoteTopic(), n.getComments())).collect(Collectors.toList()));
        this.setSearchDocCustomDataIfEnabled(esDoc, subAward);
        this.setCommonFields(esDoc, subAward);
        return esDoc;
    }

    void setCommonFields(GrantsSearchDocument esDoc, SubAward subAward) {
        esDoc.setSubawardNumber(subAward.getSubAwardCode());
        esDoc.setTitle(subAward.getTitle());
        esDoc.setSponsorCode(subAward.getSponsorCode());
        esDoc.setSponsorName(subAward.getSponsorName());
        esDoc.setPrimeSponsorCode(subAward.getPrimeSponsorCode());
        esDoc.setPrimeSponsorName(subAward.getPrimeSponsorName());
        esDoc.setLeadUnitNumber(subAward.getLeadUnitNumber());
        esDoc.setLeadUnitName(subAward.getLeadUnitName());
        this.setSubAwardPersonFields(esDoc, subAward);
        this.getAwardForSubAward(subAward).ifPresent(linkedAward -> {
            esDoc.setAwardNumber(linkedAward.getAwardNumber());
            esDoc.setSponsorNumber(linkedAward.getSponsorAwardNumber());
            this.awardSerializer.setAwardPersonFields(esDoc, (Award)linkedAward);
        });
    }

    protected void setSubAwardPersonFields(GrantsSearchDocument esDoc, SubAward subAward) {
        esDoc.setPrincipalInvestigatorName(subAward.getSiteInvestigatorName());
        String requisitionerName = this.formatNameForElasticsearch(subAward.getRequisitioner());
        Stream<String> contactNames = subAward.getSubAwardContactsList().stream().map(SubAwardContact::getRolodex).map(this::formatNameForElasticsearch);
        Stream.concat(contactNames, Stream.of(requisitionerName)).filter(Objects::nonNull).forEach(esDoc::addAdministratorName);
    }

    protected Optional<Award> getAwardForSubAward(SubAward subAward) {
        if (subAward.getSubAwardFundingSourceList() != null && subAward.getSubAwardFundingSourceList().size() > 0) {
            return subAward.getSubAwardFundingSourceList().stream().max(Comparator.comparing(KcPersistableBusinessObjectBase::getUpdateTimestamp)).map(SubAwardFundingSource::getAward).map(award -> {
                Award workingAward = this.awardVersionService.getWorkingAwardVersion(award.getAwardNumber());
                return workingAward != null ? workingAward : award;
            });
        }
        return Optional.empty();
    }

    @Override
    public String getNamespace() {
        return "KC-SUBAWARD";
    }

    @Override
    public Set<String> getViewPermissions() {
        return Set.of("VIEW SUBAWARD");
    }

    @Override
    public boolean supports(Object document) {
        return document instanceof SubAwardDocument;
    }
}

