/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.personnel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetAddPersonnelPeriodEvent;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetSavePersonnelPeriodEvent;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.coeus.common.framework.ruleengine.KcEventResult;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;

@KcBusinessRule(value="budgetPersonnelPeriodRule")
public class BudgetPersonnelPeriodRule {
    public static final String PERSON_SEQUENCE_NUMBER = "personSequenceNumber";
    public static final String START_DATE = "startDate";
    public static final String PERCENT_EFFORT = "percentEffort";
    public static final String PERCENT_CHARGED = "percentCharged";
    public static final String END_DATE = "endDate";
    public static final String CAN_NOT_BE_AFTER = "can not be after";
    public static final String CAN_NOT_BE_BEFORE = "can not be before";
    public static final String LOWER_END_DATE = "end date";
    public static final String LOWER_START_DATE = "start date";

    @KcEventMethod
    public KcEventResult validateAddBudgetPersonnelPeriod(BudgetAddPersonnelPeriodEvent event) {
        KcEventResult result = new KcEventResult();
        result.getMessageMap().addToErrorPath(event.getErrorPath());
        this.verifyProjectPersonnel(event, result);
        this.verifyPersonnelEffortAndCharged(event.getBudgetPersonnelDetails(), result);
        this.verifyPersonnelDates(event.getBudgetPersonnelDetails(), event.getBudgetPeriod(), result);
        result.getMessageMap().removeFromErrorPath(event.getErrorPath());
        return result;
    }

    @KcEventMethod
    public KcEventResult validateSaveBudgetPersonnelPeriod(BudgetSavePersonnelPeriodEvent event) {
        KcEventResult result = new KcEventResult();
        result.getMessageMap().addToErrorPath(event.getErrorPath());
        this.verifyPersonnelEffortAndCharged(event.getBudgetPersonnelDetails(), result);
        this.verifyPersonnelDates(event.getBudgetPersonnelDetails(), event.getBudgetPeriod(), result);
        if (!this.isSummaryPerson(event.getBudgetPersonnelDetails())) {
            List<BudgetPersonnelDetails> budgetPersonnelDetails = this.getBudgetPersonnelDetails(event.getBudgetLineItem(), event.getBudgetPersonnelDetails(), event.getEditLineIndex());
            BudgetPersonnelPeriodRule.verifyDuplicatePerson(budgetPersonnelDetails, result, START_DATE);
        }
        result.getMessageMap().removeFromErrorPath(event.getErrorPath());
        return result;
    }

    protected void verifyProjectPersonnel(BudgetAddPersonnelPeriodEvent event, KcEventResult result) {
        BudgetLineItem newBudgetLineItem = event.getBudgetLineItem();
        BudgetPersonnelDetails newBudgetPersonnelDetails = event.getBudgetPersonnelDetails();
        List<BudgetLineItem> budgetLineItemList = event.getBudgetPeriod().getBudgetLineItems();
        String newBudgetCategoryTypeCode = newBudgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode();
        for (BudgetLineItem budgetLineItem : budgetLineItemList) {
            String existingBudgetCategoryTypeCode = budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode();
            if (!existingBudgetCategoryTypeCode.equalsIgnoreCase(newBudgetCategoryTypeCode) || !newBudgetLineItem.getCostElement().equalsIgnoreCase(budgetLineItem.getCostElement()) || !StringUtils.equals((CharSequence)newBudgetLineItem.getGroupName(), (CharSequence)budgetLineItem.getGroupName())) continue;
            if (this.isSummaryPerson(newBudgetPersonnelDetails)) {
                this.addSummaryPersonnelLineItemErrorMessage(budgetLineItem, event, result);
                break;
            }
            this.verifyPersonnel(budgetLineItem, newBudgetLineItem, newBudgetPersonnelDetails, event, result);
            if (result.getSuccess().booleanValue()) continue;
            break;
        }
    }

    protected boolean isSummaryPerson(BudgetPersonnelDetails budgetPersonnelDetails) {
        return budgetPersonnelDetails.getPersonSequenceNumber().equals(BudgetConstants.BudgetPerson.SUMMARYPERSON.getPersonSequenceNumber());
    }

    protected void addSummaryPersonnelLineItemErrorMessage(BudgetLineItem budgetLineItem, BudgetAddPersonnelPeriodEvent event, KcEventResult result) {
        String errorKey;
        String string = errorKey = event.getErrorKeyPerson() != null ? event.getErrorKeyPerson() : PERSON_SEQUENCE_NUMBER;
        if (budgetLineItem.getBudgetPersonnelDetailsList().isEmpty()) {
            result.getMessageMap().putError(errorKey, "error.summaryLineItemExists", new String[0]);
            result.setSuccess(false);
        } else {
            result.getMessageMap().putError(errorKey, "error.personnelExists", new String[0]);
            result.setSuccess(false);
        }
    }

    protected void verifyPersonnel(BudgetLineItem budgetLineItem, BudgetLineItem newBudgetLineItem, BudgetPersonnelDetails newBudgetPersonnelDetails, BudgetAddPersonnelPeriodEvent event, KcEventResult result) {
        String errorKey;
        String string = errorKey = event.getErrorKeyPerson() != null ? event.getErrorKeyPerson() : PERSON_SEQUENCE_NUMBER;
        if (budgetLineItem.getBudgetPersonnelDetailsList().isEmpty()) {
            result.getMessageMap().putError(errorKey, "error.summaryLineItemExists", new String[0]);
            result.setSuccess(false);
        } else {
            List<BudgetPersonnelDetails> budgetPersonnelDetails = this.getBudgetPersonnelDetails(budgetLineItem, newBudgetPersonnelDetails);
            BudgetPersonnelPeriodRule.verifyDuplicatePerson(budgetPersonnelDetails, result, START_DATE);
        }
    }

    public static void verifyDuplicatePerson(List<BudgetPersonnelDetails> budgetPersonnelDetailsList, KcEventResult result, String errorPath) {
        HashSet<String> uniquePersonDetails = new HashSet<String>();
        for (BudgetPersonnelDetails budgetPersonnelDetails : budgetPersonnelDetailsList) {
            if (uniquePersonDetails.add(BudgetPersonnelPeriodRule.getBudgetPersonnelPeriodUniqueKey(budgetPersonnelDetails))) continue;
            result.getMessageMap().putError(errorPath, "error.duplicate.personnel", new String[]{budgetPersonnelDetails.getBudgetPerson().getPersonName()});
            result.setSuccess(false);
            break;
        }
    }

    protected List<BudgetPersonnelDetails> getBudgetPersonnelDetails(BudgetLineItem budgetLineItem, BudgetPersonnelDetails newBudgetPersonnelDetails) {
        ArrayList<BudgetPersonnelDetails> budgetPersonnelDetailsList = new ArrayList<BudgetPersonnelDetails>();
        budgetPersonnelDetailsList.addAll(budgetLineItem.getBudgetPersonnelDetailsList());
        budgetPersonnelDetailsList.add(newBudgetPersonnelDetails);
        return budgetPersonnelDetailsList;
    }

    protected List<BudgetPersonnelDetails> getBudgetPersonnelDetails(BudgetLineItem budgetLineItem, BudgetPersonnelDetails newBudgetPersonnelDetails, int editLineIndex) {
        List<BudgetPersonnelDetails> budgetPersonnelDetailsList = this.getBudgetPersonnelDetails(budgetLineItem, newBudgetPersonnelDetails);
        BudgetPersonnelDetails existingBudgetPersonnelDetails = budgetPersonnelDetailsList.get(editLineIndex);
        budgetPersonnelDetailsList.remove(existingBudgetPersonnelDetails);
        return budgetPersonnelDetailsList;
    }

    public static String getBudgetPersonnelPeriodUniqueKey(BudgetPersonnelDetails budgetPersonnelDetails) {
        StringBuffer uniqueKey = new StringBuffer();
        uniqueKey.append(budgetPersonnelDetails.getPersonSequenceNumber());
        uniqueKey.append(budgetPersonnelDetails.getJobCode());
        uniqueKey.append(budgetPersonnelDetails.getStartDate());
        return uniqueKey.toString();
    }

    protected void verifyPersonnelEffortAndCharged(BudgetPersonnelDetails budgetPersonnelDetails, KcEventResult result) {
        if (budgetPersonnelDetails.getPercentEffort().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(100))) {
            result.getMessageMap().putError(PERCENT_EFFORT, "error.percentage", new String[]{"Percent Effort"});
            result.setSuccess(false);
        }
        if (budgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(100))) {
            result.getMessageMap().putError(PERCENT_CHARGED, "error.percentage", new String[]{"Percent Charged"});
            result.setSuccess(false);
        }
        if (budgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractDecimal)budgetPersonnelDetails.getPercentEffort())) {
            result.getMessageMap().putError(PERCENT_CHARGED, "error.percentEffort.lessThan.percentCharged", new String[0]);
            result.setSuccess(false);
        }
    }

    protected void verifyPersonnelDates(BudgetPersonnelDetails budgetPersonnelDetails, BudgetPeriod budgetPeriod, KcEventResult result) {
        if (budgetPersonnelDetails.getEndDate().compareTo(budgetPersonnelDetails.getStartDate()) < 0) {
            result.getMessageMap().putError(END_DATE, "error.personnel.detail.dates", new String[0]);
            result.setSuccess(false);
        }
        if (budgetPeriod.getEndDate().compareTo(budgetPersonnelDetails.getEndDate()) < 0) {
            result.getMessageMap().putError(END_DATE, "error.personnel.detail.end.date", new String[]{CAN_NOT_BE_AFTER, LOWER_END_DATE});
            result.setSuccess(false);
        }
        if (budgetPeriod.getStartDate().compareTo(budgetPersonnelDetails.getEndDate()) > 0) {
            result.getMessageMap().putError(END_DATE, "error.personnel.detail.end.date", new String[]{CAN_NOT_BE_BEFORE, LOWER_START_DATE});
            result.setSuccess(false);
        }
        if (budgetPeriod.getStartDate().compareTo(budgetPersonnelDetails.getStartDate()) > 0) {
            result.getMessageMap().putError(START_DATE, "error.personnel.detail.start.date", new String[]{CAN_NOT_BE_BEFORE, LOWER_START_DATE});
            result.setSuccess(false);
        }
        if (budgetPeriod.getEndDate().compareTo(budgetPersonnelDetails.getStartDate()) < 0) {
            result.getMessageMap().putError(START_DATE, "error.personnel.detail.start.date", new String[]{CAN_NOT_BE_AFTER, LOWER_END_DATE});
            result.setSuccess(false);
        }
    }
}

