/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.state;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyService;
import org.kuali.coeus.propdev.impl.state.ProposalStateService;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalStateService")
public class ProposalStateServiceImpl
implements ProposalStateService {
    @Autowired
    @Qualifier(value="proposalHierarchyService")
    private ProposalHierarchyService proposalHierarchyService;
    @Autowired
    @Qualifier(value="kcWorkflowService")
    private KcWorkflowService kcWorkflowService;

    @Override
    public String getProposalStateTypeCode(ProposalDevelopmentDocument proposalDevelopmentDocument, boolean isRejectAction) {
        WorkflowDocument wd = proposalDevelopmentDocument.getDocumentHeader().getWorkflowDocument();
        if (wd.isInitiated()) {
            return "1";
        }
        if (wd.isSaved()) {
            return this.computeProposalStateForSaved(proposalDevelopmentDocument, isRejectAction);
        }
        if (wd.isEnroute()) {
            return this.computeProposalStateForEnRoute(proposalDevelopmentDocument, isRejectAction);
        }
        if (wd.isApproved()) {
            return this.computeProposalStateForApproved(proposalDevelopmentDocument);
        }
        if (wd.isDisapproved()) {
            return this.computeProposalStateForDisapproved(proposalDevelopmentDocument);
        }
        if (wd.isCanceled()) {
            return "10";
        }
        return "11";
    }

    protected String computeProposalStateForSaved(ProposalDevelopmentDocument proposalDevelopmentDocument, boolean isRejectAction) {
        if (this.isSubmitted(proposalDevelopmentDocument)) {
            return "4";
        }
        if (isRejectAction) {
            return "12";
        }
        return "1";
    }

    protected String computeProposalStateForEnRoute(ProposalDevelopmentDocument proposalDevelopmentDocument, boolean isRejectAction) {
        String proposalStateTypeCode = proposalDevelopmentDocument.getDevelopmentProposal().getProposalStateTypeCode();
        if (isRejectAction) {
            return "12";
        }
        if (this.isSubmitted(proposalDevelopmentDocument) && !this.isFinalApproval(proposalDevelopmentDocument.getDocumentHeader().getWorkflowDocument()) || StringUtils.equals((CharSequence)proposalStateTypeCode, (CharSequence)"5")) {
            return "5";
        }
        return "2";
    }

    protected boolean isFinalApproval(WorkflowDocument workflowDocument) {
        return StringUtils.isNotEmpty((CharSequence)workflowDocument.getDocumentId()) && this.getKcWorkflowService().isFinalApproval(workflowDocument);
    }

    protected String computeProposalStateForApproved(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        String proposalStateTypeCode = proposalDevelopmentDocument.getDevelopmentProposal().getProposalStateTypeCode();
        if (this.isSubmitted(proposalDevelopmentDocument)) {
            if (StringUtils.equals((CharSequence)proposalStateTypeCode, (CharSequence)"5") || StringUtils.equals((CharSequence)proposalStateTypeCode, (CharSequence)"8")) {
                return "8";
            }
            return "6";
        }
        return "3";
    }

    protected String computeProposalStateForDisapproved(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        if (this.isSubmitted(proposalDevelopmentDocument)) {
            return "9";
        }
        return "7";
    }

    protected boolean isSubmitted(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        return proposalDevelopmentDocument.getDevelopmentProposal().getSubmitFlag();
    }

    public ProposalHierarchyService getProposalHierarchyService() {
        return this.proposalHierarchyService;
    }

    public void setProposalHierarchyService(ProposalHierarchyService proposalHierarchyService) {
        this.proposalHierarchyService = proposalHierarchyService;
    }

    public KcWorkflowService getKcWorkflowService() {
        return this.kcWorkflowService;
    }

    public void setKcWorkflowService(KcWorkflowService kcWorkflowService) {
        this.kcWorkflowService = kcWorkflowService;
    }
}

