/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.auth;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.kuali.coeus.sys.impl.auth.KimPersonLite;
import org.kuali.coeus.sys.impl.auth.KimPersonLiteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="kimPersonLiteService")
public class KimPersonLiteServiceImpl
implements KimPersonLiteService {
    private static final String KIM_PERSON_LITE_QUERY = "select\n  kpt.PRNCPL_ID,\n  kpt.PRNCPL_NM,\n  UPPER(kpt.ACTV_IND) AS ACTV_IND,\n  kent.FIRST_NM,\n  kent.LAST_NM,\n  keet.EMAIL_ADDR,\n  kept.PHONE_NBR,\n  keeit.PRMRY_DEPT_CD,\n  CASE\n    WHEN UPPER(keett.ENT_TYP_CD) = 'SYSTEM' THEN UPPER(kpt.PRNCPL_NM)\n    ELSE TRIM(CONCAT(\n      COALESCE(kent.LAST_NM, ''),\n      IF(kent.LAST_NM IS NULL OR kent.LAST_NM = '', '', ', '),\n      COALESCE(kent.FIRST_NM, ''),\n      IF(kent.FIRST_NM IS NULL OR kent.FIRST_NM = '', '', ' '),\n      COALESCE(kent.MIDDLE_NM, '')\n    ))\n  END AS NAME\nfrom krim_prncpl_t kpt\n  left outer join krim_entity_t ket on ket.ENTITY_ID = kpt.ENTITY_ID\n  left outer join krim_entity_ent_typ_t keett on keett.ENTITY_ID = kpt.ENTITY_ID and (keett.ACTV_IND = 'Y' OR keett.ACTV_IND = 'y')\n  left outer join krim_entity_nm_t kent on kent.ENTITY_ID = kpt.ENTITY_ID and (kent.ACTV_IND = 'Y' OR kent.ACTV_IND = 'y') and (kent.DFLT_IND = 'Y' OR kent.DFLT_IND = 'y')\n  left outer join krim_entity_email_t keet on keet.ENTITY_ID = kpt.ENTITY_ID and (keet.ACTV_IND = 'Y' OR keet.ACTV_IND = 'y') and (keet.DFLT_IND = 'Y' OR keet.DFLT_IND = 'y')\n  left outer join krim_entity_phone_t kept on kept.ENTITY_ID = kpt.ENTITY_ID and (kept.ACTV_IND = 'Y' OR kept.ACTV_IND = 'y') and (kept.DFLT_IND = 'Y' OR kept.DFLT_IND = 'y')\n  left outer join krim_entity_emp_info_t keeit on keeit.ENTITY_ID = kpt.ENTITY_ID and (keeit.ACTV_IND = 'Y' OR keeit.ACTV_IND = 'y') and (keeit.PRMRY_IND = 'Y' OR keeit.PRMRY_IND = 'y')\n";
    @Autowired
    @Qualifier(value="riceDataSource")
    private DataSource riceDataSource;

    @Override
    public List<KimPersonLite> getAllPeople() {
        ArrayList<KimPersonLite> people = new ArrayList<KimPersonLite>();
        try (Connection riceConn = this.riceDataSource.getConnection();
             PreparedStatement personeStmt = riceConn.prepareStatement(KIM_PERSON_LITE_QUERY);
             ResultSet personResultSet = personeStmt.executeQuery();){
            while (personResultSet.next()) {
                KimPersonLite person = new KimPersonLite();
                person.setPrincipalId(personResultSet.getString("PRNCPL_ID"));
                person.setPrincipalName(personResultSet.getString("PRNCPL_NM"));
                person.setActive("Y".equals(personResultSet.getString("ACTV_IND")));
                person.setFirstName(personResultSet.getString("FIRST_NM"));
                person.setLastName(personResultSet.getString("LAST_NM"));
                person.setEmailAddress(personResultSet.getString("EMAIL_ADDR"));
                person.setPhoneNumber(personResultSet.getString("PHONE_NBR"));
                person.setPrimaryDepartmentCode(personResultSet.getString("PRMRY_DEPT_CD"));
                person.setName(personResultSet.getString("NAME"));
                people.add(person);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return people;
    }

    public DataSource getRiceDataSource() {
        return this.riceDataSource;
    }

    public void setRiceDataSource(DataSource riceDataSource) {
        this.riceDataSource = riceDataSource;
    }
}

