/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.List;
import java.util.stream.Collectors;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.AwardLimitedEditAuthorizationService;
import org.kuali.kra.award.notesandattachments.attachments.AwardAttachmentType;
import org.kuali.kra.lookup.keyvalue.ActivatableValuesFinder;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardAttachmentTypeValuesFinder
extends ActivatableValuesFinder<AwardAttachmentType> {
    private static final long serialVersionUID = 1L;
    private AwardLimitedEditAuthorizationService awardLimitedEditAuthorizationService;

    @Override
    public List getKeyValues() {
        List<KeyValue> keyValues = super.getKeyValues();
        if (this.getAwardLimitedEditAuthorizationService().canLimitedModifyAwardAttachments((AwardDocument)this.getDocument(), GlobalVariables.getUserSession().getPrincipalId())) {
            List<String> attachmentTypes = this.getAwardLimitedEditAuthorizationService().getLimitedEditabilityAwardAttachmentTypes();
            return keyValues.stream().filter(keyValue -> attachmentTypes.contains(keyValue.getKey()) || keyValue.getKey().isEmpty()).collect(Collectors.toList());
        }
        return keyValues;
    }

    @Override
    protected String getKey(AwardAttachmentType activatable) {
        return activatable.getTypeCode();
    }

    @Override
    protected String getValue(AwardAttachmentType activatable) {
        return activatable.getDescription();
    }

    @Override
    protected String getCurrentValue() {
        return "";
    }

    public AwardLimitedEditAuthorizationService getAwardLimitedEditAuthorizationService() {
        if (this.awardLimitedEditAuthorizationService == null) {
            this.awardLimitedEditAuthorizationService = KcServiceLocator.getService(AwardLimitedEditAuthorizationService.class);
        }
        return this.awardLimitedEditAuthorizationService;
    }

    public void setAwardLimitedEditAuthorizationService(AwardLimitedEditAuthorizationService awardLimitedEditAuthorizationService) {
        this.awardLimitedEditAuthorizationService = awardLimitedEditAuthorizationService;
    }
}

