/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports.reporting.service;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.paymentreports.ReportStatus;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTrackingBean;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingService;
import org.kuali.kra.award.service.AwardScheduleGenerationService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ReportTrackingServiceImpl
implements ReportTrackingService {
    public static final String DUE_STATUS_DESCRIPTION = "Due";
    public static final String PENDING_STATUS_DESCRIPTION = "Pending";
    public static final String REPORT_CLASS = "reportClass";
    public static final String REPORT_STATUS_CODE = "REPORT_STATUS_CODE";
    public static final String DESCRIPTION = "DESCRIPTION";
    private AwardScheduleGenerationService awardScheduleGenerationService;
    private BusinessObjectService businessObjectService;
    private AwardService awardService;

    @Override
    public void refreshReportTracking(Award award) throws ParseException {
        ArrayList<AwardReportTerm> awardReportTermItems = new ArrayList<AwardReportTerm>(award.getAwardReportTermItems());
        for (AwardReportTerm awardTerm : awardReportTermItems) {
            ArrayList<AwardReportTerm> awardReportTerms = new ArrayList<AwardReportTerm>();
            awardReportTerms.add(awardTerm);
            List<Date> dates = this.generateSchedules(award, awardReportTerms);
            if (awardTerm.getReportTrackings() == null) {
                awardTerm.setReportTrackings(this.getReportTracking(awardTerm));
            }
            if (this.autoRegenerateReports(award) && award.getPrincipalInvestigator() != null) {
                this.synchronizeReportsWithDates(award, awardTerm, dates);
            }
            Collections.sort(awardTerm.getReportTrackings());
        }
    }

    @Override
    public void generateReportTrackingAndSave(Award award, boolean forceReportRegeneration) throws ParseException {
        if ((forceReportRegeneration || this.autoRegenerateReports(award)) && award.getPrincipalInvestigator() != null) {
            List<AwardReportTerm> awardReportTermItems = award.getAwardReportTermItems();
            ArrayList<ReportTracking> reportsToSave = new ArrayList<ReportTracking>();
            ArrayList<ReportTracking> reportsToDelete = new ArrayList<ReportTracking>();
            for (AwardReportTerm awardTerm : awardReportTermItems) {
                awardTerm.refreshReferenceObject(REPORT_CLASS);
                if (awardTerm.getReportTrackings() == null) {
                    awardTerm.setReportTrackings(this.getReportTracking(awardTerm));
                }
                if (!awardTerm.getReportClass().getGenerateReportRequirements()) {
                    reportsToSave.addAll(awardTerm.getReportTrackings());
                    continue;
                }
                ArrayList<AwardReportTerm> awardReportTerms = new ArrayList<AwardReportTerm>();
                awardReportTerms.add(awardTerm);
                List<Date> dates = this.generateSchedules(award, awardReportTerms);
                reportsToDelete.addAll(this.findOutdatedTrackings(awardTerm, dates));
                this.synchronizeReportsWithDates(award, awardTerm, dates);
                reportsToSave.addAll(awardTerm.getReportTrackings());
            }
            for (ReportTracking rt : reportsToSave) {
                ReportTracking dbRt;
                if (rt.getAwardReportTrackingId() == null || !rt.hasBeenUpdated(dbRt = (ReportTracking)this.getBusinessObjectService().findByPrimaryKey(ReportTracking.class, Collections.singletonMap("awardReportTrackingId", rt.getAwardReportTrackingId())))) continue;
                rt.setLastUpdateDate(new Timestamp(new java.util.Date().getTime()));
                rt.setLastUpdateUser(GlobalVariables.getUserSession().getPrincipalName());
            }
            this.getBusinessObjectService().save(reportsToSave);
            this.getBusinessObjectService().delete(reportsToDelete);
        }
    }

    protected void synchronizeReportsWithDates(Award award, AwardReportTerm awardTerm, List<Date> dates) {
        if (dates.size() == 0 && awardTerm.getReportTrackings().size() == 0) {
            ReportTracking rt2 = this.buildReportTracking(award, awardTerm, awardTerm.getDueDate());
            awardTerm.getReportTrackings().add(rt2);
            return;
        }
        awardTerm.getReportTrackings().removeAll(this.findOutdatedTrackings(awardTerm, dates));
        awardTerm.getReportTrackings().addAll(this.generateNewReportTrackings(award, awardTerm, dates));
        awardTerm.getReportTrackings().forEach(rt -> this.updateReportProperties(award, awardTerm, (ReportTracking)rt, dates));
        Collections.sort(awardTerm.getReportTrackings());
    }

    protected List<ReportTracking> findOutdatedTrackings(AwardReportTerm awardTerm, List<Date> dates) {
        ReportStatus pendingStatus = this.getPendingReportStatus();
        return pendingStatus == null ? Collections.emptyList() : awardTerm.getReportTrackings().stream().filter(rt -> StringUtils.equals((CharSequence)pendingStatus.getReportStatusCode(), (CharSequence)rt.getStatusCode())).filter(rt -> !dates.contains(rt.getDueDate())).collect(Collectors.toList());
    }

    protected List<ReportTracking> generateNewReportTrackings(Award award, AwardReportTerm awardTerm, List<Date> dates) {
        return dates.stream().filter(date -> awardTerm.getReportTrackings().stream().noneMatch(rt -> date.equals(rt.getDueDate()))).map(date -> this.buildReportTracking(award, awardTerm, (Date)date)).collect(Collectors.toList());
    }

    protected void updateReportProperties(Award award, AwardReportTerm awardTerm, ReportTracking reportTracking, List<Date> dates) {
        this.copyAwardTermPropertiesToReport(awardTerm, reportTracking);
        this.copyAwardPropertiesToReport(award, reportTracking);
        if (dates != null) {
            reportTracking.setAutoGenerated(dates.contains(reportTracking.getDueDate()));
        }
    }

    protected ReportTracking buildReportTracking(Award award, AwardReportTerm awardTerm, Date dueDate) {
        awardTerm.refresh();
        ReportTracking reportTracking = new ReportTracking();
        reportTracking.setAwardNumber(award.getAwardNumber());
        reportTracking.setAwardId(award.getAwardId());
        reportTracking.setAwardReportTermId(awardTerm.getAwardReportTermId());
        reportTracking.setDueDate(dueDate);
        reportTracking.setLastUpdateDate(new Timestamp(new java.util.Date().getTime()));
        reportTracking.setLastUpdateUser(null);
        ReportStatus pending = this.getPendingReportStatus();
        reportTracking.setReportStatus(pending);
        reportTracking.setStatusCode(pending.getReportStatusCode());
        reportTracking.setBaseDate(this.calculateBaseDate(awardTerm));
        reportTracking.setAutoGenerated(true);
        this.copyAwardTermPropertiesToReport(awardTerm, reportTracking);
        this.copyAwardPropertiesToReport(award, reportTracking);
        return reportTracking;
    }

    protected void copyAwardTermPropertiesToReport(AwardReportTerm awardTerm, ReportTracking reportTracking) {
        reportTracking.setFrequency(awardTerm.getFrequency());
        reportTracking.setFrequencyBase(awardTerm.getFrequencyBase());
        reportTracking.setFrequencyBaseCode(awardTerm.getFrequencyBaseCode());
        reportTracking.setFrequencyCode(awardTerm.getFrequencyCode());
        reportTracking.setOspDistributionCode(awardTerm.getOspDistributionCode());
        reportTracking.setReport(awardTerm.getReport());
        reportTracking.setReportClass(awardTerm.getReportClass());
        reportTracking.setReportClassCode(awardTerm.getReportClassCode());
        reportTracking.setReportCode(awardTerm.getReportCode());
    }

    protected void copyAwardPropertiesToReport(Award award, ReportTracking reportTracking) {
        reportTracking.setLeadUnit(award.getLeadUnit());
        reportTracking.setLeadUnitNumber(award.getLeadUnitNumber());
        reportTracking.setPiName(award.getPrincipalInvestigatorName());
        if (award.getPrincipalInvestigator() != null) {
            reportTracking.setPiPersonId(award.getPrincipalInvestigator().getPersonId());
            reportTracking.setPiRolodexId(award.getPrincipalInvestigator().getRolodexId());
        }
        reportTracking.setSponsor(award.getSponsor());
        reportTracking.setSponsorAwardNumber(award.getSponsorAwardNumber());
        reportTracking.setSponsorCode(award.getSponsorCode());
        reportTracking.setTitle(award.getTitle());
    }

    protected Date calculateBaseDate(AwardReportTerm awardTerm) {
        Date returnDate = null;
        if (awardTerm != null && awardTerm.getFrequencyBaseCode() != null) {
            if (StringUtils.equalsIgnoreCase((CharSequence)awardTerm.getFrequencyBaseCode(), (CharSequence)"1")) {
                returnDate = awardTerm.getAward().getAwardExecutionDate();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)awardTerm.getFrequencyBaseCode(), (CharSequence)"2")) {
                returnDate = awardTerm.getAward().getAwardEffectiveDate();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)awardTerm.getFrequencyBaseCode(), (CharSequence)"3")) {
                returnDate = awardTerm.getAward().getLastAwardAmountInfo().getObligationExpirationDate();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)awardTerm.getFrequencyBaseCode(), (CharSequence)"4")) {
                returnDate = awardTerm.getAward().getLastAwardAmountInfo().getFinalExpirationDate();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)awardTerm.getFrequencyBaseCode(), (CharSequence)"5")) {
                returnDate = awardTerm.getAward().getLastAwardAmountInfo().getCurrentFundEffectiveDate();
            }
        }
        return returnDate;
    }

    protected List<Date> generateSchedules(Award award, List<AwardReportTerm> awardReportTerms) throws ParseException {
        return this.getAwardScheduleGenerationService().generateSchedules(award, awardReportTerms, true).stream().map(date -> new Date(date.getTime())).collect(Collectors.toList());
    }

    @Override
    public ReportStatus getDueReportStatus() {
        Map<String, String> params = Collections.singletonMap(DESCRIPTION, DUE_STATUS_DESCRIPTION);
        return (ReportStatus)this.getBusinessObjectService().findByPrimaryKey(ReportStatus.class, params);
    }

    @Override
    public ReportStatus getPendingReportStatus() {
        Map<String, String> params = Collections.singletonMap(DESCRIPTION, PENDING_STATUS_DESCRIPTION);
        return (ReportStatus)this.getBusinessObjectService().findByPrimaryKey(ReportStatus.class, params);
    }

    @Override
    public List<ReportTracking> getReportTracking(AwardReportTerm awardTerm) {
        Map<String, Long> params = Collections.singletonMap("awardReportTermId", awardTerm.getAwardReportTermId());
        ArrayList<ReportTracking> reportTrackings = new ArrayList<ReportTracking>(this.getBusinessObjectService().findMatching(ReportTracking.class, params));
        Collections.sort(reportTrackings);
        return reportTrackings;
    }

    @Override
    public List<ReportTracking> getReportTracking(Award award) {
        Map<String, Long> params = Collections.singletonMap("awardId", award.getAwardId());
        ArrayList<ReportTracking> reportTrackings = new ArrayList<ReportTracking>(this.getBusinessObjectService().findMatching(ReportTracking.class, params));
        Collections.sort(reportTrackings);
        return reportTrackings;
    }

    @Override
    public boolean autoRegenerateReports(Award award) {
        boolean retVal = StringUtils.endsWith((CharSequence)award.getAwardNumber(), (CharSequence)"-00001");
        if (!retVal) {
            for (AwardReportTerm term : award.getAwardReportTermItems()) {
                List<ReportTracking> tracking = this.getReportTracking(term);
                if (tracking.isEmpty()) continue;
                return true;
            }
        }
        return retVal;
    }

    @Override
    public void setReportTrackingListSelected(List<ReportTracking> reportTrackingListing, boolean selectedValue) {
        for (ReportTracking rt : reportTrackingListing) {
            rt.setMultiEditSelected(selectedValue);
        }
    }

    @Override
    public void updateMultipleReportTrackingRecords(List<ReportTracking> reportTrackingListing, ReportTrackingBean reportTrackingBean) {
        for (ReportTracking rt : reportTrackingListing) {
            if (!rt.getMultiEditSelected()) continue;
            if (StringUtils.isNotBlank((CharSequence)reportTrackingBean.getComments())) {
                rt.setComments(reportTrackingBean.getComments());
            }
            if (StringUtils.isNotBlank((CharSequence)reportTrackingBean.getPreparerId())) {
                rt.setPreparerId(reportTrackingBean.getPreparerId());
                rt.setPreparerName(reportTrackingBean.getPreparerName());
            }
            if (reportTrackingBean.getActivityDate() != null) {
                rt.setActivityDate(reportTrackingBean.getActivityDate());
            }
            if (!StringUtils.isNotBlank((CharSequence)reportTrackingBean.getStatusCode())) continue;
            rt.setStatusCode(reportTrackingBean.getStatusCode());
            rt.setReportStatus(this.getReportStatus(reportTrackingBean.getStatusCode()));
        }
    }

    protected ReportStatus getReportStatus(String statusCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(REPORT_STATUS_CODE, statusCode);
        ReportStatus rs = (ReportStatus)this.getBusinessObjectService().findByPrimaryKey(ReportStatus.class, params);
        return rs;
    }

    @Override
    public boolean shouldAlertReportTrackingDetailChange(Award award) {
        List<ReportTracking> dbReportTrackings;
        Award dbAward;
        boolean retVal = false;
        if (award.getAwardId() != null && (dbAward = this.getAwardService().getAward(award.getAwardId())) != null && (dbReportTrackings = this.getReportTracking(dbAward)) != null && !dbReportTrackings.isEmpty()) {
            retVal = !this.dateCompare(award.getAwardExecutionDate(), dbAward.getAwardExecutionDate()) || !this.dateCompare(award.getAwardEffectiveDate(), dbAward.getAwardEffectiveDate()) || !this.dateCompare(award.getLastAwardAmountInfo().getObligationExpirationDate(), dbAward.getLastAwardAmountInfo().getObligationExpirationDate()) || !this.dateCompare(award.getLastAwardAmountInfo().getFinalExpirationDate(), dbAward.getLastAwardAmountInfo().getFinalExpirationDate()) || !this.dateCompare(award.getLastAwardAmountInfo().getCurrentFundEffectiveDate(), dbAward.getLastAwardAmountInfo().getCurrentFundEffectiveDate());
        }
        return retVal;
    }

    private boolean dateCompare(Date formDate, Date dbDate) {
        boolean retVal = false;
        if (formDate == null && dbDate == null) {
            retVal = true;
        } else if (formDate != null && dbDate != null && formDate.equals(dbDate)) {
            retVal = true;
        }
        return retVal;
    }

    public AwardScheduleGenerationService getAwardScheduleGenerationService() {
        return this.awardScheduleGenerationService;
    }

    public void setAwardScheduleGenerationService(AwardScheduleGenerationService awardScheduleGenerationService) {
        this.awardScheduleGenerationService = awardScheduleGenerationService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }
}

