/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.subcontracting.reporting;

import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.subcontracting.reporting.SubcontractingExpenditureCategoryAmounts;
import org.kuali.kra.award.subcontracting.reporting.SubcontractingExpenditureCategoryAmountsBase;
import org.kuali.kra.award.subcontracting.reporting.SubcontractingExpenditureCategoryAmountsInDateRange;
import org.kuali.kra.award.subcontracting.reporting.SubcontractingExpenditureCategoryDetails;
import org.kuali.kra.award.subcontracting.reporting.SubcontractingExpenditureCategoryService;
import org.kuali.kra.award.subcontracting.reporting.dao.SubcontractingExpenditureCategoryDetailsDao;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class SubcontractingExpenditureCategoryServiceImpl
implements SubcontractingExpenditureCategoryService {
    private static final String AWARD_NUMBER = "awardNumber";
    private SubcontractingExpenditureCategoryDetailsDao detailsDao;
    private BusinessObjectService businessObjectService;

    @Override
    public void populateAllAvailableCategoryExpenses() {
        List detailBOs = this.getBusinessObjectService().findAll(SubcontractingExpenditureCategoryDetails.class);
        this.deleteAllExistingExpenditureCategoryAmountsBOs();
        this.populateAndSaveExpenditureCategoryAmountsBOs(detailBOs);
    }

    public void deleteAllExistingExpenditureCategoryAmountsBOs() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(AWARD_NUMBER, "*");
        this.getBusinessObjectService().deleteMatching(SubcontractingExpenditureCategoryAmounts.class, fieldValues);
    }

    @Override
    public void populateCategoryExpensesInDateRange(Date rangeStartDate, Date rangeEndDate) {
        if (rangeStartDate == null || rangeEndDate == null) {
            throw new IllegalArgumentException("Both start and end date of the range have to be non-null");
        }
        List<SubcontractingExpenditureCategoryDetails> detailBOs = this.getDetailsDao().findCategoryDetailsByFiscalPeriodRange(rangeStartDate, rangeEndDate);
        this.deleteAllExistingExpenditureCategoryAmountsDateRangeBOs();
        this.populateAndSaveExpenditureCategoryAmountsInRangeBOs(detailBOs, rangeStartDate, rangeEndDate);
    }

    public void deleteAllExistingExpenditureCategoryAmountsDateRangeBOs() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(AWARD_NUMBER, "*");
        this.getBusinessObjectService().deleteMatching(SubcontractingExpenditureCategoryAmountsInDateRange.class, fieldValues);
    }

    private void populateAndSaveExpenditureCategoryAmountsInRangeBOs(Collection<SubcontractingExpenditureCategoryDetails> detailsBOs, Date rangeStartDate, Date rangeEndDate) {
        HashMap<String, SubcontractingExpenditureCategoryAmountsInDateRange> awardNumberToAmountsBOAssoc = new HashMap<String, SubcontractingExpenditureCategoryAmountsInDateRange>();
        for (SubcontractingExpenditureCategoryDetails detailsBO : detailsBOs) {
            SubcontractingExpenditureCategoryAmountsInDateRange amountsInDateRangeBO;
            String awardNumber = detailsBO.getAwardNumber();
            if (awardNumberToAmountsBOAssoc.containsKey(awardNumber)) {
                amountsInDateRangeBO = (SubcontractingExpenditureCategoryAmountsInDateRange)awardNumberToAmountsBOAssoc.get(awardNumber);
            } else {
                amountsInDateRangeBO = new SubcontractingExpenditureCategoryAmountsInDateRange(awardNumber, rangeStartDate, rangeEndDate);
                awardNumberToAmountsBOAssoc.put(amountsInDateRangeBO.getAwardNumber(), amountsInDateRangeBO);
            }
            this.incrementCategoryAmountsUsingDetails(amountsInDateRangeBO, detailsBO);
        }
        for (SubcontractingExpenditureCategoryAmountsInDateRange amountsBOToBeSaved : awardNumberToAmountsBOAssoc.values()) {
            this.getBusinessObjectService().save((PersistableBusinessObject)amountsBOToBeSaved);
        }
    }

    private void populateAndSaveExpenditureCategoryAmountsBOs(Collection<SubcontractingExpenditureCategoryDetails> detailsBOs) {
        HashMap<String, SubcontractingExpenditureCategoryAmounts> awardNumberToAmountsBOAssoc = new HashMap<String, SubcontractingExpenditureCategoryAmounts>();
        for (SubcontractingExpenditureCategoryDetails detailsBO : detailsBOs) {
            SubcontractingExpenditureCategoryAmounts amountsBO;
            String awardNumber = detailsBO.getAwardNumber();
            if (awardNumberToAmountsBOAssoc.containsKey(awardNumber)) {
                amountsBO = (SubcontractingExpenditureCategoryAmounts)awardNumberToAmountsBOAssoc.get(awardNumber);
            } else {
                amountsBO = new SubcontractingExpenditureCategoryAmounts(awardNumber);
                awardNumberToAmountsBOAssoc.put(amountsBO.getAwardNumber(), amountsBO);
            }
            this.incrementCategoryAmountsUsingDetails(amountsBO, detailsBO);
        }
        for (SubcontractingExpenditureCategoryAmounts amountsBOToBeSaved : awardNumberToAmountsBOAssoc.values()) {
            this.getBusinessObjectService().save((PersistableBusinessObject)amountsBOToBeSaved);
        }
    }

    private void incrementCategoryAmountsUsingDetails(SubcontractingExpenditureCategoryAmountsBase amountsBO, SubcontractingExpenditureCategoryDetails detailsBO) {
        ScaleTwoDecimal detailAmount = detailsBO.getAmount();
        if (detailsBO.isLargeBusiness()) {
            amountsBO.addToLargeBusinessExpenditureAmount(detailAmount);
        }
        if (detailsBO.isSmallBusiness()) {
            amountsBO.addToSmallBusinessExpenditureAmount(detailAmount);
        }
        if (detailsBO.isWomanOwned()) {
            amountsBO.addToWomanOwnedExpenditureAmount(detailAmount);
        }
        if (detailsBO.isEightADisadvantage()) {
            amountsBO.addToEightADisadvantageExpenditureAmount(detailAmount);
        }
        if (detailsBO.isHubZone()) {
            amountsBO.addToHubZoneExpenditureAmount(detailAmount);
        }
        if (detailsBO.isVeteranOwned()) {
            amountsBO.addToVeteranOwnedExpenditureAmount(detailAmount);
        }
        if (detailsBO.isServiceDisabledVeteranOwned()) {
            amountsBO.addToServiceDisabledVeteranOwnedExpenditureAmount(detailAmount);
        }
        if (detailsBO.isHistoricalBlackCollege()) {
            amountsBO.addToHistoricalBlackCollegeExpenditureAmount(detailAmount);
        }
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KNSServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setDetailsDao(SubcontractingExpenditureCategoryDetailsDao detailsDao) {
        this.detailsDao = detailsDao;
    }

    public SubcontractingExpenditureCategoryDetailsDao getDetailsDao() {
        return this.detailsDao;
    }
}

