/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.abstrct;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.abstrct.AbstractType;
import org.kuali.coeus.propdev.impl.abstrct.AbstractsRule;
import org.kuali.coeus.propdev.impl.abstrct.ProposalAbstract;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentAbstractsRule
extends KcTransactionalDocumentRuleBase
implements AbstractsRule {
    private DataObjectService dataObjectService;

    @Override
    protected DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    @Override
    public boolean processAddAbstractBusinessRules(ProposalDevelopmentDocument document, ProposalAbstract proposalAbstract) {
        boolean isValid = true;
        String abstractTypeCode = proposalAbstract.getAbstractTypeCode();
        if (StringUtils.isBlank((CharSequence)abstractTypeCode)) {
            isValid = false;
            GlobalVariables.getMessageMap().putError("newProposalAbstract.abstractTypeCode", "error.abstractType.notselected", new String[0]);
        } else if (this.isInvalid(abstractTypeCode)) {
            isValid = false;
            this.reportError("newProposalAbstract", "error.abstractType.invalid", new String[0]);
        } else if (this.isDuplicate(document, abstractTypeCode)) {
            isValid = false;
            this.reportError("newProposalAbstract", "error.abstractType.duplicate", new String[0]);
        }
        return isValid;
    }

    private boolean isInvalid(String abstractTypeCode) {
        if (abstractTypeCode != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("code", abstractTypeCode);
            if (this.getDataObjectService().findMatching(AbstractType.class, QueryByCriteria.Builder.andAttributes(fieldValues).setCountFlag(CountFlag.ONLY).build()).getTotalRowCount() == 1) {
                return false;
            }
        }
        return true;
    }

    private boolean isDuplicate(ProposalDevelopmentDocument document, String abstractTypeCode) {
        List<ProposalAbstract> proposalAbstracts = document.getDevelopmentProposal().getProposalAbstracts();
        for (ProposalAbstract proposalAbstract : proposalAbstracts) {
            if (!proposalAbstract.getAbstractTypeCode().equals(abstractTypeCode)) continue;
            return true;
        }
        return false;
    }
}

