/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.controller;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.controller.DocHandlerService;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.api.parameter.EvaluationOperator;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.api.parameter.ParameterType;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="docHandlerService")
public class DocHandlerServiceImpl
implements DocHandlerService,
InitializingBean {
    @Autowired
    @Qualifier(value="routeHeaderService")
    private RouteHeaderService routeHeaderService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;

    @Override
    public String getDocHandlerUrl(String routeHeaderId) {
        DocumentRouteHeaderValue routeHeader = this.routeHeaderService.getRouteHeader(routeHeaderId);
        return routeHeader.getDocumentType().getResolvedDocumentHandlerUrl();
    }

    @Override
    public void publishDocHandlerUrlPrefix() {
        if (RunMode.EMBEDDED == this.getKewRunMode()) {
            ParameterType.Builder parameterType = ParameterType.Builder.create((String)"CONFG");
            Parameter.Builder parameter = Parameter.Builder.create((String)this.getApplicationId(), (String)"KR-WKFLW", (String)"All", (String)"kuali.docHandler.url.prefix", (ParameterType.Builder)parameterType);
            parameter.setDescription("KC application docHandler prefix");
            parameter.setValue(this.getApplicationUrl());
            parameter.setEvaluationOperator(EvaluationOperator.ALLOW);
            Parameter existingParameter = this.parameterService.getParameter("KR-WKFLW", "All", "kuali.docHandler.url.prefix");
            if (existingParameter == null) {
                this.parameterService.createParameter(parameter.build());
            } else if (!StringUtils.equals((CharSequence)existingParameter.getValue(), (CharSequence)this.getApplicationUrl())) {
                parameter.setObjectId(existingParameter.getObjectId());
                parameter.setVersionNumber(existingParameter.getVersionNumber());
                this.parameterService.updateParameter(parameter.build());
            }
        }
    }

    protected RunMode getKewRunMode() {
        String runMode = this.configurationService.getPropertyValueAsString("kew.mode");
        if (StringUtils.isBlank((CharSequence)runMode)) {
            throw new ConfigurationException("Failed to determine kew run mode.  Please be sure to set configuration parameter kew.mode");
        }
        return RunMode.valueOf((String)runMode.toUpperCase());
    }

    protected String getApplicationId() {
        String applicationId = this.configurationService.getPropertyValueAsString("application.id");
        if (StringUtils.isBlank((CharSequence)applicationId)) {
            throw new ConfigurationException("Failed to determine the application id.  Please be sure to set configuration parameter application.id");
        }
        return applicationId;
    }

    protected String getApplicationUrl() {
        String applicationUrl = this.configurationService.getPropertyValueAsString("application.url");
        if (StringUtils.isBlank((CharSequence)applicationUrl)) {
            throw new ConfigurationException("Failed to determine the application url.  Please be sure to set configuration parameter application.url");
        }
        return applicationUrl;
    }

    public void afterPropertiesSet() throws Exception {
        this.publishDocHandlerUrlPrefix();
    }

    public void setRouteHeaderService(RouteHeaderService routeHeaderService) {
        this.routeHeaderService = routeHeaderService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

