/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.org.kuali.rice.krad.uif.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.ToggleMenu;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;

public class CollectionToggleMenu
extends ToggleMenu {
    private static final Logger LOG = LogManager.getLogger(CollectionToggleMenu.class);
    private Class<?> collectionObjectClass;
    private BindingInfo bindingInfo;
    private Action navigationActionPrototype;
    private String actionLabelPropertyName;

    public void performInitialization(Object model) {
        super.performInitialization(model);
        this.setMenuItems(new ArrayList());
    }

    public void performApplyModel(Object model, LifecycleElement parent) {
        ArrayList<Action> menuItemList = new ArrayList<Action>();
        ArrayList<String> actionLabelNames = new ArrayList<String>();
        List modelCollection = (List)ObjectPropertyUtils.getPropertyValue((Object)model, (String)this.getBindingInfo().getBindingPath());
        int index = 0;
        for (Object object : modelCollection) {
            String actionLabel = this.getActionLabel(object);
            if (actionLabelNames.contains(actionLabel)) continue;
            Action menuItem = (Action)ComponentUtils.copy((Component)this.navigationActionPrototype);
            menuItem.getActionParameters().put("actionLabel", actionLabel);
            menuItem.setActionLabel(actionLabel);
            menuItem.setSuccessCallback("Kc.PropDev.markActiveMenuLink(" + index + ");");
            menuItem.addDataAttribute("menuname", this.getNavigationActionPrototype().getNavigateToPageId() + index);
            menuItemList.add(menuItem);
            actionLabelNames.add(actionLabel);
            ++index;
        }
        Collections.sort(menuItemList, new Comparator<Component>(this){

            @Override
            public int compare(Component c1, Component c2) {
                if (c1 instanceof Action && c2 instanceof Action) {
                    return ((Action)c1).getActionLabel().compareTo(((Action)c2).getActionLabel());
                }
                return c1.getTitle().compareTo(c2.getTitle());
            }
        });
        this.setMenuItems(menuItemList);
        this.getMenuGroup().setItems(menuItemList);
        super.performApplyModel(model, parent);
    }

    protected String getActionLabel(Object obj) {
        try {
            return PropertyUtils.getNestedProperty((Object)obj, (String)this.getActionLabelPropertyName()).toString();
        }
        catch (Exception e) {
            LOG.error("Problem creating actionLabel from actionLabelPropertyName", (Throwable)e);
            return null;
        }
    }

    public Class<?> getCollectionObjectClass() {
        return this.collectionObjectClass;
    }

    public void setCollectionObjectClass(Class<?> collectionObjectClass) {
        this.collectionObjectClass = collectionObjectClass;
    }

    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    public void setBindingInfo(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
    }

    public Action getNavigationActionPrototype() {
        return this.navigationActionPrototype;
    }

    public void setNavigationActionPrototype(Action navigationActionPrototype) {
        this.navigationActionPrototype = navigationActionPrototype;
    }

    public String getActionLabelPropertyName() {
        return this.actionLabelPropertyName;
    }

    public void setActionLabelPropertyName(String actionLabelPropertyName) {
        this.actionLabelPropertyName = actionLabelPropertyName;
    }
}

