/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.standalone.modular;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.api.modular.ModularBudgetService;
import org.kuali.coeus.common.budget.api.standalone.modular.StandaloneModularBudgetCommunicationException;
import org.kuali.coeus.common.budget.impl.standalone.modular.StandaloneModularBudgetDto;
import org.kuali.coeus.common.budget.impl.standalone.modular.StandaloneModularBudgetPeriodDto;
import org.kuali.coeus.common.budget.impl.standalone.modular.StandaloneModularBudgetResponse;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularContract;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetNavigationService;
import org.kuali.coeus.sys.framework.graphql.GraphqlRequest;
import org.kuali.coeus.sys.framework.rest.AuthServiceRestUtilService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

@Service(value="standaloneModularBudgetService")
public class StandaloneModularBudgetServiceImpl
implements ModularBudgetService {
    protected static final String STANDALONE_MODULAR_BUDGET_GRAPHQL_ENDPOINT = "/api/v1/budget/graphql";
    protected static final String BUDGET_ID_VARIABLE = "budgetId";
    protected static final String MOD_BUDGET_GRAPHQL_QUERY = "query AllModularBudgetData($budgetId: Int!) {\n  modularBudget(budgetId: $budgetId) {\n    budgetId\n    proposalNumber\n    periods {\n      period\n      modularAmounts {\n        detailedBudgetActuals\n        directCostLessConsortiumFA\n        consortiumFA\n        moduleRequested\n        modularTotalDirectCost\n        faBase\n        faRates {\n          rate\n          description\n          base\n          total\n        }\n        totalFA\n        modularTotal\n      }\n    }\n  }\n}\n";
    @Autowired
    @Qualifier(value="authServiceRestUtilService")
    private AuthServiceRestUtilService authServiceRestUtilService;
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;
    @Autowired
    @Qualifier(value="proposalBudgetNavigationService")
    private ProposalBudgetNavigationService proposalBudgetNavigationService;

    public List<? extends BudgetModularContract> getModularBudgetAmounts(BudgetContract budgetContract) {
        return this.retrieveRemoteModularBudget(budgetContract);
    }

    protected List<? extends BudgetModularContract> retrieveRemoteModularBudget(BudgetContract budget) {
        String budgetBaseUrl = this.getProposalBudgetNavigationService().getStandaloneModularBudgetBaseUrl();
        String requestUrl = budgetBaseUrl + STANDALONE_MODULAR_BUDGET_GRAPHQL_ENDPOINT;
        GraphqlRequest modBudgetQuery = new GraphqlRequest.Builder().query(MOD_BUDGET_GRAPHQL_QUERY).variable(BUDGET_ID_VARIABLE, budget.getBudgetId()).build();
        try {
            ResponseEntity modBudgetResponse = this.getRestOperations().exchange(requestUrl, HttpMethod.POST, new HttpEntity((Object)modBudgetQuery, (MultiValueMap)this.getAuthServiceRestUtilService().getAuthServiceStyleHttpHeadersForUser()), StandaloneModularBudgetResponse.class, new Object[0]);
            return this.mapModBudgetResponseToModularAmounts((StandaloneModularBudgetResponse)modBudgetResponse.getBody());
        }
        catch (RestClientException e) {
            throw new StandaloneModularBudgetCommunicationException(String.format("Failed to retrieve modular budget for budget ID %d", budget.getBudgetId()), e);
        }
    }

    protected List<? extends BudgetModularContract> mapModBudgetResponseToModularAmounts(StandaloneModularBudgetResponse modBudgetResponse) {
        return Optional.of(modBudgetResponse).map(StandaloneModularBudgetResponse::getModularBudget).map(StandaloneModularBudgetDto::getPeriods).map(periods -> periods.stream().map(StandaloneModularBudgetPeriodDto::getModularAmounts).collect(Collectors.toList())).orElse(new ArrayList());
    }

    public AuthServiceRestUtilService getAuthServiceRestUtilService() {
        return this.authServiceRestUtilService;
    }

    public void setAuthServiceRestUtilService(AuthServiceRestUtilService authServiceRestUtilService) {
        this.authServiceRestUtilService = authServiceRestUtilService;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public void setProposalBudgetNavigationService(ProposalBudgetNavigationService proposalBudgetNavigationService) {
        this.proposalBudgetNavigationService = proposalBudgetNavigationService;
    }

    public ProposalBudgetNavigationService getProposalBudgetNavigationService() {
        return this.proposalBudgetNavigationService;
    }
}

