/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person.attr;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.personnel.AppointmentType;
import org.kuali.coeus.common.framework.custom.SaveCustomDataEvent;
import org.kuali.coeus.common.framework.person.attr.KcPersonExtendedAttributes;
import org.kuali.coeus.common.framework.person.attr.PersonAppointment;
import org.kuali.coeus.common.framework.person.attr.PersonBiosketch;
import org.kuali.coeus.common.impl.person.attr.KcPersonExtendedAttributesMaintainableImpl;
import org.kuali.coeus.common.impl.person.attr.PersonCustomDataAuditRule;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.ApproveDocumentEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class KcPersonExtendedAttributesMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private static final String PRINCIPAL_ID = "principalId";
    private static final String CUSTOM_DATA_ERROR_PREFIX = "document.newMaintainableObject.businessObject.personCustomDataList";
    private static final String ERROR_APPOINTMENTS_OVERLAP = "error.appointmentType.period.overlap";

    public boolean processSaveDocument(Document document) {
        boolean rulePassed = true;
        rulePassed &= super.processSaveDocument(document);
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new maintainable is: " + String.valueOf(maintenanceDocument.getNewMaintainableObject().getClass()));
        }
        KcPersonExtendedAttributesMaintainableImpl maintainableImpl = (KcPersonExtendedAttributesMaintainableImpl)maintenanceDocument.getNewMaintainableObject();
        KcPersonExtendedAttributes kcPersonExtendedAttributes = (KcPersonExtendedAttributes)maintenanceDocument.getNewMaintainableObject().getDataObject();
        rulePassed &= this.checkExistence(kcPersonExtendedAttributes);
        rulePassed &= this.processRules(new SaveCustomDataEvent(CUSTOM_DATA_ERROR_PREFIX, document, kcPersonExtendedAttributes.getPersonCustomDataList(), maintainableImpl.getCustomAttributeDocuments()));
        rulePassed &= this.checkForAttachmentData(kcPersonExtendedAttributes.getAttachments());
        this.checkEraCommonsUserName(kcPersonExtendedAttributes);
        return rulePassed &= this.appointmentsDoNotOverlap(kcPersonExtendedAttributes.getPersonAppointments());
    }

    public boolean processRouteDocument(Document document) {
        boolean rulePassed = true;
        rulePassed &= super.processRouteDocument(document);
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new maintainable is: " + String.valueOf(maintenanceDocument.getNewMaintainableObject().getClass()));
        }
        KcPersonExtendedAttributes kcPersonExtendedAttributes = (KcPersonExtendedAttributes)maintenanceDocument.getNewMaintainableObject().getDataObject();
        return rulePassed &= new PersonCustomDataAuditRule().processRunAuditBusinessRules((Document)maintenanceDocument);
    }

    public boolean processApproveDocument(ApproveDocumentEvent approveEvent) {
        boolean rulePassed = true;
        rulePassed &= super.processApproveDocument(approveEvent);
        Document document = approveEvent.getDocument();
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new maintainable is: " + String.valueOf(maintenanceDocument.getNewMaintainableObject().getClass()));
        }
        KcPersonExtendedAttributes kcPersonExtendedAttributes = (KcPersonExtendedAttributes)maintenanceDocument.getNewMaintainableObject().getDataObject();
        return rulePassed &= new PersonCustomDataAuditRule().processRunAuditBusinessRules((Document)maintenanceDocument);
    }

    public boolean processAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject bo) {
        if (bo instanceof PersonBiosketch && ((PersonBiosketch)bo).getAttachmentFile() == null) {
            this.reportMissingAttachment("document.newMaintainableObject.add.attachments.attachmentFile");
            return false;
        }
        return super.processAddCollectionLineBusinessRules(document, collectionName, bo);
    }

    private boolean checkExistence(KcPersonExtendedAttributes kcPersonExtendedAttributes) {
        boolean valid = true;
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put(PRINCIPAL_ID, kcPersonExtendedAttributes.getPersonId());
        valid = this.checkExistenceFromTable(Person.class, pkMap, PRINCIPAL_ID, "KcPersonExtendedAttributes Id");
        return valid;
    }

    private void checkEraCommonsUserName(KcPersonExtendedAttributes kcPersonExtendedAttributes) {
        if (StringUtils.isNotBlank((CharSequence)kcPersonExtendedAttributes.getEraCommonUserName()) && kcPersonExtendedAttributes.getEraCommonUserName().length() < 6) {
            GlobalVariables.getMessageMap().putWarning("document.newMaintainableObject.eRACommonsUserName", "error.minLength", new String[]{"eRA Commons User Name", "6"});
        }
    }

    protected boolean checkExistenceFromTable(Class clazz, Map fieldValues, String errorField, String errorParam) {
        boolean success = true;
        String idString = (String)fieldValues.get(PRINCIPAL_ID);
        boolean bl = success = this.getPersonService().getPerson(idString) != null;
        if (!success) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject." + errorField, "error.existence", new String[]{errorParam});
        }
        return success;
    }

    protected boolean checkForAttachmentData(List<PersonBiosketch> attachments) {
        int index = 0;
        for (PersonBiosketch biosketch : attachments) {
            if (biosketch.getAttachmentFile() == null && StringUtils.isBlank((CharSequence)biosketch.getFileName())) {
                this.reportMissingAttachment("document.newMaintainableObject.attachments[" + index + "].attachmentFile");
                return false;
            }
            ++index;
        }
        return true;
    }

    private void reportMissingAttachment(String errorPath) {
        ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        errorReporter.reportError(errorPath, "error.required", "Attachment File (Attachment File)");
    }

    private boolean appointmentsDoNotOverlap(List<PersonAppointment> appointments) {
        appointments.forEach(a -> a.refreshReferenceObject("appointmentType"));
        for (int i = 0; i < appointments.size() - 1; ++i) {
            for (int j = i + 1; j < appointments.size(); ++j) {
                AppointmentType a2 = appointments.get(i).getAppointmentType();
                AppointmentType b = appointments.get(j).getAppointmentType();
                if (!DateUtils.periodsOverlap(a2.getStartDate(), a2.getEndDate(), b.getStartDate(), b.getEndDate())) continue;
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.personAppointments[" + j + "].typeCode", ERROR_APPOINTMENTS_OVERLAP, new String[]{a2.getDescription(), b.getDescription()});
            }
        }
        return true;
    }
}

