/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.core;

import com.codiform.moo.annotation.CollectionProperty;
import com.codiform.moo.annotation.Ignore;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.AbstractBudget;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategoryType;
import org.kuali.coeus.common.budget.framework.distribution.BudgetCostShare;
import org.kuali.coeus.common.budget.framework.distribution.BudgetUnrecoveredFandA;
import org.kuali.coeus.common.budget.framework.income.BudgetProjectIncome;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetFormulatedCostDetail;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetRateAndBase;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelRateAndBase;
import org.kuali.coeus.common.budget.framework.rate.AbstractBudgetRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetLaRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRatesService;
import org.kuali.coeus.common.budget.framework.rate.InstituteLaRate;
import org.kuali.coeus.common.budget.framework.rate.InstituteRate;
import org.kuali.coeus.common.budget.framework.rate.RateClass;
import org.kuali.coeus.common.budget.framework.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.common.budget.framework.summary.BudgetSummaryService;
import org.kuali.coeus.common.budget.impl.print.BudgetPrintForm;
import org.kuali.coeus.common.framework.impl.Period;
import org.kuali.coeus.common.framework.person.PersonRolodexComparator;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetNumberOfMonthsService;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModular;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModularIdc;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardAttachment;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardFiles;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardPeriodDetail;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwards;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleThreeDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.DocumentNextvalue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

@ParameterConstants.NAMESPACE(namespace="KC-B")
@ParameterConstants.COMPONENT(component="Document")
@MappedSuperclass
@Entity
@Table(name="BUDGET")
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="PARENT_DOCUMENT_TYPE_CODE", discriminatorType=DiscriminatorType.STRING)
public class Budget
extends AbstractBudget
implements BudgetContract {
    private static final String PARAM_VALUE_ENABLED = "1";
    private static final long serialVersionUID = -252470308729741085L;
    private static final String FALSE_FLAG = "N";
    private static final String TRUE_FLAG = "Y";
    private static final Logger LOG = LogManager.getLogger(Budget.class);
    @Column(name="PARENT_DOCUMENT_TYPE_CODE")
    private String parentDocumentTypeCode;
    @Column(name="BUDGET_JUSTIFICATION")
    @Lob
    private String budgetJustification;
    @Column(name="CREATE_TIMESTAMP")
    private Timestamp createTimestamp;
    @Column(name="CREATE_USER")
    private String createUser;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="OH_RATE_CLASS_CODE", referencedColumnName="RATE_CLASS_CODE", insertable=false, updatable=false)
    private RateClass rateClass;
    @CollectionProperty
    @Ignore
    @OneToMany(mappedBy="budget", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BudgetRate> budgetRates;
    @CollectionProperty
    @Ignore
    @OneToMany(mappedBy="budget", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BudgetLaRate> budgetLaRates;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="BUDGET_ID", referencedColumnName="BUDGET_ID")
    @OrderBy(value="budgetPeriodNumber")
    private List<BudgetProjectIncome> budgetProjectIncomes;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="BUDGET_ID", referencedColumnName="BUDGET_ID")
    @OrderBy(value="projectPeriod")
    private List<BudgetCostShare> budgetCostShares;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="BUDGET_ID", referencedColumnName="BUDGET_ID")
    @OrderBy(value="fiscalYear")
    private List<BudgetUnrecoveredFandA> budgetUnrecoveredFandAs;
    @Column(name="BUDGET_ADJUSTMENT_DOC_NBR")
    private String budgetAdjustmentDocumentNumber;
    @OneToMany(mappedBy="budget", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BudgetPerson> budgetPersons;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="BUDGET_ID", referencedColumnName="BUDGET_ID")
    @OrderBy(value="subAwardNumber")
    private List<BudgetSubAwards> budgetSubAwards;
    @OneToMany(mappedBy="budget", orphanRemoval=true, cascade={CascadeType.ALL})
    @OrderBy(value="budgetPeriod")
    private List<BudgetPeriod> budgetPeriods;
    @Transient
    private java.sql.Date summaryPeriodStartDate;
    @Transient
    private java.sql.Date summaryPeriodEndDate;
    @Transient
    private List<InstituteRate> instituteRates;
    @Transient
    private List<InstituteLaRate> instituteLaRates;
    @Transient
    private List<RateClass> rateClasses;
    @Transient
    private List<RateClassType> rateClassTypes;
    @Transient
    private SortedMap<CostElement, List<ScaleTwoDecimal>> objectCodeTotals;
    @Transient
    private SortedMap<RateType, List<ScaleTwoDecimal>> calculatedExpenseTotals;
    @Transient
    private SortedMap<RateType, List<ScaleTwoDecimal>> personnelCalculatedExpenseTotals;
    @Transient
    private SortedMap<RateType, List<ScaleTwoDecimal>> nonPersonnelCalculatedExpenseTotals;
    @Transient
    private List<KeyValue> budgetCategoryTypeCodes;
    @Transient
    private SortedMap<BudgetCategoryType, List<CostElement>> objectCodeListByBudgetCategoryType;
    @Transient
    private SortedMap<CostElement, List<BudgetPersonnelDetails>> objectCodePersonnelList;
    @Transient
    private SortedMap<String, List<ScaleTwoDecimal>> objectCodePersonnelSalaryTotals;
    @Transient
    private SortedMap<String, List<ScaleTwoDecimal>> objectCodePersonnelFringeTotals;
    @Transient
    private SortedMap<String, List<ScaleTwoDecimal>> budgetSummaryTotals;
    @Transient
    private List<BudgetPrintForm> budgetPrintForms;
    @Transient
    private boolean rateSynced;
    @Transient
    private transient ParameterService parameterService;
    @Transient
    private transient BudgetCalculationService budgetCalculationService;
    @Transient
    private List<BudgetPersonnelDetails> budgetPersonnelDetailsList;
    @Transient
    private String activityTypeCode = "x";
    @Transient
    private boolean budgetLineItemDeleted;
    @Transient
    private boolean rateClassTypesReloaded = false;
    @Transient
    private Boolean viewOnly = Boolean.FALSE;
    @Transient
    private transient BusinessObjectService businessObjectService;

    public BudgetParent getBudgetParent() {
        throw new UnsupportedOperationException("Not defined in parent class.");
    }

    public String getParentDocumentKey() {
        throw new UnsupportedOperationException("Not defined in parent class.");
    }

    public String getParentDocumentGroupName() {
        throw new UnsupportedOperationException("Not defined in parent class.");
    }

    public Budget() {
        this.budgetProjectIncomes = new ArrayList<BudgetProjectIncome>();
        this.budgetRates = new ArrayList<BudgetRate>();
        this.budgetLaRates = new ArrayList<BudgetLaRate>();
        this.budgetPeriods = new ArrayList<BudgetPeriod>();
        this.budgetPersonnelDetailsList = new ArrayList<BudgetPersonnelDetails>();
        this.budgetUnrecoveredFandAs = new ArrayList<BudgetUnrecoveredFandA>();
        this.instituteRates = new ArrayList<InstituteRate>();
        this.instituteLaRates = new ArrayList<InstituteLaRate>();
        this.rateClasses = new ArrayList<RateClass>();
        this.rateClassTypes = new ArrayList<RateClassType>();
        this.budgetPersons = new ArrayList<BudgetPerson>();
        this.budgetCategoryTypeCodes = new ArrayList<KeyValue>();
        this.budgetPrintForms = new ArrayList<BudgetPrintForm>();
        this.budgetSubAwards = new ArrayList<BudgetSubAwards>();
        this.budgetCostShares = new ArrayList<BudgetCostShare>();
        this.setOnOffCampusFlag("D");
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void handlePeriodToProjectIncomeRelationship() {
        ArrayList<Long> periodIncomesToDelete = new ArrayList<Long>();
        for (BudgetPeriod persistedPeriod : this.getPersistedBudgetPeriods()) {
            if (this.containsBudgetPeriod(persistedPeriod.getBudgetPeriodId())) continue;
            periodIncomesToDelete.add(persistedPeriod.getBudgetPeriodId());
        }
        this.deletePersistedProjectIncomes(periodIncomesToDelete);
        this.deleteLocalProjectIncomes(periodIncomesToDelete);
    }

    private boolean containsBudgetPeriod(Long periodId) {
        assert (periodId != null) : "the periodId is null";
        for (BudgetPeriod localPeriod : this.getBudgetPeriods()) {
            if (!periodId.equals(localPeriod.getBudgetPeriodId())) continue;
            return true;
        }
        return false;
    }

    public String getBudgetAdjustmentDocumentNumber() {
        return this.budgetAdjustmentDocumentNumber;
    }

    public void setBudgetAdjustmentDocumentNumber(String budgetAdjustmentDocumentNumber) {
        this.budgetAdjustmentDocumentNumber = budgetAdjustmentDocumentNumber;
    }

    private Collection<BudgetPeriod> getPersistedBudgetPeriods() {
        HashMap<String, Long> matchCriteria = new HashMap<String, Long>();
        matchCriteria.put("budgetId", this.getBudgetId());
        List periods = this.getBusinessObjectService().findMatching(BudgetPeriod.class, matchCriteria);
        return periods != null ? Collections.unmodifiableCollection(periods) : Collections.emptyList();
    }

    private void deletePersistedProjectIncomes(Collection<Long> periodIds) {
        assert (periodIds != null) : "the periodIds are null";
        if (periodIds.isEmpty()) {
            return;
        }
        HashMap<String, Collection<Long>> matchCriteria = new HashMap<String, Collection<Long>>();
        matchCriteria.put("budgetPeriodId", periodIds);
        this.getBusinessObjectService().deleteMatching(BudgetProjectIncome.class, matchCriteria);
    }

    private void deleteLocalProjectIncomes(Collection<Long> periodIds) {
        assert (periodIds != null) : "the periodIds are null";
        if (periodIds.isEmpty()) {
            return;
        }
        this.getBudgetProjectIncomes().removeIf(budgetProjectIncome -> periodIds.contains(budgetProjectIncome.getBudgetPeriodId()));
    }

    public List<ScaleTwoDecimal> getProjectIncomePeriodTotalsForEachBudgetPeriod() {
        Map<Integer, ScaleTwoDecimal> incomes = this.mapProjectIncomeTotalsToBudgetPeriodNumbers();
        return this.findProjectIncomeTotalsForBudgetPeriods(incomes);
    }

    public List<FiscalYearSummary> getFiscalYearCostShareTotals() {
        Map<Integer, List<BudgetPeriod>> budgetPeriodFiscalYears = this.mapBudgetPeriodsToFiscalYears();
        return this.findCostShareTotalsForBudgetPeriods(budgetPeriodFiscalYears);
    }

    public List<FiscalYearSummary> getFiscalYearUnrecoveredFandATotals() {
        Map<Integer, List<BudgetPeriod>> budgetPeriodFiscalYears = this.mapBudgetPeriodsToFiscalYears();
        return this.findCostShareTotalsForBudgetPeriods(budgetPeriodFiscalYears);
    }

    public Boolean isCostSharingApplicable() {
        return this.loadCostSharingApplicability();
    }

    public Boolean isCostSharingEnforced() {
        return this.loadCostSharingEnforcement();
    }

    public boolean isCostSharingAvailable() {
        BudgetPeriod budgetPeriod;
        boolean costSharingAvailable = false;
        Iterator<BudgetPeriod> iterator = this.getBudgetPeriods().iterator();
        while (iterator.hasNext() && !(costSharingAvailable = (budgetPeriod = iterator.next()).getCostSharingAmount().isPositive())) {
        }
        return costSharingAvailable;
    }

    public Boolean isUnrecoveredFandAEnforced() {
        return this.loadUnrecoveredFandAEnforcement();
    }

    public Boolean isUnrecoveredFandAApplicable() {
        return this.loadUnrecoveredFandAApplicability();
    }

    public boolean isUnrecoveredFandAAvailable() {
        return this.getAvailableUnrecoveredFandA().doubleValue() > 0.0;
    }

    public ScaleTwoDecimal getAllocatedCostSharing() {
        ScaleTwoDecimal costShareTotal = new ScaleTwoDecimal(0.0);
        for (BudgetCostShare budgetCostShare : this.getBudgetCostShares()) {
            if (budgetCostShare.getShareAmount() == null) continue;
            costShareTotal = (ScaleTwoDecimal)costShareTotal.add((AbstractDecimal)budgetCostShare.getShareAmount());
        }
        return costShareTotal;
    }

    public ScaleTwoDecimal getAllocatedUnrecoveredFandA() {
        ScaleTwoDecimal allocatedUnrecoveredFandA = ScaleTwoDecimal.ZERO;
        for (BudgetUnrecoveredFandA unrecoveredFandA : this.getBudgetUnrecoveredFandAs()) {
            if (unrecoveredFandA.getAmount() == null) continue;
            allocatedUnrecoveredFandA = (ScaleTwoDecimal)allocatedUnrecoveredFandA.add((AbstractDecimal)unrecoveredFandA.getAmount());
        }
        return allocatedUnrecoveredFandA;
    }

    public ScaleTwoDecimal getProjectIncomeTotal() {
        ScaleTwoDecimal projectIncomeTotal = new ScaleTwoDecimal(0.0);
        for (BudgetProjectIncome budgetProjectIncome : this.budgetProjectIncomes) {
            if (budgetProjectIncome.getProjectIncome() == null) continue;
            projectIncomeTotal = (ScaleTwoDecimal)projectIncomeTotal.add((AbstractDecimal)budgetProjectIncome.getProjectIncome());
        }
        return projectIncomeTotal;
    }

    public ScaleTwoDecimal getUnallocatedCostSharing() {
        return (ScaleTwoDecimal)this.getAvailableCostSharing().subtract((AbstractDecimal)this.getAllocatedCostSharing());
    }

    public ScaleTwoDecimal getUnallocatedUnrecoveredFandA() {
        return (ScaleTwoDecimal)this.getAvailableUnrecoveredFandA().subtract((AbstractDecimal)this.getAllocatedUnrecoveredFandA());
    }

    @Override
    public RateClass getRateClass() {
        return this.rateClass;
    }

    @Override
    public void setRateClass(RateClass rateClass) {
        this.rateClass = rateClass;
    }

    public List<BudgetPeriod> getBudgetPeriods() {
        return this.budgetPeriods;
    }

    public BudgetSummaryService getBudgetSummaryService() {
        return KcServiceLocator.getService(BudgetSummaryService.class);
    }

    public void setBudgetPeriods(List<BudgetPeriod> budgetPeriods) {
        this.budgetPeriods = budgetPeriods;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getBudgetProjectIncomes());
        managedLists.add(this.getBudgetCostShares());
        managedLists.add(this.getBudgetUnrecoveredFandAs());
        ArrayList<BudgetLineItem> budgetLineItems = new ArrayList<BudgetLineItem>();
        ArrayList<BudgetLineItemCalculatedAmount> budgetLineItemCalculatedAmounts = new ArrayList<BudgetLineItemCalculatedAmount>();
        ArrayList<BudgetFormulatedCostDetail> budgetFormulatedCosts = new ArrayList<BudgetFormulatedCostDetail>();
        ArrayList<BudgetRateAndBase> budgetRateAndBaseList = new ArrayList<BudgetRateAndBase>();
        ArrayList<BudgetPersonnelDetails> bPersonnelDetailsList = new ArrayList<BudgetPersonnelDetails>();
        ArrayList<BudgetPersonnelCalculatedAmount> budgetPersonnelCalculatedAmounts = new ArrayList<BudgetPersonnelCalculatedAmount>();
        ArrayList<BudgetPersonnelRateAndBase> budgetPersonnelRateAndBaseList = new ArrayList<BudgetPersonnelRateAndBase>();
        ArrayList<BudgetModularIdc> budgetModularIdcs = new ArrayList<BudgetModularIdc>();
        ArrayList<BudgetModular> budgetModular = new ArrayList<BudgetModular>();
        for (BudgetPeriod budgetPeriod : this.getBudgetPeriods()) {
            if (ObjectUtils.isNotNull((Object)budgetPeriod.getBudgetModular())) {
                budgetModularIdcs.addAll(budgetPeriod.getBudgetModular().getBudgetModularIdcs());
                budgetModular.add(budgetPeriod.getBudgetModular());
            }
            List<BudgetLineItem> tempLIs = budgetPeriod.getBudgetLineItems();
            budgetLineItems.addAll(tempLIs);
            for (BudgetLineItem budgetLineItem : tempLIs) {
                budgetFormulatedCosts.addAll(budgetLineItem.getBudgetFormulatedCosts());
                budgetLineItemCalculatedAmounts.addAll(budgetLineItem.getBudgetLineItemCalculatedAmounts());
                budgetRateAndBaseList.addAll(budgetLineItem.getBudgetRateAndBaseList());
                List<BudgetPersonnelDetails> tempPerList = budgetLineItem.getBudgetPersonnelDetailsList();
                bPersonnelDetailsList.addAll(tempPerList);
                for (BudgetPersonnelDetails budgetPersonnelDetails : tempPerList) {
                    budgetPersonnelCalculatedAmounts.addAll(budgetPersonnelDetails.getBudgetPersonnelCalculatedAmounts());
                    budgetPersonnelRateAndBaseList.addAll(budgetPersonnelDetails.getBudgetPersonnelRateAndBaseList());
                }
            }
        }
        ArrayList<BudgetSubAwardFiles> subAwardFiles = new ArrayList<BudgetSubAwardFiles>();
        ArrayList<BudgetSubAwardAttachment> subAwardAttachments = new ArrayList<BudgetSubAwardAttachment>();
        ArrayList<BudgetSubAwardPeriodDetail> subAwardPeriodDetails = new ArrayList<BudgetSubAwardPeriodDetail>();
        for (BudgetSubAwards budgetSubAward : this.getBudgetSubAwards()) {
            subAwardFiles.addAll(budgetSubAward.getBudgetSubAwardFiles());
            subAwardAttachments.addAll(budgetSubAward.getBudgetSubAwardAttachments());
            subAwardPeriodDetails.addAll(budgetSubAward.getBudgetSubAwardPeriodDetails());
        }
        managedLists.add(budgetModularIdcs);
        managedLists.add(budgetModular);
        managedLists.add(budgetPersonnelRateAndBaseList);
        managedLists.add(budgetPersonnelCalculatedAmounts);
        managedLists.add(bPersonnelDetailsList);
        managedLists.add(budgetRateAndBaseList);
        managedLists.add(budgetLineItemCalculatedAmounts);
        managedLists.add(budgetFormulatedCosts);
        managedLists.add(budgetLineItems);
        managedLists.add(this.getBudgetPersons());
        managedLists.add(this.getBudgetPeriods());
        managedLists.add(this.getBudgetLaRates());
        managedLists.add(this.getBudgetRates());
        managedLists.add(subAwardAttachments);
        managedLists.add(subAwardFiles);
        managedLists.add(subAwardPeriodDetails);
        managedLists.add(this.getBudgetSubAwards());
        return managedLists;
    }

    public boolean areLineItemJustificationsPresent() {
        boolean justificationFound = false;
        block0: for (BudgetPeriod budgetPeriod : this.getBudgetPeriods()) {
            for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                justificationFound = !StringUtils.isEmpty((CharSequence)lineItem.getBudgetJustification());
                if (!justificationFound) continue;
                break block0;
            }
        }
        return justificationFound;
    }

    public BudgetPeriod getBudgetPeriod(int index) {
        while (this.getBudgetPeriods().size() <= index) {
            BudgetPeriod budgetPeriod = this.getNewBudgetPeriod();
            budgetPeriod.setBudget(this);
            this.getBudgetPeriods().add(budgetPeriod);
        }
        return this.getBudgetPeriods().get(index);
    }

    public java.sql.Date getSummaryPeriodStartDate() {
        this.summaryPeriodStartDate = this.getBudgetPeriods().get(0).getStartDate();
        if (this.summaryPeriodStartDate == null) {
            this.summaryPeriodStartDate = this.getStartDate();
        }
        return this.summaryPeriodStartDate;
    }

    public java.sql.Date getSummaryPeriodEndDate() {
        this.summaryPeriodEndDate = this.getBudgetPeriods().get(this.budgetPeriods.size() - 1).getEndDate();
        if (this.summaryPeriodEndDate == null) {
            this.summaryPeriodEndDate = this.getEndDate();
        }
        return this.summaryPeriodEndDate;
    }

    public List<BudgetRate> getBudgetRates() {
        return this.budgetRates;
    }

    public void setBudgetRates(List<BudgetRate> budgetRates) {
        this.budgetRates = budgetRates;
    }

    public List<BudgetLaRate> getBudgetLaRates() {
        return this.budgetLaRates;
    }

    public void setBudgetLaRates(List<BudgetLaRate> budgetLaRates) {
        this.budgetLaRates = budgetLaRates;
    }

    public List<AbstractBudgetRate> getAllBudgetRates() {
        ArrayList<AbstractBudgetRate> result = new ArrayList<AbstractBudgetRate>();
        result.addAll(this.getBudgetRates());
        result.addAll(this.getBudgetLaRates());
        return result;
    }

    public String getActivityTypeCode() {
        return this.activityTypeCode;
    }

    public void setActivityTypeCode(String activityTypeCode) {
        this.activityTypeCode = activityTypeCode;
    }

    public List<InstituteRate> getInstituteRates() {
        return this.instituteRates;
    }

    public void setInstituteRates(List<InstituteRate> instituteRates) {
        this.instituteRates = instituteRates;
    }

    public BudgetRatesService getBudgetRatesService() {
        return KcServiceLocator.getService(BudgetRatesService.class);
    }

    public List<RateClass> getRateClasses() {
        return this.rateClasses;
    }

    public void setRateClasses(List<RateClass> rateClasses) {
        this.rateClasses = rateClasses;
    }

    public List<RateClassType> getRateClassTypes() {
        if (!(!this.rateClassTypes.isEmpty() || this.rateClassTypesReloaded || this.getBudgetRates().isEmpty() && this.getBudgetLaRates().isEmpty())) {
            this.getBudgetRatesService().syncBudgetRateCollectionsToExistingRates(this.rateClassTypes, this);
        } else if (this.rateClassTypesReloaded) {
            if (!this.rateClassTypes.isEmpty()) {
                this.rateClassTypes.clear();
            }
            this.rateClassTypesReloaded = false;
            this.getBudgetRatesService().getBudgetRates(this.rateClassTypes, this);
        }
        this.rateClassTypes.sort(new RateClassTypeComparator());
        return this.rateClassTypes;
    }

    public void setRateClassTypes(List<RateClassType> rateClassTypes) {
        this.rateClassTypes = rateClassTypes;
    }

    public int getBudgetProjectIncomeCount() {
        return this.getCollectionSize(this.budgetProjectIncomes);
    }

    public List<BudgetProjectIncome> getBudgetProjectIncomes() {
        return this.budgetProjectIncomes;
    }

    public BudgetProjectIncome getBudgetProjectIncome(int index) {
        while (this.getBudgetProjectIncomes().size() <= index) {
            this.getBudgetProjectIncomes().add(new BudgetProjectIncome());
        }
        return this.getBudgetProjectIncomes().get(index);
    }

    public void setBudgetCostShares(List<BudgetCostShare> budgetCostShares) {
        this.budgetCostShares = budgetCostShares;
    }

    public void setBudgetUnrecoveredFandAs(List<BudgetUnrecoveredFandA> budgetUnrecoveredFandAs) {
        this.budgetUnrecoveredFandAs = budgetUnrecoveredFandAs;
    }

    public void setBudgetProjectIncomes(List<BudgetProjectIncome> budgetProjectIncomes) {
        this.budgetProjectIncomes = budgetProjectIncomes;
    }

    public void add(BudgetCostShare budgetCostShare) {
        if (budgetCostShare != null) {
            budgetCostShare.setBudgetId(this.getBudgetId());
            budgetCostShare.setBudget(this);
            budgetCostShare.setDocumentComponentId(this.getNextValue(budgetCostShare.getDocumentComponentIdKey()));
            this.budgetCostShares.add(budgetCostShare);
        } else {
            LOG.warn("Attempt to add null budgetCostShare was ignored.");
        }
    }

    public List<DocumentNextvalue> getNextValues() {
        throw new UnsupportedOperationException("Not supported in Budget parent class");
    }

    public DocumentNextvalue getNewNextValue() {
        throw new UnsupportedOperationException("Not supported in Budget parent class");
    }

    public void add(DocumentNextvalue nextValue) {
        throw new UnsupportedOperationException("Not supported in Budget parent class");
    }

    public Integer getNextValue(String propertyName) {
        Integer propNextValue = 1;
        for (DocumentNextvalue element : this.getNextValues()) {
            DocumentNextvalue nextValue = element;
            if (!nextValue.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            propNextValue = nextValue.getNextValue();
            nextValue.setNextValue(propNextValue + 1);
        }
        if (propNextValue == 1) {
            DocumentNextvalue nextValue = this.getNewNextValue();
            nextValue.setNextValue(propNextValue + 1);
            nextValue.setPropertyName(propertyName);
            this.add(nextValue);
        }
        return propNextValue;
    }

    public boolean isProposalBudget() {
        return this.getBudgetParent().isProposalBudget();
    }

    public void add(BudgetProjectIncome budgetProjectIncome) {
        if (budgetProjectIncome != null) {
            budgetProjectIncome.setBudgetId(this.getBudgetId());
            budgetProjectIncome.setDocumentComponentId(this.getNextValue(budgetProjectIncome.getDocumentComponentIdKey()));
            this.budgetProjectIncomes.add(budgetProjectIncome);
            budgetProjectIncome.setBudgetPeriod(this.getBudgetPeriod(budgetProjectIncome));
        } else {
            LOG.warn("Attempt to add null budgetProjectIncome was ignored.");
        }
    }

    public BudgetPeriod getBudgetPeriod(BudgetProjectIncome budgetProjectIncome) {
        List<BudgetPeriod> bPeriods = this.getBudgetPeriods();
        if (bPeriods != null && bPeriods.size() > 0) {
            for (BudgetPeriod bPeriod : bPeriods) {
                if (bPeriod.getBudgetPeriod() == null || budgetProjectIncome.getBudgetPeriodNumber() == null || bPeriod.getBudgetPeriod().intValue() != budgetProjectIncome.getBudgetPeriodNumber().intValue()) continue;
                return bPeriod;
            }
        }
        return null;
    }

    public void add(BudgetRate budgetRate) {
        if (budgetRate != null) {
            this.getBudgetRates().add(budgetRate);
        }
    }

    public void add(BudgetLaRate budgetLaRate) {
        if (budgetLaRate != null) {
            this.getBudgetLaRates().add(budgetLaRate);
        }
    }

    public void add(BudgetUnrecoveredFandA budgetUnrecoveredFandA) {
        if (budgetUnrecoveredFandA != null) {
            budgetUnrecoveredFandA.setBudgetId(this.getBudgetId());
            budgetUnrecoveredFandA.setBudget(this);
            budgetUnrecoveredFandA.setDocumentComponentId(this.getNextValue(budgetUnrecoveredFandA.getDocumentComponentIdKey()));
            this.budgetUnrecoveredFandAs.add(budgetUnrecoveredFandA);
        } else {
            LOG.warn("Attempt to add null budgetUnrecoveredFandA was ignored.");
        }
    }

    public List<BudgetPerson> getBudgetPersons() {
        this.budgetPersons.sort(PersonRolodexComparator.INSTANCE);
        return this.budgetPersons;
    }

    public void setBudgetPersons(List<BudgetPerson> budgetPersons) {
        this.budgetPersons = budgetPersons;
    }

    public BudgetPerson getBudgetPerson(int index) {
        while (this.getBudgetPersons().size() <= index) {
            this.getBudgetPersons().add(new BudgetPerson());
        }
        return this.getBudgetPersons().get(index);
    }

    public void addBudgetPerson(BudgetPerson budgetPerson) {
        this.getBudgetPersons().add(budgetPerson);
        budgetPerson.setBudget(this);
    }

    public void add(BudgetPeriod budgetPeriod) {
        this.getBudgetPeriods().add(budgetPeriod);
    }

    public BudgetCostShare removeBudgetCostShare(int index) {
        return this.getBudgetCostShares().remove(index);
    }

    public BudgetProjectIncome removeBudgetProjectIncome(int index) {
        return this.getBudgetProjectIncomes().remove(index);
    }

    public BudgetUnrecoveredFandA removeBudgetUnrecoveredFandA(int index) {
        return this.getBudgetUnrecoveredFandAs().remove(index);
    }

    public final List<InstituteLaRate> getInstituteLaRates() {
        return this.instituteLaRates;
    }

    public final void setInstituteLaRates(List<InstituteLaRate> instituteLaRates) {
        this.instituteLaRates = instituteLaRates;
    }

    public BudgetCostShare getBudgetCostShare(int index) {
        while (this.getBudgetCostShares().size() <= index) {
            this.getBudgetCostShares().add(new BudgetCostShare());
        }
        return this.getBudgetCostShares().get(index);
    }

    public List<BudgetCostShare> getBudgetCostShares() {
        return this.budgetCostShares;
    }

    public int getBudgetCostShareCount() {
        return this.getCollectionSize(this.budgetCostShares);
    }

    public BudgetUnrecoveredFandA getBudgetUnrecoveredFandA(int index) {
        while (this.getBudgetUnrecoveredFandAs().size() <= index) {
            this.getBudgetUnrecoveredFandAs().add(new BudgetUnrecoveredFandA());
        }
        return this.getBudgetUnrecoveredFandAs().get(index);
    }

    public List<BudgetUnrecoveredFandA> getBudgetUnrecoveredFandAs() {
        return this.budgetUnrecoveredFandAs;
    }

    public int getBudgetUnrecoveredFandACount() {
        return this.getCollectionSize(this.budgetUnrecoveredFandAs);
    }

    public void getBudgetTotals() {
        this.getBudgetCalculationService().calculateBudgetSummaryTotals(this);
    }

    public SortedMap<CostElement, List<ScaleTwoDecimal>> getObjectCodeTotals() {
        return this.objectCodeTotals;
    }

    public void setObjectCodeTotals(SortedMap<CostElement, List<ScaleTwoDecimal>> objectCodeTotals) {
        this.objectCodeTotals = objectCodeTotals;
    }

    public SortedMap<RateType, List<ScaleTwoDecimal>> getCalculatedExpenseTotals() {
        return this.calculatedExpenseTotals;
    }

    public void setCalculatedExpenseTotals(SortedMap<RateType, List<ScaleTwoDecimal>> calculatedExpenseTotals) {
        this.calculatedExpenseTotals = calculatedExpenseTotals;
    }

    public ScaleTwoDecimal getAvailableCostSharing() {
        ScaleTwoDecimal availableCostShare = ScaleTwoDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : this.getBudgetPeriods()) {
            if (budgetPeriod.getCostSharingAmount() == null) continue;
            availableCostShare = (ScaleTwoDecimal)availableCostShare.add((AbstractDecimal)budgetPeriod.getCostSharingAmount());
        }
        return availableCostShare;
    }

    public ScaleTwoDecimal getAvailableUnrecoveredFandA() {
        ScaleTwoDecimal availableUnrecoveredFandA = ScaleTwoDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : this.getBudgetPeriods()) {
            if (budgetPeriod.getUnderrecoveryAmount() == null) continue;
            availableUnrecoveredFandA = (ScaleTwoDecimal)availableUnrecoveredFandA.add((AbstractDecimal)budgetPeriod.getUnderrecoveryAmount());
        }
        return availableUnrecoveredFandA;
    }

    public ScaleTwoDecimal findCostSharingForFiscalYear(Integer fiscalYear) {
        ScaleTwoDecimal costSharing = ScaleTwoDecimal.ZERO;
        List<FiscalYearSummary> costShareFiscalYears = this.findCostShareTotalsForBudgetPeriods(this.mapBudgetPeriodsToFiscalYears());
        for (FiscalYearSummary costShareFiscalYear : costShareFiscalYears) {
            if (costShareFiscalYear.fiscalYear != fiscalYear) continue;
            costSharing = costShareFiscalYear.costShare;
            break;
        }
        return costSharing;
    }

    public ScaleTwoDecimal findUnrecoveredFandAForFiscalYear(Integer fiscalYear) {
        ScaleTwoDecimal unrecoveredFandA = ScaleTwoDecimal.ZERO;
        List<FiscalYearSummary> fiscalYearSummaries = this.findCostShareTotalsForBudgetPeriods(this.mapBudgetPeriodsToFiscalYears());
        for (FiscalYearSummary fiscalYearSummary : fiscalYearSummaries) {
            if (fiscalYearSummary.getFiscalYear() != fiscalYear.intValue()) continue;
            unrecoveredFandA = fiscalYearSummary.getUnrecoveredFandA();
            break;
        }
        return unrecoveredFandA;
    }

    public java.sql.Date loadFiscalYearStart() {
        return this.createDateFromString(this.getParameterService().getParameterValueAsString(Budget.class, "budgetCurrentFiscalYear"));
    }

    public boolean getSalaryInflationEnabled() {
        return this.getParameterService().getParameterValueAsString(Budget.class, "enableSalaryInflationAnniversaryDate").equals(PARAM_VALUE_ENABLED);
    }

    protected Boolean loadCostSharingApplicability() {
        return this.getBooleanValue("budgetCostSharingApplicabilityFlag");
    }

    protected Boolean loadUnrecoveredFandAApplicability() {
        return this.getBooleanValue("budgetUnrecoveredFandAApplicabilityFlag");
    }

    protected Boolean loadCostSharingEnforcement() {
        return this.getBooleanValue("budgetCostSharingEnforcementFlag");
    }

    protected Boolean loadUnrecoveredFandAEnforcement() {
        return this.getBooleanValue("budgetUnrecoveredFandAEnforcementFlag");
    }

    public java.sql.Date createDateFromString(String budgetFiscalYearStart) {
        if (budgetFiscalYearStart == null) {
            return null;
        }
        String[] dateParts = budgetFiscalYearStart.split("/");
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.valueOf(dateParts[2]), Integer.valueOf(dateParts[0]) - 1, Integer.valueOf(dateParts[1]), 0, 0, 0);
        return new java.sql.Date(calendar.getTimeInMillis());
    }

    private FiscalYearApplicableRate findApplicableRatesForFiscalYear(Integer fiscalYear) {
        String unrecoveredFandARateClassCode = this.getUrRateClassCode();
        if (unrecoveredFandARateClassCode == null || unrecoveredFandARateClassCode.trim().length() == 0) {
            return new FiscalYearApplicableRate(fiscalYear, ScaleThreeDecimal.ZERO, ScaleThreeDecimal.ZERO);
        }
        ScaleThreeDecimal offCampusRate = this.findApplicableRateForRateClassCode(fiscalYear, unrecoveredFandARateClassCode, false);
        ScaleThreeDecimal onCampusRate = this.findApplicableRateForRateClassCode(fiscalYear, unrecoveredFandARateClassCode, true);
        return new FiscalYearApplicableRate(fiscalYear, onCampusRate, offCampusRate);
    }

    private ScaleThreeDecimal findApplicableRateForRateClassCode(Integer fiscalYear, String unrecoveredFandARateClassCode, boolean findOnCampusRate) {
        ScaleThreeDecimal applicableRate = ScaleThreeDecimal.ZERO;
        for (BudgetRate budgetRate : this.getBudgetRates()) {
            if (!Integer.valueOf(budgetRate.getFiscalYear()).equals(fiscalYear) || !budgetRate.getRateClassCode().equalsIgnoreCase(unrecoveredFandARateClassCode) || findOnCampusRate != budgetRate.getOnOffCampusFlag()) continue;
            applicableRate = new ScaleThreeDecimal(budgetRate.getApplicableRate().bigDecimalValue());
            break;
        }
        return applicableRate;
    }

    private List<FiscalYearSummary> findCostShareTotalsForBudgetPeriods(Map<Integer, List<BudgetPeriod>> budgetPeriodFiscalYears) {
        ArrayList<FiscalYearSummary> fiscalYearSummaries = new ArrayList<FiscalYearSummary>();
        for (Map.Entry<Integer, List<BudgetPeriod>> entry : budgetPeriodFiscalYears.entrySet()) {
            ScaleTwoDecimal fiscalYearCostShareAmount = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal fiscalYearUnrecoveredFandA = ScaleTwoDecimal.ZERO;
            List<BudgetPeriod> budgetPeriodsInFiscalYear = entry.getValue();
            for (BudgetPeriod budgetPeriod : budgetPeriodsInFiscalYear) {
                fiscalYearCostShareAmount = (ScaleTwoDecimal)fiscalYearCostShareAmount.add((AbstractDecimal)budgetPeriod.getCostSharingAmount());
                fiscalYearUnrecoveredFandA = (ScaleTwoDecimal)fiscalYearUnrecoveredFandA.add((AbstractDecimal)budgetPeriod.getUnderrecoveryAmount());
            }
            fiscalYearSummaries.add(new FiscalYearSummary(budgetPeriodsInFiscalYear.get(0), entry.getKey(), fiscalYearCostShareAmount, fiscalYearUnrecoveredFandA, this.findApplicableRatesForFiscalYear(entry.getKey())));
        }
        return fiscalYearSummaries;
    }

    private List<ScaleTwoDecimal> findProjectIncomeTotalsForBudgetPeriods(Map<Integer, ScaleTwoDecimal> incomes) {
        ArrayList<ScaleTwoDecimal> periodIncomeTotals = new ArrayList<ScaleTwoDecimal>(this.budgetPeriods.size());
        for (BudgetPeriod budgetPeriod : this.budgetPeriods) {
            ScaleTwoDecimal periodIncomeTotal = incomes.get(budgetPeriod.getBudgetPeriod());
            if (periodIncomeTotal == null) {
                periodIncomeTotal = ScaleTwoDecimal.ZERO;
            }
            periodIncomeTotals.add(periodIncomeTotal);
        }
        return periodIncomeTotals;
    }

    private int getCollectionSize(Collection collection) {
        return collection != null ? collection.size() : 0;
    }

    private java.sql.Date getFiscalYearStart() {
        return this.loadFiscalYearStart();
    }

    protected Boolean getBooleanValue(String parmName) {
        String parmValue = this.getParameterService().parameterExists(Budget.class, parmName) == false ? FALSE_FLAG : this.getParameterService().getParameterValueAsString(Budget.class, parmName);
        return parmValue.equalsIgnoreCase(TRUE_FLAG);
    }

    public String getUnitNumber() {
        return this.getBudgetParent().getUnitNumber();
    }

    public Map<Integer, ScaleTwoDecimal> mapProjectIncomeTotalsToBudgetPeriodNumbers() {
        TreeMap<Integer, ScaleTwoDecimal> budgetPeriodProjectIncomeMap = new TreeMap<Integer, ScaleTwoDecimal>();
        for (BudgetProjectIncome budgetProjectIncome : this.budgetProjectIncomes) {
            Integer budgetPeriodNumber = budgetProjectIncome.getBudgetPeriodNumber();
            ScaleTwoDecimal amount = (ScaleTwoDecimal)budgetPeriodProjectIncomeMap.get(budgetPeriodNumber);
            amount = amount == null ? budgetProjectIncome.getProjectIncome() : (ScaleTwoDecimal)amount.add((AbstractDecimal)budgetProjectIncome.getProjectIncome());
            budgetPeriodProjectIncomeMap.put(budgetPeriodNumber, amount);
        }
        return budgetPeriodProjectIncomeMap;
    }

    private Map<Integer, List<BudgetPeriod>> mapBudgetPeriodsToFiscalYears() {
        TreeMap<Integer, List<BudgetPeriod>> budgetPeriodFiscalYears = new TreeMap<Integer, List<BudgetPeriod>>();
        for (BudgetPeriod budgetPeriod : this.getBudgetPeriods()) {
            Integer fiscalYear = budgetPeriod.calculateFiscalYear(this.getFiscalYearStart());
            List budgetPeriodsInFiscalYear = budgetPeriodFiscalYears.computeIfAbsent(fiscalYear, k -> new ArrayList());
            budgetPeriodsInFiscalYear.add(budgetPeriod);
            budgetPeriodsInFiscalYear.sort(BudgetPeriod.getBudgetPeriodDateComparator());
        }
        return budgetPeriodFiscalYears;
    }

    public List<KeyValue> getBudgetCategoryTypeCodes() {
        return this.budgetCategoryTypeCodes;
    }

    public void setBudgetCategoryTypeCodes(List<KeyValue> budgetCategoryTypeCodes) {
        this.budgetCategoryTypeCodes = budgetCategoryTypeCodes;
    }

    public List<BudgetPersonnelDetails> getBudgetPersonnelDetailsList() {
        return this.budgetPersonnelDetailsList;
    }

    public void setBudgetPersonnelDetailsList(List<BudgetPersonnelDetails> budgetPersonnelDetailsList) {
        this.budgetPersonnelDetailsList = budgetPersonnelDetailsList;
    }

    public String getBudgetJustification() {
        return this.budgetJustification;
    }

    public void setBudgetJustification(String budgetJustification) {
        this.budgetJustification = budgetJustification;
    }

    public String getOnOffCampusFlagDescription() {
        return this.getBudgetSummaryService().getOnOffCampusFlagDescription(this.getOnOffCampusFlag());
    }

    public boolean isBudgetLineItemDeleted() {
        return this.budgetLineItemDeleted;
    }

    public void setBudgetLineItemDeleted(boolean budgetLineItemDeleted) {
        this.budgetLineItemDeleted = budgetLineItemDeleted;
    }

    public List<BudgetPrintForm> getBudgetPrintForms() {
        return this.budgetPrintForms;
    }

    public void setBudgetPrintForms(List<BudgetPrintForm> budgetPrintForms) {
        this.budgetPrintForms = budgetPrintForms;
    }

    public boolean isRateClassTypesReloaded() {
        return this.rateClassTypesReloaded;
    }

    public void setRateClassTypesReloaded(boolean rateClassTypesReloaded) {
        this.rateClassTypesReloaded = rateClassTypesReloaded;
    }

    public List<BudgetSubAwards> getBudgetSubAwards() {
        return this.budgetSubAwards;
    }

    public void setBudgetSubAwards(List<BudgetSubAwards> budgetSubAwards) {
        this.budgetSubAwards = budgetSubAwards;
    }

    public boolean isRateSynced() {
        return this.rateSynced;
    }

    public void setRateSynced(boolean rateSynced) {
        this.rateSynced = rateSynced;
    }

    public SortedMap<BudgetCategoryType, List<CostElement>> getObjectCodeListByBudgetCategoryType() {
        return this.objectCodeListByBudgetCategoryType;
    }

    public void setObjectCodeListByBudgetCategoryType(SortedMap<BudgetCategoryType, List<CostElement>> objectCodeListByBudgetCategoryType) {
        this.objectCodeListByBudgetCategoryType = objectCodeListByBudgetCategoryType;
    }

    public SortedMap<CostElement, List<BudgetPersonnelDetails>> getObjectCodePersonnelList() {
        return this.objectCodePersonnelList;
    }

    public void setObjectCodePersonnelList(SortedMap<CostElement, List<BudgetPersonnelDetails>> objectCodePersonnelList) {
        this.objectCodePersonnelList = objectCodePersonnelList;
    }

    public SortedMap<String, List<ScaleTwoDecimal>> getObjectCodePersonnelSalaryTotals() {
        return this.objectCodePersonnelSalaryTotals;
    }

    public void setObjectCodePersonnelSalaryTotals(SortedMap<String, List<ScaleTwoDecimal>> objectCodePersonnelSalaryTotals) {
        this.objectCodePersonnelSalaryTotals = objectCodePersonnelSalaryTotals;
    }

    public SortedMap<String, List<ScaleTwoDecimal>> getObjectCodePersonnelFringeTotals() {
        return this.objectCodePersonnelFringeTotals;
    }

    public void setObjectCodePersonnelFringeTotals(SortedMap<String, List<ScaleTwoDecimal>> objectCodePersonnelFringeTotals) {
        this.objectCodePersonnelFringeTotals = objectCodePersonnelFringeTotals;
    }

    public SortedMap<RateType, List<ScaleTwoDecimal>> getPersonnelCalculatedExpenseTotals() {
        return this.personnelCalculatedExpenseTotals;
    }

    public void setPersonnelCalculatedExpenseTotals(SortedMap<RateType, List<ScaleTwoDecimal>> personnelCalculatedExpenseTotals) {
        this.personnelCalculatedExpenseTotals = personnelCalculatedExpenseTotals;
    }

    public SortedMap<RateType, List<ScaleTwoDecimal>> getNonPersonnelCalculatedExpenseTotals() {
        return this.nonPersonnelCalculatedExpenseTotals;
    }

    public void setNonPersonnelCalculatedExpenseTotals(SortedMap<RateType, List<ScaleTwoDecimal>> nonPersonnelCalculatedExpenseTotals) {
        this.nonPersonnelCalculatedExpenseTotals = nonPersonnelCalculatedExpenseTotals;
    }

    public SortedMap<String, List<ScaleTwoDecimal>> getBudgetSummaryTotals() {
        return this.budgetSummaryTotals;
    }

    public void setBudgetSummaryTotals(SortedMap<String, List<ScaleTwoDecimal>> budgetSummaryTotals) {
        this.budgetSummaryTotals = budgetSummaryTotals;
    }

    public final ScaleTwoDecimal getSumUnderreoveryAmountFromPeriods() {
        ScaleTwoDecimal amount = ScaleTwoDecimal.ZERO;
        for (BudgetPeriod period : this.getBudgetPeriods()) {
            amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)period.getUnderrecoveryAmount());
        }
        return amount;
    }

    public final ScaleTwoDecimal getSumCostSharingAmountFromPeriods() {
        ScaleTwoDecimal amount = ScaleTwoDecimal.ZERO;
        for (BudgetPeriod period : this.getBudgetPeriods()) {
            amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)period.getCostSharingAmount());
        }
        return amount;
    }

    public ScaleTwoDecimal getSumDirectCostAmountFromPeriods() {
        ScaleTwoDecimal amount = ScaleTwoDecimal.ZERO;
        for (BudgetPeriod period : this.getBudgetPeriods()) {
            amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)period.getTotalDirectCost());
        }
        return amount;
    }

    public final ScaleTwoDecimal getSumIndirectCostAmountFromPeriods() {
        ScaleTwoDecimal amount = ScaleTwoDecimal.ZERO;
        for (BudgetPeriod period : this.getBudgetPeriods()) {
            amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)period.getTotalIndirectCost());
        }
        return amount;
    }

    public final ScaleTwoDecimal getSumTotalCostAmountFromPeriods() {
        ScaleTwoDecimal amount = ScaleTwoDecimal.ZERO;
        for (BudgetPeriod period : this.getBudgetPeriods()) {
            amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)period.getTotalCost());
        }
        return amount;
    }

    public boolean getOhRatesNonEditable() {
        return false;
    }

    public boolean getEbRatesNonEditable() {
        return false;
    }

    public BudgetPeriod getNewBudgetPeriod() {
        return new BudgetPeriod();
    }

    public BudgetLineItem getNewBudgetLineItem() {
        return new BudgetLineItem();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.activityTypeCode == null ? 0 : this.activityTypeCode.hashCode());
        result = 31 * result + (this.budgetCategoryTypeCodes == null ? 0 : this.budgetCategoryTypeCodes.hashCode());
        result = 31 * result + (this.budgetCostShares == null ? 0 : this.budgetCostShares.hashCode());
        result = 31 * result + (this.budgetJustification == null ? 0 : this.budgetJustification.hashCode());
        result = 31 * result + (this.budgetLaRates == null ? 0 : this.budgetLaRates.hashCode());
        result = 31 * result + (this.budgetLineItemDeleted ? 1231 : 1237);
        result = 31 * result + (this.budgetPeriods == null ? 0 : this.budgetPeriods.hashCode());
        result = 31 * result + (this.budgetPersonnelDetailsList == null ? 0 : this.budgetPersonnelDetailsList.hashCode());
        result = 31 * result + (this.budgetPersons == null ? 0 : this.budgetPersons.hashCode());
        result = 31 * result + (this.budgetPrintForms == null ? 0 : this.budgetPrintForms.hashCode());
        result = 31 * result + (this.budgetProjectIncomes == null ? 0 : this.budgetProjectIncomes.hashCode());
        result = 31 * result + (this.budgetRates == null ? 0 : this.budgetRates.hashCode());
        result = 31 * result + (this.budgetSubAwards == null ? 0 : this.budgetSubAwards.hashCode());
        result = 31 * result + (this.budgetSummaryTotals == null ? 0 : this.budgetSummaryTotals.hashCode());
        result = 31 * result + (this.budgetUnrecoveredFandAs == null ? 0 : this.budgetUnrecoveredFandAs.hashCode());
        result = 31 * result + (this.calculatedExpenseTotals == null ? 0 : this.calculatedExpenseTotals.hashCode());
        result = 31 * result + (this.instituteLaRates == null ? 0 : this.instituteLaRates.hashCode());
        result = 31 * result + (this.instituteRates == null ? 0 : this.instituteRates.hashCode());
        result = 31 * result + (this.nonPersonnelCalculatedExpenseTotals == null ? 0 : this.nonPersonnelCalculatedExpenseTotals.hashCode());
        result = 31 * result + (this.objectCodeListByBudgetCategoryType == null ? 0 : this.objectCodeListByBudgetCategoryType.hashCode());
        result = 31 * result + (this.objectCodePersonnelFringeTotals == null ? 0 : this.objectCodePersonnelFringeTotals.hashCode());
        result = 31 * result + (this.objectCodePersonnelList == null ? 0 : this.objectCodePersonnelList.hashCode());
        result = 31 * result + (this.objectCodePersonnelSalaryTotals == null ? 0 : this.objectCodePersonnelSalaryTotals.hashCode());
        result = 31 * result + (this.objectCodeTotals == null ? 0 : this.objectCodeTotals.hashCode());
        result = 31 * result + (this.personnelCalculatedExpenseTotals == null ? 0 : this.personnelCalculatedExpenseTotals.hashCode());
        result = 31 * result + (this.rateClass == null ? 0 : this.rateClass.hashCode());
        result = 31 * result + (this.rateClassTypes == null ? 0 : this.rateClassTypes.hashCode());
        result = 31 * result + (this.rateClassTypesReloaded ? 1231 : 1237);
        result = 31 * result + (this.rateClasses == null ? 0 : this.rateClasses.hashCode());
        result = 31 * result + (this.rateSynced ? 1231 : 1237);
        result = 31 * result + (this.summaryPeriodEndDate == null ? 0 : this.summaryPeriodEndDate.hashCode());
        result = 31 * result + (this.summaryPeriodStartDate == null ? 0 : this.summaryPeriodStartDate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Budget other = (Budget)obj;
        if (this.activityTypeCode == null ? other.activityTypeCode != null : !this.activityTypeCode.equals(other.activityTypeCode)) {
            return false;
        }
        if (this.budgetCategoryTypeCodes == null ? other.budgetCategoryTypeCodes != null : !this.budgetCategoryTypeCodes.equals(other.budgetCategoryTypeCodes)) {
            return false;
        }
        if (this.budgetCostShares == null ? other.budgetCostShares != null : !this.budgetCostShares.equals(other.budgetCostShares)) {
            return false;
        }
        if (this.budgetJustification == null ? other.budgetJustification != null : !this.budgetJustification.equals(other.budgetJustification)) {
            return false;
        }
        if (this.budgetLaRates == null ? other.budgetLaRates != null : !this.budgetLaRates.equals(other.budgetLaRates)) {
            return false;
        }
        if (this.budgetLineItemDeleted != other.budgetLineItemDeleted) {
            return false;
        }
        if (this.budgetPeriods == null ? other.budgetPeriods != null : !this.budgetPeriods.equals(other.budgetPeriods)) {
            return false;
        }
        if (this.budgetPersonnelDetailsList == null ? other.budgetPersonnelDetailsList != null : !this.budgetPersonnelDetailsList.equals(other.budgetPersonnelDetailsList)) {
            return false;
        }
        if (this.budgetPersons == null ? other.budgetPersons != null : !this.budgetPersons.equals(other.budgetPersons)) {
            return false;
        }
        if (this.budgetPrintForms == null ? other.budgetPrintForms != null : !this.budgetPrintForms.equals(other.budgetPrintForms)) {
            return false;
        }
        if (this.budgetProjectIncomes == null ? other.budgetProjectIncomes != null : !this.budgetProjectIncomes.equals(other.budgetProjectIncomes)) {
            return false;
        }
        if (this.budgetRates == null ? other.budgetRates != null : !this.budgetRates.equals(other.budgetRates)) {
            return false;
        }
        if (this.budgetSubAwards == null ? other.budgetSubAwards != null : !this.budgetSubAwards.equals(other.budgetSubAwards)) {
            return false;
        }
        if (this.budgetSummaryTotals == null ? other.budgetSummaryTotals != null : !this.budgetSummaryTotals.equals(other.budgetSummaryTotals)) {
            return false;
        }
        if (this.budgetUnrecoveredFandAs == null ? other.budgetUnrecoveredFandAs != null : !this.budgetUnrecoveredFandAs.equals(other.budgetUnrecoveredFandAs)) {
            return false;
        }
        if (this.calculatedExpenseTotals == null ? other.calculatedExpenseTotals != null : !this.calculatedExpenseTotals.equals(other.calculatedExpenseTotals)) {
            return false;
        }
        if (this.instituteLaRates == null ? other.instituteLaRates != null : !this.instituteLaRates.equals(other.instituteLaRates)) {
            return false;
        }
        if (this.instituteRates == null ? other.instituteRates != null : !this.instituteRates.equals(other.instituteRates)) {
            return false;
        }
        if (this.nonPersonnelCalculatedExpenseTotals == null ? other.nonPersonnelCalculatedExpenseTotals != null : !this.nonPersonnelCalculatedExpenseTotals.equals(other.nonPersonnelCalculatedExpenseTotals)) {
            return false;
        }
        if (this.objectCodeListByBudgetCategoryType == null ? other.objectCodeListByBudgetCategoryType != null : !this.objectCodeListByBudgetCategoryType.equals(other.objectCodeListByBudgetCategoryType)) {
            return false;
        }
        if (this.objectCodePersonnelFringeTotals == null ? other.objectCodePersonnelFringeTotals != null : !this.objectCodePersonnelFringeTotals.equals(other.objectCodePersonnelFringeTotals)) {
            return false;
        }
        if (this.objectCodePersonnelList == null ? other.objectCodePersonnelList != null : !this.objectCodePersonnelList.equals(other.objectCodePersonnelList)) {
            return false;
        }
        if (this.objectCodePersonnelSalaryTotals == null ? other.objectCodePersonnelSalaryTotals != null : !this.objectCodePersonnelSalaryTotals.equals(other.objectCodePersonnelSalaryTotals)) {
            return false;
        }
        if (this.objectCodeTotals == null ? other.objectCodeTotals != null : !this.objectCodeTotals.equals(other.objectCodeTotals)) {
            return false;
        }
        if (this.personnelCalculatedExpenseTotals == null ? other.personnelCalculatedExpenseTotals != null : !this.personnelCalculatedExpenseTotals.equals(other.personnelCalculatedExpenseTotals)) {
            return false;
        }
        if (this.rateClass == null ? other.rateClass != null : !this.rateClass.equals(other.rateClass)) {
            return false;
        }
        if (this.rateClassTypes == null ? other.rateClassTypes != null : !this.rateClassTypes.equals(other.rateClassTypes)) {
            return false;
        }
        if (this.rateClassTypesReloaded != other.rateClassTypesReloaded) {
            return false;
        }
        if (this.rateClasses == null ? other.rateClasses != null : !this.rateClasses.equals(other.rateClasses)) {
            return false;
        }
        if (this.rateSynced != other.rateSynced) {
            return false;
        }
        if (this.summaryPeriodEndDate == null ? other.summaryPeriodEndDate != null : !this.summaryPeriodEndDate.equals(other.summaryPeriodEndDate)) {
            return false;
        }
        return !(this.summaryPeriodStartDate == null ? other.summaryPeriodStartDate != null : !this.summaryPeriodStartDate.equals(other.summaryPeriodStartDate));
    }

    public BudgetPersonnelDetails getNewBudgetPersonnelLineItem() {
        return new BudgetPersonnelDetails();
    }

    public boolean isCostSharingSubmissionEnabled() {
        return this.getParameterService().getParameterValueAsString(Budget.class, "ENABLE_COST_SHARE_SUBMIT").equals(PARAM_VALUE_ENABLED);
    }

    public String getSummaryNumberOfMonths() {
        return String.valueOf(this.getProposalBudgetNumberOfMonthsService().getNumberOfMonth(this.getSummaryPeriodStartDate(), this.getSummaryPeriodEndDate()));
    }

    protected ProposalBudgetNumberOfMonthsService getProposalBudgetNumberOfMonthsService() {
        return KcServiceLocator.getService(ProposalBudgetNumberOfMonthsService.class);
    }

    public Date getBudgetStartDate() {
        throw new UnsupportedOperationException();
    }

    public Date getBudgetEndDate() {
        throw new UnsupportedOperationException();
    }

    public Boolean getViewOnly() {
        return this.viewOnly;
    }

    public Boolean isViewOnly() {
        return this.viewOnly;
    }

    public void setViewOnly(Boolean viewOnly) {
        this.viewOnly = viewOnly;
    }

    public List<BudgetPersonnelDetails> getBudgetPersonnelDetails() {
        String personnelBudgetCategoryTypeCode = this.getBudgetCalculationService().getPersonnelBudgetCategoryTypeCode();
        ArrayList<BudgetPersonnelDetails> budgetPersonnelDetailsList = new ArrayList<BudgetPersonnelDetails>();
        for (BudgetPeriod budgetPeriod : this.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (budgetLineItem.getCostElementBO() == null || !budgetLineItem.getCostElementBO().getBudgetCategory().getBudgetCategoryTypeCode().equalsIgnoreCase(personnelBudgetCategoryTypeCode)) continue;
                if (budgetLineItem.getBudgetPersonnelDetailsList().size() > 0) {
                    budgetPersonnelDetailsList.addAll(budgetLineItem.getBudgetPersonnelDetailsList());
                    continue;
                }
                budgetPersonnelDetailsList.add(new BudgetPersonnelDetails(budgetLineItem));
            }
        }
        return budgetPersonnelDetailsList;
    }

    public List<BudgetLineItem> getBudgetLineItems() {
        String personnelBudgetCategoryTypeCode = this.getBudgetCalculationService().getPersonnelBudgetCategoryTypeCode();
        ArrayList<BudgetLineItem> budgetLineItems = new ArrayList<BudgetLineItem>();
        for (BudgetPeriod budgetPeriod : this.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode().equalsIgnoreCase(personnelBudgetCategoryTypeCode)) continue;
                budgetLineItems.add(budgetLineItem);
            }
        }
        return budgetLineItems;
    }

    public List<Period> getBudgetSummaryDetails() {
        return this.getBudgetCalculationService().retrieveBudgetSummaryTotals(this);
    }

    protected BudgetCalculationService getBudgetCalculationService() {
        if (this.budgetCalculationService == null) {
            this.budgetCalculationService = KcServiceLocator.getService(BudgetCalculationService.class);
        }
        return this.budgetCalculationService;
    }

    public Timestamp getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(Timestamp createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public String getParentDocumentTypeCode() {
        return this.parentDocumentTypeCode;
    }

    public void setParentDocumentTypeCode(String parentDocumentTypeCode) {
        this.parentDocumentTypeCode = parentDocumentTypeCode;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    private static class RateClassTypeComparator
    implements Comparator<RateClassType>,
    Serializable {
        private static final long serialVersionUID = 8230902362851330642L;

        private RateClassTypeComparator() {
        }

        @Override
        public int compare(RateClassType rateClassType1, RateClassType rateClassType2) {
            return rateClassType1.getSortId().compareTo(rateClassType2.getSortId());
        }
    }

    public static class FiscalYearSummary {
        private int fiscalYear;
        private BudgetPeriod assignedBudgetPeriod;
        private ScaleTwoDecimal costShare;
        private ScaleTwoDecimal unrecoveredFandA;
        private FiscalYearApplicableRate fiscalYearRates;

        public FiscalYearSummary(BudgetPeriod assignedBudgetPeriod, int fiscalYear, ScaleTwoDecimal costShare, ScaleTwoDecimal unrecoveredFandA, FiscalYearApplicableRate fiscalYearRates) {
            this.assignedBudgetPeriod = assignedBudgetPeriod;
            this.fiscalYear = fiscalYear;
            this.costShare = costShare;
            this.unrecoveredFandA = unrecoveredFandA;
            this.fiscalYearRates = fiscalYearRates;
        }

        public int getFiscalYear() {
            return this.fiscalYear;
        }

        public BudgetPeriod getAssignedBudgetPeriod() {
            return this.assignedBudgetPeriod;
        }

        public ScaleTwoDecimal getCostShare() {
            return this.costShare;
        }

        public FiscalYearApplicableRate getFiscalYearRates() {
            return this.fiscalYearRates;
        }

        public ScaleTwoDecimal getUnrecoveredFandA() {
            return this.unrecoveredFandA;
        }
    }

    public static class FiscalYearApplicableRate {
        private Integer fiscalYear;
        private ScaleThreeDecimal onCampusApplicableRate;
        private ScaleThreeDecimal offCampusApplicableRate;

        public FiscalYearApplicableRate(Integer fiscalYear, ScaleThreeDecimal onCampusApplicableRate, ScaleThreeDecimal offCampusApplicableRate) {
            this.fiscalYear = fiscalYear;
            this.onCampusApplicableRate = onCampusApplicableRate;
            this.offCampusApplicableRate = offCampusApplicableRate;
        }

        public Integer getFiscalYear() {
            return this.fiscalYear;
        }

        public ScaleThreeDecimal getOnCampusApplicableRate() {
            return this.onCampusApplicableRate;
        }

        public ScaleThreeDecimal getOffCampusApplicableRate() {
            return this.offCampusApplicableRate;
        }
    }
}

