/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.notification;

import java.util.List;
import org.kuali.coeus.common.notification.impl.NotificationAwareForm;
import org.kuali.coeus.common.notification.impl.NotificationContext;
import org.kuali.coeus.common.notification.impl.bo.KcNotification;
import org.kuali.coeus.common.notification.impl.bo.NotificationTypeRecipient;
import org.kuali.coeus.common.notification.impl.rule.event.SendNotificationEvent;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.common.view.wizard.framework.WizardControllerService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.notification.NotificationControllerService;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotification;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationContext;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

@Component(value="notificationControllerService")
public class NotificationControllerServiceImpl
implements NotificationControllerService {
    @Autowired
    @Qualifier(value="kualiRuleService")
    private KualiRuleService kualiRuleService;
    @Autowired
    @Qualifier(value="refreshControllerService")
    private RefreshControllerService refreshControllerService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="kcNotificationService")
    private KcNotificationService kcNotificationService;
    @Autowired
    @Qualifier(value="wizardControllerService")
    private WizardControllerService wizardControllerService;
    @Autowired
    @Qualifier(value="modelAndViewService")
    private ModelAndViewService modelAndViewService;

    @Override
    public <T extends NotificationContext> ModelAndView sendNotification(NotificationAwareForm<T> form) {
        if (form.isSendNotification()) {
            return this.getModelAndViewService().showDialog("Kc-SendNotification-Wizard", true, (UifFormBase)form);
        }
        form.setSendNotification(false);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Override
    public <T extends NotificationContext> ModelAndView performRecipientSearch(NotificationAwareForm<T> form) {
        form.getAddRecipientHelper().getResults().clear();
        form.getAddRecipientHelper().setResults(this.getWizardControllerService().performWizardSearch(form.getAddRecipientHelper().getLookupFieldValues(), form.getAddRecipientHelper().getLineType()));
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Override
    public <T extends NotificationContext> ModelAndView addRecipients(NotificationAwareForm<T> form) {
        form.getNotificationHelper().getNotificationRecipients().addAll(this.getKcNotificationService().addRecipient(form.getAddRecipientHelper().getResults()));
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Override
    public <T extends NotificationContext> ModelAndView sendNotifications(NotificationAwareForm<T> form, T context) {
        Document document = form.getDocument();
        KcNotification notification = form.getNotificationHelper().getNotification();
        List<NotificationTypeRecipient> notificationRecipients = form.getNotificationHelper().getNotificationRecipients();
        if (this.getKualiRuleService().applyRules((DocumentEvent)new SendNotificationEvent(document, notification, notificationRecipients))) {
            if (context instanceof ProposalDevelopmentNotificationContext) {
                DevelopmentProposal propDev = ((ProposalDevelopmentNotificationContext)context).getProposal();
                form.getNotificationHelper().sendNotificationAndPersist(new ProposalDevelopmentNotification(), propDev);
            } else {
                form.getNotificationHelper().sendNotification();
            }
        }
        form.getNotificationHelper().initializeDefaultValues(context);
        form.getAddRecipientHelper().reset();
        this.populateDeferredMessages(form);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Override
    public <T extends NotificationContext> void sendNotificationIfNoErrors(NotificationAwareForm<T> form, T context) {
        if (this.getGlobalVariableService().getMessageMap().hasNoErrors()) {
            if (form.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                form.getNotificationHelper().initializeDefaultValues(context);
                form.setSendNotification(true);
            } else if (context instanceof ProposalDevelopmentNotificationContext) {
                DevelopmentProposal propDev = ((ProposalDevelopmentNotificationContext)context).getProposal();
                this.getKcNotificationService().sendNotificationAndPersist(context, new ProposalDevelopmentNotification(), propDev);
            } else {
                this.getKcNotificationService().sendNotification(context);
            }
        } else {
            form.setSendNotification(false);
        }
    }

    @Override
    public <T extends NotificationContext> ModelAndView prepareNotificationWizard(NotificationAwareForm<T> form) {
        String step = form.getNotificationHelper().getNotificationRecipients().isEmpty() ? "0" : "2";
        form.getActionParameters().put("Kc-SendNotification-Wizard.step", step);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Override
    public <T extends NotificationContext> ModelAndView cancelNotifications(NotificationAwareForm<T> form) {
        this.populateDeferredMessages(form);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    private void populateDeferredMessages(NotificationAwareForm<?> form) {
        if (form.getDeferredMessages() != null && form.getDeferredMessages().hasMessages()) {
            MessageMap messageMap = form.getDeferredMessages();
            MessageMap currentMessageMap = this.getGlobalVariableService().getMessageMap();
            messageMap.getErrorMessages().putAll(currentMessageMap.getErrorMessages());
            messageMap.getInfoMessages().putAll(currentMessageMap.getInfoMessages());
            messageMap.getWarningMessages().putAll(currentMessageMap.getWarningMessages());
            this.getGlobalVariableService().setMessageMap(messageMap);
        }
        form.setDeferredMessages(null);
    }

    public KualiRuleService getKualiRuleService() {
        return this.kualiRuleService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    public RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public KcNotificationService getKcNotificationService() {
        return this.kcNotificationService;
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }

    public WizardControllerService getWizardControllerService() {
        return this.wizardControllerService;
    }

    public void setWizardControllerService(WizardControllerService wizardControllerService) {
        this.wizardControllerService = wizardControllerService;
    }

    public ModelAndViewService getModelAndViewService() {
        return this.modelAndViewService;
    }

    public void setModelAndViewService(ModelAndViewService modelAndViewService) {
        this.modelAndViewService = modelAndViewService;
    }
}

