/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.commitments;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardCostShareAuditRule
implements DocumentAuditRule {
    private static final String AUDIT_CLUSTER = "costShareAuditErrors";
    private List<AuditError> auditErrors;

    public boolean processRunAuditBusinessRules(Document document) {
        AwardDocument awardDocument = (AwardDocument)document;
        Award award = awardDocument.getAward();
        boolean retval = this.validateCostShareDoesNotViolateUniqueConstraintNonNull(award.getAwardCostShares());
        if (!retval) {
            this.reportAndCreateAuditCluster();
        }
        return retval;
    }

    public boolean validateCostShareDoesNotViolateUniqueConstraintNonNull(List<AwardCostShare> awardCostShares) {
        boolean valid = true;
        for (AwardCostShare costShare1 : awardCostShares) {
            if (costShare1.getCostShareTypeCode() != null) {
                for (AwardCostShare costShare2 : awardCostShares) {
                    if (costShare1 == costShare2 || !StringUtils.equals((CharSequence)costShare1.getProjectPeriod(), (CharSequence)costShare2.getProjectPeriod()) || !costShare1.getCostShareTypeCode().equals(costShare2.getCostShareTypeCode()) || !StringUtils.equalsIgnoreCase((CharSequence)costShare1.getSource(), (CharSequence)costShare2.getSource()) || !StringUtils.equalsIgnoreCase((CharSequence)costShare1.getDestination(), (CharSequence)costShare2.getDestination())) continue;
                    valid = false;
                    this.addAuditError(new AuditError("document.awardList[0].awardCostShares[" + awardCostShares.indexOf(costShare1) + "].fiscalYear", "error.awardCostShare.duplicate.entry", "commitments.CostShare"));
                }
                continue;
            }
            valid = false;
            this.addAuditError(new AuditError("document.awardList[0].awardCostShares[" + awardCostShares.indexOf(costShare1) + "].costShareTypeCode", "error.awardCostShare.costShareTypeCode.required", "commitments.CostShare"));
        }
        return valid;
    }

    private void addAuditError(AuditError auditError) {
        if (this.auditErrors == null) {
            this.auditErrors = new ArrayList<AuditError>();
        }
        this.auditErrors.add(auditError);
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            GlobalVariables.getAuditErrorMap().put(AUDIT_CLUSTER, new AuditCluster("Cost Share", this.auditErrors, "Error"));
        }
    }
}

