/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.krms;

import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.krms.KcKrmsFactBuilderService;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.repository.category.CategoryDefinition;
import org.kuali.rice.krms.api.repository.term.TermRepositoryService;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.w3c.dom.Document;

public abstract class KcKrmsFactBuilderServiceHelper
implements KcKrmsFactBuilderService {
    protected final Logger LOG = LogManager.getLogger(KcKrmsFactBuilderServiceHelper.class);
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;

    protected String getElementValue(String docContent, String xpathExpression) {
        String string;
        ByteArrayInputStream stream = new ByteArrayInputStream(docContent.getBytes());
        try {
            Document document = XmlHelper.trimXml((InputStream)stream);
            XPath xpath = XPathHelper.newXPath();
            string = (String)xpath.evaluate(xpathExpression, document, XPathConstants.STRING);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RiceRuntimeException((Throwable)e);
            }
        }
        ((InputStream)stream).close();
        return string;
    }

    public void addObjectMembersAsFacts(Facts.Builder factsBuilder, Object factsObject, String contextId, String factTermNS) {
        TermRepositoryService termRepositoryService = (TermRepositoryService)KcServiceLocator.getService("termRepositoryService");
        List termSpecs = termRepositoryService.findAllTermSpecificationsByContextId(contextId);
        for (TermSpecificationDefinition termSpecificationDefinition : termSpecs) {
            String termNS;
            if (!this.isPropertyType(termSpecificationDefinition) || !(termNS = termSpecificationDefinition.getNamespace()).equals(factTermNS)) continue;
            String factKey = termSpecificationDefinition.getName();
            if (factsObject != null) {
                Class<?> factsClazz = factsObject.getClass();
                try {
                    PropertyDescriptor propDescriptor = PropertyUtils.getPropertyDescriptor((Object)factsObject, (String)factKey);
                    if (propDescriptor == null) continue;
                    Object propertyValue = null;
                    Method readMethod = propDescriptor.getReadMethod();
                    if (readMethod != null) {
                        propertyValue = propDescriptor.getReadMethod().invoke(factsObject, new Object[0]);
                    }
                    if (propertyValue != null && propertyValue.getClass().isAssignableFrom(ScaleTwoDecimal.class)) {
                        propertyValue = ((ScaleTwoDecimal)propertyValue).bigDecimalValue();
                    }
                    factsBuilder.addFact(factKey, propertyValue);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                    this.LOG.error("KRMS Fact for " + factKey + " has not been added to fact builder", (Throwable)e);
                }
                continue;
            }
            factsBuilder.addFact(factKey, null);
        }
    }

    private boolean isPropertyType(TermSpecificationDefinition termSpecificationDefinition) {
        List catgories = termSpecificationDefinition.getCategories();
        for (CategoryDefinition categoryDefinition : catgories) {
            if (!categoryDefinition.getName().equals("Property")) continue;
            return true;
        }
        return false;
    }

    @Override
    public KrmsRulesContext getContextForDocContent(String docContent) {
        String documentNumber = this.getElementValue(docContent, "//documentNumber");
        try {
            return (KrmsRulesContext)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

