/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.fundingproposal;

import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.common.framework.keyword.ScienceKeyword;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.fundingproposal.FundingProposalMergeType;
import org.kuali.kra.award.home.fundingproposal.ProposalDataFeedCommandBase;
import org.kuali.kra.award.home.keywords.AwardScienceKeyword;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalScienceKeyword;
import org.kuali.rice.krad.service.BusinessObjectService;

class KeywordsDataFeedCommand
extends ProposalDataFeedCommandBase {
    public KeywordsDataFeedCommand(Award award, InstitutionalProposal proposal, FundingProposalMergeType mergeType) {
        super(award, proposal, mergeType);
    }

    @Override
    void performDataFeed() {
        if (this.mergeType != FundingProposalMergeType.NOCHANGE) {
            List results = null;
            if (!this.proposal.getProposalNumber().equals("1234")) {
                HashMap<String, String> criteria = new HashMap<String, String>();
                criteria.put("proposalNumber", this.proposal.getProposalNumber());
                results = KcServiceLocator.getService(BusinessObjectService.class).findMatching(InstitutionalProposalScienceKeyword.class, criteria);
            } else {
                results = this.proposal.getInstitutionalProposalScienceKeywords();
            }
            if (results != null) {
                for (InstitutionalProposalScienceKeyword ipKeyword : results) {
                    boolean duplicateFound = false;
                    for (AwardScienceKeyword awardKeyword : this.award.getKeywords()) {
                        if (!this.isIdentical(awardKeyword, ipKeyword)) continue;
                        duplicateFound = true;
                        break;
                    }
                    if (duplicateFound) continue;
                    this.award.addKeyword(this.copyScienceKeyword(ipKeyword));
                }
            }
        }
    }

    private boolean isIdentical(AwardScienceKeyword awardKeyword, InstitutionalProposalScienceKeyword ipKeyword) {
        return awardKeyword.getScienceKeywordCode().equals(ipKeyword.getScienceKeywordCode());
    }

    private ScienceKeyword copyScienceKeyword(InstitutionalProposalScienceKeyword ipKeyWord) {
        ScienceKeyword keyword = ipKeyWord.getScienceKeyword();
        if (keyword == null) {
            keyword = new ScienceKeyword();
            keyword.setCode(ipKeyWord.getScienceKeywordCode());
            keyword.setDescription(ipKeyWord.getScienceKeywordDescription());
        }
        return keyword;
    }
}

