/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.print;

import edu.mit.coeus.utils.xml.v2.lookuptypes.ACTIVITYTYPEDocument;
import edu.mit.coeus.utils.xml.v2.lookuptypes.APPLICABLEREVIEWTYPEDocument;
import edu.mit.coeus.utils.xml.v2.lookuptypes.NOTICEOFOPPORTUNITYDocument;
import edu.mit.coeus.utils.xml.v2.lookuptypes.PROPOSALTYPEDocument;
import edu.mit.coeus.utils.xml.v2.lookuptypes.SPECIALREVIEWDocument;
import edu.mit.coeus.utils.xml.v2.organization.ORGANIZATIONDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPINVESTIGATORTYPE;
import edu.mit.coeus.utils.xml.v2.propdev.PROPOSALDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPOSALMASTERDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPPERCREDITSPLITDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPSPECIALREVIEWDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPUNITCREDITSPLITDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPUNITSDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPYNQDocument;
import edu.mit.coeus.utils.xml.v2.rolodex.ADDRESSDocument;
import edu.mit.coeus.utils.xml.v2.rolodex.NAMEDocument;
import edu.mit.coeus.utils.xml.v2.rolodex.ROLODEXDocument;
import edu.mit.coeus.utils.xml.v2.sponsor.SPONSORDocument;
import edu.mit.coeus.utils.xml.v2.userUnit.UNITDocument;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.framework.noo.NoticeOfOpportunity;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.propdev.impl.abstrct.ProposalAbstract;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.editable.ProposalChangedData;
import org.kuali.coeus.propdev.impl.location.ProposalSite;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.propdev.impl.person.creditsplit.ProposalPersonCreditSplit;
import org.kuali.coeus.propdev.impl.print.ProposalBaseStream;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.propdev.impl.ynq.ProposalYnq;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="proposalSubmissionXmlStream")
@Scope(value="prototype")
public class ProposalSubmissionXmlStream
extends ProposalBaseStream<PROPOSALDocument> {
    private static final String DOES_REQUIRE = "does require";
    private static final String DOES_NOT_REQUIRE = "does not require";
    private static final String COI_DEFAULT_VALUE = "__________";
    private static final String INCOMPLETE_STRING_TERMINATOR = "...";
    private static final String CONFLICT_OF_INTEREST = "CONFLICT_OF_INTEREST";
    private static final String NOTICE_OF_OPPORTUNITY_CODE = "noticeOfOpportunityCode";
    private static final String MAIL_SUBMISSINON_METHOD_DHL = "DHL";
    private static final String MAIL_SUBMISSINON_METHOD_REGULAR = "Regular";
    private static final String MAIL_SUBMISSINON_METHOD_ELECTRONIC = "Electronic";
    private static final String MAIL_TYPE_DHL = "3";
    private static final String MAIL_TYPE_REGULAR = "1";
    private static final String MAIL_TYPE_ELECTRONIC = "2";
    private static final String ABSTRACT_TYPE_CODE_MAILING = "16";
    private static final String ABSTRACT_TYPE_CODE_OTHER = "17";
    private static final String STRING_DOUBLE_SEPARATOR = "--";
    private static final String INVESTIGATOR_CREDIT_TYPE_CODE_TWO = "2";
    private static final String INVESTIGATOR_CREDIT_TYPE_CODE_ONE = "1";
    private static final String IDENTIFIER_NO = "No";
    private static final String IDENTIFIER_YES = "Yes";
    private static final String NOT_AVAILABLE = "N/A";
    private static final String PROPOSAL_CHANGE_DATA_COLUMN_NAME_ITAP_FLAG_3 = "ITAP_FLAG_3";
    private static final String PROPOSAL_CHANGE_DATA_COLUMN_NAME_ITAP_FLAG_2 = "ITAP_FLAG_2";
    private static final String PROPOSAL_CHANGE_DATA_COLUMN_NAME_ITAP_FLAG_1 = "ITAP_FLAG_1";
    private static final String QUESTION_ID_E = "E";
    private static final String QUESTION_ID_D = "3";
    private static final String QUESTION_ID_C = "C";
    private static final String QUESTION_ID_B = "B";
    private static final String QUESTION_ID_A = "A";
    private static final String QUESTION_ID_G8 = "G8";
    private static final String PROPOSAL_YNQ_ID_P_03 = "P-03";
    private static final String PROPOSAL_YNQ_ID_P_02 = "P-02";
    private static final String PROPOSAL_YNQ_ID_P_01 = "P-01";
    private static final String CENTER_INSTITUTE_CODE5 = "CENTER_INSTITUTE_CODE5";
    private static final String CENTER_INSTITUTE_CODE4 = "CENTER_INSTITUTE_CODE4";
    private static final String CENTER_INSTITUTE_CODE3 = "CENTER_INSTITUTE_CODE3";
    private static final String CENTER_INSTITUTE_CODE2 = "CENTER_INSTITUTE_CODE2";
    private static final String CENTER_INSTITUTE_CODE = "CENTER_INSTITUTE_CODE";
    private static final String NEW_LINE = "/n";
    private static final String SPONSOR_DEADLINE_RECEIPT_DESCRIPTION = "(Receipt)";
    private static final String SPONSOR_DEADLINE_TYPE_RECEIPT = "R";
    private static final String SPONSOR_DEADLINE_POSTMARK_DESCRIPTION = "(Postmark)";
    private static final String SPONSOR_DEADLINE_TYPE_POSTMARK = "P";
    private static final String STRING_SEPRATOR = "-";
    private static final String BLANK_STRING = " ";
    private static final String OPEN_BRACES = "(";
    private static final String CLOSE_BRACES = ")";
    private static final String IMAGES_PATH = "/images/";
    private static final String REPORT_NAME = "Proposal Submission";

    @Override
    public Class<PROPOSALDocument> type() {
        return PROPOSALDocument.class;
    }

    @Override
    public Map<String, PROPOSALDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        DevelopmentProposal developmentProposal = (DevelopmentProposal)printableBusinessObject;
        Budget budget = this.getBudget(developmentProposal.getProposalDocument());
        PROPOSALDocument proposalDocument = (PROPOSALDocument)PROPOSALDocument.Factory.newInstance();
        PROPOSALDocument.PROPOSAL proposal = this.getProposal(developmentProposal, budget);
        proposalDocument.setPROPOSAL(proposal);
        LinkedHashMap<String, PROPOSALDocument> xmlObjectList = new LinkedHashMap<String, PROPOSALDocument>();
        xmlObjectList.put(REPORT_NAME, proposalDocument);
        return xmlObjectList;
    }

    private PROPOSALDocument.PROPOSAL getProposal(DevelopmentProposal developmentProposal, Budget budget) {
        PROPOSALDocument.PROPOSAL proposal = (PROPOSALDocument.PROPOSAL)PROPOSALDocument.PROPOSAL.Factory.newInstance();
        proposal.setPROPOSALMASTER(this.getProposalMaster(developmentProposal, budget));
        proposal.setLOGOPATH(IMAGES_PATH);
        proposal.setPROPUNITSArray(this.getPropUnits(developmentProposal.getProposalPersons()));
        proposal.setPROPINVESTIGATORSArray(this.getProposalInvestigators(developmentProposal.getProposalPersons()));
        proposal.setPROPSPECIALREVIEWArray(this.getPropSpecialReviews(developmentProposal.getPropSpecialReviews()));
        proposal.setPROPYNQArray(this.getProposalYNQs(developmentProposal.getProposalYnqs(), developmentProposal.getProposalChangedDataList()));
        proposal.setCURDATE(this.getDateTimeService().getCurrentDate().toString());
        return proposal;
    }

    private PROPYNQDocument.PROPYNQ[] getProposalYNQs(List<ProposalYnq> proposalYnqs, List<ProposalChangedData> proposalChangedDataList) {
        PROPYNQDocument.PROPYNQ propYnqB;
        PROPYNQDocument.PROPYNQ propYnqA;
        ArrayList<PROPYNQDocument.PROPYNQ> propYnqList = new ArrayList<PROPYNQDocument.PROPYNQ>();
        PROPYNQDocument.PROPYNQ propYnqG8 = this.getProposalYnqByQuestionId(QUESTION_ID_G8, PROPOSAL_YNQ_ID_P_01, proposalYnqs);
        if (propYnqG8 != null) {
            propYnqList.add(propYnqG8);
        }
        if ((propYnqA = this.getProposalYnqByQuestionId(QUESTION_ID_A, PROPOSAL_YNQ_ID_P_02, proposalYnqs)) != null) {
            propYnqList.add(propYnqA);
        }
        if ((propYnqB = this.getProposalYnqByQuestionId(QUESTION_ID_B, PROPOSAL_YNQ_ID_P_03, proposalYnqs)) != null) {
            propYnqList.add(propYnqB);
        }
        this.setQuestionAnswerForProposalYNQS(proposalChangedDataList, propYnqList);
        return propYnqList.toArray(new PROPYNQDocument.PROPYNQ[0]);
    }

    private void setQuestionAnswerForProposalYNQS(List<ProposalChangedData> proposalChangedDataList, List<PROPYNQDocument.PROPYNQ> propYnqList) {
        PROPYNQDocument.PROPYNQ propYnqC = (PROPYNQDocument.PROPYNQ)PROPYNQDocument.PROPYNQ.Factory.newInstance();
        propYnqC.setQUESTIONID(QUESTION_ID_C);
        propYnqC.setANSWER(this.getProposalChangeDataAnswer(PROPOSAL_CHANGE_DATA_COLUMN_NAME_ITAP_FLAG_1, proposalChangedDataList));
        propYnqList.add(propYnqC);
        PROPYNQDocument.PROPYNQ propYnqD = (PROPYNQDocument.PROPYNQ)PROPYNQDocument.PROPYNQ.Factory.newInstance();
        propYnqD.setQUESTIONID("3");
        propYnqD.setANSWER(this.getProposalChangeDataAnswer(PROPOSAL_CHANGE_DATA_COLUMN_NAME_ITAP_FLAG_2, proposalChangedDataList));
        propYnqList.add(propYnqD);
        PROPYNQDocument.PROPYNQ propYnqE = (PROPYNQDocument.PROPYNQ)PROPYNQDocument.PROPYNQ.Factory.newInstance();
        propYnqE.setQUESTIONID(QUESTION_ID_E);
        propYnqE.setANSWER(this.getProposalChangeDataAnswer(PROPOSAL_CHANGE_DATA_COLUMN_NAME_ITAP_FLAG_3, proposalChangedDataList));
        propYnqList.add(propYnqE);
    }

    private String getProposalChangeDataAnswer(String columenName, List<ProposalChangedData> proposalChangedDataList) {
        ProposalChangedData proposalChangeData = null;
        String columnValue = "";
        for (ProposalChangedData propChangeData : proposalChangedDataList) {
            if (!propChangeData.getColumnName().equals(columenName)) continue;
            proposalChangeData = propChangeData;
            break;
        }
        if (proposalChangeData != null) {
            columnValue = proposalChangeData.getChangedValue();
        }
        return columnValue;
    }

    private PROPYNQDocument.PROPYNQ getProposalYnqByQuestionId(String questionId1, String questionId2, List<ProposalYnq> proposalYnqs) {
        PROPYNQDocument.PROPYNQ propYnq = null;
        ProposalYnq proposalYnq = this.getProposalYnqById(questionId2, proposalYnqs);
        if (proposalYnq != null) {
            propYnq = (PROPYNQDocument.PROPYNQ)PROPYNQDocument.PROPYNQ.Factory.newInstance();
            propYnq.setQUESTIONID(questionId1);
            propYnq.setANSWER(this.getProposalYnqAnswerDetail(proposalYnq.getAnswer()));
            propYnq.setEXPLANATION(proposalYnq.getExplanation());
        }
        return propYnq;
    }

    private String getProposalYnqAnswerDetail(String answer) {
        String detailAnswer = NOT_AVAILABLE;
        if (answer.equals("Y")) {
            detailAnswer = IDENTIFIER_YES;
        }
        if (answer.equals("N")) {
            detailAnswer = IDENTIFIER_NO;
        }
        return detailAnswer;
    }

    private ProposalYnq getProposalYnqById(String questionId, List<ProposalYnq> proposalYnqs) {
        ProposalYnq proposalYnq = null;
        for (ProposalYnq propYnq : proposalYnqs) {
            if (!propYnq.getQuestionId().equals(questionId)) continue;
            proposalYnq = propYnq;
            break;
        }
        return proposalYnq;
    }

    private PROPSPECIALREVIEWDocument.PROPSPECIALREVIEW[] getPropSpecialReviews(List<ProposalSpecialReview> proposalSpecialReviewList) {
        ArrayList<PROPSPECIALREVIEWDocument.PROPSPECIALREVIEW> propSplReviewList = new ArrayList<PROPSPECIALREVIEWDocument.PROPSPECIALREVIEW>();
        for (ProposalSpecialReview specialReview : proposalSpecialReviewList) {
            PROPSPECIALREVIEWDocument.PROPSPECIALREVIEW propSplReview = (PROPSPECIALREVIEWDocument.PROPSPECIALREVIEW)PROPSPECIALREVIEWDocument.PROPSPECIALREVIEW.Factory.newInstance();
            APPLICABLEREVIEWTYPEDocument.APPLICABLEREVIEWTYPE appReviewType = (APPLICABLEREVIEWTYPEDocument.APPLICABLEREVIEWTYPE)APPLICABLEREVIEWTYPEDocument.APPLICABLEREVIEWTYPE.Factory.newInstance();
            appReviewType.setAPPLICABLEREVIEWTYPECODE(0);
            appReviewType.setDESCRIPTION(specialReview.getApprovalType().getDescription());
            propSplReview.setAPPLICABLEREVIEWTYPE(appReviewType);
            SPECIALREVIEWDocument.SPECIALREVIEW splReview = (SPECIALREVIEWDocument.SPECIALREVIEW)SPECIALREVIEWDocument.SPECIALREVIEW.Factory.newInstance();
            splReview.setSPECIALREVIEWCODE(0);
            splReview.setDESCRIPTION(specialReview.getSpecialReviewType().getDescription());
            propSplReview.setSPECIALREVIEW(splReview);
            propSplReview.setPROTOCOLNUMBER(specialReview.getProtocolNumber());
            propSplReview.setPROPOSALNUMBER(specialReview.getDevelopmentProposal().getProposalNumber());
            propSplReviewList.add(propSplReview);
        }
        return propSplReviewList.toArray(new PROPSPECIALREVIEWDocument.PROPSPECIALREVIEW[0]);
    }

    private PROPINVESTIGATORTYPE[] getProposalInvestigators(List<ProposalPerson> proposalPersons) {
        ArrayList<PROPINVESTIGATORTYPE> propInvestigatorList = new ArrayList<PROPINVESTIGATORTYPE>();
        for (ProposalPerson propPerson : proposalPersons) {
            PROPINVESTIGATORTYPE propInvestigator = (PROPINVESTIGATORTYPE)PROPINVESTIGATORTYPE.Factory.newInstance();
            propInvestigator.setPERSONNAME(propPerson.getPerson().getFullName());
            propInvestigator.setPRINCIPALINVESTIGATORFLAG(propPerson.getProposalPersonRoleId());
            PROPPERCREDITSPLITDocument.PROPPERCREDITSPLIT propPersonCredit = (PROPPERCREDITSPLITDocument.PROPPERCREDITSPLIT)PROPPERCREDITSPLITDocument.PROPPERCREDITSPLIT.Factory.newInstance();
            propPersonCredit.setCREDIT(this.getCreditForProposalInvestigator(propPerson));
            propPersonCredit.setPROPUNITCREDITSPLITArray(this.getProposalUnitCreditSplits(propPerson));
            propInvestigator.setPROPPERCREDITSPLIT(propPersonCredit);
            propInvestigatorList.add(propInvestigator);
        }
        return propInvestigatorList.toArray(new PROPINVESTIGATORTYPE[0]);
    }

    private String getCreditForProposalInvestigator(ProposalPerson propPerson) {
        String credit = "";
        for (ProposalPersonCreditSplit creditSplit : propPerson.getCreditSplits()) {
            if (!creditSplit.getInvCreditTypeCode().equals("1")) continue;
            credit = creditSplit.getCredit().toString();
            break;
        }
        return credit;
    }

    private PROPUNITCREDITSPLITDocument.PROPUNITCREDITSPLIT[] getProposalUnitCreditSplits(ProposalPerson propPerson) {
        ArrayList<PROPUNITCREDITSPLITDocument.PROPUNITCREDITSPLIT> propUnitCreditSplitList = new ArrayList<PROPUNITCREDITSPLITDocument.PROPUNITCREDITSPLIT>();
        String unit = this.getUnitForCreditSplit(propPerson.getUnit());
        for (ProposalPersonCreditSplit creditSplit : propPerson.getCreditSplits()) {
            if (!creditSplit.getInvCreditTypeCode().equals("1") && !creditSplit.getInvCreditTypeCode().equals("2")) continue;
            PROPUNITCREDITSPLITDocument.PROPUNITCREDITSPLIT propUnitCreditSplit = (PROPUNITCREDITSPLITDocument.PROPUNITCREDITSPLIT)PROPUNITCREDITSPLITDocument.PROPUNITCREDITSPLIT.Factory.newInstance();
            propUnitCreditSplit.setUNIT(unit);
            propUnitCreditSplit.setPRIMARY(creditSplit.getCredit() == null ? STRING_DOUBLE_SEPARATOR : creditSplit.getCredit().toString());
            propUnitCreditSplit.setSECONDARY(creditSplit.getCredit() == null ? STRING_DOUBLE_SEPARATOR : creditSplit.getCredit().toString());
            propUnitCreditSplitList.add(propUnitCreditSplit);
        }
        return propUnitCreditSplitList.toArray(new PROPUNITCREDITSPLITDocument.PROPUNITCREDITSPLIT[0]);
    }

    private String getUnitForCreditSplit(Unit unit) {
        String unitCredit = null;
        if (unit != null) {
            String unitName = unit.getUnitName();
            unitCredit = new StringBuilder(unit.getUnitNumber()).append(STRING_SEPRATOR).append(unitName, 0, 29).append(unitName.length() <= 30 ? "" : INCOMPLETE_STRING_TERMINATOR).toString();
        }
        return unitCredit;
    }

    private PROPUNITSDocument.PROPUNITS[] getPropUnits(List<ProposalPerson> proposalPersonList) {
        ArrayList<PROPUNITSDocument.PROPUNITS> propUnitsList = new ArrayList<PROPUNITSDocument.PROPUNITS>();
        ArrayList<ProposalPersonUnit> propPersonUnitList = new ArrayList<ProposalPersonUnit>();
        for (ProposalPerson pPerson : proposalPersonList) {
            for (ProposalPersonUnit propPersonUnit : pPerson.getUnits()) {
                if (!propPersonUnit.isLeadUnit() || propPersonUnit.getUnit() == null) continue;
                propPersonUnitList.add(propPersonUnit);
            }
        }
        for (ProposalPersonUnit propPersonUnit : propPersonUnitList) {
            PROPUNITSDocument.PROPUNITS propUnits = (PROPUNITSDocument.PROPUNITS)PROPUNITSDocument.PROPUNITS.Factory.newInstance();
            propUnits.setLEADUNITFLAG(propPersonUnit.isLeadUnit() ? "Y" : "N");
            propUnits.setPROPOSALNUMBER(propPersonUnit.getProposalPerson().getDevelopmentProposal().getProposalNumber());
            UNITDocument.UNIT unit = (UNITDocument.UNIT)UNITDocument.UNIT.Factory.newInstance();
            unit.setUNITNUMBER(propPersonUnit.getUnitNumber());
            unit.setUNITNAME(propPersonUnit.getUnit().getUnitName());
            propUnits.setUNIT(unit);
            propUnitsList.add(propUnits);
        }
        return propUnitsList.toArray(new PROPUNITSDocument.PROPUNITS[0]);
    }

    private PROPOSALMASTERDocument.PROPOSALMASTER getProposalMaster(DevelopmentProposal developmentProposal, Budget budget) {
        PROPOSALMASTERDocument.PROPOSALMASTER proposalMaster = (PROPOSALMASTERDocument.PROPOSALMASTER)PROPOSALMASTERDocument.PROPOSALMASTER.Factory.newInstance();
        proposalMaster.setPROPOSALNUMBER(developmentProposal.getProposalNumber());
        if (developmentProposal.getApplicantOrganization().getRolodex() != null) {
            proposalMaster.setORGANIZATION(this.getDevelopmentProposalOrganizationXMLObject(developmentProposal.getApplicantOrganization().getRolodex()));
        }
        proposalMaster.setLEADUNIT(this.getProposalLeadUnit(developmentProposal.getProposalPersons()));
        proposalMaster.setTITLE(developmentProposal.getTitle());
        proposalMaster.setPERIOD(this.getProjectPeriod(developmentProposal.getRequestedStartDateInitial(), developmentProposal.getRequestedEndDateInitial()));
        proposalMaster.setSPONSORCOST(this.getSponsorCost(budget));
        proposalMaster.setCOSTSHARING(budget.getCostSharingAmount().toString());
        proposalMaster.setOTHERCOMMENTS(this.getAbstractFromProposalAbstract(developmentProposal.getProposalAbstracts(), ABSTRACT_TYPE_CODE_OTHER));
        proposalMaster.setCOI(this.getConflictOfInterest(developmentProposal.getProposalChangedDataList()));
        proposalMaster.setDEADLINE(this.getSponsorDeadLine(developmentProposal.getDeadlineDate(), developmentProposal.getDeadlineType()));
        proposalMaster.setADDLMAILINGINSTR(this.getAbstractFromProposalAbstract(developmentProposal.getProposalAbstracts(), ABSTRACT_TYPE_CODE_MAILING));
        proposalMaster.setCENTERINST(this.getCenterInstitute(developmentProposal.getProposalChangedDataList(), developmentProposal.getProposalPersons()));
        proposalMaster.setSPONSOR(this.getSponsorXMLObject(developmentProposal.getSponsorName()));
        proposalMaster.setPRIMESPONSOR(this.getPrimeSponsorXMLObject(developmentProposal.getPrimeSponsorCode()));
        proposalMaster.setPROPINVESTIGATORS(this.getProposalInvestigatorXMLObject(developmentProposal.getProposalPersons()));
        proposalMaster.setPROPOSALTYPE(this.getProposalTypeXMLObject(developmentProposal.getProposalType().getDescription()));
        proposalMaster.setACTIVITYTYPE(this.getActivityTypeXMLObject(developmentProposal.getActivityType().getDescription()));
        proposalMaster.setNOTICEOFOPPORTUNITY(this.getNoticeOfOpportunityXMLObject(developmentProposal.getNoticeOfOpportunityCode()));
        proposalMaster.setPROGRAMANNOUNCEMENTNUMBER(developmentProposal.getProgramAnnouncementNumber());
        proposalMaster.setPROGRAMANNOUNCEMENTTITLE(developmentProposal.getProgramAnnouncementTitle());
        proposalMaster.setMAILTYPE(this.getMailType(developmentProposal.getMailType()));
        proposalMaster.setNUMBEROFCOPIES(developmentProposal.getNumberOfCopies());
        proposalMaster.setMAILADDRESS(this.getMailingAddressXMLObject(developmentProposal.getApplicantOrganization()));
        proposalMaster.setMAILDESCRIPTION(developmentProposal.getMailDescription());
        return proposalMaster;
    }

    private PROPOSALMASTERDocument.PROPOSALMASTER.MAILADDRESS getMailingAddressXMLObject(ProposalSite proposalSite) {
        ADDRESSDocument.ADDRESS address = (ADDRESSDocument.ADDRESS)ADDRESSDocument.ADDRESS.Factory.newInstance();
        address.setADDRESSLINE1(this.getSponsorAddress(proposalSite));
        ROLODEXDocument.ROLODEX rolodex = (ROLODEXDocument.ROLODEX)ROLODEXDocument.ROLODEX.Factory.newInstance();
        rolodex.setADDRESS(address);
        PROPOSALMASTERDocument.PROPOSALMASTER.MAILADDRESS mailAddress = (PROPOSALMASTERDocument.PROPOSALMASTER.MAILADDRESS)PROPOSALMASTERDocument.PROPOSALMASTER.MAILADDRESS.Factory.newInstance();
        mailAddress.setROLODEX(rolodex);
        return mailAddress;
    }

    private String getSponsorAddress(ProposalSite proposalSite) {
        Rolodex rolodex = proposalSite.getRolodex();
        String address = "";
        if (proposalSite != null && proposalSite.getRolodexId() != null) {
            address = (rolodex.getLastName() == null ? "" : rolodex.getLastName()) + (rolodex.getFirstName() == null ? "" : rolodex.getFirstName()) + (rolodex.getMiddleName() == null ? "" : rolodex.getMiddleName()) + (rolodex.getEmailAddress() == null ? "" : new StringBuilder(OPEN_BRACES).append(rolodex.getEmailAddress()).append(CLOSE_BRACES)) + (rolodex.getPhoneNumber() == null ? "" : rolodex.getPhoneNumber()) + NEW_LINE + proposalSite.getLocationName() + NEW_LINE + (proposalSite.getAddressLine1() == null ? "" : proposalSite.getAddressLine1()) + NEW_LINE + (proposalSite.getAddressLine2() == null ? "" : proposalSite.getAddressLine2()) + NEW_LINE + (proposalSite.getAddressLine3() == null ? "" : proposalSite.getAddressLine3()) + NEW_LINE + (proposalSite.getCity() == null ? "" : proposalSite.getCity()) + "," + (proposalSite.getState() == null ? "" : proposalSite.getState()) + BLANK_STRING + (proposalSite.getPostalCode() == null ? "" : proposalSite.getPostalCode()) + BLANK_STRING + (proposalSite.getCountryCode() == null ? "" : proposalSite.getCountryCode());
        }
        return address;
    }

    private String getMailType(String mailType) {
        String submissionMethod = "";
        if ("2".equals(mailType)) {
            submissionMethod = MAIL_SUBMISSINON_METHOD_ELECTRONIC;
        } else if ("1".equals(mailType)) {
            submissionMethod = MAIL_SUBMISSINON_METHOD_REGULAR;
        } else if ("3".equals(mailType)) {
            submissionMethod = MAIL_SUBMISSINON_METHOD_DHL;
        }
        return submissionMethod;
    }

    private NOTICEOFOPPORTUNITYDocument.NOTICEOFOPPORTUNITY getNoticeOfOpportunityXMLObject(String noticeOfOpportunityCode) {
        NOTICEOFOPPORTUNITYDocument.NOTICEOFOPPORTUNITY noticeOfOpportunity = (NOTICEOFOPPORTUNITYDocument.NOTICEOFOPPORTUNITY)NOTICEOFOPPORTUNITYDocument.NOTICEOFOPPORTUNITY.Factory.newInstance();
        String description = this.getNoticeOfOpportunityDesc(noticeOfOpportunityCode);
        noticeOfOpportunity.setDESCRIPTION(description);
        noticeOfOpportunity.setNOTICEOFOPPORTUNITYCODE(0);
        return noticeOfOpportunity;
    }

    private String getNoticeOfOpportunityDesc(String noticeOfOpportunityCode) {
        HashMap<String, String> noticeCodeMap = new HashMap<String, String>();
        noticeCodeMap.put(NOTICE_OF_OPPORTUNITY_CODE, noticeOfOpportunityCode);
        String description = "";
        NoticeOfOpportunity noticeOfOpportunity = (NoticeOfOpportunity)this.getBusinessObjectService().findByPrimaryKey(NoticeOfOpportunity.class, noticeCodeMap);
        if (noticeOfOpportunity != null) {
            description = noticeOfOpportunity.getDescription();
        }
        return description;
    }

    private ACTIVITYTYPEDocument.ACTIVITYTYPE getActivityTypeXMLObject(String description) {
        ACTIVITYTYPEDocument.ACTIVITYTYPE activityType = (ACTIVITYTYPEDocument.ACTIVITYTYPE)ACTIVITYTYPEDocument.ACTIVITYTYPE.Factory.newInstance();
        activityType.setDESCRIPTION(description);
        activityType.setACTIVITYTYPECODE(0);
        return activityType;
    }

    private PROPOSALTYPEDocument.PROPOSALTYPE getProposalTypeXMLObject(String description) {
        PROPOSALTYPEDocument.PROPOSALTYPE propType = (PROPOSALTYPEDocument.PROPOSALTYPE)PROPOSALTYPEDocument.PROPOSALTYPE.Factory.newInstance();
        propType.setDESCRIPTION(description);
        propType.setPROPOSALTYPECODE(0);
        return propType;
    }

    private PROPINVESTIGATORTYPE getProposalInvestigatorXMLObject(List<ProposalPerson> proposalPersonList) {
        PROPINVESTIGATORTYPE propInvestigatorType = (PROPINVESTIGATORTYPE)PROPINVESTIGATORTYPE.Factory.newInstance();
        KcPerson person = this.getPrincipalInvetigatorPerson(proposalPersonList);
        if (person != null) {
            propInvestigatorType.setPERSONNAME(this.getPersonNameAndInfo(person));
        }
        if (person.getFullName() != null) {
            propInvestigatorType.setPERSONID(person.getFullName());
        }
        return propInvestigatorType;
    }

    private KcPerson getPrincipalInvetigatorPerson(List<ProposalPerson> proposalPersonList) {
        KcPerson person = null;
        for (ProposalPerson pPerson : proposalPersonList) {
            if (pPerson.getPersonId() == null || !pPerson.getProposalPersonRoleId().equals("PI")) continue;
            person = pPerson.getPerson();
            break;
        }
        return person;
    }

    private PROPOSALMASTERDocument.PROPOSALMASTER.PRIMESPONSOR getPrimeSponsorXMLObject(String primeSponsorCode) {
        Sponsor primSponsor = this.getSponsorBySponsorCode(primeSponsorCode);
        SPONSORDocument.SPONSOR sponsor = (SPONSORDocument.SPONSOR)SPONSORDocument.SPONSOR.Factory.newInstance();
        if (primSponsor != null) {
            sponsor.setSPONSORNAME(primSponsor.getSponsorName());
        }
        PROPOSALMASTERDocument.PROPOSALMASTER.PRIMESPONSOR primeSponsor = (PROPOSALMASTERDocument.PROPOSALMASTER.PRIMESPONSOR)PROPOSALMASTERDocument.PROPOSALMASTER.PRIMESPONSOR.Factory.newInstance();
        primeSponsor.setSPONSOR(sponsor);
        return primeSponsor;
    }

    private Sponsor getSponsorBySponsorCode(String sponsorCode) {
        HashMap<String, String> sponsorCodeMap = new HashMap<String, String>();
        sponsorCodeMap.put("sponsorCode", sponsorCode);
        Sponsor sponsor = (Sponsor)this.getBusinessObjectService().findByPrimaryKey(Sponsor.class, sponsorCodeMap);
        return sponsor;
    }

    private SPONSORDocument.SPONSOR getSponsorXMLObject(String sponsorName) {
        SPONSORDocument.SPONSOR sponsor = (SPONSORDocument.SPONSOR)SPONSORDocument.SPONSOR.Factory.newInstance();
        sponsor.setSPONSORNAME(sponsorName);
        return sponsor;
    }

    private String getCenterInstitute(List<ProposalChangedData> proposalChangedDataList, List<ProposalPerson> proposalPersons) {
        String columnValue1 = this.getProposalChangeDataColumnValue(CENTER_INSTITUTE_CODE, proposalChangedDataList);
        String columnValue2 = this.getProposalChangeDataColumnValue(CENTER_INSTITUTE_CODE2, proposalChangedDataList);
        String columnValue3 = this.getProposalChangeDataColumnValue(CENTER_INSTITUTE_CODE3, proposalChangedDataList);
        String columnValue4 = this.getProposalChangeDataColumnValue(CENTER_INSTITUTE_CODE4, proposalChangedDataList);
        String columnValue5 = this.getProposalChangeDataColumnValue(CENTER_INSTITUTE_CODE5, proposalChangedDataList);
        Unit unit1 = this.getUnitFromProposalChangeData(columnValue1, proposalPersons);
        Unit unit2 = this.getUnitFromProposalChangeData(columnValue2, proposalPersons);
        Unit unit3 = this.getUnitFromProposalChangeData(columnValue3, proposalPersons);
        Unit unit4 = this.getUnitFromProposalChangeData(columnValue4, proposalPersons);
        Unit unit5 = this.getUnitFromProposalChangeData(columnValue5, proposalPersons);
        String centerInstitute1 = this.getCenterInstitute(columnValue1, unit1);
        String centerInstitute2 = this.getCenterInstitute(columnValue2, unit2);
        String centerInstitute3 = this.getCenterInstitute(columnValue3, unit3);
        String centerInstitute4 = this.getCenterInstitute(columnValue4, unit4);
        String centerInstitute5 = this.getCenterInstitute(columnValue5, unit5);
        return centerInstitute1 + NEW_LINE + centerInstitute2 + NEW_LINE + centerInstitute3 + NEW_LINE + centerInstitute4 + NEW_LINE + centerInstitute5;
    }

    private String getCenterInstitute(String columnValue, Unit unit) {
        String centerInstitue = columnValue;
        if (unit != null && unit.getUnitNumber() != null) {
            centerInstitue = columnValue + STRING_SEPRATOR + unit.getUnitName();
        }
        return centerInstitue;
    }

    private String getProposalChangeDataColumnValue(String centerInstituteCode, List<ProposalChangedData> proposalChangedDataList) {
        String columnValue = "";
        for (ProposalChangedData propChangeData : proposalChangedDataList) {
            if (!propChangeData.getColumnName().equals(centerInstituteCode)) continue;
            columnValue = propChangeData.getChangedValue();
        }
        return columnValue;
    }

    private Unit getUnitFromProposalChangeData(String value, List<ProposalPerson> proposalPersons) {
        Unit unit = null;
        for (ProposalPerson pPerson : proposalPersons) {
            for (ProposalPersonUnit pUnit : pPerson.getUnits()) {
                if (!pUnit.getUnitNumber().equals(value)) continue;
                unit = pUnit.getUnit();
            }
        }
        return unit;
    }

    private String getConflictOfInterest(List<ProposalChangedData> proposalChangedDataList) {
        String conflictOfInterest = COI_DEFAULT_VALUE;
        for (ProposalChangedData propChangesData : proposalChangedDataList) {
            if (!propChangesData.getColumnName().equals(CONFLICT_OF_INTEREST)) continue;
            if (propChangesData.getChangedValue().equals(IDENTIFIER_NO)) {
                conflictOfInterest = DOES_NOT_REQUIRE;
                continue;
            }
            if (!propChangesData.getChangedValue().equals(IDENTIFIER_YES)) continue;
            conflictOfInterest = DOES_REQUIRE;
        }
        return conflictOfInterest;
    }

    private String getSponsorDeadLine(Date deadLineDate, String deadLineType) {
        String sponsorDeadLineType = "";
        String deadLineDateFormated = DateFormatUtils.format((java.util.Date)deadLineDate, (String)"MM/dd/yyyy");
        if (SPONSOR_DEADLINE_TYPE_POSTMARK.equals(deadLineType)) {
            sponsorDeadLineType = SPONSOR_DEADLINE_POSTMARK_DESCRIPTION;
        } else if (SPONSOR_DEADLINE_TYPE_RECEIPT.equals(deadLineType)) {
            sponsorDeadLineType = SPONSOR_DEADLINE_RECEIPT_DESCRIPTION;
        }
        return deadLineDateFormated + sponsorDeadLineType;
    }

    private String getAbstractFromProposalAbstract(List<ProposalAbstract> proposalAbstracts, String abstractTypeCode) {
        String abstractDetail = "";
        for (ProposalAbstract proposalAbstract : proposalAbstracts) {
            if (!proposalAbstract.getAbstractTypeCode().equals(abstractTypeCode)) continue;
            abstractDetail = proposalAbstract.getAbstractDetails();
            break;
        }
        return abstractDetail;
    }

    private String getSponsorCost(Budget budget) {
        String sponsorCost = budget.getTotalCost().toString();
        return sponsorCost;
    }

    private String getProjectPeriod(Date requestedStartDate, Date requestedEndDate) {
        String startDate = DateFormatUtils.format((java.util.Date)requestedStartDate, (String)"MM/dd/yyyy");
        String endDate = DateFormatUtils.format((java.util.Date)requestedEndDate, (String)"MM/dd/yyyy");
        return startDate + STRING_SEPRATOR + endDate;
    }

    private String getProposalLeadUnit(List<ProposalPerson> proposalPersonList) {
        String leadUnit = "";
        block0: for (ProposalPerson proposalPerson : proposalPersonList) {
            for (ProposalPersonUnit proposalPersonUnit : proposalPerson.getUnits()) {
                if (!proposalPersonUnit.isLeadUnit()) continue;
                leadUnit = proposalPersonUnit.getUnitNumber() + BLANK_STRING + proposalPersonUnit.getUnit().getUnitName();
                continue block0;
            }
        }
        return leadUnit;
    }

    private ORGANIZATIONDocument.ORGANIZATION getDevelopmentProposalOrganizationXMLObject(Rolodex rolodexDetails) {
        String nameAndInfo = this.getRolodexNameAndInfo(rolodexDetails);
        NAMEDocument.NAME name = (NAMEDocument.NAME)NAMEDocument.NAME.Factory.newInstance();
        name.setFIRSTNAME(nameAndInfo);
        ADDRESSDocument.ADDRESS address = (ADDRESSDocument.ADDRESS)ADDRESSDocument.ADDRESS.Factory.newInstance();
        address.setADDRESSLINE1(nameAndInfo);
        ROLODEXDocument.ROLODEX rolodex = (ROLODEXDocument.ROLODEX)ROLODEXDocument.ROLODEX.Factory.newInstance();
        rolodex.setNAME(name);
        rolodex.setADDRESS(address);
        ORGANIZATIONDocument.ORGANIZATION organization = (ORGANIZATIONDocument.ORGANIZATION)ORGANIZATIONDocument.ORGANIZATION.Factory.newInstance();
        organization.setROLODEX(rolodex);
        return organization;
    }

    private String getPersonNameAndInfo(KcPerson person) {
        String personEmail = person.getEmailAddress();
        String officePhone = person.getOfficePhone();
        String personInfo = "";
        if (personEmail != null && officePhone != null) {
            personInfo = OPEN_BRACES + person.getEmailAddress() + person.getOfficePhone() + CLOSE_BRACES;
        }
        if (personEmail == null && officePhone != null) {
            personInfo = OPEN_BRACES + person.getOfficePhone() + CLOSE_BRACES;
        }
        String personNameAndInfo = person.getFullName() + personInfo;
        return personNameAndInfo;
    }

    private String getRolodexNameAndInfo(Rolodex rolodex) {
        String personEmail = rolodex.getEmailAddress();
        String officePhone = rolodex.getPhoneNumber();
        String rolodexinfo = "";
        if (personEmail != null && officePhone != null) {
            rolodexinfo = OPEN_BRACES + rolodex.getEmailAddress() + rolodex.getPhoneNumber() + CLOSE_BRACES;
        }
        if (personEmail == null && officePhone != null) {
            rolodexinfo = OPEN_BRACES + rolodex.getPhoneNumber() + CLOSE_BRACES;
        }
        String personNameAndInfo = rolodex.getFullName() + rolodexinfo;
        return personNameAndInfo;
    }
}

