/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.sql.Timestamp;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDao;
import org.kuali.coeus.propdev.api.s2s.S2sAppSubmissionContract;
import org.kuali.coeus.propdev.impl.s2s.S2sApplication;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;

@Entity
@Table(name="S2S_APP_SUBMISSION")
@IdClass(value=S2sAppSubmissionId.class)
public class S2sAppSubmission
extends KcPersistableBusinessObjectBase
implements S2sAppSubmissionContract {
    @Id
    @Column(name="PROPOSAL_NUMBER")
    private String proposalNumber;
    @Id
    @Column(name="SUBMISSION_NUMBER")
    private Integer submissionNumber;
    @Column(name="AGENCY_TRACKING_ID")
    private String agencyTrackingId;
    @Column(name="COMMENTS")
    private String comments;
    @Column(name="GG_TRACKING_ID")
    private String ggTrackingId;
    @Column(name="LAST_MODIFIED_DATE")
    private Timestamp lastModifiedDate;
    @Column(name="LAST_NOTIFIED_DATE")
    private Timestamp lastNotifiedDate;
    @Column(name="RECEIVED_DATE")
    private Timestamp receivedDate;
    @Column(name="STATUS")
    private String status;
    @Column(name="GG_APP_ZIP_FILE_ID")
    private String ggApplicationZipFileId;
    @Column(name="NIH_APP_PDF_FILE_ID")
    private String nihApplicationPdfFileId;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER", insertable=false, updatable=false)
    private S2sApplication s2sApplication;
    @Transient
    private transient WeakReference<byte[]> ggApplicationZipData;
    @Transient
    private transient WeakReference<byte[]> nihApplicationPdfData;

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public Integer getSubmissionNumber() {
        return this.submissionNumber;
    }

    public void setSubmissionNumber(Integer submissionNumber) {
        this.submissionNumber = submissionNumber;
    }

    public String getAgencyTrackingId() {
        return this.agencyTrackingId;
    }

    public void setAgencyTrackingId(String agencyTrackingId) {
        this.agencyTrackingId = agencyTrackingId;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getGgTrackingId() {
        return this.ggTrackingId;
    }

    public void setGgTrackingId(String ggTrackingId) {
        this.ggTrackingId = ggTrackingId;
    }

    public Timestamp getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Timestamp lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Timestamp getLastNotifiedDate() {
        return this.lastNotifiedDate;
    }

    public void setLastNotifiedDate(Timestamp lastNotifiedDate) {
        this.lastNotifiedDate = lastNotifiedDate;
    }

    public Timestamp getReceivedDate() {
        return this.receivedDate;
    }

    public void setReceivedDate(Timestamp receivedDate) {
        this.receivedDate = receivedDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public S2sApplication getS2sApplication() {
        return this.s2sApplication;
    }

    public void setS2sApplication(S2sApplication s2sApplication) {
        this.s2sApplication = s2sApplication;
    }

    public boolean isMissingSubmissionData() {
        return this.getS2sApplication() == null || StringUtils.isBlank((CharSequence)this.getS2sApplication().getApplication()) || this.getS2sApplication().getS2sAppAttachmentList().stream().anyMatch(a -> StringUtils.isBlank((CharSequence)a.getFileDataId()));
    }

    public byte[] getGgApplicationZipData() {
        byte[] existingData;
        if (this.ggApplicationZipData != null && (existingData = (byte[])this.ggApplicationZipData.get()) != null) {
            return existingData;
        }
        byte[] newData = this.getKcAttachmentDao().getData(this.ggApplicationZipFileId);
        this.ggApplicationZipData = new WeakReference<byte[]>(newData);
        return newData;
    }

    public String getGgApplicationZipFileId() {
        return this.ggApplicationZipFileId;
    }

    public void setGgApplicationZipFileId(String ggApplicationZipFileId) {
        this.ggApplicationZipFileId = ggApplicationZipFileId;
    }

    public void setGgApplicationZipData(byte[] ggApplicationZipData) {
        if (ggApplicationZipData == null) {
            this.getKcAttachmentDao().removeData(this.ggApplicationZipFileId);
        } else {
            this.ggApplicationZipFileId = this.getKcAttachmentDao().saveData(ggApplicationZipData, this.ggApplicationZipFileId);
        }
        this.ggApplicationZipData = new WeakReference<byte[]>(ggApplicationZipData);
    }

    public byte[] getNihApplicationPdfData() {
        byte[] existingData;
        if (this.nihApplicationPdfData != null && (existingData = (byte[])this.nihApplicationPdfData.get()) != null) {
            return existingData;
        }
        byte[] newData = this.getKcAttachmentDao().getData(this.nihApplicationPdfFileId);
        this.nihApplicationPdfData = new WeakReference<byte[]>(newData);
        return newData;
    }

    public String getNihApplicationPdfFileId() {
        return this.nihApplicationPdfFileId;
    }

    public void setNihApplicationPdfFileId(String nihApplicationPdfFileId) {
        this.nihApplicationPdfFileId = nihApplicationPdfFileId;
    }

    public void setNihApplicationPdfData(byte[] nihApplicationPdfData) {
        if (nihApplicationPdfData == null) {
            this.getKcAttachmentDao().removeData(this.nihApplicationPdfFileId);
        } else {
            this.nihApplicationPdfFileId = this.getKcAttachmentDao().saveData(nihApplicationPdfData, this.nihApplicationPdfFileId);
        }
        this.nihApplicationPdfData = new WeakReference<byte[]>(nihApplicationPdfData);
    }

    public void postRemove() {
        super.postRemove();
        if (this.getGgApplicationZipFileId() != null) {
            this.getKcAttachmentDao().removeData(this.getGgApplicationZipFileId());
        }
        if (this.getNihApplicationPdfFileId() != null) {
            this.getKcAttachmentDao().removeData(this.getNihApplicationPdfFileId());
        }
    }

    private KcAttachmentDataDao getKcAttachmentDao() {
        return KcServiceLocator.getService(KcAttachmentDataDao.class);
    }

    public static final class S2sAppSubmissionId
    implements Serializable,
    Comparable<S2sAppSubmissionId> {
        private String proposalNumber;
        private Integer submissionNumber;

        public String getProposalNumber() {
            return this.proposalNumber;
        }

        public void setProposalNumber(String proposalNumber) {
            this.proposalNumber = proposalNumber;
        }

        public Integer getSubmissionNumber() {
            return this.submissionNumber;
        }

        public void setSubmissionNumber(Integer submissionNumber) {
            this.submissionNumber = submissionNumber;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("proposalNumber", (Object)this.proposalNumber).append("submissionNumber", (Object)this.submissionNumber).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            S2sAppSubmissionId rhs = (S2sAppSubmissionId)other;
            return new EqualsBuilder().append((Object)this.proposalNumber, (Object)rhs.proposalNumber).append((Object)this.submissionNumber, (Object)rhs.submissionNumber).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.proposalNumber).append((Object)this.submissionNumber).toHashCode();
        }

        @Override
        public int compareTo(S2sAppSubmissionId other) {
            return new CompareToBuilder().append((Object)this.proposalNumber, (Object)other.proposalNumber).append((Object)this.submissionNumber, (Object)other.submissionNumber).toComparison();
        }
    }
}

