/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.custom;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kuali.coeus.common.framework.custom.CustomDataContainer;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.rice.krms.api.engine.TermResolutionException;
import org.kuali.rice.krms.api.engine.TermResolver;

public class CustomDataResolver
implements TermResolver<Object> {
    public static final String CUSTOM_ATTRIBUTE_ID = "Custom Attribute Id";
    private String outputName;
    private Set<String> prereqs;
    private Set<String> params;
    private String moduleNamePreReq;

    public CustomDataResolver(String outputName, Set<String> params, String moduleNamePrereq) {
        this.outputName = outputName;
        this.prereqs = new HashSet<String>();
        this.moduleNamePreReq = moduleNamePrereq;
        this.prereqs.add(moduleNamePrereq);
        this.params = params == null ? Collections.emptySet() : params;
    }

    public String getModuleNamePreReq() {
        return this.moduleNamePreReq;
    }

    public Set<String> getPrerequisites() {
        return this.prereqs;
    }

    public String getOutput() {
        return this.outputName;
    }

    public Set<String> getParameterNames() {
        return this.params;
    }

    public int getCost() {
        return 0;
    }

    public Object resolve(Map<String, Object> resolvedPrereqs, Map<String, String> parameters) throws TermResolutionException {
        CustomDataContainer customDataContainer = (CustomDataContainer)resolvedPrereqs.get(this.getModuleNamePreReq());
        return customDataContainer.getCustomDataList().stream().filter(customData -> Objects.equal((Object)customData.getCustomAttributeId().toString(), parameters.get(CUSTOM_ATTRIBUTE_ID))).findFirst().map(DocumentCustomData::getValue).orElse(null);
    }
}

